/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.beans;

import java.util.*;
import java.io.*;
import java.lang.reflect.Type;

/**
 * {@link Map}^PropertyEditorNXB<p>
 * L[=l`̕java.util.LinkedHashMapɕϊB<br>
 * es̑Ő󔒂gB󔒂́Ajava.lang.Character#isWhitespace(char)Ŕ肳B܂A"&lt;!--""--&gt;"Ɉ͂܂ꂽ̓RgƉ߂ꖳB܂A"${""}"Ɉ͂܂ꂽ́ÃVXevpeBƒuB<br>
 * "${\t}"A"${\n}"A"${\r}"A"${\f}"́AGXP[vV[PXƂĒuB<br>
 * "u"n܂ÚAjR[hƂĒuB<br>
 * ܂A󔒂𕶎̑Oɕtꍇɂ́A"ň͂ށB"GXP[vɂ́A\"ƋLqB<br>
 * <p>
 * F<br>
 * &nbsp;&nbsp;A=a<br>
 * &nbsp;&nbsp;B=b<br>
 * &nbsp;&nbsp;C="c "<br>
 * &nbsp;&nbsp;&lt;!--D=d<br>
 * &nbsp;&nbsp;E=e--&gt;<br>
 * <br>
 * ̂悤ȕ<br>
 * <br>
 * &nbsp;&nbsp;Map map = new LinkedHashMap();<br>
 * &nbsp;&nbsp;map.put("A", "a");<br>
 * &nbsp;&nbsp;map.put("B", "b");<br>
 * &nbsp;&nbsp;map.put("C", "c ");<br>
 * <br>
 * ̂悤ɕϊB<br>
 *
 * @author M.Takata
 */
public class MapEditor extends ParameterizedTypePropertyEditorSupport
 implements java.io.Serializable{
    
    private static final long serialVersionUID = 2982596271402144547L;
    
    private static final String ESCAPE_DOUBLE_QUOTE = "\\\"";
    private static final String ESCAPE_DOUBLE_QUOTE_REGEX = "\\\\\"";
    private static final String DOUBLE_QUOTE = "\"";
    
    /**
     * w肳ꂽ͂ăvpeBlݒ肷B<p>
     *
     * @param text ͂镶
     */
    @SuppressWarnings("unchecked")
    @Override
    public void setAsText(String text){
        if(text == null){
            setValue(null);
            return;
        }
        final String tmpText = jp.ossc.nimbus.core.Utility.replaceSystemProperty(
            Utility.xmlComentOut(text), false
        );
        final StringReader sr = new StringReader(tmpText);
        final BufferedReader br = new BufferedReader(sr, tmpText.length());
        final Map<Object, Object> linkedMap = new LinkedHashMap<Object, Object>();
        try{
            String line = null;
            while((line = br.readLine()) != null){
                String mapping = Utility.trim(line);
                if(mapping == null){
                    throw new IllegalArgumentException('"' + mapping + '"');
                }
                if(mapping.indexOf('\\') != -1){
                    mapping = Utility.unicodeConvert(mapping);
                }
                final int length = mapping.length();
                if(length == 0 || mapping.trim().length() == 0){
                    continue;
                }
                int index = -1;
                if(mapping.charAt(0) == '"'){
                    index = 0;
                    do{
                        index = mapping.indexOf('"', index + 1);
                    }while(index != -1 && mapping.charAt(index) == '\\');
                    if(index != -1 && index < length){
                        index = mapping.indexOf('=', index + 1);
                    }else{
                        index = mapping.indexOf('=');
                    }
                }else{
                    index = mapping.indexOf('=');
                }
                if(index == -1){
                    throw new IllegalArgumentException('"' + mapping + '"');
                }
                String key = mapping.substring(0, index).trim();
                if(key != null && key.length() > 1
                     && key.charAt(0) == '"' && key.charAt(key.length() - 1) == '"'){
                    key = key.substring(1, key.length() - 1);
                }
                if(key.indexOf(ESCAPE_DOUBLE_QUOTE) != -1){
                    key = key.replaceAll(ESCAPE_DOUBLE_QUOTE_REGEX, DOUBLE_QUOTE);
                }
                String val = mapping.substring(index + 1).trim();
                if(val != null && val.length() > 1
                     && val.charAt(0) == '"' && val.charAt(val.length() - 1) == '"'){
                    val = val.substring(1, val.length() - 1);
                }
                if(val.indexOf(ESCAPE_DOUBLE_QUOTE) != -1){
                    val = val.replaceAll(ESCAPE_DOUBLE_QUOTE_REGEX, DOUBLE_QUOTE);
                }
                Object keyObj = key;
                Object valObj = val;
                if(parameterizedType != null){
                    Type[] types = parameterizedType.getActualTypeArguments();
                    if(types != null && types.length == 2){
                        keyObj = getValue(types[0], key);
                        valObj = getValue(types[1], val);
                    }
                }
                Object old = linkedMap.get(keyObj);
                if(old != null){
                    List<Object> list = null;
                    if(!(old instanceof List)){
                        list = new ArrayList<Object>();
                        list.add(old);
                        linkedMap.put(keyObj, list);
                    }else{
                        list = (List<Object>)old;
                    }
                    list.add(valObj);
                }else{
                    linkedMap.put(keyObj, valObj);
                }
            }
        }catch(IOException e){
            // NȂ͂
            e.printStackTrace();
        }finally{
            try{
                br.close();
            }catch(IOException e){
                // NȂ͂
                e.printStackTrace();
            }
            sr.close();
        }
        setValue(linkedMap);
    }
    
    /**
     * vpeB擾B<p>
     *
     * @return vpeB
     */
    @SuppressWarnings("unchecked")
    @Override
    public String getAsText(){
        final Map<Object, Object> linkedMap = (Map<Object, Object>)getValue();
        if(linkedMap == null){
            return null;
        }
        final StringWriter sw = new StringWriter();
        final PrintWriter writer = new PrintWriter(sw);
        final Iterator<Object> keys = linkedMap.keySet().iterator();
        while(keys.hasNext()){
            Object key = keys.next();
            Object val = linkedMap.get(key);
            Type valueType = null;
            if(parameterizedType != null){
                Type[] types = parameterizedType.getActualTypeArguments();
                if(types != null && types.length == 2){
                    key = getAsText(types[0], key);
                    valueType = types[1];
                }
            }
            if(val instanceof List){
                List<String> vals = (List<String>)val;
                for(int i = 0, imax = vals.size(); i < imax; i++){
                    writer.print(key);
                    writer.print('=');
                    val = vals.get(i);
                    if(valueType != null){
                        val = getAsText(valueType, val);
                    }
                    writer.print(val);
                    if(i != imax - 1){
                        writer.println();
                    }
                }
            }else{
                writer.print(key);
                writer.print('=');
                if(valueType != null){
                    val = getAsText(valueType, val);
                }
                writer.print(val);
            }
            if(keys.hasNext()){
                writer.println();
            }
        }
        return sw.toString();
    }
}
