package jp.gr.java_conf.shiseissi.commonlib;

import android.app.Activity;
import android.content.Context;
import android.graphics.Paint;
import android.hardware.Camera;
import android.os.AsyncTask;
import android.os.Build;
import android.view.View;
import android.webkit.WebSettings;
import android.webkit.WebView;

import java.io.File;
import java.util.List;

/**
 *
 * @author shisei
 */
public abstract class APILevelWrapper {
    protected static final String LOG_TAG = "APILevelWrapper";

    public static APILevelWrapper createInstance() {
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.HONEYCOMB) {
            return new APILevelWrapper11();
        } else if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.GINGERBREAD) {
            return new APILevelWrapper9();
        } else if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.FROYO) {
            return new APILevelWrapper8();
        } else if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.ECLAIR_MR1) {
            return new APILevelWrapper7();
        } else if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.ECLAIR) {
            return new APILevelWrapper5();
        } else {
            return new APILevelWrapper4();
        }
    }

    public abstract File getExternalFilesDir(Context context, String type);

    public abstract void setPluginsEnabled(WebSettings webSettings, boolean flag);

    public abstract void setDomStorageEnabled(WebSettings webSettings, boolean flag);

    public abstract Object getActionBar(Activity activity);

    public abstract void setDisplayHomeAsUpEnabled_ActionBar(Object actionBar,
            boolean showHomeAsUp);

    public abstract void setCustomView_ActionBar(Object actionBar, int resId);

    public abstract <T extends View> T getCustomView_ActionBar(Object actionBar);

    public abstract int getHeight_ActionBar(Object actionBar);

    public abstract void show_ActionBar(Object actionBar);

    public abstract void hide_ActionBar(Object actionBar);

    public abstract boolean isShowing_ActionBar(Object actionBar);

    public abstract void setSystemUiVisibility (View view, int visibility);

    public abstract <Params> AsyncTask<Params, ?, ?> executeOnSerialExecutor(
            AsyncTask<Params, ?, ?> task, Params... params);
    public abstract <Params> AsyncTask<Params, ?, ?> executeOnThreadPoolExecutor(
            AsyncTask<Params, ?, ?> task, Params... params);

    public abstract void setDisplayOrientation(Camera camera, int degrees);
    public abstract void setPreviewSize(Camera.Parameters params,
            int width, int height);

    public abstract void getCameraInfo(int cameraId, CameraInfo cameraInfo);

    public static class CameraInfo {
        public int facing;
        public int orientation;
    }

    public abstract List<Camera.Size> getSupportedPreviewSizes(Camera.Parameters params);
    public abstract List<Integer> getSupportedPreviewFormats(Camera.Parameters params);

    public abstract void emulateShiftHeld(WebView webView);

    public abstract void invalidateOptionsMenu(Activity activity);

    public abstract void setLayerType(View view, int layerType, Paint paint);
}
