package jp.sourceforge.nicoro;

/**
 * Playerで共通して使用する定数他
 */
public class PlayerConstants {
    /** 動画のURL */
    public static final String INTENT_NAME_VIDEO_URL = "VIDEO_URL";
    /** 動画ページアクセス履歴のcookie（動画URLへのアクセスに必要） */
    public static final String INTENT_NAME_COOKIE = "COOKIE";
    /** 動画番号（例：sm12345） */
    public static final String INTENT_NAME_VIDEO_NUMBER = "VIDEO_NUMBER";
    /** 動画情報、{@link WatchVideo}クラス */
    public static final String INTENT_NAME_WATCH_VIDEO = "WATCH_VIDEO";
    /** コメントサーバーのURL */
    public static final String INTENT_NAME_MESSAGE_URL = "MESSAGE_URL";
    /** コメントのthread id */
    public static final String INTENT_NAME_THREAD_ID = "THREAD_ID";
    /** コメントのoptional thread id */
    public static final String INTENT_NAME_OPTIONAL_THREAD_ID = "OPTIONAL_THREAD_ID";
    /** user id */
    public static final String INTENT_NAME_USER_ID = "USER_ID";
    /** コメントのthread key */
    public static final String INTENT_NAME_THREAD_KEY = "THREAD_KEY";
    /** コメントのforce 184 */
    public static final String INTENT_NAME_FORCE_184 = "FORCE_184";
    /** 画質モード強制 */
    public static final String INTENT_NAME_FORCE_ECO = "FORCE_ECO";
    /** コメントのnicos id */
    public static final String INTENT_NAME_NICOS_ID = "NICOS_ID";
    /** コメントのフィルタ。パラメータは{@link java.util.HashMap}{@literal <String, String>} */
    public static final String INTENT_NAME_NG_UP = "NG_UP";
    /** 動画の再生開始時間（秒） */
    public static final String INTENT_NAME_START_TIME_SECOND = "START_TIME_SECOND";
    /** ジャンプ時の、戻り先の動画番号 */
    public static final String INTENT_NAME_RETURN_VIDEO_NUMBER = "RETURN_VIDEO_NUMBER";
    /** ジャンプ時に、動画を何秒再生したら前の動画に戻るか */
    public static final String INTENT_NAME_RETURN_TIME_SECOND = "RETURN_TIME_SECOND";
    /** ジャンプ時に、前の動画に戻る際に表示するメッセージ */
    public static final String INTENT_NAME_RETURN_MESSAGE = "RETURN_MESSAGE";
    /** ジャンプ時に、前の動画に戻った際の再生開始時間（秒） */
    public static final String INTENT_NAME_RETURN_START_TIME_SECOND = "RETURN_START_TIME_SECOND";
    /** 再生リストの {@link Playlist} を圧縮したGZIP形式のbyte[] */
    public static final String INTENT_NAME_PLAYLIST = "PLAYLIST";
    /** 再生リストのソート順 */
    public static final String INTENT_NAME_PLAYLIST_SORT_ORDER = "PLAYLIST_SORT_ORDER";

    /** 生放送番号（例：lv12345） */
    public static final String INTENT_NAME_LIVE_NUMBER = "LIVE_NUMBER";
    /** 生放送番組のタイトル */
    public static final String INTENT_NAME_TITLE = "TITLE";
    /** 生放送番組の詳細 */
    public static final String INTENT_NAME_DESCRIPTION = "DESCRIPTION";

    /** コメント取得完了 */
    public static final int MSG_ID_MESSAGE_FINISHED = 0;
    /** コメント取得エラー */
    public static final int MSG_ID_MESSAGE_OCCURRED_ERROR = 1;
    /** 動画情報（getthumbinfo）取得完了 */
    public static final int MSG_ID_THUMBINFO_FINISHED = 2;
    /** 動画情報（getthumbinfo）取得エラー */
    public static final int MSG_ID_THUMBINFO_OCCURRED_ERROR = 3;
    /** 動画ファイル取得エラー */
    public static final int MSG_ID_VIDEO_OCCURRED_ERROR = 4;
    /** 動画ファイル取得進行状況通知 */
    public static final int MSG_ID_VIDEO_NOTIFY_PROGRESS = 5;
    /** 動画の再生時間表示を更新 */
    public static final int MSG_ID_INFO_TIME_UPDATE = 6;
    /** 動画再生中にエラー */
    public static final int MSG_ID_PLAY_ERROR = 7;
    /** SeekBarを有効化 */
    public static final int MSG_ID_ENABLE_SEEK_BAR = 10;
    /** 動画の再生情報表示を更新 */
    public static final int MSG_ID_INFO_PLAY_DATA_UPDATE = 12;
    /** 動画情報（getthumbinfo）をネットワークから新規に取得完了 */
    public static final int MSG_ID_THUMBINFO_FINISHED_NEW = 13;
    /** 動画情報（getthumbinfo）をネットワークから新規に取得でエラー */
    public static final int MSG_ID_THUMBINFO_OCCURRED_ERROR_NEW = 14;
    /** 動画を最後まで再生完了 */
    public static final int MSG_ID_PLAY_FINISHED = 15;
    /** 動画再生完了時のダイアログを表示 */
    public static final int MSG_ID_PLAY_FINISHED_DIALOG = 16;
    /** Playerをタイマーで自動終了 */
    public static final int MSG_ID_AUTO_CLOSE = 17;
    /** 動画ファイル取得完了 */
    public static final int MSG_ID_VIDEO_DOWNLOAD_FINISHED = 18;
    /** 動画ファイルの一定以上のキャッシュ完了 */
    public static final int MSG_ID_VIDEO_CACHED = 19;
    /** 動画ファイル取得開始 */
    public static final int MSG_ID_VIDEO_DOWNLOAD_STARTED = 20;
    /** コメントサーバーへの接続完了 */
    public static final int MSG_ID_LIVE_MESSAGE_CONNECTED = 21;
    /** コメントサーバーへの接続エラー */
    public static final int MSG_ID_LIVE_MESSAGE_OCCURRED_ERROR = 22;
    /** 生放送情報（getplayerstatus）の取得完了 */
    public static final int MSG_ID_GET_PLAYER_STATUS_SUCCEEDED = 23;
    /** 生放送情報（getplayerstatus）の取得エラー */
    public static final int MSG_ID_GET_PLAYER_STATUS_FAILED = 24;
    /** 投稿者コメントによるシーク禁止 */
    public static final int MSG_ID_FORBID_SEEK_BY_CONTRIBUTOR = 25;
    /** 投稿者コメントによるシーク禁止の解除 */
    public static final int MSG_ID_ALLOW_SEEK_BY_CONTRIBUTOR = 26;
    /** 秒指定でシーク */
    public static final int MSG_ID_SEEK_BY_SECOND = 27;
    /** 別の動画へジャンプ */
    public static final int MSG_ID_JUMP_VIDEO = 28;
    /** 非表示状態でコメントの内部状態更新 */
    public static final int MSG_ID_UPDATE_COMMENT_INNER = 29;
    /** コメント書き込み成功 */
    public static final int MSG_ID_MESSAGE_SEND_FINISHED = 31;
    /** コメント書き込み失敗 */
    public static final int MSG_ID_MESSAGE_SEND_OCCURRED_ERROR = 32;
    /** 投稿者コメントによるコメント禁止 */
    public static final int MSG_ID_FORBID_COMMENT_BY_CONTRIBUTOR = 33;
    /** 投稿者コメントによるコメント禁止の解除 */
    public static final int MSG_ID_ALLOW_COMMENT_BY_CONTRIBUTOR = 34;
    /** ユーザーのNG設定取得成功 */
    public static final int MSG_ID_GET_CONFIGURE_NG_CLIENT_FINISHED = 35;
    /** ユーザーのNG設定取得失敗 */
    public static final int MSG_ID_GET_CONFIGURE_NG_CLIENT_OCCURRED_ERROR = 36;
    /** Notificationの動画の再生時間表示を更新 */
    public static final int MSG_ID_NOTIFICATION_TIME_UPDATE = 37;
    /** AbstractPlayerFragmentに手動でparent screeのサイズを設定する */
    public static final int MSG_ID_SET_PLAYER_FRAGMENT_PARENT_SCREEN_SIZE = 38;
    /** 次の動画に遷移するためのAbstractPlayerFragment用のパラメータ準備完了 */
    public static final int MSG_ID_NEW_PLAYER_FRAGMENT = 39;
    /** （optional_thread_idの）コメント取得完了 */
    public static final int MSG_ID_OPTIONAL_MESSAGE_FINISHED = 40;
    /** {@link AbstractPlayerFragment}のサブクラスで追加定義するイベントIDのオフセット */
    public static final int MSG_ID_SUB_OFFSET = 0x100;

    public static final int REAL_PLAYER_WIDTH_PX_4_3 = 512;
    public static final int REAL_PLAYER_HEIGHT_PX_4_3 = 384;
//    public static final int REAL_PLAYER_HEIGHT_PX_16_9 = 288;
    public static final int REAL_PLAYER_WIDTH_PX_15_9 = 640;
    public static final int REAL_PLAYER_WIDTH_PX_16_9 = 684; // 682.66

    public static final String KEY_CHAT_MAIL = "chat_mail";
    public static final String KEY_CHAT_BODY = "chat_body";
    public static final String KEY_CHAT_VPOS = "chat_vpos";
    public static final String KEY_CHAT_NO = "chat_no";

    public static final int REQUEST_RECOGNIZE_SPEECH = 1;
}
