package jp.sourceforge.nicoro;

import android.test.AndroidTestCase;

import java.util.ArrayList;

public class MessageDataTest extends AndroidTestCase {


    public void testSetChats() {
        MessageData md = new MessageData();

        ArrayList<MessageChat> chats = new ArrayList<MessageChat>();
        MessageChat chat = new MessageChat("", 0, 0, 0L, "", 0);
        chats.add(chat);
        md.setChats(chats);

        assertTrue(md.isMessageOk());
        assertNotNull(md.getChatsWait());
        assertEquals(1, md.getChatsWait().size());
        assertEquals(chat, md.getChatsWait().get(0));
        assertNotNull(md.getChatsRunningNaka());
        assertEquals(0, md.getChatsRunningNaka().size());
        assertNotNull(md.getChatsRunningShita());
        assertEquals(0, md.getChatsRunningShita().size());
        assertNotNull(md.getChatsRunningUe());
        assertEquals(0, md.getChatsRunningUe().size());

        md = new MessageData();
        md.setChats(null);
        assertTrue(md.isMessageOk());
        assertNotNull(md.getChatsWait());
        assertEquals(0, md.getChatsWait().size());
        assertNotNull(md.getChatsRunningNaka());
        assertEquals(0, md.getChatsRunningNaka().size());
        assertNotNull(md.getChatsRunningShita());
        assertEquals(0, md.getChatsRunningShita().size());
        assertNotNull(md.getChatsRunningUe());
        assertEquals(0, md.getChatsRunningUe().size());
    }

    public void testResetChats() {
        MessageData md = new MessageData();

        ArrayList<MessageChat> chats = new ArrayList<MessageChat>();
        MessageChat chat = new MessageChat("", 0, 0, 0L, "", 0);
        chats.add(chat);
        md.resetChats(chats);

        assertFalse(md.isMessageOk());
        assertNotNull(md.getChatsWait());
        assertEquals(1, md.getChatsWait().size());
        assertEquals(chat, md.getChatsWait().get(0));
        assertNotNull(md.getChatsRunningNaka());
        assertEquals(0, md.getChatsRunningNaka().size());
        assertNotNull(md.getChatsRunningShita());
        assertEquals(0, md.getChatsRunningShita().size());
        assertNotNull(md.getChatsRunningUe());
        assertEquals(0, md.getChatsRunningUe().size());

        md = new MessageData();
        md.resetChats(null);
        assertFalse(md.isMessageOk());
        assertNotNull(md.getChatsWait());
        assertEquals(0, md.getChatsWait().size());
        assertNotNull(md.getChatsRunningNaka());
        assertEquals(0, md.getChatsRunningNaka().size());
        assertNotNull(md.getChatsRunningShita());
        assertEquals(0, md.getChatsRunningShita().size());
        assertNotNull(md.getChatsRunningUe());
        assertEquals(0, md.getChatsRunningUe().size());
    }

    public void testClear() {
        MessageData md = new MessageData();

        md.setChats(null);
        assertTrue(md.isMessageOk());

        md.clear();
        assertFalse(md.isMessageOk());
    }
}
