package jp.sourceforge.nicoro.nicoscript;

import static jp.sourceforge.nicoro.Log.LOG_TAG;

import android.text.TextUtils;

import jp.sourceforge.nicoro.Log;
import jp.sourceforge.nicoro.MessageChat;
import jp.sourceforge.nicoro.MessageChatController;
import jp.sourceforge.nicoro.MessageChatFork;
import jp.sourceforge.nicoro.Release;

public class NicoScriptGyaku extends NicoScript {
    private static final boolean DEBUG_LOGD = Release.IS_DEBUG && true;

    protected static final String COMMAND = "逆";

    /**
     * 逆の対象：全て＝全
     */
    private static final int TARGET_SUBE = 0;
    /**
     * 逆の対象：コメントのみ＝コメ
     */
    private static final int TARGET_COMME = 1;
    /**
     * 投稿者コメントのみ＝投コメ
     */
    private static final int TARGET_TOUCOMME = 2;

    private int mTarget;

    public NicoScriptGyaku(MessageChatFork chat, CommandSplitter commandSplitter) {
        super(chat);
        if (chat.getTime() < 0) {
            chat.setTime(UNDEFINED_DEFAULT_TIME);
        }

        String target = commandSplitter.getNextCommand();
        if (TextUtils.isEmpty(target)) {
            mTarget = TARGET_SUBE;
        } else {
            if (target.startsWith("全")) {
                mTarget = TARGET_SUBE;
            } else if (target.startsWith("コメ")) {
                mTarget = TARGET_COMME;
            } else if (target.startsWith("投コメ")) {
                mTarget = TARGET_TOUCOMME;
            } else {
                mTarget = TARGET_SUBE;
            }
        }
    }

    @Override
    public void onPrepareRemove(MessageChatController controller) {
        controller.clearCommandGyaku(this);
        if (DEBUG_LOGD) {
            Log.d(LOG_TAG, Log.buf().append("End NicoScript Gyaku: ")
                    .append(mChat).toString());
        }
    }
    @Override
    public void onDraw(MessageChatController controller) {
        controller.setCommandGyaku(this);
        if (DEBUG_LOGD) {
            Log.d(LOG_TAG, Log.buf().append("Start NicoScript Gyaku: ")
                    .append(mChat).toString());
        }
    }

    public int getDir(boolean isFork) {
        switch (mTarget) {
            case TARGET_SUBE:
                return MessageChat.DIR_GYAKU;
            case TARGET_COMME:
                if (isFork) {
                    return MessageChat.DIR_NORMAL;
                } else {
                    return MessageChat.DIR_GYAKU;
                }
            case TARGET_TOUCOMME:
                if (isFork) {
                    return MessageChat.DIR_GYAKU;
                } else {
                    return MessageChat.DIR_NORMAL;
                }
            default:
                assert false : "unexpected target=" + mTarget;
                return MessageChat.DIR_NORMAL;
        }
    }
}
