
package jp.sourceforge.nicoro;

import java.util.Date;

public interface ThumbInfoInterface extends XmlLoaderInterface {

    public interface EventListener {
    	/**
    	 * ファイル全体の読み込み完了
    	 * @param thumbInfo
    	 */
    	public void onFinished(ThumbInfoInterface thumbInfo);
    	/**
    	 * エラー発生
    	 * @param thumbInfo
    	 * @param errorMessage
    	 */
    	public void onOccurredError(ThumbInfo thumbInfo, String errorMessage);
    }

    boolean isNull();

    String getVideoNumber();

    int getViewCounter();

    int getCommentNum();

    int getMylistCounter();

    String getLength();

    String getFormattedLengthForPlayer();

    int getLengthBySecond();

    int getLengthByVpos();

    String getTitle();

    String getParsedTitle();

    String getDescription();

    String getMovieType();

    int getSizeHigh();

    int getSizeLow();

    String getFirstRetrieve();

    Date getFirstRetrieveAsDate();

    String getThumbnailUrl();

    void setEventListener(ThumbInfoInterface.EventListener eventListener);

    public static class NullObject extends XmlLoader.AbstractNullObject
    implements ThumbInfoInterface {
        private static final NullObject sInstance = new NullObject();
        public static NullObject getInstance() {
            return sInstance;
        }

        private NullObject() {
        }

        @Override
        public boolean isNull() {
            return true;
        }

        @Override
        public String getVideoNumber() {
            return null;
        }

        @Override
        public int getViewCounter() {
            return 0;
        }

        @Override
        public int getCommentNum() {
            return 0;
        }

        @Override
        public int getMylistCounter() {
            return 0;
        }

        @Override
        public String getLength() {
            return null;
        }

        @Override
        public String getFormattedLengthForPlayer() {
            return null;
        }

        @Override
        public int getLengthBySecond() {
            return 0;
        }

        @Override
        public int getLengthByVpos() {
            return 0;
        }

        @Override
        public String getTitle() {
            return null;
        }

        @Override
        public String getParsedTitle() {
            return null;
        }

        @Override
        public String getDescription() {
            return null;
        }

        @Override
        public String getMovieType() {
            return null;
        }

        @Override
        public int getSizeHigh() {
            return 0;
        }

        @Override
        public int getSizeLow() {
            return 0;
        }

        @Override
        public String getFirstRetrieve() {
            return null;
        }

        @Override
        public Date getFirstRetrieveAsDate() {
            return null;
        }

        @Override
        public String getThumbnailUrl() {
            return null;
        }

        @Override
        public void setEventListener(EventListener eventListener) {
        }
    }
}
