package jp.sourceforge.nicoro;

import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;

import android.os.AsyncTask;

import java.io.IOException;

import jp.sourceforge.nicoro.NicoroAPIManager.CookieNicoHistoryAndBody;

import static jp.sourceforge.nicoro.Log.LOG_TAG;

public abstract class GetCookieNicoHistoryTask extends AsyncTask<Void, Void, CookieNicoHistoryAndBody> {
    protected String mVideoNumber;
    protected String mCookieUserSession;
    protected String mUserAgent;
    protected int mForceEco;

    protected Exception mException;

    private HttpUriRequest mHttpRequestNicoHistory;

    private boolean mGetBody;

    protected GetCookieNicoHistoryTask(String videoNumber, int forceEco,
            String cookieUserSession, String userAgent, boolean getBody) {
        mVideoNumber = videoNumber;
        mForceEco = forceEco;
        mCookieUserSession = cookieUserSession;
        mUserAgent = userAgent;
        mGetBody = getBody;
    }

    @Override
    protected void onPreExecute() {
        if (mGetBody) {
            mHttpRequestNicoHistory = NicoroAPIManager.createGetCookieNicoHistoryAndBody(
                    mVideoNumber, mCookieUserSession,
                    mForceEco, mUserAgent);
        } else {
            mHttpRequestNicoHistory = NicoroAPIManager.createGetCookieNicoHistory(
                    mVideoNumber, mCookieUserSession,
                    mForceEco, mUserAgent);
        }
    }

    @Override
    protected CookieNicoHistoryAndBody doInBackground(Void... params) {
        DefaultHttpClient httpClient = Util.createHttpClient();
        try {
            if (mGetBody) {
                return NicoroAPIManager.getCookieNicoHistoryAndBody(
                        httpClient, mHttpRequestNicoHistory, mForceEco);
            } else {
                String cookie = NicoroAPIManager.getCookieNicoHistory(
                        httpClient, mHttpRequestNicoHistory, mForceEco);
                CookieNicoHistoryAndBody result = new CookieNicoHistoryAndBody();
                result.cookie = cookie;
                return result;
            }
        } catch (IOException e) {
            Log.e(LOG_TAG, e.toString(), e);
            mException = e;
            return null;
        } finally {
            httpClient.getConnectionManager().shutdown();
        }
    }

    public void stop() {
        cancel(false);
        Util.abortHttpUriRequest(mHttpRequestNicoHistory);
    }
}
