package jp.sourceforge.nicoro;

import android.content.res.Configuration;
import android.content.res.Resources;
import android.test.AndroidTestCase;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;

public class PlayerProgressViewsTest extends AndroidTestCase {
    private LayoutInflater mInflater;
    private View mRootView;
    private Resources mRes;
    private PlayerProgressViews mViews;

    @Override
    protected void setUp() {
        mInflater = LayoutInflater.from(getContext());
        assertNotNull(mInflater);
        FrameLayout temp = new FrameLayout(getContext());
        mRootView = mInflater.inflate(R.layout.player_progress, temp, false);
        assertNotNull(mRootView);
        mRes = getContext().getResources();
        mViews = new PlayerProgressViews();
        mViews.initializeView(mRootView);
    }

    @Override
    protected void tearDown() {
        mInflater = null;
        mRootView = null;
        mRes = null;
        mViews = null;
    }

    public void testSetVisibilityGone() {
        View progressGroup = mRootView.findViewById(R.id.progress_group);
        assertNotNull(progressGroup);

        mViews.setVisibilityGone();
        assertEquals(View.GONE,
                progressGroup.getVisibility());
    }

    public void testSetTextVideo() {
        VariableLabelView progressVideo = Util.findViewById(mRootView,
                R.id.progress_text_video);
        assertNotNull(progressVideo);
        assertEquals(mRes.getString(R.string.progress_video_wait_connect),
                progressVideo.getText());
        assertNotNull(progressVideo.getAnimation());

        mViews.setTextVideoDownloadFinished();
        assertEquals(mRes.getString(R.string.progress_video_finished),
                progressVideo.getText());
        assertNull(progressVideo.getAnimation());

        mViews.setTextVideoError();
        assertEquals(mRes.getString(R.string.progress_video_error),
                progressVideo.getText());
        assertNull(progressVideo.getAnimation());

        mViews.setTextVideoNotifyProgress(3, 4);
        assertEquals("3/4",
                progressVideo.getText());
        assertNull(progressVideo.getAnimation());
    }

    public void testSetTextThumbinfo() {
        VariableLabelView progressThumbinfo = Util.findViewById(mRootView,
                R.id.progress_text_thumbinfo);
        assertNotNull(progressThumbinfo);
        assertEquals(mRes.getString(R.string.progress_thumbinfo_wait),
                progressThumbinfo.getText());
        assertNotNull(progressThumbinfo.getAnimation());

        mViews.setTextThumbinfoFinished();
        assertEquals(mRes.getString(R.string.progress_thumbinfo_finished),
                progressThumbinfo.getText());
        assertNull(progressThumbinfo.getAnimation());

        mViews.setTextThumbinfoError();
        assertEquals(mRes.getString(R.string.progress_thumbinfo_error),
                progressThumbinfo.getText());
        assertNull(progressThumbinfo.getAnimation());
    }

    public void testSetTextMessage() {
        VariableLabelView progressMessage = Util.findViewById(mRootView,
                R.id.progress_text_message);
        assertNotNull(progressMessage);
        assertEquals(mRes.getString(R.string.progress_message_wait),
                progressMessage.getText());
        assertNotNull(progressMessage.getAnimation());

        mViews.setTextMessageFinished();
        assertEquals(mRes.getString(R.string.progress_message_finished),
                progressMessage.getText());
        assertNull(progressMessage.getAnimation());

        mViews.setTextMessageError();
        assertEquals(mRes.getString(R.string.progress_message_error),
                progressMessage.getText());
        assertNull(progressMessage.getAnimation());
    }

    public void testSetTextMessageFork() {
        VariableLabelView progressMessageFork = Util.findViewById(mRootView,
                R.id.progress_text_message_fork);
        assertNotNull(progressMessageFork);
        assertEquals(mRes.getString(R.string.progress_message_fork_wait),
                progressMessageFork.getText());
        assertNotNull(progressMessageFork.getAnimation());

        mViews.setTextMessageForkFinished();
        assertEquals(mRes.getString(R.string.progress_message_fork_finished),
                progressMessageFork.getText());
        assertNull(progressMessageFork.getAnimation());

        mViews.setTextMessageForkError();
        assertEquals(mRes.getString(R.string.progress_message_fork_error),
                progressMessageFork.getText());
        assertNull(progressMessageFork.getAnimation());
    }

    public void testSetTextInner() {
        VariableLabelView progressInner = Util.findViewById(mRootView,
                R.id.progress_text_inner);
        assertNotNull(progressInner);
        assertNull(progressInner.getText());
        assertNull(progressInner.getAnimation());

        mViews.setTextInnerSwfPrepareWait();
        assertEquals(mRes.getString(R.string.progress_swf_prepare_wait),
                progressInner.getText());
        assertNotNull(progressInner.getAnimation());

        mViews.setTextInnerSwfPrepareFinished();
        assertEquals(mRes.getString(R.string.progress_swf_prepare_finished),
                progressInner.getText());
        assertNull(progressInner.getAnimation());
    }

    public void testCopyLayoutParamsFrom() {
        Configuration configOrg = mRes.getConfiguration();
        try {
            Configuration config = new Configuration(configOrg);
            if (config.orientation == Configuration.ORIENTATION_PORTRAIT) {
                config.orientation = Configuration.ORIENTATION_LANDSCAPE;
            } else if (config.orientation == Configuration.ORIENTATION_LANDSCAPE) {
                config.orientation = Configuration.ORIENTATION_PORTRAIT;
            }
            mRes.updateConfiguration(config, mRes.getDisplayMetrics());
            FrameLayout temp = new FrameLayout(getContext());
            ViewGroup anotherRootView = (ViewGroup) LayoutInflater.from(getContext())
                    .inflate(R.layout.player_progress, temp, false);
            assertNotNull(anotherRootView);

            mViews.copyLayoutParamsFrom(anotherRootView);

            TestUtil.checkLayoutParams(mRootView, anotherRootView);
        } finally {
            mRes.updateConfiguration(configOrg, mRes.getDisplayMetrics());
        }
    }
}
