package jp.sourceforge.nicoro;

import static jp.sourceforge.nicoro.Log.LOG_TAG;

import android.content.Context;
import android.content.SharedPreferences;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.preference.PreferenceManager;
import android.support.v4.app.ListFragment;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.BaseAdapter;
import android.widget.ImageView;
import android.widget.ListView;
import android.widget.Spinner;
import android.widget.SpinnerAdapter;

import java.util.ArrayList;

public class RankingFragment extends ListFragment
implements WebBrowserFragmentStarter, AdapterView.OnItemSelectedListener {
    private static final boolean DEBUG_LOGD = Release.IS_DEBUG & true;
//    private static final boolean DEBUG_LOGV = Release.IS_DEBUG & false;

    private static final int MSG_ID_LOAD_FINISHED = 0;
    private static final int MSG_ID_LOAD_OCCURED_ERROR = 1;
    private static final int MSG_ID_CHANGE_LIST = 2;

    private static final String KEY_SELECTION = "selection";
    private static final String KEY_RANKING_LIST_ADAPTER = "RankingListAdapter";

    private Context mContext;
    private SharedPreferences mSharedPreferences;

    RssLoader mRssLoader;
    private RankingListAdapter mAdapter;

    private VariableLabelView mViewTitle;
    private ListEmptyProgressManager mEmptyProgress;
    private Spinner mSpinnerCategory;
    private Spinner mSpinnerTerm;
    private Spinner mSpinnerTarget;

    private ArrayAdapter<?> mAdapterCategory;
    private ArrayAdapter<?> mAdapterCategoryAllOnly;

    private CallbackMessage<String, Void> mBrowserStarter;

    private String mLastUrl;

    private boolean mSavedInstanceState;

    private String mResStringUpload;
    private String mResStringView;
    private String mResStringRes;
    private String mResStringMylist;
    private String mResStringTotal;
    private String mResStringHourly;
    private String mResStringDaily;
    private String mResStringWeekly;
    private String mResStringMonthly;
    private String[] mResStringArrayCategoryUrl;
    private String[] mResStringArrayTermUrl;
    private String[] mResStringArrayTargetUrl;
    private String[] mResStringArrayCategoryAllOnlyUrl;
    private int mResIntegerTermHourlyPosition;
    private int mResIntegerCategoryDefaultPosition;
    private int mResIntegerTermDefaultPosition;
    private int mResIntegerTargetDefaultPosition;

    private Handler mHandler = new Handler() {
        @Override
        public void handleMessage(Message msg) {
            if (isRemoving()) {
                if (DEBUG_LOGD) {
                    Log.d(LOG_TAG, Log.buf().append("Fragment is removing. ignore message=")
                            .append(msg.toString()).toString());
                }
                return;
            }
            if (getActivity() == null) {
                if (DEBUG_LOGD) {
                    Log.d(LOG_TAG, Log.buf().append("Fragment was detached. ignore message=")
                            .append(msg.toString()).toString());
                }
                return;
            }
            RssLoader result;
            switch (msg.what) {
                case MSG_ID_LOAD_FINISHED:
                    result = (RssLoader) msg.obj;
                    // 現在実行中のloaderからの通知のみ画面に反映
                    if (result == mRssLoader) {
                        mEmptyProgress.showEmptyText();
                        mViewTitle.setText(mRssLoader.getTitle());
                        mAdapter.setItems(mRssLoader.getItems());
                        mAdapter.notifyDataSetChanged();
                    }
                    break;
                case MSG_ID_LOAD_OCCURED_ERROR:
                    result = (RssLoader) msg.obj;
                    // 現在実行中のloaderからのエラー通知のみ画面に反映
                    if (result == mRssLoader) {
                        mEmptyProgress.showEmptyText();
                        if (!mSavedInstanceState) {
                            String errorMessage = result.getLastErrorMessage();
                            CloseDialogFragment.createErrorDialog(errorMessage,
                                    false).show(getFragmentManager(),
                                            mContext.getString(R.string.tag_close_dialog_fragment));
                        }
                    }
                    break;
                case MSG_ID_CHANGE_LIST:
                    // 重複イベントは削除
                    removeMessages(MSG_ID_CHANGE_LIST);

                    if (createAndStartRssLoader()) {
                        mEmptyProgress.showEmptyProgress();
                        mViewTitle.setText("");
                        mAdapter.setItems(null);
                        mAdapter.notifyDataSetChanged();
                    }
                    break;
                default:
                    assert false : msg.what;
                    break;
            }
        }
    };

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);

        mContext = getActivity().getApplicationContext();
        mSharedPreferences = PreferenceManager.getDefaultSharedPreferences(mContext);

        mSavedInstanceState = false;

        Resources res = mContext.getResources();
        mResStringUpload = res.getString(R.string.upload);
        mResStringView = res.getString(R.string.view);
        mResStringRes = res.getString(R.string.res);
        mResStringMylist = res.getString(R.string.mylist);
        mResStringTotal = res.getString(R.string.total);
        mResStringHourly = res.getString(R.string.hourly);
        mResStringDaily = res.getString(R.string.daily);
        mResStringWeekly = res.getString(R.string.weekly);
        mResStringMonthly = res.getString(R.string.monthly);
        mResStringArrayCategoryUrl = res.getStringArray(R.array.ranking_category_url);
        mResStringArrayTermUrl = res.getStringArray(R.array.ranking_term_url);
        mResStringArrayTargetUrl = res.getStringArray(R.array.ranking_target_url);
        mResStringArrayCategoryAllOnlyUrl = res.getStringArray(
                R.array.ranking_category_all_only_url);
        mResIntegerTermHourlyPosition = res.getInteger(
                R.integer.ranking_term_hourly_position);
        mResIntegerCategoryDefaultPosition = res.getInteger(
                R.integer.ranking_category_default_position);
        mResIntegerTermDefaultPosition = res.getInteger(
                R.integer.ranking_term_default_position);
        mResIntegerTargetDefaultPosition = res.getInteger(
                R.integer.ranking_target_default_position);
    }

    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container,
            Bundle savedInstanceState) {
        View v = inflater.inflate(R.layout.ranking_list, container, false);
        mEmptyProgress = new ListEmptyProgressManager(v);
        mViewTitle = Util.findViewById(v, R.id.list_title);
        mEmptyProgress.showEmptyProgress();

        SharedPreferences sp = mSharedPreferences;
        int categoryDefault = sp.getInt(NicoroConfig.RANKING_CATEGORY, mResIntegerCategoryDefaultPosition);
        int termDefault = sp.getInt(NicoroConfig.RANKING_TERM, mResIntegerTermDefaultPosition);
        int targetDefault = sp.getInt(NicoroConfig.RANKING_TARGET, mResIntegerTargetDefaultPosition);

        ArrayAdapter<?> adapter;
        mSpinnerCategory = Util.findViewById(v, R.id.spinner_category);

        adapter = ArrayAdapter.createFromResource(mContext,
                R.array.ranking_category, R.layout.ranking_spinner_item);
        mAdapterCategory = adapter;
        adapter.setDropDownViewResource(android.R.layout.simple_spinner_dropdown_item);

        adapter = ArrayAdapter.createFromResource(mContext,
                R.array.ranking_category_all_only, R.layout.ranking_spinner_item);
        mAdapterCategoryAllOnly = adapter;
        adapter.setDropDownViewResource(android.R.layout.simple_spinner_dropdown_item);

        if (termDefault == mResIntegerTermHourlyPosition) {
            mSpinnerCategory.setAdapter(mAdapterCategoryAllOnly);
        } else {
            mSpinnerCategory.setAdapter(mAdapterCategory);
        }

        mSpinnerTerm = Util.findViewById(v, R.id.spinner_term);
        adapter = ArrayAdapter.createFromResource(mContext,
                R.array.ranking_term, R.layout.ranking_spinner_item);
        adapter.setDropDownViewResource(android.R.layout.simple_spinner_dropdown_item);
        mSpinnerTerm.setAdapter(adapter);

        mSpinnerTarget = Util.findViewById(v, R.id.spinner_target);
        adapter = ArrayAdapter.createFromResource(mContext,
                R.array.ranking_target, R.layout.ranking_spinner_item);
        adapter.setDropDownViewResource(android.R.layout.simple_spinner_dropdown_item);
        mSpinnerTarget.setAdapter(adapter);

        if (savedInstanceState == null) {
            mSpinnerCategory.setOnItemSelectedListener(this);
            mSpinnerTerm.setOnItemSelectedListener(this);
            mSpinnerTarget.setOnItemSelectedListener(this);

            mSpinnerTerm.setSelection(termDefault);
            mSpinnerCategory.setSelection(categoryDefault);
            mSpinnerTarget.setSelection(targetDefault);
        } else {
            // 復帰時は読み込みが起きないようListener設定前にselectionを変える
            mSpinnerTerm.setSelection(termDefault);
            mSpinnerCategory.setSelection(categoryDefault);
            mSpinnerTarget.setSelection(targetDefault);

            mSpinnerCategory.setOnItemSelectedListener(this);
            mSpinnerTerm.setOnItemSelectedListener(this);
            mSpinnerTarget.setOnItemSelectedListener(this);
        }

        return v;
    }

    @Override
    public void onActivityCreated(Bundle savedInstanceState) {
        super.onActivityCreated(savedInstanceState);

        ListView listView = getListView();
        mAdapter = new RankingListAdapter();
        int selection = AdapterView.INVALID_POSITION;
        if (savedInstanceState != null) {
            selection = savedInstanceState.getInt(KEY_SELECTION,
                    AdapterView.INVALID_POSITION);
            mAdapter.onRestoreInstanceState(savedInstanceState);
        }
        setListAdapter(mAdapter);
        if (selection >= 0) {
            listView.setSelection(selection);
        }
        listView.setOnItemClickListener(new AdapterView.OnItemClickListener() {
            @Override
            public void onItemClick(AdapterView<?> parent, View view,
                    int position, long id) {
                if (mBrowserStarter != null) {
                    String url = mRssLoader.getItems().get(position).link;

                    mBrowserStarter.sendMessageSuccess(url);
                }
            }
        });
    }

    @Override
    public void onPause() {
        super.onPause();
        mLastUrl = null;

        SharedPreferences.Editor editor = mSharedPreferences.edit();
        editor.putInt(NicoroConfig.RANKING_CATEGORY, mSpinnerCategory.getSelectedItemPosition());
        editor.putInt(NicoroConfig.RANKING_TERM, mSpinnerTerm.getSelectedItemPosition());
        editor.putInt(NicoroConfig.RANKING_TARGET, mSpinnerTarget.getSelectedItemPosition());
        editor.commit();
    }

    @Override
    public void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        ListView listView = getListView();
//        int selected = listView.getSelectedItemPosition();
        int selected = listView.getFirstVisiblePosition();
        if (selected >= 0) {
            outState.putInt(KEY_SELECTION, selected);
        }
        mAdapter.onSaveInstanceState(outState);
        mSavedInstanceState = true;
    }

    @Override
    public void setBrowserStarterCallback(CallbackMessage<String, Void> callback) {
        mBrowserStarter = callback;
    }

    @Override
    public void onItemSelected(AdapterView<?> parent, View view, int position, long id) {
        // 毎時はカテゴリ合算のみ
        boolean changeAdapter = false;
        if (parent == mSpinnerTerm) {
            SpinnerAdapter currentCategoryAdapter = mSpinnerCategory.getAdapter();
            if (mResIntegerTermHourlyPosition == position) {
                if (currentCategoryAdapter != mAdapterCategoryAllOnly) {
                    mSpinnerCategory.setAdapter(mAdapterCategoryAllOnly);
                    changeAdapter = true;
                }
            } else {
                if (currentCategoryAdapter != mAdapterCategory) {
                    mSpinnerCategory.setAdapter(mAdapterCategory);
                    changeAdapter = true;
                }
            }
        }
        if (!changeAdapter) {
            mHandler.sendEmptyMessage(MSG_ID_CHANGE_LIST);
        }
    }

    @Override
    public void onNothingSelected(AdapterView<?> parent) {
    }

    private boolean createAndStartRssLoader() {
        assert mHandler != null;

        String category;
        int positionCategory = mSpinnerCategory.getSelectedItemPosition();
        SpinnerAdapter currentCategoryAdapter = mSpinnerCategory.getAdapter();
        if (currentCategoryAdapter == mAdapterCategoryAllOnly) {
            category = mResStringArrayCategoryAllOnlyUrl[positionCategory];
        } else {
            assert currentCategoryAdapter == mAdapterCategory;
            category = mResStringArrayCategoryUrl[positionCategory];
        }
        String term = mResStringArrayTermUrl[mSpinnerTerm.getSelectedItemPosition()];
        String target = mResStringArrayTargetUrl[mSpinnerTarget.getSelectedItemPosition()];
        String url = new StringBuilder("http://www.nicovideo.jp/ranking/")
            .append(target).append('/').append(term).append('/')
            .append(category).append("?rss=2.0").toString();

        if (TextUtils.equals(mLastUrl, url)) {
            // 前回と同じ場合は読み込み省略
            return false;
        }
        mLastUrl = url;

        // TODO ここでCookie取得すべきかどうか
        SharedPreferences sp = mSharedPreferences;
        String userSession = sp.getString(NicoroConfig.COOKIE_USER_SESSION, null);
        RssLoader loader = new RssLoader(
                url,
                userSession);
        // TODO: ANR対策の為に***Loader類のabort対応が必要
        if (mRssLoader != null) {
            mRssLoader.finish();
        }
        mRssLoader = loader;
        CallbackMessage<RssLoader, RssLoader> callback = new CallbackMessage<RssLoader, RssLoader>(
                mHandler, MSG_ID_LOAD_FINISHED, MSG_ID_LOAD_OCCURED_ERROR);
        loader.registerCallback(callback);
        loader.startLoad();
        return true;
    }

    private class RankingListAdapter extends BaseAdapter {
        private ArrayList<RssLoader.Item> mItems;
        private ThumbnailCacher mThumbnailCacher =
            NicoroApplication.getInstance(getActivity())
                .getThumbnailCacher();

        @Override
        public int getCount() {
            if (mItems == null) {
                return 0;
            } else {
                return mItems.size();
            }
        }

        @Override
        public Object getItem(int position) {
            // TODO 自動生成されたメソッド・スタブ
            return null;
        }

        @Override
        public long getItemId(int position) {
            return position;
        }

        @Override
        public View getView(int position, View convertView, ViewGroup parent) {
            View view;
            ListItem listItem;
            if (convertView == null) {
                LayoutInflater inflater = getActivity().getLayoutInflater();
                view = inflater.inflate(R.layout.ranking, parent, false);
                listItem = new ListItem();
                view.setTag(listItem);
                listItem.thumbnail = Util.findViewById(view, R.id.thumbnail);
                listItem.title = Util.findViewById(view, R.id.title);
                listItem.description = Util.findViewById(view, R.id.description);
                listItem.info1 = Util.findViewById(view, R.id.info1);
                listItem.info2 = Util.findViewById(view, R.id.info2);
                listItem.info3 = Util.findViewById(view, R.id.info3);
                listItem.info4 = Util.findViewById(view, R.id.info4);
                listItem.info5 = Util.findViewById(view, R.id.info5);
                listItem.info6 = Util.findViewById(view, R.id.info6);
            } else {
                view = convertView;
                listItem = (ListItem) convertView.getTag();
            }
            RssLoader.Item item = mItems.get(position);

            AsyncBitmapDrawable drawable;
            ViewGroup.LayoutParams params = listItem.thumbnail.getLayoutParams();
            if (item.thumbnail == null) {
                drawable = new AsyncBitmapDrawable(null,
                        params.width, params.height);
            } else {
                Bitmap bitmap = mThumbnailCacher.getThumbnail(item.thumbnail);
                if (bitmap == null) {
                    drawable = new AsyncBitmapDrawable(params.width, params.height, true);
                    mThumbnailCacher.loadThumbnail(item.thumbnail,
                            new CallbackMessage<Bitmap, Void>(
                                    drawable.getHandler(), 0));
                } else {
                    drawable = new AsyncBitmapDrawable(bitmap,
                            params.width, params.height, true);
                }
            }
            listItem.thumbnail.setImageDrawable(drawable);

            listItem.title.setText(item.title);
            listItem.description.setText(item.description);

            StringBuilder builder = listItem.info1.getTextBuilderWithClear();
            builder.append(item.infoNumber)
                .append("pts.｜")
                .append(item.infoLength)
                .append("｜")
                .append(item.infoDate)
                .append(' ')
                .append(mResStringUpload);
            listItem.info1.notifyUpdateText();

            updateViewTotal(listItem.info2, item);
            updateViewHourly(listItem.info3, item);
            updateViewDaily(listItem.info4, item);
            updateViewWeekly(listItem.info5, item);
            updateViewMonthly(listItem.info6, item);

            return view;
        }

        private void updateViewTotal(VariableLabelView info, RssLoader.Item item) {
            if (item.infoTotalView == null) {
                info.setVisibility(View.GONE);
            } else {
                info.setVisibility(View.VISIBLE);
                StringBuilder builder = info.getTextBuilderWithClear();
                if (item.infoTotalRes == null || item.infoTotalMylist == null) {
                    Log.w(LOG_TAG, "info hourly is lacked");
                }
                builder.append(mResStringTotal)
                    .append(' ').append(mResStringView).append('：')
                    .append(item.infoTotalView)
                    .append(' ').append(mResStringRes).append('：')
                    .append(item.infoTotalRes)
                    .append(' ').append(mResStringMylist).append('：')
                    .append(item.infoTotalMylist);
                info.notifyUpdateText();
            }
        }
        private void updateViewHourly(VariableLabelView info, RssLoader.Item item) {
            if (item.infoHourlyView == null) {
                info.setVisibility(View.GONE);
            } else {
                info.setVisibility(View.VISIBLE);
                StringBuilder builder = info.getTextBuilderWithClear();
                if (item.infoHourlyRes == null || item.infoHourlyMylist == null) {
                    Log.w(LOG_TAG, "info hourly is lacked");
                }
                builder.append(mResStringHourly)
                    .append(' ').append(mResStringView).append('：')
                    .append(item.infoHourlyView)
                    .append(' ').append(mResStringRes).append('：')
                    .append(item.infoHourlyRes)
                    .append(' ').append(mResStringMylist).append('：')
                    .append(item.infoHourlyMylist);
                info.notifyUpdateText();
            }
        }
        private void updateViewDaily(VariableLabelView info, RssLoader.Item item) {
            if (item.infoDailyView == null) {
                info.setVisibility(View.GONE);
            } else {
                info.setVisibility(View.VISIBLE);
                StringBuilder builder = info.getTextBuilderWithClear();
                if (item.infoDailyRes == null || item.infoDailyMylist == null) {
                    Log.w(LOG_TAG, "info daily is lacked");
                }
                builder.append(mResStringDaily)
                    .append(' ').append(mResStringView).append('：')
                    .append(item.infoDailyView)
                    .append(' ').append(mResStringRes).append('：')
                    .append(item.infoDailyRes)
                    .append(' ').append(mResStringMylist).append('：')
                    .append(item.infoDailyMylist);
                info.notifyUpdateText();
            }
        }
        private void updateViewWeekly(VariableLabelView info, RssLoader.Item item) {
            if (item.infoWeeklyView == null) {
                info.setVisibility(View.GONE);
            } else {
                info.setVisibility(View.VISIBLE);
                StringBuilder builder = info.getTextBuilderWithClear();
                if (item.infoWeeklyRes == null || item.infoWeeklyMylist == null) {
                    Log.w(LOG_TAG, "info hourly is lacked");
                }
                builder.append(mResStringWeekly)
                    .append(' ').append(mResStringView).append('：')
                    .append(item.infoWeeklyView)
                    .append(' ').append(mResStringRes).append('：')
                    .append(item.infoWeeklyRes)
                    .append(' ').append(mResStringMylist).append('：')
                    .append(item.infoWeeklyMylist);
                info.notifyUpdateText();
            }
        }
        private void updateViewMonthly(VariableLabelView info, RssLoader.Item item) {
            if (item.infoMonthlyView == null) {
                info.setVisibility(View.GONE);
            } else {
                info.setVisibility(View.VISIBLE);
                StringBuilder builder = info.getTextBuilderWithClear();
                if (item.infoMonthlyRes == null || item.infoMonthlyMylist == null) {
                    Log.w(LOG_TAG, "info hourly is lacked");
                }
                builder.append(mResStringMonthly)
                    .append(' ').append(mResStringView).append('：')
                    .append(item.infoMonthlyView)
                    .append(' ').append(mResStringRes).append('：')
                    .append(item.infoMonthlyRes)
                    .append(' ').append(mResStringMylist).append('：')
                    .append(item.infoMonthlyMylist);
                info.notifyUpdateText();
            }
        }

        public void setItems(ArrayList<RssLoader.Item> items) {
            if (items == null) {
                if (mItems != null) {
                    mItems.clear();
                }
            } else {
                if (mItems == null) {
                    mItems = new ArrayList<RssLoader.Item>(items);
                } else {
                    mItems.clear();
                    mItems.addAll(items);
                }
            }
        }

        public void onSaveInstanceState(Bundle outState) {
            outState.putParcelableArrayList(KEY_RANKING_LIST_ADAPTER, mItems);
        }

        public void onRestoreInstanceState(Bundle savedInstanceState) {
            ArrayList<RssLoader.Item> items =
                savedInstanceState.getParcelableArrayList(KEY_RANKING_LIST_ADAPTER);
            setItems(items);
        }
    }

    private static class ListItem {
        public ImageView thumbnail;
        public VariableLabelView title;
        public VariableLabelView description;
        public VariableLabelView info1;
        public VariableLabelView info2;
        public VariableLabelView info3;
        public VariableLabelView info4;
        public VariableLabelView info5;
        public VariableLabelView info6;
    }
}
