package jp.sourceforge.nicoro;

import android.app.Activity;
import android.view.View;
import android.view.ViewGroup;
import android.widget.CompoundButton;
import android.widget.ImageButton;
import android.widget.SeekBar;
import android.widget.ToggleButton;

public class PlayerControllerViews {
    /** nullの可能性あり */
    private VariableLabelView mControllerTime;
    /** nullの可能性あり */
    private ImageButton mButtonPause;
    /** nullの可能性あり */
    private ImageButton mButtonFromBegin;
    private ToggleButton mButtonCommentOnOff;
    /** nullの可能性あり */
    private SeekBar mSeekBar;
    private ViewGroup mPlayerController;

    SeekBar.OnSeekBarChangeListener mOnSeekBarChangeListener;
    boolean mIsTrackingSeekBar = false;

    public void initializeView(Activity activity) {
        View root = activity.getWindow().getDecorView();
        initializeView(root);
    }

    public void initializeView(View root) {
        mControllerTime = Util.findViewById(root, R.id.controller_time);
        mButtonPause = Util.findViewById(root, R.id.button_pause);
        mButtonFromBegin = Util.findViewById(root, R.id.button_from_begin);
        mButtonCommentOnOff = Util.findViewById(root, R.id.button_comment_onoff);
        mSeekBar = Util.findViewById(root, R.id.seek_bar);
        mPlayerController = Util.findViewById(root, R.id.player_controller);
    }

    public void setButtonPauseOnClickListener(View.OnClickListener listener) {
        if (mButtonPause == null) {
            return;
        }
        mButtonPause.setOnClickListener(listener);
    }
    public void setButtonFromBeginOnClickListener(View.OnClickListener listener) {
        if (mButtonFromBegin == null) {
            return;
        }
        mButtonFromBegin.setOnClickListener(listener);
    }
    public void setButtonCommentOnOffOnCheckedChangeListener(CompoundButton.OnCheckedChangeListener listener) {
        mButtonCommentOnOff.setOnCheckedChangeListener(listener);
    }

    public void setOnSeekBarChangeListener(SeekBar.OnSeekBarChangeListener listener) {
        mOnSeekBarChangeListener = listener;
        if (mSeekBar == null) {
            return;
        }
        mSeekBar.setOnSeekBarChangeListener(new SeekBar.OnSeekBarChangeListener() {
            @Override
            public void onProgressChanged(SeekBar seekBar, int progress,
                    boolean fromUser) {
                assert seekBar == mSeekBar;
                mOnSeekBarChangeListener.onProgressChanged(seekBar, progress,
                        fromUser);
            }
            @Override
            public void onStartTrackingTouch(SeekBar seekBar) {
                mIsTrackingSeekBar = true;
                assert seekBar == mSeekBar;
                mOnSeekBarChangeListener.onStartTrackingTouch(seekBar);
            }
            @Override
            public void onStopTrackingTouch(SeekBar seekBar) {
                mIsTrackingSeekBar = false;
                assert seekBar == mSeekBar;
                mOnSeekBarChangeListener.onStopTrackingTouch(seekBar);
            }
        });
    }

    public void copyLayoutParamsFrom(ViewGroup src) {
        if (mControllerTime != null) {
            Util.copyLayoutParamsById(mControllerTime, src);
        }
    }

    public void setTime(String text) {
        if (mControllerTime == null) {
            return;
        }
        StringBuilder controllerTimeData = mControllerTime.getTextBuilder();
        controllerTimeData.replace(0, controllerTimeData.length(), text);
        mControllerTime.notifyUpdateText();
    }

    public boolean hasControllerTime() {
        return (mControllerTime != null);
    }

    public void setButtonPauseImage(boolean isPausePlay) {
        if (mButtonPause == null) {
            return;
        }
        int icon;
        // 一時停止中は再生ボタン、再生中は一時停止ボタンを表示
        if (isPausePlay) {
            icon = android.R.drawable.ic_media_play;
        } else {
            icon = android.R.drawable.ic_media_pause;
        }
        mButtonPause.setImageResource(icon);
    }

    public void setEnabledSeekController(boolean enabled) {
        if (mSeekBar != null) {
            mSeekBar.setEnabled(enabled);
        }
        if (mButtonFromBegin != null) {
            mButtonFromBegin.setEnabled(enabled);
        }
    }

    public ViewGroup getControllerView() {
        return mPlayerController;
    }

    /**
     * SeekBarの最大値を設定
     * @param second 最大値（秒）
     */
    public void setSeekBarMax(int second) {
        if (mSeekBar == null) {
            return;
        }
        mSeekBar.setMax(second);
    }

    /**
     * SeekBarのcurrent progressを設定
     * @param second （秒）
     */
    public void setSeekBarProgress(int second) {
        if (mSeekBar == null) {
            return;
        }
        mSeekBar.setProgress(second);
    }

    /**
     * SeekBarのsecondary progressを分数で設定
     * @param num 分子
     * @param den 分母
     */
    public void setSeekBarSecondaryProgress(long num, int den) {
        if (mSeekBar == null) {
            return;
        }
        mSeekBar.setSecondaryProgress(
                (int) ((long) mSeekBar.getMax() * num / den));
    }

    /**
     * SeekBarのsecondary progressを現在の最大値に設定
     */
    public void setSeekBarSecondaryMax() {
        if (mSeekBar == null) {
            return;
        }
        mSeekBar.setSecondaryProgress(mSeekBar.getMax());
    }

    public boolean canUpdateSeekBarProgress() {
        if (mSeekBar == null) {
            return false;
        }
        return !mIsTrackingSeekBar && mSeekBar.isEnabled();
    }

    public void setCheckedButtonCommentOnOff(boolean checked) {
        mButtonCommentOnOff.setChecked(checked);
    }
}
