package jp.sourceforge.nicoro;

import static jp.sourceforge.nicoro.Log.LOG_TAG;

import java.io.IOException;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;

import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;

import android.graphics.Bitmap;
import android.os.Handler;
import android.os.Message;

public class ThumbnailCacher extends LooperThread {
	private static final int MSG_ID_LOAD_THUMBNAIL = 0;
	
	private static class Params {
		public String url;
        public WeakReference<Handler> handler;
		public int reply;
		
		public Params() {
		}
		public Params(String u, Handler h, int r) {
			url = u;
			handler = new WeakReference<Handler>(h);
			reply = r;
		}
	}
	
	private ConcurrentHashMap<String, SoftReference<Bitmap>> mThumbnailCache =
		new ConcurrentHashMap<String, SoftReference<Bitmap>>();
	private volatile HttpUriRequest mCurrentHttpRequest;
	private DefaultHttpClient mHttpClient;
	
	public ThumbnailCacher() {
		super("ThumbnailCacher");
	}

	@Override
	public boolean handleMessage(Message msg) {
		switch (msg.what) {
		case MSG_ID_LOAD_THUMBNAIL:
			Params params = (Params) msg.obj;
			// ダウンロード前にもう一度確認（別のリクエストでダウンロード済みかもしれないので）
			Bitmap bitmap = getThumbnail(params.url);
			try {
				if (bitmap == null) {
					HttpGet httpRequest = new HttpGet(params.url);
					mCurrentHttpRequest = httpRequest;
					if (mHttpClient == null) {
						mHttpClient = Util.createHttpClient(15 * 1000);
					}
					bitmap = Util.loadBitmap(mHttpClient, httpRequest);
					mCurrentHttpRequest = null;
					if (bitmap != null) {
						mThumbnailCache.put(params.url, new SoftReference<Bitmap>(bitmap));
					}
				}
				
				if (bitmap != null) {
				    Handler handler = params.handler.get();
				    if (handler != null) {
				        handler.obtainMessage(params.reply, bitmap)
				            .sendToTarget();
				    }
				}
			} catch (ClientProtocolException e) {
				Log.e(LOG_TAG, e.toString(), e);
				// 再ダウンロード
				mCurrentHttpRequest = null;
				mHttpClient = null;
				getHandler().obtainMessage(MSG_ID_LOAD_THUMBNAIL, params).sendToTarget();
			} catch (IOException e) {
				Log.e(LOG_TAG, e.toString(), e);
				// 再ダウンロード
				mCurrentHttpRequest = null;
				mHttpClient = null;
				getHandler().obtainMessage(MSG_ID_LOAD_THUMBNAIL, params).sendToTarget();
			}
			break;
		default:
			assert false : msg.what;
			break;
		}
		return true;
	}
	
	@Override
	public boolean quit() {
		boolean ret = super.quit();
		HttpUriRequest request = mCurrentHttpRequest;
		if (request != null && !request.isAborted()) {
			request.abort();
		}
		return ret;
	}
	
	public void onLowMemory() {
	    for (Iterator<String> it = mThumbnailCache.keySet().iterator(); it.hasNext(); ) {
	        String key = it.next();
            SoftReference<Bitmap> ref = mThumbnailCache.get(key);
            Bitmap bitmap = (ref == null ? null : ref.get());
            if (bitmap == null) {
                it.remove();
            }
	    }
	}

	public Bitmap getThumbnail(String url) {
		SoftReference<Bitmap> ref = mThumbnailCache.get(url);
		if (ref != null) {
			return ref.get();
		}
		return null;
	}
	
	public void loadThumbnail(String url, Handler handler, int reply) {
		Params params = new Params(url, handler, reply);
		getHandler().obtainMessage(MSG_ID_LOAD_THUMBNAIL, params).sendToTarget();
	}
}
