package jp.sourceforge.nicoro.nicoscript;

import jp.sourceforge.nicoro.Log;
import static jp.sourceforge.nicoro.Log.LOG_TAG;
import jp.sourceforge.nicoro.MessageChatController;
import jp.sourceforge.nicoro.MessageChatFork;
import jp.sourceforge.nicoro.Release;

// TODO @button考慮

public class NicoScriptReplace extends NicoScript
implements NicoScript.NicosOrLocal, NicoScript.GetStyle {
    private static final boolean DEBUG_LOGD = Release.IS_DEBUG & true;

    protected static final String COMMAND = "置換";

    /** 一致した場合に置換する文字列 */
    private String mReplaced;

    /**
     * <ul>
     * <li>true: コメント全体を置換
     * <li>false: 該当箇所だけ置換
     * </ul>
     */
    private boolean mAllReplace;
    /**
     * <ul>
     * <li>true: 投稿者コメント・ニコスクリプトを置換対象に含む
     * <li>false: 投稿者コメント・ニコスクリプトを置換対象に含まない
     * </ul>
     */
    private boolean mIncludeContributor;

    private final SingleKeyword mSingleKeyword = new SingleKeyword();

    public NicoScriptReplace(MessageChatFork chat, CommandSplitter commandSplitter) {
        super(chat);
        if (chat.getTime() < 0) {
            chat.setTime(UNDEFINED_DEFAULT_TIME);
        }

        mSingleKeyword.setKeyword(commandSplitter.getNextCommand());
        mReplaced = commandSplitter.getNextCommandPhraze();

        mAllReplace = false;
        mIncludeContributor = false;

        for (String cmd = commandSplitter.getNextCommand();
                cmd != null;
                cmd = commandSplitter.getNextCommand()) {
            if (cmd.startsWith("単")) {
                mAllReplace = false;
            } else if (cmd.startsWith("全")) {
                mAllReplace = true;
            } else if (cmd.startsWith("含まない")) {
                mIncludeContributor = false;
            } else if (cmd.startsWith("含む")) {
                mIncludeContributor = true;
            } else {
                mSingleKeyword.setAgreeEntirely(cmd);
            }
        }
    }

    public boolean isIncludeContributor() {
        return mIncludeContributor;
    }

    @Override
    public boolean match(String text) {
        return mSingleKeyword.match(text);
    }

    public String replace(String text) {
        if (text == null || mSingleKeyword.mKeyword == null || mReplaced == null) {
            return text;
        }
        if (mAllReplace) {
            return mReplaced;
        } else {
            return text.replace(mSingleKeyword.mKeyword, mReplaced);
        }
    }

    @Override
    public void onPrepareRemove(MessageChatController controller) {
        controller.removeCommandReplace(this);
        if (DEBUG_LOGD) {
            Log.d(LOG_TAG, Log.buf().append("End NicoScript Replace: ")
                    .append(mChat).toString());
        }
    }
    @Override
    public void onDraw(MessageChatController controller) {
        controller.addCommandReplace(this);
        if (DEBUG_LOGD) {
            Log.d(LOG_TAG, Log.buf().append("Start NicoScript Replace: ")
                    .append(mChat).toString());
        }
    }

    @Override
    public int getColor() {
        return mChat.getColor();
    }

    @Override
    public int getFontSize() {
        return mChat.getFontSize();
    }

    @Override
    public int getFontSizeType() {
        return mChat.getFontSizeType();
    }

    @Override
    public int getPos() {
        return mChat.getPos();
    }

    @Override
    public int getLineHeight() {
        return mChat.getLineHeight();
    }

    @Override
    public boolean isSaveLocal() {
        return mChat.isSaveLocal();
    }
}
