package jp.sourceforge.nicoro.nicoscript;

import static jp.sourceforge.nicoro.Log.LOG_TAG;
import jp.sourceforge.nicoro.Log;
import jp.sourceforge.nicoro.MessageChatController;
import jp.sourceforge.nicoro.MessageChatFork;
import jp.sourceforge.nicoro.Release;

public class NicoScriptDefault extends NicoScript
implements NicoScript.GetStyle {
    private static final boolean DEBUG_LOGD = Release.IS_DEBUG && true;

    protected static final String COMMAND = "デフォルト";

    public NicoScriptDefault(MessageChatFork chat) {
        super(chat);
        if (chat.getTime() < 0) {
            // 最後まで
            chat.setTime(Integer.MAX_VALUE);
        }
    }

    @Override
    public void onPrepareRemove(MessageChatController controller) {
        controller.clearCommandDefault(this);
        if (DEBUG_LOGD) {
            Log.d(LOG_TAG, Log.buf().append("End NicoScript Default: ")
                    .append(mChat).toString());
        }
    }
    @Override
    public void onDraw(MessageChatController controller) {
        controller.setCommandDefault(this);
        if (DEBUG_LOGD) {
            Log.d(LOG_TAG, Log.buf().append("Start NicoScript Default: ")
                    .append(mChat).toString());
        }
    }

    @Override
    public int getColor() {
        return mChat.getColor();
    }

    @Override
    public int getFontSize() {
        return mChat.getFontSize();
    }

    @Override
    public int getFontSizeType() {
        return mChat.getFontSizeType();
    }

    @Override
    public int getPos() {
        return mChat.getPos();
    }

    @Override
    public int getLineHeight() {
        return mChat.getLineHeight();
    }
}
