package jp.sourceforge.nicoro;

import static jp.sourceforge.nicoro.Log.LOG_TAG;

import android.app.Activity;
import android.app.ProgressDialog;
import android.os.AsyncTask;
import android.os.RemoteException;

/**
 * 実行前にVideoCacheServiceにbind済みであること
 *
 */
public class CacheStopTask extends AsyncTask<Void, Void, Void> {
    private ProgressDialog mProgressDialog;

    private Activity mActivity;
    private String mVideoNumber;

    private VideoCacheServiceConnection mVideoCacheServiceConnection;

    public CacheStopTask(Activity activity,
            String videoNumber) {
        mActivity = activity;
        mVideoNumber = videoNumber;
    }

    @Override
    protected void onPreExecute() {
        mProgressDialog = Util.createProgressDialogLoading(
                mActivity, R.string.progress_stop_cache_one, null);
        mProgressDialog.show();
        mVideoCacheServiceConnection =
            NicoroApplication.getInstance(mActivity).getVideoCacheServiceConnection();
    }
    @Override
    protected Void doInBackground(Void... params) {
        IVideoCacheService videoCacheService =
            mVideoCacheServiceConnection.getIVideoCacheService();
        // XXX エラーチェック
        if (videoCacheService != null) {
            try {
                videoCacheService.stopCache(mVideoNumber);
                videoCacheService.clearNotification(mVideoNumber);
            } catch (RemoteException e) {
                Log.e(LOG_TAG, e.toString(), e);
            }
        }
        return null;
    }
    /**
     * 追加処理を行いたいときはoverrideすること
     */
    @Override
    protected void onPostExecute(Void result) {
        // XXX dismissでIllegalArgumentExceptionのエラーレポートが出たがどういうタイミングで起きるのか？
        // →dismissする前にonDestory起きたとき？onCreateDialog使った方がいいか？
        mProgressDialog.dismiss();
        mProgressDialog = null;
        mActivity = null;
        mVideoCacheServiceConnection = null;
    }
}
