package jp.sourceforge.nicoro.nicoscript;

import static jp.sourceforge.nicoro.Log.LOG_TAG;

import jp.sourceforge.nicoro.Log;
import jp.sourceforge.nicoro.MessageChatController;
import jp.sourceforge.nicoro.MessageChatFork;
import jp.sourceforge.nicoro.Release;

// TODO とりあえずparseだけでメイン動作は後で実装

// TODO @button考慮

public class NicoScriptVote extends NicoScript
implements NicoScript.NicosOrLocal, NicoScript.GetStyleSide {
    private static final boolean DEBUG_LOGD = Release.IS_DEBUG & true;

    protected static final String COMMAND_PREFIX = "投票";

    private final Label mLabel = new Label();
    private boolean mIsProgressVisible;
    private String mUnit;

    private final MultiKeyword mMultiKeyword = new MultiKeyword();

    protected NicoScriptVote(MessageChatFork chat, String commandMain,
            CommandSplitter commandSplitter) {
        super(chat);
        if (chat.getTime() < 0) {
            chat.setTime(UNDEFINED_DEFAULT_TIME);
        }

        mIsProgressVisible = true;
        mUnit = "人";

        // TODO デフォルトのコメントスタイルの設定（上書き）

        mLabel.setLabel(commandMain);

        String keyword = commandSplitter.getNextCommand();
        if (keyword == null) {
            return;
        }
        mMultiKeyword.setKeyword(keyword);

        String progress = commandSplitter.getNextCommand();
        if (progress == null) {
            return;
        }
        if (progress.startsWith("表示")) {
            mIsProgressVisible = true;
        } else if (progress.startsWith("非表示")) {
            mIsProgressVisible = false;
        } else {
            Log.w(LOG_TAG, Log.buf().append("invalid Vote: progress=")
                    .append(progress).toString());
            return;
        }

        String unit = commandSplitter.getNextCommand();
        if (unit == null) {
            return;
        }
        mUnit = unit;

        String agreeEntirely = commandSplitter.getNextCommand();
        if (agreeEntirely == null) {
            return;
        }
        if (!mMultiKeyword.setAgreeEntirely(agreeEntirely)) {
            Log.w(LOG_TAG, Log.buf().append("invalid Vote: agreeEntirely=")
                    .append(agreeEntirely).toString());
            return;
        }
    }

    @Override
    public void onPrepareRemove(MessageChatController controller) {
        controller.removeCommandVote(this);
        if (DEBUG_LOGD) {
            Log.d(LOG_TAG, Log.buf().append("End NicoScript Vote: ")
                    .append(mChat).toString());
        }
    }
    @Override
    public void onDraw(MessageChatController controller) {
        controller.addCommandVote(this);
        if (DEBUG_LOGD) {
            Log.d(LOG_TAG, Log.buf().append("Start NicoScript Vote: ")
                    .append(mChat).toString());
        }
    }

    @Override
    public boolean isSaveLocal() {
        return mChat.isSaveLocal();
    }

    @Override
    public boolean match(String text) {
        return mMultiKeyword.match(text);
    }

    @Override
    public int getColor() {
        // TODO 自動生成されたメソッド・スタブ
        return 0;
    }

    @Override
    public int getFontSize() {
        // TODO 自動生成されたメソッド・スタブ
        return 0;
    }

    @Override
    public int getFontSizeType() {
        // TODO 自動生成されたメソッド・スタブ
        return 0;
    }

    @Override
    public int getPos() {
        // TODO 自動生成されたメソッド・スタブ
        return 0;
    }

    @Override
    public int getLineHeight() {
        // TODO 自動生成されたメソッド・スタブ
        return 0;
    }

    @Override
    public int getPosSide() {
        // TODO 自動生成されたメソッド・スタブ
        return 0;
    }

    public String getLabel() {
        return mLabel.getLabel();
    }

    public boolean isProgressVisible() {
        return mIsProgressVisible;
    }

    public String getUnit() {
        return mUnit;
    }
}
