package jp.sourceforge.nicoro.nicoscript;

import static jp.sourceforge.nicoro.Log.LOG_TAG;
import jp.sourceforge.nicoro.Log;
import jp.sourceforge.nicoro.MessageChatController;
import jp.sourceforge.nicoro.MessageChatFork;
import jp.sourceforge.nicoro.Release;

public class NicoScriptForbidSeek extends NicoScript {
    private static final boolean DEBUG_LOGD = Release.IS_DEBUG & true;

    protected static final String COMMAND = "シーク禁止";

    public NicoScriptForbidSeek(MessageChatFork chat) {
        super(chat);
        if (chat.getTime() < 0) {
            chat.setTime(UNDEFINED_DEFAULT_TIME);
        }
    }

    @Override
    public void onPrepareRemove(MessageChatController controller) {
        controller.allowSeek();
        if (DEBUG_LOGD) {
            Log.d(LOG_TAG, Log.buf().append("End NicoScript ForbidSeek: ")
                    .append(mChat).toString());
        }
    }
    @Override
    public void onDraw(MessageChatController controller) {
        controller.forbidSeek();
        if (DEBUG_LOGD) {
            Log.d(LOG_TAG, Log.buf().append("Start NicoScript ForbidSeek: ")
                    .append(mChat).toString());
        }
    }
}
