package jp.sourceforge.nicoro;

import android.content.Context;
import android.util.AttributeSet;
import android.widget.RelativeLayout;

public class PlayerParentScreenLayout extends RelativeLayout {
    private LayoutListener mLayoutListener;

    public PlayerParentScreenLayout(Context context) {
        super(context);
    }

    public PlayerParentScreenLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public PlayerParentScreenLayout(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
    }

    @Override
    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        super.onLayout(changed, l, t, r, b);
        if (changed) {
            if (mLayoutListener != null) {
                mLayoutListener.onLayout(this, l, t, r, b);
            }
        }
    }

    public void setLayoutListener(LayoutListener listener) {
        mLayoutListener = listener;
    }
}
