package jp.gr.java_conf.shiseissi.commonlib;

import java.lang.ref.SoftReference;

/**
 *
 * @author shisei
 *
 * @param <T>
 */
public class ThreadSoftReference<T> extends ThreadLocal<SoftReference<T>> {
    @Override
    protected SoftReference<T> initialValue() {
        return new SoftReference<T>(null);
    }

    public T getValue() {
        SoftReference<T> ref = get();
        assert ref != null;
        return ref.get();
    }

    public void setValue(T value) {
        set(new SoftReference<T>(value));
    }
}
