package jp.sourceforge.nicoro;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;

public interface XmlLoaderInterface {
    /**
     * load開始する
     */
    void startLoad();

    /**
     * 動作中のloadを終了させる。
     * 完全に終了するまで戻らない。
     */
    void finish();

    /**
     * 動作中のloadを非同期で終了させる
     */
    void finishAsync(ExecutorService executorService,
            final CallbackMessage<Void, Void> callback);

    /**
     * 動作中のloadを非同期で終了させる
     */
    void finishAsync(ExecutorService executorService,
            final CountDownLatch latch);
}
