
package jp.sourceforge.nicoro;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;

public interface LiveMessageLoaderInterface extends XmlLoaderInterface {

    public interface EventListener {
        /**
         * サーバーと接続した
         * @param loader
         */
        void onConnected(LiveMessageLoaderInterface loader);
    	/**
    	 * 新しいMessageChatが追加された
    	 * 注意：連続して呼ばれる可能性あり
    	 * @param loader
    	 */
    	void onAddedMessage(LiveMessageLoaderInterface loader);
    	/**
    	 * ファイル全体の読み込み完了
    	 * @param loader
    	 */
    	void onFinished(LiveMessageLoaderInterface loader);
    	/**
    	 * エラー発生
    	 * @param loader
    	 * @param errorMessage
    	 */
    	void onOccurredError(LiveMessageLoaderInterface loader, String errorMessage);
    }

    boolean isNull();

    MessageChat poll();

    void setEventListener(LiveMessageLoaderInterface.EventListener eventListener);

    public static class NullObject implements LiveMessageLoaderInterface {
        private static final NullObject sInstance = new NullObject();
        public static NullObject getInstance() {
            return sInstance;
        }

        private NullObject() {
        }

        @Override
        public boolean isNull() {
            return true;
        }

        @Override
        public MessageChat poll() {
            return null;
        }

        @Override
        public void setEventListener(EventListener eventListener) {
        }

        @Override
        public void startLoad() {
        }

        @Override
        public void finish() {
        }

        @Override
        public void finishAsync(ExecutorService executorService,
                CallbackMessage<Void, Void> callback) {
            if (callback != null) {
                callback.sendMessageSuccess(null);
            }
        }

        @Override
        public void finishAsync(ExecutorService executorService, CountDownLatch latch) {
            latch.countDown();
        }
    }

}
