package jp.sourceforge.nicoro;

import java.lang.ref.SoftReference;
import static jp.sourceforge.nicoro.Log.LOG_TAG;

public class WatchCache {
    private static final boolean DEBUG_LOGD = Release.IS_DEBUG && true;
    
    private SoftReference<Object> mRef;
    Runnable mRun;
    
    public WatchCache(Runnable run) {
        mRun = run;
        createReference();
    }

    void createReference() {
        mRef = new SoftReference<Object>(new Object() {
            @Override
            protected void finalize() throws Throwable {
                try {
                    if (DEBUG_LOGD) {
                        Log.d(LOG_TAG, "WatchCache finalize");
                    }
                    mRun.run();
                } finally {
                    try {
                        createReference();
                    } finally {
                        super.finalize();
                    }
                }
            }
        });
    }
}
