//-------------------------------------------------------------------------
// 雑多な関数管理クラス
//
// Copyright (c) 金時豆(http://ch.nicovideo.jp/community/co48276)
// $Id: Utils.cs 766 2010-09-11 08:00:14Z kintoki $
//-------------------------------------------------------------------------
using System.Windows.Forms;
using System.Text.RegularExpressions;
using System.Drawing;
using System;
using System.IO;

//-------------------------------------------------------------------------
// クラス実装
//-------------------------------------------------------------------------
namespace NicoLive
{
	public class Utils
	{
        //-------------------------------------------------------------------------
        // 文字コード変換
        //-------------------------------------------------------------------------
        public static string ConvertEncoding(string _src
                                      , System.Text.Encoding _srcEncoding
                                      , System.Text.Encoding _destEncoding)
        {
            byte[] srcBytes = _srcEncoding.GetBytes(_src);
            return _destEncoding.GetString(srcBytes);
        }
        public static string ToBase64(string iStr)
        {
            byte[] byteData = System.Text.Encoding.UTF8.GetBytes(iStr);
            return System.Convert.ToBase64String(byteData);
        }
        public static string FromBase64(string iStr)
        {
            byte[] byteData = System.Convert.FromBase64String(iStr);
            return System.Text.Encoding.UTF8.GetString(byteData);
        }
        //-------------------------------------------------------------------------
        // テキスト内のURLを開く
        //-------------------------------------------------------------------------
        public static void OpenURL(string iText)
        {
            string text = Regex.Replace(
                iText,
               @"(http|https):\/\/[\w\-_]+(\.[\w\-_]+)+([\w\-\.,@?^=%&amp;:/~\+#]*[\w\-\@?^=%&amp;/~\+#])",
               delegate(Match match)
               {
                   System.Diagnostics.Process.Start(match.ToString());
                   return match.ToString();
               });
        }

        //-------------------------------------------------------------------------
        // コメント追加
        //-------------------------------------------------------------------------
        public static void AddComment(ref DataGridView iView, Comment iCmt)
        {
            int idx;
			if( iCmt.Text.Length <= 0 )
				return;

            if (iView.SortOrder == SortOrder.Ascending)
            {
                idx = iView.Rows.Add(iView.Rows);
            }
            else
            {
                iView.Rows.Insert(0,iView.Rows);
                idx = 0;
            }

            iView.Rows[idx].Cells["NO"].Value  = iCmt.No;
            iView.Rows[idx].Cells["ID"].Value      = iCmt.Uid;
            iView.Rows[idx].Cells["HANDLE"].Value  = iCmt.Handle;
            iView.Rows[idx].Cells["COMMENT"].Value = iCmt.Text;

            if (iCmt.Premium.Equals("3"))
            {
                iView.Rows[idx].Cells["COMMENT"].Style.ForeColor = Properties.Settings.Default.owner_color;
            }
            else if (iCmt.IsNG)
            {
                iView.Rows[idx].Cells["COMMENT"].Style.ForeColor = Properties.Settings.Default.ng_color;
            }
            else if (iCmt.Mail.Contains("docomo"))
            {
                iView.Rows[idx].Cells["COMMENT"].Style.ForeColor = Properties.Settings.Default.mobile_color;
            }

            int max_item = Properties.Settings.Default.comment_max;

           
            if (iView.Rows.Count > max_item)
            {
                if (iView.SortOrder == SortOrder.Ascending)
                    iView.Rows.RemoveAt(0);
                else
                    iView.Rows.RemoveAt(max_item);
            }

            if (iView.SortOrder == SortOrder.Ascending)
            {
                iView.FirstDisplayedScrollingRowIndex = iView.Rows.Count - 1;
            }
        }

		//-------------------------------------------------------------------------
		// リスト中のニックネームを変更
		//-------------------------------------------------------------------------
        public static void SetNickname(ref DataGridView iView, string iID, string iName)
		{
			// 既存アイテムのIDをコテハンに書き換え
            int cnt = iView.Rows.Count;
            for (int i = 0; i < cnt; i++)
            {
                DataGridViewRow item = iView.Rows[i];
                if (item != null)
                {
                    string id = item.Cells["ID"].Value.ToString();
                    if (id.Equals(iID))
                    {
                        item.Cells["HANDLE"].Value = iName;
                    }
                }
            }
		}

		//-------------------------------------------------------------------------
		// コメント用フォントの設定
		//-------------------------------------------------------------------------
        public static void SetCommentFont(ref DataGridView iView)
		{
            iView.Font = new Font(Properties.Settings.Default.font_name,
                                  Properties.Settings.Default.font_size,
                                  FontStyle.Bold);
		
		}

        //-------------------------------------------------------------------------
        // 順番待ちが残り２桁になったらTweet
        //-------------------------------------------------------------------------
        public static void TweetWait(int iWaitCnt)
        {
            if (!Properties.Settings.Default.tweet_wait) return;

            if (iWaitCnt <= 1)
                return;

            MessageSettings msgSet = MessageSettings.Instance;

            string msg = String.Format(msgSet.GetMessage("枠取り順番待ち、残り{0}人"), iWaitCnt);

            using (Twitter tw = new Twitter())
            {
                tw.Post(msg, "#nicolive");
            }
        }

        //-------------------------------------------------------------------------
        // ログ書き出し
        //-------------------------------------------------------------------------
        public static void WriteLog(string iTitle, string iStr)
        {
            using (StreamWriter writer = new StreamWriter("error_log.txt", true))
            {
                writer.WriteLine("【" + iTitle + "】");
                writer.WriteLine(iStr);
                writer.Flush();
                writer.Close();
            }
        }

         //-------------------------------------------------------------------------
        // LiveID抽出
        //-------------------------------------------------------------------------
        public static string ParseLiveID(string iText)
        {
            string tmp = iText;
            string live_id = "lv";

            int idx = tmp.LastIndexOf("lv");
            int len = tmp.Length;

            for (int i = idx + 2; i < len; i++)
            {
                if ('0' <= tmp[i] && tmp[i] <= '9')
                    live_id += tmp[i].ToString();
                else
                    break;
            }

            return live_id;
        }

        //-------------------------------------------------------------------------
        // 残り時間計算
        //-------------------------------------------------------------------------
        public static int CalcTime()
        {
            int sub;
            LiveInfo info = LiveInfo.Instance;

            if (info.EndTime != 0)
            {
                if (info.StartTime > info.Time)
                {
                    sub = (int)(info.Time - info.StartTime);
                }
                else
                {
                    sub = (int)(info.EndTime - info.Time);  // 残り時間
                    if (info.EndTime < info.Time)
                        sub = 0;
                }
            }
            else
            {
                sub = (int)(info.Time - info.StartTime);   
            }
            return sub;
        }
	}
}

//-------------------------------------------------------------------------
// 雑多な関数管理クラス
//
// Copyright (c) 金時豆(http://ch.nicovideo.jp/community/co48276)
//-------------------------------------------------------------------------
