﻿//-------------------------------------------------------------------------
// Main Form
//
// Copyright (c) 金時豆(http://ch.nicovideo.jp/community/co48276)
// $Id: WorkerAutoExtend.cs 766 2010-09-11 08:00:14Z kintoki $
//-------------------------------------------------------------------------
using System;
using System.ComponentModel;
using System.Threading;
using System.Windows.Forms;

namespace NicoLive
{
    partial class Form1
    {
        //-------------------------------------------------------------------------
        // 自動無料延長用ワーカー
        //-------------------------------------------------------------------------
        private void AutoExtendWorker_DoWork(object sender, DoWorkEventArgs e)
        {
            int wait = 1000 * 2;
            bool push_extend;
            bool extend_wait = false;

            using (AutoExtend ax = new AutoExtend())
            {
                while (true)
                {
                    push_extend = false;

                    if (mNico == null) return;

                    //if (!mNico.IsLogin) continue;

                    // ウェイト
                    if (this.WindowState == FormWindowState.Minimized)
                    {
                        Thread.Sleep(wait);
                        continue;
                    }

                    if (this.Bounds.Width < 50 || this.Bounds.Height < 50)
                    {
                        //Thread.Sleep(wait);
                        continue;
                    }

                    // 延長が完了したらしばらく休憩
                    if (extend_wait)
                    {
                        Thread.Sleep(1000 * 60 * 5);
                        extend_wait = false;
                        continue;
                    }

                    DelStatus(STATUS_FLAGS.IS_EXTEND);

                    UInt32 time = mLiveInfo.Time;
                    UInt32 btime = mLiveInfo.StartTime;

                    if (btime < time)
                    {
                        UInt32 lim = 30 * 60;        // 30分
                        UInt32 sub = time - btime;  // 経過時間

                        //
                        if (sub > lim)
                        {
                            UInt32 mod = sub / lim;
                            sub = sub - mod * lim;
                        }

                        // 自動延長
                        if (mAutoExtendBtn.Checked && sub >= 25 * 60)  // 25分
                        {
                            int r = ax.CheckExtend(this.Bounds, this.Location.X, this.Location.Y);
                            switch (r)
                            {
                                // 購入ボタンクリック
                                case 1:
                                    AddStatus(STATUS_FLAGS.PUSH_EXT_AUTO);
                                    break;
                                // OKボタンクリック
                                case 2:
                                    if (CheckStatus(STATUS_FLAGS.PUSH_EXT_AUTO))
                                    {
                                        this.SendComment(mMsg.GetMessage("延長完了"), true);
                                        DelStatus(STATUS_FLAGS.PUSH_EXT_AUTO);
                                        extend_wait = true;
                                        AddStatus(STATUS_FLAGS.IS_EXTEND);
                                    }
                                    break;
                            }
                            if (r != 0)
                                push_extend = true;
                        }
                    }

                    if (Properties.Settings.Default.use_fme)
                    {
                        if (!CheckStatus(STATUS_FLAGS.START_FME_AUTO) && mNico.IsLogin)
                        {
                            int r = ax.AutoFME(this.Bounds, this.Location.X, this.Location.Y);
                            if (r == 1)
                            {
                                FMLE_Exec();
                                AddStatus(STATUS_FLAGS.START_FME_AUTO);
                            }
                        }
                    }
                    else
                    {
                        if (!push_extend && !CheckStatus(STATUS_FLAGS.PUSH_EXT_AUTO))
                        {
                            // 自動配信開始
                            if (Properties.Settings.Default.auto_connect)
                            {
                                int r = ax.AutoStart(this.Bounds, this.Location.X, this.Location.Y);
                                switch (r)
                                {
                                    // 配信開始
                                    case 1:
                                        AddStatus(STATUS_FLAGS.PUSH_START_AUTO);
                                        break;
                                    // OK
                                    case 2:
                                        if (CheckStatus(STATUS_FLAGS.PUSH_START_AUTO))
                                            mBouyomi.Talk(mMsg.GetMessage("配信を開始しました"));
                                        DelStatus(STATUS_FLAGS.PUSH_START_AUTO);
                                        this.mLastChatTime = DateTime.Now;
                                        break;
                                }

                            }
                        }
                    }

                    // ウェイト
                    Thread.Sleep(wait);
                }
            }
        }
    }
}
//-------------------------------------------------------------------------
// Copyright (c) 金時豆(http://ch.nicovideo.jp/community/co48276)
// $Id: WorkerAutoExtend.cs 766 2010-09-11 08:00:14Z kintoki $
//-------------------------------------------------------------------------
