﻿//-------------------------------------------------------------------------
// Main Form
//
// Copyright (c) 金時豆(http://ch.nicovideo.jp/community/co48276)
// $Id: BtnHandler.cs 766 2010-09-11 08:00:14Z kintoki $
//-------------------------------------------------------------------------
using System;
using System.Windows.Forms;

namespace NicoLive
{
    partial class Form1
    {
        //-------------------------------------------------------------------------
        // 購入ボタン
        //-------------------------------------------------------------------------
        private void mBuyBtn_Click(object sender, EventArgs e)
        {
            if (mSaleListMenu.Items.Count > 0 && mSaleListMenu.SelectedIndex >= 0)
            {
                AddStatus(STATUS_FLAGS.EXTEND_ITEM_LOCK);
                ExtendCheck dlg = new ExtendCheck(this,
                                                mSaleListMenu.SelectedIndex,
                                                mSaleListMenu.SelectedItem.ToString());
                dlg.Show();
            }
        }

        //-------------------------------------------------------------------------
        // 外部コメントウィンド
        //-------------------------------------------------------------------------
        private void CommentBtn_Click(object sender, EventArgs e)
        {
            mCommentForm.Show();
        }

        //-------------------------------------------------------------------------
        // 接続ボタン押し
        //-------------------------------------------------------------------------
        private void ConnectBtn_Click(object sender, EventArgs e)
        {
            Connect(false);
        }
        //-------------------------------------------------------------------------
        // 放送ＩＤでエンターキーが押された時
        //-------------------------------------------------------------------------
        private void LiveID_KeyDown(object sender, KeyEventArgs e)
        {
            if (e.KeyCode == System.Windows.Forms.Keys.Enter)
            {
                Connect(false);
            }
        }
        //-------------------------------------------------------------------------
        // オーナーコメント送信
        //-------------------------------------------------------------------------
        private void OwnerComment_KeyDown(object sender, KeyEventArgs e)
        {

            if (e.KeyCode == System.Windows.Forms.Keys.Enter)
            {
                if (mNico.IsLogin)
                {
                    mNico.SendOwnerComment(mLiveInfo.ID, mOwnerComment.Text, mLiveInfo.Nickname, mLiveInfo.Token);
                }
                mOwnerComment.Text = "";
            }
        }
        
        private void OwnerComment_KeyPress(object sender, KeyPressEventArgs e)
        {
            //EnterやEscapeキーでビープ音が鳴らないようにする
            if (e.KeyChar == (char)Keys.Enter || e.KeyChar == (char)Keys.Escape)
            {
                e.Handled = true;
            }
        }
        
        //-------------------------------------------------------------------------
        // 自動枠取り画面起動
        //-------------------------------------------------------------------------
        private void WakutoriBtn_Click(object sender, EventArgs e)
        {
            MakeWakutori(false);
        }
        //-------------------------------------------------------------------------
        // コメント読み上げ起動
        //-------------------------------------------------------------------------
        private void BouyomiBtn_Click(object sender, EventArgs e)
        {
            if (mBouyomiBtn.Checked)
            {
                mBouyomi.Talk(mMsg.GetMessage("読み上げを開始します"));
            }
        }

        //-------------------------------------------------------------------------
        // 自動無料延長
        //-------------------------------------------------------------------------
        private void AutoExtendBtn_Click(object sender, EventArgs e)
        {
            if (mAutoExtendBtn.Checked)
            {
                mBouyomi.Talk(mMsg.GetMessage("自動無料延長を開始します"));
            }
        }

        //-------------------------------------------------------------------------
        // 前枠の続き
        //-------------------------------------------------------------------------
        private void mCopyBtn_Click(object sender, EventArgs e)
        {

            WakuDlg dlg = new WakuDlg(ParseLiveID(), true);
            dlg.ShowDialog();

            if (dlg.mState == WakuResult.NO_ERR)
            {
                using (Bouyomi bm = new Bouyomi())
                {
                    bm.Talk(mMsg.GetMessage("枠が取れたよ"));
                }

                this.LiveID = dlg.mLv;
                Connect(true);
            }
            else if (dlg.mState == WakuResult.JUNBAN)
            {
                MakeWakutori(false);
            }
        }

        //-------------------------------------------------------------------------
        // 今ココ起動
        //-------------------------------------------------------------------------
        private void ImakokoBtn_Click(object sender, EventArgs e)
        {
            Imakoko imk = new Imakoko();
            imk.MyOwner = this;
            imk.Show();
        }

    }
}
//-------------------------------------------------------------------------
// Copyright (c) 金時豆(http://ch.nicovideo.jp/community/co48276)
// $Id: BtnHandler.cs 766 2010-09-11 08:00:14Z kintoki $
//-------------------------------------------------------------------------