﻿//-------------------------------------------------------------------------
// 放送情報変更ダイアログ
//
// Copyright (c) 金時豆(http://ch.nicovideo.jp/community/co48276)
// $Id: ChangePropDlg.cs 764 2010-09-01 12:24:10Z kintoki $
//-------------------------------------------------------------------------
using System.Windows.Forms;
using System.Collections.Generic;
using System.Xml;
using System.Diagnostics;
using System;

namespace NicoLive
{
    public partial class ChangeProp : Form
    {
        Dictionary<string, string> mCom;
        Dictionary<int, string> mDescList;
        Dictionary<int, string> mPublicStatusList;
        Dictionary<int, string> mFaceList;
        Dictionary<int, string> mTotuList;
        Dictionary<int, string> mTimeShiftList;
        Dictionary<int, string> mComList;

        public string Title
        {
            get { return mTitle.Text; }
            set { mTitle.Text = value; }
        }
        public string Desc
        {
            get {
                string desc = mDesc.Text;
                desc = desc.Replace("<br>", "");
                desc = desc.Replace("<br />", "");
                desc = desc.Replace("\r\n", "<br />\r\n");

                return desc;
            }
            set {
                string desc = value;
                desc = desc.Replace("<br />\r\n", "\r\n");
                desc = desc.Replace("<br />", "\r\n");
                mDesc.Text = desc;
            }
        }
        
        public bool CommunityOnly
        {
            get { return mComuOnly.Checked; }
            set { mComuOnly.Checked = value; }
        }

        public bool TimeShift
        {
            get { return mTimeShift.Checked; }
            set { mTimeShift.Checked = value; }
        }
        public bool Totumachi
        {
            get { return mTotumachi.Checked; }
            set { mTotumachi.Checked = value; }
        }
        public bool Face
        {
            get { return mFace.Checked; }
            set { mFace.Checked = value; }
        }
        public string Community
        {
            get {
                return mCom[mCommunity.SelectedItem.ToString()]; 
            }
        }

        public ChangeProp()
        {
            mCom = new Dictionary<string, string>();

            mDescList = new Dictionary<int, string>();
            mTotuList = new Dictionary<int, string>();
            mPublicStatusList = new Dictionary<int, string>();
            mTimeShiftList = new Dictionary<int, string>();
            mFaceList = new Dictionary<int, string>();
            mComList = new Dictionary<int, string>();
            InitializeComponent();
        }


        public void SetCommunity(Dictionary<string, string> iCommunity)
        {
            foreach (string key in iCommunity.Keys)
            {
                mCommunity.Items.Add(iCommunity[key]);
                mCom[iCommunity[key]] = key;
            }
            mCommunity.SelectedIndex = 0;
        }

        private void button1_Click(object sender, System.EventArgs e)
        {
            SaveHistory();
            Close();
        }

        private void ChangeProp_Load(object sender, System.EventArgs e)
        {
            LoadHistory();
        }

        //-------------------------------------------------------------------------
        // タイトル履歴保存
        //-------------------------------------------------------------------------
        private void SaveHistory()
        {
            using (XmlTextWriter writer = new XmlTextWriter("prop_history.xml", null))
            {
                int cnt = mTitle.Items.Count;
                int max = 10;

                writer.Formatting = Formatting.Indented;

                writer.WriteStartDocument();

                writer.WriteStartElement("history");

                if (cnt == 0 ||
                   (
                    !Title.Equals((string)mTitle.Items[0]) || 
                    !Desc.Equals(mDescList[0]) ||
					Face.ToString() != mFaceList[0] ||
                    CommunityOnly.ToString() != mPublicStatusList[0] ||
                    TimeShift.ToString() != mTimeShiftList[0] ||
                    Totumachi.ToString() != mTotuList[0] 
                   )
                 )
                {
                    writer.WriteStartElement("item");
                    writer.WriteElementString("title", mTitle.Text);
                    writer.WriteElementString("description", mDesc.Text);
                    writer.WriteElementString("public_status", CommunityOnly.ToString());
                    writer.WriteElementString("time_shift", TimeShift.ToString());
                    writer.WriteElementString("face", Face.ToString());
                    writer.WriteElementString("totsu", Totumachi.ToString());
                    writer.WriteElementString("community", Community);
                    writer.WriteEndElement();
                    max--;
                }

                if (cnt > max)
                    cnt = max;

                for( int i = 0;i < cnt ;i++)
                {
                    writer.WriteStartElement("item");
                        writer.WriteElementString("title", (string)mTitle.Items[i]);
                        writer.WriteElementString("description", mDescList[i]);
                        writer.WriteElementString("public_status", mPublicStatusList[i].ToString());
                        writer.WriteElementString("time_shift", mTimeShiftList[i].ToString());
                        writer.WriteElementString("face", mFaceList[i].ToString());
                        writer.WriteElementString("totsu", mTotuList[i].ToString());
                        writer.WriteElementString("community", mComList[i]);
                    writer.WriteEndElement();
                }

                writer.WriteEndElement();
                writer.WriteEndDocument();

                writer.Flush();
                writer.Close();
            }
        }

        //-------------------------------------------------------------------------
        // タイトル履歴ロード
        //-------------------------------------------------------------------------
        public void LoadHistory()
        {
            int i = -1;

            using (XmlTextReader xml = new XmlTextReader("prop_history.xml"))
            {
                if (xml == null)
                {
                    return;
                }

                try
                {
                    while (xml.Read())
                    {
                        if (xml.NodeType == XmlNodeType.Element)
                        {
                            if (xml.LocalName.Equals("item"))
                            {
                                i++;
                            }
                            else if (xml.LocalName.Equals("title"))
                            {
                                mTitle.Items.Add(xml.ReadString());
                            }
                            else if (xml.LocalName.Equals("description"))
                            {
                                mDescList[i] = xml.ReadString();
                            }
                            else if (xml.LocalName.Equals("public_status"))
                            {
                                mPublicStatusList[i] = xml.ReadString();
                            }
                            else if (xml.LocalName.Equals("time_shift"))
                            {
                                mTimeShiftList[i] = xml.ReadString();
                            }
                            else if (xml.LocalName.Equals("face"))
                            {
                                mFaceList[i] = xml.ReadString();
                            }
                            else if (xml.LocalName.Equals("totsu"))
                            {
                                mTotuList[i] = xml.ReadString();
                            }
                            else if (xml.LocalName.Equals("community"))
                            {
                                mComList[i] = xml.ReadString();
                            }
                        }
                    }
                }
                catch (Exception e)
                {
                    Debug.WriteLine("LoadHistory:" + e.Message);
                }
            }
        }

        //-------------------------------------------------------------------------
        // 詳細履歴設定
        //-------------------------------------------------------------------------
        private void mTitle_SelectionChangeCommitted(object sender, EventArgs e)
        {
            int sel = mTitle.SelectedIndex;
            if (sel < 0) return;

            if (mDescList.ContainsKey(sel))
            {
                Desc = mDescList[sel];
                CommunityOnly = mPublicStatusList[sel].Equals("True");
                Face = mFaceList[sel].Equals("True");
                Totumachi = mTotuList[sel].Equals("True");
                TimeShift = mTimeShiftList[sel].Equals("True");

                int i = 0;
                foreach (string val in mCom.Values)
                {
                    if (val.Equals(mComList[sel]))
                    {
                        mCommunity.SelectedIndex = i;
                        break;
                    }
                    i++;
                }
            }
        }
    }
}
//-------------------------------------------------------------------------
// 放送情報変更ダイアログ
//
// Copyright (c) 金時豆(http://ch.nicovideo.jp/community/co48276)
// $Id: ChangePropDlg.cs 764 2010-09-01 12:24:10Z kintoki $
//-------------------------------------------------------------------------
