﻿//-------------------------------------------------------------------------
// Viewer
//
// Copyright (c) 金時豆(http://ch.nicovideo.jp/community/co48276)
// $Id: Nickname.cs 697 2010-07-05 06:13:32Z kintoki $
//-------------------------------------------------------------------------
using System;
using System.Windows.Forms;
using System.Collections.Generic;
using System.Diagnostics;
using Flash.External;
using System.Drawing;

namespace NicoLive
{
    public partial class Viewer : Form
    {
        private string mLv;
        private ExternalInterfaceProxy mProxy;
        private bool mConnect = false;
        
        //-------------------------------------------------------------------------
        //　コンストラクタ
        //-------------------------------------------------------------------------
        public Viewer(string iLv)
        {
            mLv = iLv;

            InitializeComponent();
        }

        //-------------------------------------------------------------------------
        //　SWFロード
        //-------------------------------------------------------------------------
        private void LoadMovie()
        {
#if DEBUG
            string url = "http://nicolive.sourceforge.jp/debug/tiny_player.swf";
#else
            string url = "http://nicolive.sourceforge.jp/tiny_player.swf";
#endif
            mFlash.LoadMovie(0, url);
        }

        //-------------------------------------------------------------------------
        //　Formロード
        //-------------------------------------------------------------------------
        private void Viewer_Load(object sender, System.EventArgs e)
        {
            mProxy = new ExternalInterfaceProxy(mFlash);
            LoadMovie();

            this.Top = Properties.Settings.Default.vw_pos.Y;
            this.Left = Properties.Settings.Default.vw_pos.X;
            this.Width = Properties.Settings.Default.vw_size.Width;
            this.Height = Properties.Settings.Default.vw_size.Height;
        }

        //-------------------------------------------------------------------------
        //　視聴する放送ＩＤ設定
        //-------------------------------------------------------------------------
        private void Play(string iLv)
        {
            mLiveID.Text = Utils.ParseLiveID(iLv);
            if (iLv.Length > 0)
                Connect(true);
        }

        public void PlayLive(string iLv)
        {
            this.Invoke((Action)delegate()
            {
                mLiveID.Text = Utils.ParseLiveID(iLv);
                mConnect = true;
            });
        }

        public void SetLiveID(string iLv)
        {
            this.Invoke((Action)delegate()
            {
                mLiveID.Text = Utils.ParseLiveID(iLv);
            });
        }

        //-------------------------------------------------------------------------
        //　視聴する放送ＩＤ変更
        //-------------------------------------------------------------------------
        private void mLiveID_KeyDown(object sender, KeyEventArgs e)
        {
            if (e.KeyCode == System.Windows.Forms.Keys.Enter)
            {
                string tmp = Utils.ParseLiveID(mLiveID.Text);
                mLiveID.Text = tmp;
                Play(tmp);
            }
        }

        private void mPlayBtn_Click(object sender, EventArgs e)
        {
            string tmp = Utils.ParseLiveID(mLiveID.Text);
            mLiveID.Text = tmp;
            Connect(true);
        }

        private void Connect(bool iPlay)
        {
            //if (mLiveID.Text.Length <= 0) return;

            Nico nico = Nico.Instance;
            if (!nico.IsLogin)
            {
                string user_id = Properties.Settings.Default.user_id;
                string passwd = Properties.Settings.Default.password;
                nico.Login(user_id, passwd);
            }

            string url, id;

            if (GetUrl(out url, out id))
            {
                try
                {
                    mProxy.Call("setUrl", url);
                    mProxy.Call("setPublish", id);
                    if (iPlay)
                    {
                        mProxy.Call("playVideo", "arg");
                    }
                }
                catch (Exception e)
                {
                    Console.WriteLine(e.Message);
                }
            }
            else
            {
                MessageBox.Show("放送が見つかりません", "豆ライブ");
            }
        }

        public void RefreshUrl()
        {
            string url, id;

            if (GetUrl(out url, out id))
            {
                try
                {
                    mProxy.Call("setUrl", url);
                }
                catch (Exception e)
                {
                    Console.WriteLine(e.Message);
                }
            }
        }

        private bool GetUrl(out string oUrl,out string oID)
        {
            oUrl = oID = "";
            
            Nico nico = Nico.Instance;
                
            Dictionary<string, string> arr = nico.GetPlayerStatus(Utils.ParseLiveID(mLiveID.Text));
            if (arr == null || !arr.ContainsKey("url"))
            {
                return false;
            }
            else
            {
                string url;

                url = arr["url"] + "?" + arr["ticket"];

                //Debug.WriteLine(url);
                
                if (url != null && arr.ContainsKey("id"))
                {
                    oUrl = url;
                    oID = arr["id"];
                    return true;
                }
            }
            return false;
        }

        private void Viewer_Show(object sender, EventArgs e)
        {
            //mConnect = true;
        }

        private void mUITimer_Tick(object sender, EventArgs e)
        {
            if (mConnect)
            {
                mConnect = false;
                Play(mLiveID.Text);
            }

            RefreshUrl();
        }

        private void Viewer_FormClosing(object sender, FormClosingEventArgs e)
        {
            // ウィンドステート保存
            if (this.WindowState == FormWindowState.Normal)
            {
                Size size = new Size(this.Width, this.Height);
                Properties.Settings.Default.vw_size = size;
                Point pos = new Point(this.Left, this.Top);
                Properties.Settings.Default.vw_pos = pos;
            }
        }
    }
}
//-------------------------------------------------------------------------
// Copyright (c) 金時豆(http://ch.nicovideo.jp/community/co48276)
// $Id: Nickname.cs 697 2010-07-05 06:13:32Z kintoki $
//-------------------------------------------------------------------------
