﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

using SystemCommon;
using ClientCommon;


namespace 顧客分析君
{
    public partial class _601広告検索 : Form
    {
        ////////////////////////////////////////////////////////////////////////
        // メンバ変数
        ////////////////////////////////////////////////////////////////////////
        #region メンバ変数

        public string mstr選択済み広告No;

        public D16広告.D16広告検索DataTable dt広告検索結果 = new D16広告.D16広告検索DataTable();

		//private enum enm広告一覧Cell : int
		//{
		//    選択 = 0,
		//    広告No = 1,
		//    広告名 = 2,
		//    担当者名 = 3,
		//    TEL = 4,
		//    FAX = 5,
		//    メールアドレス = 6,
		//    URL = 7,
		//    備考 = 8
		//}
		private static class 広告一覧Cell
		{
            public const byte byt選択 = 0;
            public const byte byt広告No = 1;
            public const byte byt広告名 = 2;
            public const byte byt担当者名 = 3;
            public const byte bytTEL = 4;
            public const byte bytFAX = 5;
            public const byte bytメールアドレス = 6;
            public const byte bytURL = 7;
			public const byte byt備考 = 8;
		}

        private class 検索条件
        {
            public string 広告名 { get; set; }
            public string 担当者名 { get; set; }
            public string TEL { get; set; }
            public string メールアドレス { get; set; }
        }

		//private 顧客分析君.D16広告TableAdapters.D16広告検索ta d16広告検索ta;
		
		#endregion


        ////////////////////////////////////////////////////////////////////////
        // 公開 共通メソッド 
        ////////////////////////////////////////////////////////////////////////
        #region 公開 共通メソッド

        public _601広告検索()
        {
            InitializeComponent();

			//this.d16広告検索ta = new 顧客分析君.D16広告TableAdapters.D16広告検索ta();

			//this.d16広告検索ta.ClearBeforeFill = true;
		}

        #endregion

        ////////////////////////////////////////////////////////////////////////
        // 非公開 共通メソッド
		////////////////////////////////////////////////////////////////////////
		#region 非公開 共通メソッド Static

		#endregion


		#region 非公開 共通メソッド Non Static

		private void Set列幅()
        {
            dgv広告一覧.Columns[広告一覧Cell.byt選択].Width = C_列幅.新規;
            dgv広告一覧.Columns[広告一覧Cell.byt広告No].Visible = false;
            dgv広告一覧.Columns[広告一覧Cell.byt広告名].Width = C_列幅.広告名;
            dgv広告一覧.Columns[広告一覧Cell.byt担当者名].Width = C_列幅.氏名;
            dgv広告一覧.Columns[広告一覧Cell.bytTEL].Width = C_列幅.TEL;
            dgv広告一覧.Columns[広告一覧Cell.bytFAX].Width = C_列幅.FAX;
            dgv広告一覧.Columns[広告一覧Cell.bytメールアドレス].Width = C_列幅.メールアドレス;
            dgv広告一覧.Columns[広告一覧Cell.bytURL].Width = C_列幅.URL;
            dgv広告一覧.Columns[広告一覧Cell.byt備考].Width = C_列幅.備考;
        }

        //検索で使用するSQLパラメータの取得
        private 検索条件 Get検索条件()
        {
            検索条件 row = new 検索条件();

            if (txt広告名.Text == "")
                row.広告名 = null;
            else
                row.広告名 = txt広告名.Text;

            if (txt担当者名.Text == "")
                row.担当者名 = null;
            else
                row.担当者名 = txt担当者名.Text;

            if (txtTEL.Text == "")
                row.TEL = null;
            else
                row.TEL = txtTEL.Text;

            if (txtメールアドレス.Text == "")
                row.メールアドレス = null;
            else
                row.メールアドレス = txtメールアドレス.Text;

            return (row);
        }

        private bool IsValidate()
        {
            //// この処理はバインドのバグによって使えない。
            ////d16広告.D16広告検索Row[] dr = (d16広告.D16広告検索Row[])d16広告.D16広告検索.Select("選択 = True");
            //// 妥協ロジック
            //int i選択数 = 0;
            //for (int iRow = 0; iRow < dgv広告一覧.RowCount; iRow++)
            //{
            //    if ((Boolean)dgv広告一覧.Rows[iRow].Cells[広告一覧Cell.byt選択].Value == true)
            //        i選択数++;
            //}
            ////チェックがされていなければエラー
            //if (i選択数 < 1)
            //{
            //    MessageBox.Show(string.Format(Properties.Resources.MSG_INF_008, )
            //        , this.Text, MessageBoxButtons.OK, MessageBoxIcon.Warning);
            //    dgv広告一覧.Focus();
            //    return false;
            //}
            if (C01FormCommon.チェック選択数(dgv広告一覧, 広告一覧Cell.byt選択, this.Text
                , Properties.Resources.DGV列名_広告) == false)
                return false;
            
            return true;
        }

        private void Set広告検索結果()
        {
            D16広告.D16広告検索Row[] dr = (D16広告.D16広告検索Row[])d16広告.D16広告検索
                .Select(Properties.Resources.DGV列名_選択 + " = true");

            for (int iRow = 0; iRow < dr.Length; iRow++)
            {
                D16広告.D16広告検索Row dr広告検索結果 = dt広告検索結果.NewD16広告検索Row();

                dr広告検索結果.広告No = dr[iRow].広告No;
                dr広告検索結果.広告名 = dr[iRow].広告名;
                dr広告検索結果.担当者名 = dr[iRow].担当者名;
                dr広告検索結果.TEL = dr[iRow].TEL;
                dr広告検索結果.FAX = dr[iRow].FAX;
                dr広告検索結果.メールアドレス = dr[iRow].メールアドレス;
                dr広告検索結果.URL = dr[iRow].URL;

                dt広告検索結果.AddD16広告検索Row(dr広告検索結果);
            }
        }

        #endregion

        ////////////////////////////////////////////////////////////////////////
        // イベントハンドラ
        ////////////////////////////////////////////////////////////////////////
        #region イベントハンドラ

        private void _115広告検索_Load(object sender, EventArgs e)
        {
            try
            {
                Set列幅();
            }
            catch (Exception ex)
            {
                C04システム共通.ErrorLog("_115広告検索", "_115広告検索_Load", ex);
            }
        }

        private void _115広告検索_Resize(object sender, EventArgs e)
        {
            try
            {
                C01FormCommon.画面最小サイズに変更(this, false);
            }
            catch (Exception ex)
            {
                C04システム共通.ErrorLog("_115広告検索", "_115広告検索_Resize", ex);
            }
        }

        private void dgv広告一覧_RowPostPaint(object sender, DataGridViewRowPostPaintEventArgs e)
        {
            try
            {
				C01FormCommon.行数表示(e.RowBounds.Location.X,
					e.RowBounds.Location.Y,
					dgv広告一覧.RowHeadersWidth,
					e.RowBounds.Height,
					e.Graphics,
					e.RowIndex,
					dgv広告一覧.RowHeadersDefaultCellStyle.Font,
					dgv広告一覧.RowHeadersDefaultCellStyle.ForeColor);
            }
            catch (Exception ex)
            {
                C04システム共通.ErrorLog("_115広告検索", "dgv広告一覧_RowPostPaint", ex);
            }
        }

        private void btn検索条件をクリア_Click(object sender, EventArgs e)
        {
            try
            {
                txt広告名.Text = "";
                txt担当者名.Text = "";
                txtTEL.Text = "";
            }
            catch (Exception ex)
            {
                C04システム共通.ErrorLog("_115広告検索", "btn検索条件をクリア_Click", ex);
            }
        }

        private void btn検索_Click(object sender, EventArgs e)
        {
            try
            {
                Cursor.Current = Cursors.WaitCursor;

                d16広告検索bs.DataSource = null;
                検索条件 row = Get検索条件();
				C06DB共通.d16広告検索ta.FillBy検索(d16広告.D16広告検索, row.広告名, row.担当者名, row.TEL, row.メールアドレス);

                //選択済みの広告を再選択
                if (mstr選択済み広告No != "" && mstr選択済み広告No != null)
                {
                    D16広告.D16広告検索Row[] dr = (D16広告.D16広告検索Row[])d16広告.D16広告検索
                        .Select(Properties.Resources.DGV列名_広告No + " IN (" + mstr選択済み広告No + ")");

                    for (int iRow = 0; iRow < dr.Length; iRow++)
                        dr[iRow].選択 = true;
                }

                //見つからない場合はメッセージ表示
                if (d16広告.D16広告検索.Rows.Count == 0)
                    MessageBox.Show(Properties.Resources.MSG_W_データは見つかりませんでした, this.Text
						, MessageBoxButtons.OK, MessageBoxIcon.Warning);
            }
            catch (Exception ex)
            {
                C04システム共通.ErrorLog("_115広告検索", "btn検索_Click", ex);
            }
            finally
            {
                d16広告検索bs.DataSource = d16広告.D16広告検索;
				lbl件数.Text = "検索結果：" + d16広告.D16広告検索.Count.ToString() + " 件";
				Cursor.Current = Cursors.Arrow;
            }
        }

        private void btn選択行を全てチェック_Click(object sender, EventArgs e)
        {
            try
            {
                Cursor.Current = Cursors.WaitCursor;

                foreach (DataGridViewRow row in dgv広告一覧.SelectedRows)
                    row.Cells[広告一覧Cell.byt選択].Value = true;
            }
            catch (Exception ex)
            {
                C04システム共通.ErrorLog("_115広告検索", "btn選択行を全てチェック_Click", ex);
            }
            finally
            {
                Cursor.Current = Cursors.Arrow;
            }
        }

        private void btn選択行のチェックを全て外す_Click(object sender, EventArgs e)
        {
            try
            {
                Cursor.Current = Cursors.WaitCursor;

                foreach (DataGridViewRow row in dgv広告一覧.SelectedRows)
                    row.Cells[広告一覧Cell.byt選択].Value = false;
            }
            catch (Exception ex)
            {
                C04システム共通.ErrorLog("_115広告検索", "btn選択行のチェックを全て外す_Click", ex);
            }
            finally
            {
                Cursor.Current = Cursors.Arrow;
            }
        }

        private void btn検索結果をクリア_Click(object sender, EventArgs e)
        {
            try
            {
                if (DialogResult.Yes != MessageBox.Show(Properties.Resources.MSG_Q_検索結果をクリアしますか
                    , this.Text, MessageBoxButtons.YesNo, MessageBoxIcon.Question))
                    return;

				Cursor.Current = Cursors.WaitCursor;

				d16広告.D16広告検索.Clear();
				lbl件数.Text = "";
			}
            catch (Exception ex)
            {
                C04システム共通.ErrorLog("_115広告検索", "btn検索結果をクリア_Click", ex);
            }
			finally
			{
				Cursor.Current = Cursors.Arrow;
			}
		}

        private void btnOK_Click(object sender, EventArgs e)
        {
            try
            {
                if (false == IsValidate())
                    return;

                Cursor.Current = Cursors.WaitCursor;

                Set広告検索結果();

                this.DialogResult = DialogResult.OK;
                this.Close();
            }
            catch (Exception ex)
            {
                C04システム共通.ErrorLog("_115広告検索", "btnOK_Click", ex);
            }
            finally
            {
                Cursor.Current = Cursors.Arrow;
            }
        }

        private void btnキャンセル_Click(object sender, EventArgs e)
        {
            try
            {
                this.Close();
            }
            catch (Exception ex)
            {
                C04システム共通.ErrorLog("_115広告検索", "btnキャンセル_Click", ex);
            }
        }

        #endregion

    }
}
