﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.IO;
//using System.Reflection;

using SystemCommon;
using ClientCommon;


namespace 顧客分析君
{
    public partial class _405顧客詳細 : Form
    {
        ////////////////////////////////////////////////////////////////////////
        // 内部クラス
        ////////////////////////////////////////////////////////////////////////
        #region CSV取込処理内部クラス

        private class CSV取込_コンタクト履歴 : C03CSV取込処理基底
        {
			//private enum enmCSV取込列
			//{
			//    コンタクト日時 = 0,
			//    件名 = 1,
			//    本文 = 2,
			//    バウンド = 3,
			//    ツール = 4,
			//    コンタクトスタッフ = 5,
			//    備考 = 6
			//}
			private static class CSV取込列
			{
                public const byte bytコンタクト日時 = 0;
                public const byte byt件名 = 1;
                public const byte byt本文 = 2;
                public const byte bytバウンド = 3;
                public const byte bytツール = 4;
                public const byte bytコンタクトスタッフ = 5;
                public const byte byt備考 = 6;
			}

            protected override int 基底CSV取込クラスからの列数取得()
            {
                return CSV取込列.byt備考 + 1;
            }

            protected override bool 基底CSV取込クラスからの検証(int iRow, int colIndex, string value)
            {
                switch (colIndex)
                {
                    case CSV取込列.bytコンタクト日時:
                        //必須入力、桁数、書式検証
                        if (!IsValidate共通(value, false, C_最大文字数.日時, C_正規表現.半角英数, "コンタクト日時"))
                            return false;

                        // 日付型チェック
                        DateTime dt;
                        if (DateTime.TryParse(value, out dt) == false)
                        {
                            mErrorDetail = string.Format(Properties.Resources.MSG_W_Aが日付として正しくありません, "コンタクト日時");
                            return false;
                        }

                        // 日付範囲チェック
                        if (dt.Year < C_最小値.年 || C_最大値.年 < dt.Year)
                        {
                            mErrorDetail = string.Format(Properties.Resources.MSG_W_Aには_B_C年以外の値を_入力できません, "コンタクト日時", C_最小値.年, C_最大値.年);
                            return false;
                        }

                        break;

                    case CSV取込列.byt件名:
                        if (!IsValidate共通(value, false, C_最大文字数.件名, C_正規表現.なし, "件名"))
                            return false;

                        break;

                    case CSV取込列.byt本文:
                        if (!IsValidate共通(value, false, C_最大文字数.本文, C_正規表現.なし, "住所"))
                            return false;

                        break;

                    case CSV取込列.bytバウンド:
                        if (!IsValidate共通(value, false, C_最大文字数.住所, C_正規表現.なし, "住所"))
                            return false;

                        break;

                    case CSV取込列.bytツール:
                        if (!IsValidate共通(value, false, C_最大文字数.住所, C_正規表現.なし, "住所"))
                            return false;

                        break;

                    case CSV取込列.bytコンタクトスタッフ:
                        if (!IsValidate共通(value, false, C_最大文字数.住所, C_正規表現.なし, "住所"))
                            return false;

                        break;

                    case CSV取込列.byt備考:
                        if (!IsValidate共通(value, false, C_最大文字数.備考, C_正規表現.なし, "備考"))
                            return false;

                        break;
                }
                return true;
            }

            protected override void 基底CSV取込クラスからのデータ変換(int iRow, List<string> values, DataTable dt)
            {
                D13コンタクト.D13コンタクト履歴DataTable dtコンタクト履歴 = (D13コンタクト.D13コンタクト履歴DataTable)dt;
                D13コンタクト.D13コンタクト履歴Row row = dtコンタクト履歴.NewD13コンタクト履歴Row();

                row.新規 = true;
                row.コンタクト日時 = DateTime.Parse(values[CSV取込列.bytコンタクト日時]);
                row.件名 = values[CSV取込列.byt件名];
                row.本文 = values[CSV取込列.byt本文];
                row.バウンド = values[CSV取込列.bytバウンド];
                row.ツール = values[CSV取込列.bytツール];
                row.スタッフ氏名 = values[CSV取込列.bytコンタクトスタッフ];
                row.備考 = values[CSV取込列.byt備考];

                dtコンタクト履歴.AddD13コンタクト履歴Row(row);
            }
        }

        private class CSV取込_家族構成 : C03CSV取込処理基底
        {
			//private enum enmCSV取込列
			//{
			//    続柄 = 0,
			//    氏名 = 1,
			//    氏名カナ = 2,
			//    性別 = 3,
			//    生年月日 = 4,
			//    郵便番号 = 5,
			//    住所 = 6,
			//    TEL = 7,
			//    メールアドレス = 8,
			//    顧客ID = 9,
			//    備考 = 10
			//}
			private static class CSV取込列
			{
                public const byte byt続柄 = 0;
                public const byte byt氏名 = 1;
                public const byte byt氏名カナ = 2;
                public const byte byt性別 = 3;
                public const byte byt生年月日 = 4;
                public const byte byt郵便番号 = 5;
                public const byte byt住所 = 6;
                public const byte bytTEL = 7;
                public const byte bytメールアドレス = 8;
                public const byte byt顧客ID = 9;
                public const byte byt備考 = 10;
            }

			protected override int 基底CSV取込クラスからの列数取得()
            {
                return CSV取込列.byt備考 + 1;
            }

            protected override bool 基底CSV取込クラスからの検証(int iRow, int colIndex, string value)
            {
                switch (colIndex)
                {
                    case CSV取込列.byt続柄:
                        if (!IsValidate共通(value, false, C_最大文字数.続柄, C_正規表現.なし, "続柄"))
                            return false;

                        break;

                    case CSV取込列.byt氏名:
                        if (!IsValidate共通(value, false, C_最大文字数.氏名, C_正規表現.なし, "氏名"))
                            return false;

                        break;

                    case CSV取込列.byt氏名カナ:
                        if (!IsValidate共通(value, false, C_最大文字数.氏名カナ, C_正規表現.全角カタカナ, "氏名カナ"))
                            return false;

                        break;

                    case CSV取込列.byt性別:
                        if (!IsValidate共通(value, false, C_最大文字数.性別, C_正規表現.なし, "性別"))
                            return false;

                        break;

                    case CSV取込列.byt生年月日:
                        if (!IsValidate共通(value, true, C_最大文字数.日時, C_正規表現.半角英数, "生年月日"))
                            return false;

                        // 日付型チェック
                        DateTime dt;
                        if (DateTime.TryParse(value, out dt) == false)
                        {
                            mErrorDetail = string.Format(Properties.Resources.MSG_W_Aが日付として正しくありません, "生年月日");
                            return false;
                        }

                        // 日付範囲チェック
                        if (dt.Year < C_最小値.年 || C_最大値.年 < dt.Year)
                        {
                            mErrorDetail = string.Format(Properties.Resources.MSG_W_Aには_B_C年以外の値を_入力できません, "生年月日", C_最小値.年, C_最大値.年);
                            return false;
                        }

                        break;

                    case CSV取込列.byt郵便番号:
                        if (!IsValidate共通(value, false, C_最大文字数.郵便番号, C_正規表現.半角英数, "郵便番号"))
                            return false;

                        break;

                    case CSV取込列.byt住所:
                        if (!IsValidate共通(value, false, C_最大文字数.住所, C_正規表現.なし, "住所"))
                            return false;

                        break;

                    case CSV取込列.bytTEL:
                        if (!IsValidate共通(value, false, C_最大文字数.TEL, C_正規表現.半角英数, "TEL"))
                            return false;

                        break;

                    case CSV取込列.bytメールアドレス:
                        if (!IsValidate共通(value, false, C_最大文字数.メールアドレス, C_正規表現.メールアドレス, "メールアドレス"))
                            return false;

                        break;

                    case CSV取込列.byt顧客ID:
                        if (!IsValidate共通(value, true, C_最大文字数.顧客ID, C_正規表現.半角英数, "顧客ID"))
                            return false;

                        break;

                    case CSV取込列.byt備考:
                        if (!IsValidate共通(value, false, C_最大文字数.備考, C_正規表現.なし, "備考"))
                            return false;

                        break;
                }
                return true;
            }

            protected override void 基底CSV取込クラスからのデータ変換(int iRow, List<string> values, DataTable dt)
            {
                D10顧客.D10家族構成DataTable dt家族構成 = (D10顧客.D10家族構成DataTable)dt;
                D10顧客.D10家族構成Row row = dt家族構成.NewD10家族構成Row();

                row.新規 = true;
                row.氏名 = values[CSV取込列.byt氏名];
                row.氏名カナ = values[CSV取込列.byt氏名カナ];
                row.性別 = C02業務共通処理.Get性別No(values[CSV取込列.byt性別]);
                row.生年月日 = DateTime.Parse(values[CSV取込列.byt生年月日]);
                row.郵便番号 = values[CSV取込列.byt郵便番号];
                row.住所 = values[CSV取込列.byt住所];
                row.TEL = values[CSV取込列.bytTEL];
                row.メールアドレス = values[CSV取込列.bytメールアドレス];
                row.顧客ID = values[CSV取込列.byt顧客ID];
                row.備考 = values[CSV取込列.byt備考];

                dt家族構成.AddD10家族構成Row(row);
            }
        }

        private class CSV取込_補足情報 : C03CSV取込処理基底
        {
			//private enum enmCSV取込列
			//{
			//    補足名 = 0,
			//    補足内容 = 1,
			//    備考 = 2
			//}
			private static class CSV取込列
			{
                public const byte byt補足名 = 0;
                public const byte byt補足内容 = 1;
                public const byte byt備考 = 2;
            }

			protected override int 基底CSV取込クラスからの列数取得()
            {
                return CSV取込列.byt備考 + 1;
            }

            protected override bool 基底CSV取込クラスからの検証(int iRow, int colIndex, string value)
            {
                switch (colIndex)
                {
                    case CSV取込列.byt補足名:
                        if (!IsValidate共通(value, false, C_最大文字数.補足名, C_正規表現.なし, "補足名"))
                            return false;

                        break;

                    case CSV取込列.byt補足内容:
                        if (!IsValidate共通(value, false, C_最大文字数.補足内容, C_正規表現.なし, "補足内容"))
                            return false;

                        break;

                    case CSV取込列.byt備考:
                        if (!IsValidate共通(value, false, C_最大文字数.備考, C_正規表現.なし, "備考"))
                            return false;

                        break;
                }
                return true;
            }

            protected override void 基底CSV取込クラスからのデータ変換(int iRow, List<string> values, DataTable dt)
            {
                D10顧客.D10顧客補足DataTable dt顧客補足 = (D10顧客.D10顧客補足DataTable)dt;
                D10顧客.D10顧客補足Row row = dt顧客補足.NewD10顧客補足Row();

                row.新規 = true;
                row.補足名No = C02業務共通処理.Get補足名No(values[CSV取込列.byt補足名]);
                row.補足内容 = values[CSV取込列.byt補足内容];
                row.備考 = values[CSV取込列.byt備考];

                dt顧客補足.AddD10顧客補足Row(row);
            }
        }

        #endregion

        ////////////////////////////////////////////////////////////////////////
        // メンバ変数
        ////////////////////////////////////////////////////////////////////////
        #region メンバ変数

        public int mint顧客No;
        public string mstr顧客ID;
        public string mstr氏名;
        public string mstr氏名カナ;
        public string mstr性別;
        public string mstr生年月日;
        public string mstr郵便番号;
        public string mstr住所;
        public string mstrTEL;
        public string mstrメールアドレス;
        public string mstrメルマガ許諾;
        public string mstr備考;

		public byte mbyt確定実行済み = 0;	// 0：確定実行無し	1：確定実行有り

		//private enum enm購買履歴Cell
		//{
		//    販売履歴No = 0,
		//    コンタクト日時 = 1,
		//    商品ID = 2,
		//    商品名 = 3,
		//    商品単価 = 4,
		//    販売個数 = 5,
		//    顧客ID = 6,
		//    商品No = 7,
		//    顧客No = 8
		//}
		private static class 購買履歴Cell
		{
            public const byte byt販売履歴No = 0;
            public const byte bytコンタクト日時 = 1;
            public const byte byt商品ID = 2;
            public const byte byt商品名 = 3;
            public const byte byt商品単価 = 4;
            public const byte byt販売個数 = 5;
            public const byte byt顧客ID = 6;
            public const byte byt商品No = 7;
            public const byte byt顧客No = 8;
        }

		//private enum enmお勧め商品Cell
		//{
		//    商品No = 0,
		//    商品ID = 1,
		//    商品名 = 2,
		//    商品単価 = 3,
		//    お勧め度 = 4
		//}
		private static class お勧め商品Cell
		{
            public const byte byt商品No = 0;
            public const byte byt商品ID = 1;
            public const byte byt商品名 = 2;
            public const byte byt商品単価 = 3;
            public const byte bytお勧め度 = 4;
        }

		//private enum enmコンタクト履歴Cell
		//{
		//    新規 = 0,
		//    変更 = 1,
		//    削除 = 2,
		//    コンタクト履歴No = 3,
		//    コンタクト日時 = 4,
		//    件名 = 5,
		//    本文 = 6,
		//    バウンド = 7,
		//    ツール = 8,
		//    コンタクトスタッフ = 9,
		//    備考 = 10
		//}
		private static class コンタクト履歴Cell
		{
            public const byte byt新規 = 0;
            public const byte byt変更 = 1;
            public const byte byt削除 = 2;
            public const byte bytコンタクト履歴No = 3;
            public const byte bytコンタクト日時 = 4;
            public const byte byt件名 = 5;
            public const byte byt本文 = 6;
            public const byte bytバウンド = 7;
            public const byte bytツール = 8;
            public const byte bytコンタクトスタッフ = 9;
            public const byte byt備考 = 10;
        }

		//private enum enm家族構成Cell
		//{
		//    新規 = 0,
		//    変更 = 1,
		//    削除 = 2,
		//    家族構成No = 3,
		//    顧客No = 4,
		//    続柄 = 5,
		//    続柄名 = 6,
		//    氏名 = 7,
		//    氏名カナ = 8,
		//    性別 = 9,
		//    性別名 = 10,
		//    生年月日 = 11,
		//    郵便番号 = 12,
		//    住所 = 13,
		//    TEL = 14,
		//    メールアドレス = 15,
		//    顧客ID = 16,
		//    備考 = 17,
		//    登録スタッフNo = 18,
		//    登録日時 = 19,
		//    更新スタッフNo = 20,
		//    更新日時 = 21
		//}
		private static class 家族構成Cell
		{
            public const byte byt新規 = 0;
            public const byte byt変更 = 1;
            public const byte byt削除 = 2;
            public const byte byt家族構成No = 3;
            public const byte byt顧客No = 4;
            public const byte byt続柄 = 5;
            public const byte byt続柄名 = 6;
            public const byte byt氏名 = 7;
            public const byte byt氏名カナ = 8;
            public const byte byt性別 = 9;
            public const byte byt性別名 = 10;
            public const byte byt生年月日 = 11;
            public const byte byt郵便番号 = 12;
            public const byte byt住所 = 13;
            public const byte bytTEL = 14;
            public const byte bytメールアドレス = 15;
            public const byte byt顧客ID = 16;
            public const byte byt備考 = 17;
            public const byte byt登録スタッフNo = 18;
            public const byte byt登録日時 = 19;
            public const byte byt更新スタッフNo = 20;
			public const byte byt更新日時 = 21;
        }

		//private enum enm補足情報Cell
		//{
		//    新規 = 0,
		//    変更 = 1,
		//    削除 = 2,
		//    顧客補足No = 3,
		//    顧客No = 4,
		//    補足名 = 5,
		//    補足内容 = 6,
		//    備考 = 7,
		//    登録スタッフNo = 8,
		//    登録日時 = 9,
		//    更新スタッフNo = 10,
		//    更新日時 = 11
		//}
		private static class 補足情報Cell
		{
            public const byte byt新規 = 0;
            public const byte byt変更 = 1;
            public const byte byt削除 = 2;
            public const byte byt顧客補足No = 3;
            public const byte byt顧客No = 4;
            public const byte byt補足名 = 5;
            public const byte byt補足内容 = 6;
            public const byte byt備考 = 7;
            public const byte byt登録スタッフNo = 8;
            public const byte byt登録日時 = 9;
            public const byte byt更新スタッフNo = 10;
			public const byte byt更新日時 = 11;
        }

		//private 顧客分析君.D03販売履歴TableAdapters.D03販売履歴ta d03販売履歴ta;
		//private 顧客分析君.D10顧客TableAdapters.D10顧客ta d10顧客ta;
		//private 顧客分析君.D10顧客TableAdapters.D10お勧め商品_顧客毎ta d10お勧め商品_顧客毎ta;
		//private 顧客分析君.D01業務共通TableAdapters.D01スタッフta d01スタッフta;
		//private 顧客分析君.D01業務共通TableAdapters.D01バウンドta d01バウンドta;
		//private 顧客分析君.D01業務共通TableAdapters.D01ツールta d01ツールta;
		//private 顧客分析君.D10顧客TableAdapters.D10顧客2ta d10顧客2ta;
		//private 顧客分析君.D13コンタクトTableAdapters.D13コンタクト履歴2ta d13コンタクト履歴2ta;
		//private 顧客分析君.D01業務共通TableAdapters.D01性別ta d01性別ta;
		//private 顧客分析君.D01業務共通TableAdapters.D01メルマガ許諾ta d01メルマガ許諾ta;
		//private 顧客分析君.D10顧客TableAdapters.D10家族構成ta d10家族構成ta;
		//private 顧客分析君.D01業務共通TableAdapters.D01家族続柄ta d01家族続柄ta;
		//private 顧客分析君.D10顧客TableAdapters.D10顧客補足ta d10顧客補足ta;
		//private 顧客分析君.D01業務共通TableAdapters.D01補足名ta d01補足名ta;
		//private 顧客分析君.D13コンタクトTableAdapters.D13コンタクト履歴ta d13コンタクト履歴ta;
		//private 顧客分析君.D10顧客TableAdapters.D10RFMランクta d10RFMランクta;
		
		#endregion


        ////////////////////////////////////////////////////////////////////////
        // 公開 共通メソッド 
        ////////////////////////////////////////////////////////////////////////
        #region 公開 共通メソッド

        public _405顧客詳細()
        {
            InitializeComponent();

			//this.d03販売履歴ta = new 顧客分析君.D03販売履歴TableAdapters.D03販売履歴ta();
			//this.d10顧客ta = new 顧客分析君.D10顧客TableAdapters.D10顧客ta();
			//this.d10お勧め商品_顧客毎ta = new 顧客分析君.D10顧客TableAdapters.D10お勧め商品_顧客毎ta();
			//this.d10RFMランクta = new 顧客分析君.D10顧客TableAdapters.D10RFMランクta();
			//this.d01スタッフta = new 顧客分析君.D01業務共通TableAdapters.D01スタッフta();
			//this.d01バウンドta = new 顧客分析君.D01業務共通TableAdapters.D01バウンドta();
			//this.d01ツールta = new 顧客分析君.D01業務共通TableAdapters.D01ツールta();
			//this.d10顧客2ta = new 顧客分析君.D10顧客TableAdapters.D10顧客2ta();
			//this.d13コンタクト履歴ta = new 顧客分析君.D13コンタクトTableAdapters.D13コンタクト履歴ta();
			//this.d13コンタクト履歴2ta = new 顧客分析君.D13コンタクトTableAdapters.D13コンタクト履歴2ta();
			//this.d01性別ta = new 顧客分析君.D01業務共通TableAdapters.D01性別ta();
			//this.d01メルマガ許諾ta = new 顧客分析君.D01業務共通TableAdapters.D01メルマガ許諾ta();
			//this.d10家族構成ta = new 顧客分析君.D10顧客TableAdapters.D10家族構成ta();
			//this.d01家族続柄ta = new 顧客分析君.D01業務共通TableAdapters.D01家族続柄ta();
			//this.d10顧客補足ta = new 顧客分析君.D10顧客TableAdapters.D10顧客補足ta();
			//this.d01補足名ta = new 顧客分析君.D01業務共通TableAdapters.D01補足名ta();

			//this.d03販売履歴ta.ClearBeforeFill = true;
			//this.d10顧客ta.ClearBeforeFill = true;
			//this.d10お勧め商品_顧客毎ta.ClearBeforeFill = true;
			//this.d10RFMランクta.ClearBeforeFill = true;
			//this.d01スタッフta.ClearBeforeFill = true;
			//this.d01バウンドta.ClearBeforeFill = true;
			//this.d01ツールta.ClearBeforeFill = true;
			//this.d10顧客2ta.ClearBeforeFill = true;
			//this.d13コンタクト履歴ta.ClearBeforeFill = true;
			//this.d13コンタクト履歴2ta.ClearBeforeFill = true;
			//this.d01性別ta.ClearBeforeFill = true;
			//this.d01メルマガ許諾ta.ClearBeforeFill = true;
			//this.d10家族構成ta.ClearBeforeFill = true;
			//this.d01家族続柄ta.ClearBeforeFill = true;
			//this.d10顧客補足ta.ClearBeforeFill = true;
			//this.d01補足名ta.ClearBeforeFill = true;
		}

        #endregion


        ////////////////////////////////////////////////////////////////////////
        // 非公開 共通メソッド
        ////////////////////////////////////////////////////////////////////////
        #region 非公開 共通メソッド

		private static bool 最終行or全項目未入力_コンタクト履歴(DataGridView dgv, int iRow)
		{
			if ((dgv.RowCount - 1) != iRow)
				return false;

			if ((dgv.Rows[iRow].Cells[コンタクト履歴Cell.bytコンタクト日時].FormattedValue.ToString() == string.Empty) &&
				(dgv.Rows[iRow].Cells[コンタクト履歴Cell.byt件名].FormattedValue.ToString() == string.Empty) &&
				(dgv.Rows[iRow].Cells[コンタクト履歴Cell.byt本文].FormattedValue.ToString() == string.Empty) &&
				(dgv.Rows[iRow].Cells[コンタクト履歴Cell.bytバウンド].FormattedValue.ToString() == string.Empty) &&
				(dgv.Rows[iRow].Cells[コンタクト履歴Cell.bytツール].FormattedValue.ToString() == string.Empty) &&
				(dgv.Rows[iRow].Cells[コンタクト履歴Cell.bytコンタクトスタッフ].FormattedValue.ToString() == string.Empty))
			{
				return true;
			}

			return false;
		}

		private static bool 最終行or全項目未入力_家族構成(DataGridView dgv, int iRow)
		{
			if ((dgv.RowCount - 1) != iRow)
				return false;

			if ((dgv.Rows[iRow].Cells[家族構成Cell.byt続柄].FormattedValue.ToString() == string.Empty) &&
				(dgv.Rows[iRow].Cells[家族構成Cell.byt氏名].FormattedValue.ToString() == string.Empty) &&
				(dgv.Rows[iRow].Cells[家族構成Cell.byt性別].FormattedValue.ToString() == string.Empty) &&
				(dgv.Rows[iRow].Cells[家族構成Cell.byt生年月日].FormattedValue.ToString() == string.Empty) &&
				(dgv.Rows[iRow].Cells[家族構成Cell.byt郵便番号].FormattedValue.ToString() == string.Empty) &&
				(dgv.Rows[iRow].Cells[家族構成Cell.byt住所].FormattedValue.ToString() == string.Empty) &&
				(dgv.Rows[iRow].Cells[家族構成Cell.bytTEL].FormattedValue.ToString() == string.Empty) &&
				(dgv.Rows[iRow].Cells[家族構成Cell.bytメールアドレス].FormattedValue.ToString() == string.Empty) &&
				(dgv.Rows[iRow].Cells[家族構成Cell.byt顧客ID].FormattedValue.ToString() == string.Empty) &&
				(dgv.Rows[iRow].Cells[家族構成Cell.byt備考].FormattedValue.ToString() == string.Empty))
			{
				return true;
			}

			return false;
		}

		private static bool 最終行or全項目未入力_補足情報(DataGridView dgv, int iRow)
		{
			if ((dgv.RowCount - 1) != iRow)
				return false;

			if ((dgv.Rows[iRow].Cells[補足情報Cell.byt補足名].FormattedValue.ToString() == string.Empty) &&
				(dgv.Rows[iRow].Cells[補足情報Cell.byt補足内容].FormattedValue.ToString() == string.Empty) &&
				(dgv.Rows[iRow].Cells[補足情報Cell.byt備考].FormattedValue.ToString() == string.Empty))
			{
				return true;
			}

			return false;
		}


		private static bool IsValidateDGVコンタクト履歴(DataGridView dgv, int iRow)
		{
			if (iRow < 0)
				return true;

			bool ret = true;

			if (最終行or全項目未入力_コンタクト履歴(dgv, iRow))
				return ret;

			string value;
			for (int iCol = 0; iCol < dgv.ColumnCount; iCol++)
			{
				value = dgv.Rows[iRow].Cells[iCol].FormattedValue.ToString();

				switch (iCol)
				{
					case コンタクト履歴Cell.bytコンタクト日時:
						if (value == string.Empty)
						{
							dgv.Rows[iRow].Cells[コンタクト履歴Cell.bytコンタクト日時].Value = DateTime.Now;
							break;
						}

						if (!C11ValidateOnForm.IsValidateCell日時型(dgv, iRow, iCol, value))
						{
							ret = false;
							break;
						}

						break;
				}
			}

			return ret;
		}

		private static bool IsValidateDGV家族構成(DataGridView dgv, int iRow)
		{
			if (iRow < 0)
				return true;

			bool ret = true;

			if (最終行or全項目未入力_家族構成(dgv, iRow))
				return ret;

			string value;
			for (int iCol = 0; iCol < dgv.ColumnCount; iCol++)
			{
				value = dgv.Rows[iRow].Cells[iCol].FormattedValue.ToString();

				switch (iCol)
				{
					case コンタクト履歴Cell.bytコンタクト日時:
						if (value == string.Empty)
						{
							dgv.Rows[iRow].Cells[家族構成Cell.byt生年月日].Value = DateTime.Now;
							break;
						}

						if (!C11ValidateOnForm.IsValidateCell日時型(dgv, iRow, iCol, value))
						{
							ret = false;
							break;
						}

						break;
				}
			}

			return ret;
		}

		private static bool IsValidateDGV補足情報(DataGridView dgv, int iRow)
		{
			if (iRow < 0)
				return true;

			bool ret = true;

			if (最終行or全項目未入力_補足情報(dgv, iRow))
				return ret;

			string value;
			for (int iCol = 0; iCol < dgv.ColumnCount; iCol++)
			{
				value = dgv.Rows[iRow].Cells[iCol].FormattedValue.ToString();

				switch (iCol)
				{
					case 補足情報Cell.byt補足名:
						if (!C11ValidateOnForm.IsValidateCell必須入力(dgv, iRow, iCol, value))
						{
							ret = false;
							break;
						}

						break;
				}
			}

			return ret;
		}

		private static bool IsValidate未入力行_コンタクト履歴(DataGridViewRow row)
		{
			if ((row.Cells[コンタクト履歴Cell.bytコンタクト履歴No].FormattedValue.ToString() == string.Empty) &&
				(row.Cells[コンタクト履歴Cell.bytコンタクト日時].FormattedValue.ToString() == string.Empty) &&
				(row.Cells[コンタクト履歴Cell.byt件名].FormattedValue.ToString() == string.Empty) &&
				(row.Cells[コンタクト履歴Cell.byt本文].FormattedValue.ToString() == string.Empty) &&
				(row.Cells[コンタクト履歴Cell.bytバウンド].FormattedValue.ToString() == string.Empty) &&
				(row.Cells[コンタクト履歴Cell.bytツール].FormattedValue.ToString() == string.Empty) &&
				(row.Cells[コンタクト履歴Cell.byt備考].FormattedValue.ToString() == string.Empty) &&
				(row.Cells[コンタクト履歴Cell.bytコンタクトスタッフ].FormattedValue.ToString() == string.Empty))
				return true;
			else
				return false;
		}

		private static bool IsValidate未入力行_家族構成(DataGridViewRow row)
		{
			if ((row.Cells[家族構成Cell.byt続柄].FormattedValue.ToString() == string.Empty) &&
				(row.Cells[家族構成Cell.byt氏名].FormattedValue.ToString() == string.Empty) &&
				(row.Cells[家族構成Cell.byt性別].FormattedValue.ToString() == string.Empty) &&
				(row.Cells[家族構成Cell.byt生年月日].FormattedValue.ToString() == string.Empty) &&
				(row.Cells[家族構成Cell.byt郵便番号].FormattedValue.ToString() == string.Empty) &&
				(row.Cells[家族構成Cell.byt住所].FormattedValue.ToString() == string.Empty) &&
				(row.Cells[家族構成Cell.bytTEL].FormattedValue.ToString() == string.Empty) &&
				(row.Cells[家族構成Cell.bytメールアドレス].FormattedValue.ToString() == string.Empty) &&
				(row.Cells[家族構成Cell.byt顧客ID].FormattedValue.ToString() == string.Empty) &&
				(row.Cells[家族構成Cell.byt備考].FormattedValue.ToString() == string.Empty))
				return true;
			else
				return false;
		}

		private static bool IsValidate未入力行_補足情報(DataGridViewRow row)
		{
			if ((row.Cells[補足情報Cell.byt補足名].FormattedValue.ToString() == string.Empty) &&
				(row.Cells[補足情報Cell.byt補足内容].FormattedValue.ToString() == string.Empty) &&
				(row.Cells[補足情報Cell.byt備考].FormattedValue.ToString() == string.Empty))
				return true;
			else
				return false;
		}

		private static bool IsValidate新規変更削除チェック状態_コンタクト履歴(DataGridView dgv, string strFormTitle)
		{
			string strErrMsg = "";
			for (int iRow = 0; iRow < dgv.RowCount; iRow++)
			{
				if (最終行or全項目未入力_コンタクト履歴(dgv, iRow) == true)
					continue;

				strErrMsg = "";
				if (!C11ValidateOnForm.IsValidate新規変更削除チェック状態(dgv, iRow,
					コンタクト履歴Cell.byt新規, コンタクト履歴Cell.byt変更, コンタクト履歴Cell.byt削除,
					コンタクト履歴Cell.bytコンタクト履歴No, ref strErrMsg))
				{
					MessageBox.Show(strErrMsg, strFormTitle, MessageBoxButtons.OK, MessageBoxIcon.Warning);
					return false;
				}
			}

			return true;
		}

		private static bool IsValidate新規変更削除チェック状態_家族構成(DataGridView dgv, string strFormTitle)
		{
			string strErrMsg = "";
			for (int iRow = 0; iRow < dgv.RowCount; iRow++)
			{
				if (最終行or全項目未入力_家族構成(dgv, iRow) == true)
					continue;

				strErrMsg = "";
				if (!C11ValidateOnForm.IsValidate新規変更削除チェック状態(dgv, iRow,
					家族構成Cell.byt新規, 家族構成Cell.byt変更, 家族構成Cell.byt削除,
					家族構成Cell.byt家族構成No, ref strErrMsg))
				{
					MessageBox.Show(strErrMsg, strFormTitle, MessageBoxButtons.OK, MessageBoxIcon.Warning);
					return false;
				}
			}

			return true;
		}

		private static bool IsValidate新規変更削除チェック状態_補足情報(DataGridView dgv, string strFormTitle)
		{
			string strErrMsg = "";
			for (int iRow = 0; iRow < dgv.RowCount; iRow++)
			{
				if (最終行or全項目未入力_補足情報(dgv, iRow) == true)
					continue;

				strErrMsg = "";
				if (!C11ValidateOnForm.IsValidate新規変更削除チェック状態(dgv, iRow,
					補足情報Cell.byt新規, 補足情報Cell.byt変更, 補足情報Cell.byt削除,
					補足情報Cell.byt顧客補足No, ref strErrMsg))
				{
					MessageBox.Show(strErrMsg, strFormTitle, MessageBoxButtons.OK, MessageBoxIcon.Warning);
					return false;
				}
			}

			return true;
		}
		
		#endregion


		#region 非公開 共通メソッド Non Static

		private void Set列幅_コンタクト履歴()
        {
            dgvコンタクト履歴.Columns[コンタクト履歴Cell.byt新規].Visible = false;
            dgvコンタクト履歴.Columns[コンタクト履歴Cell.byt変更].Visible = false;
            dgvコンタクト履歴.Columns[コンタクト履歴Cell.byt削除].Width = C_列幅.削除;
            dgvコンタクト履歴.Columns[コンタクト履歴Cell.bytコンタクト履歴No].Visible = false;
            dgvコンタクト履歴.Columns[コンタクト履歴Cell.bytコンタクト日時].Width = C_列幅.コンタクト_日時;
            dgvコンタクト履歴.Columns[コンタクト履歴Cell.byt件名].Width = C_列幅.コンタクト_件名;
            dgvコンタクト履歴.Columns[コンタクト履歴Cell.byt本文].Width = C_列幅.コンタクト_本文;
            dgvコンタクト履歴.Columns[コンタクト履歴Cell.bytバウンド].Width = C_列幅.コンタクト_バウンド;
            dgvコンタクト履歴.Columns[コンタクト履歴Cell.bytツール].Width = C_列幅.コンタクト_ツール;
            dgvコンタクト履歴.Columns[コンタクト履歴Cell.bytコンタクトスタッフ].Width = C_列幅.コンタクト_スタッフ氏名;
            dgvコンタクト履歴.Columns[コンタクト履歴Cell.byt備考].Width = C_列幅.コンタクト_備考;
        }

        private void Set列幅_購買履歴()
        {
            dgv購買履歴.Columns[購買履歴Cell.byt販売履歴No].Visible = false;
            dgv購買履歴.Columns[購買履歴Cell.bytコンタクト日時].Width = C_列幅.日時;
            dgv購買履歴.Columns[購買履歴Cell.byt商品ID].Width = C_列幅.商品ID;
            dgv購買履歴.Columns[購買履歴Cell.byt商品名].Width = C_列幅.商品名;
            dgv購買履歴.Columns[購買履歴Cell.byt商品単価].Width = C_列幅.商品単価;
            dgv購買履歴.Columns[購買履歴Cell.byt販売個数].Width = C_列幅.販売個数;
        }

        private void Set列幅_家族構成()
        {
            dgv家族構成.Columns[家族構成Cell.byt新規].Visible = false;
            dgv家族構成.Columns[家族構成Cell.byt変更].Visible = false;
            dgv家族構成.Columns[家族構成Cell.byt削除].Width = C_列幅.削除;
            dgv家族構成.Columns[家族構成Cell.byt家族構成No].Visible = false;
            dgv家族構成.Columns[家族構成Cell.byt顧客No].Visible = false;
            dgv家族構成.Columns[家族構成Cell.byt続柄].Width = C_列幅.家族続柄;
            dgv家族構成.Columns[家族構成Cell.byt続柄名].Visible = false;
            dgv家族構成.Columns[家族構成Cell.byt氏名].Width = C_列幅.氏名;
            dgv家族構成.Columns[家族構成Cell.byt氏名カナ].Width = C_列幅.氏名カナ;
            dgv家族構成.Columns[家族構成Cell.byt性別].Width = C_列幅.性別;
            dgv家族構成.Columns[家族構成Cell.byt性別名].Visible = false;
            dgv家族構成.Columns[家族構成Cell.byt生年月日].Width = C_列幅.年月日;
            dgv家族構成.Columns[家族構成Cell.byt郵便番号].Width = C_列幅.郵便番号;
            dgv家族構成.Columns[家族構成Cell.byt住所].Width = C_列幅.住所;
            dgv家族構成.Columns[家族構成Cell.bytTEL].Width = C_列幅.TEL;
            dgv家族構成.Columns[家族構成Cell.bytメールアドレス].Width = C_列幅.メールアドレス;
            dgv家族構成.Columns[家族構成Cell.byt顧客ID].Width = C_列幅.顧客ID;
            dgv家族構成.Columns[家族構成Cell.byt備考].Width = C_列幅.備考;
        }

        private void Set列幅_補足情報()
        {
            dgv補足情報.Columns[補足情報Cell.byt新規].Visible = false;
            dgv補足情報.Columns[補足情報Cell.byt変更].Visible = false;
            dgv補足情報.Columns[補足情報Cell.byt削除].Width = C_列幅.削除;
			dgv補足情報.Columns[補足情報Cell.byt顧客補足No].Visible = false;
			dgv補足情報.Columns[補足情報Cell.byt顧客No].Visible = false;
            dgv補足情報.Columns[補足情報Cell.byt補足名].Width = C_列幅.補足名;
            dgv補足情報.Columns[補足情報Cell.byt補足内容].Width = C_列幅.補足内容;
            dgv補足情報.Columns[補足情報Cell.byt備考].Width = C_列幅.備考;
        }

        private void Set列幅_お勧め商品()
        {
            dgvお勧め商品.Columns[お勧め商品Cell.byt商品No].Visible = false;
            dgvお勧め商品.Columns[お勧め商品Cell.byt商品ID].Width = C_列幅.商品ID;
            dgvお勧め商品.Columns[お勧め商品Cell.byt商品名].Width = C_列幅.商品名;
            dgvお勧め商品.Columns[お勧め商品Cell.byt商品単価].Width = C_列幅.商品単価;
            dgvお勧め商品.Columns[お勧め商品Cell.bytお勧め度].Width = C_列幅.類似度;
        }



        //入力値検証
        private bool IsValidate()
        {
            //最大登録件数チェック
            //D03販売履歴.D03販売履歴Row[] dr = (D03販売履歴.D03販売履歴Row[])d03販売履歴._D03販売履歴.Select("新規 = true");
            //int intCnt = (int)d03販売履歴ta.Scalar販売履歴Cnt() + dr.Length;
            //if (intCnt > C_最大値.登録件数)
            //{
            //    string msg = string.Format(Properties.Resources.MSG_INF_101, C_最大値.登録件数);
            //    MessageBox.Show(msg, this.Text, MessageBoxButtons.OK, MessageBoxIcon.Warning);
            //    dgvコンタクト履歴.Focus();
            //    return false;
            //}

            //必須入力欄
            //if ((dgvコンタクト履歴.RowCount == 1) && (最終行or全項目未入力(0)))
            //{
            //    MessageBox.Show(Properties.Resources.MSG_INF_078, this.Text, MessageBoxButtons.OK, MessageBoxIcon.Warning);
            //    dgvコンタクト履歴.Focus();
            //    return false;
            //}

            //最大値確定件数チェック
            //dr = (D03販売履歴.D03販売履歴Row[])d03販売履歴._D03販売履歴.Select("新規 = true or 変更 = true or 削除 = true");
            //if (dr.Length > C_最大値.確定件数)
            //{
            //    MessageBox.Show(string.Format(Properties.Resources.MSG_INF_093, C_最大値.CSV取込件数), this.Text, MessageBoxButtons.OK, MessageBoxIcon.Warning);
            //}

            //if (IsValidate新規変更削除チェック状態() == false)
            //    return false;

            //未入力
            //bool b新規変更削除にチェック有り = false;
            //for (int iRow = 0; iRow < dgvコンタクト履歴.RowCount; iRow++)
            //{
            //    if (最終行or全項目未入力(iRow) == true)
            //        continue;

            //    if ((Boolean)dgvコンタクト履歴.Rows[iRow].Cells[コンタクト履歴Cell.byt新規].Value == false &&
            //        (Boolean)dgvコンタクト履歴.Rows[iRow].Cells[コンタクト履歴Cell.byt変更].Value == false &&
            //        (Boolean)dgvコンタクト履歴.Rows[iRow].Cells[コンタクト履歴Cell.byt削除].Value == false)
            //        continue;

            //    b新規変更削除にチェック有り = true;
            //    break;
            //}

            //if (b新規変更削除にチェック有り == false)
            //{
            //    MessageBox.Show(Properties.Resources.MSG_INF_067, this.Text, MessageBoxButtons.OK,
            //        MessageBoxIcon.Warning);
            //    dgvコンタクト履歴.Focus();
            //    return false;
            //}

            //編集されたセルを全てチェックする
            //bool isValid = true;
            //for (int iRow = 0; iRow < dgvコンタクト履歴.RowCount; iRow++)
            //{
            //    if (最終行or全項目未入力(iRow) == true)
            //        continue;

            //    if ((Boolean)dgvコンタクト履歴.Rows[iRow].Cells[コンタクト履歴Cell.byt新規].Value == false &&
            //        (Boolean)dgvコンタクト履歴.Rows[iRow].Cells[コンタクト履歴Cell.byt変更].Value == false &&
            //        (Boolean)dgvコンタクト履歴.Rows[iRow].Cells[コンタクト履歴Cell.byt削除].Value == false)
            //        continue;

            //    if (!IsValidateDGVコンタクト履歴(iRow))
            //        isValid = false;
            //}

            //if (!isValid)
            //{
            //    MessageBox.Show(string.Format(Properties.Resources.MSG_INF_016, "販売履歴")
            //        , this.Text, MessageBoxButtons.OK, MessageBoxIcon.Warning);

            //    dgvコンタクト履歴.Focus();
            //    return false;
            //}

            return true;
        }



        private void Update基本情報()
        {
			C06DB共通.d10顧客2ta.Update(mstr顧客ID,
                                txt氏名.Text,
                                txt氏名カナ.Text,
                                byte.Parse(cmb性別.SelectedValue.ToString()),
                                dtp生年月日.Value,
                                txt郵便番号.Text,
                                txt住所.Text,
                                txtTEL.Text,
                                txtメールアドレス.Text,
                                byte.Parse(cmbメルマガ許諾.SelectedValue.ToString()),
                                txt備考.Text,
                                C02業務共通処理.miログインスタッフNo,
                                mint顧客No);
        }

        private void Insertコンタクト履歴()
        {
            D13コンタクト.D13コンタクト履歴Row[] dr =
                (D13コンタクト.D13コンタクト履歴Row[])d13コンタクト.D13コンタクト履歴.Select("新規 = true");

            int iバウンド = 0;
            int iツール = 0;
            int iスタッフ氏名 = 0;
            for (int iRow = 0; iRow < dr.Length; iRow++)
            {
                dr[iRow].件名 = C04システム共通.NULLを空文字に変換(dr[iRow].件名);
                dr[iRow].本文 = C04システム共通.NULLを空文字に変換(dr[iRow].本文);
                dr[iRow].備考 = C04システム共通.NULLを空文字に変換(dr[iRow].備考);
                iバウンド = C02業務共通処理.GetバウンドNo(dr[iRow].バウンドNo, dr[iRow].バウンド);
                iツール = C02業務共通処理.GetツールNo(dr[iRow].ツールNo, dr[iRow].ツール);
                iスタッフ氏名 = C02業務共通処理.GetコンタクトスタッフNo(dr[iRow].コンタクトスタッフNo, dr[iRow].スタッフ氏名);

				C06DB共通.d13コンタクト履歴2ta.Insert(mint顧客No,
                                            dr[iRow].コンタクト日時, 
                                            dr[iRow].件名, 
                                            dr[iRow].本文,
                                            iバウンド,
                                            iツール,
                                            dr[iRow].備考,
                                            iスタッフ氏名,
                                            C02業務共通処理.miログインスタッフNo);
            }
        }

        private void Insert家族構成()
        {
            D10顧客.D10家族構成Row[] dr = (D10顧客.D10家族構成Row[])d10顧客.D10家族構成.Select("新規 = true");

			int i続柄No = 0;

			for (int iRow = 0; iRow < dr.Length; iRow++)
            {
				i続柄No = dr[iRow].家族構成No;
				dr[iRow].顧客ID = C04システム共通.NULLを空文字に変換(dr[iRow].顧客ID);
                dr[iRow].氏名 = C04システム共通.NULLを空文字に変換(dr[iRow].氏名);
                dr[iRow].氏名カナ = C04システム共通.NULLを空文字に変換(dr[iRow].氏名カナ);
                dr[iRow].郵便番号 = C04システム共通.NULLを空文字に変換(dr[iRow].郵便番号);
                dr[iRow].住所 = C04システム共通.NULLを空文字に変換(dr[iRow].住所);
                dr[iRow].TEL = C04システム共通.NULLを空文字に変換(dr[iRow].TEL);
                dr[iRow].メールアドレス = C04システム共通.NULLを空文字に変換(dr[iRow].メールアドレス);
                dr[iRow].備考 = C04システム共通.NULLを空文字に変換(dr[iRow].備考);

				C06DB共通.d10家族構成ta.InsertQuery(mint顧客No,
                                            dr[iRow].続柄,
                                            dr[iRow].氏名,
                                            dr[iRow].氏名カナ,
                                            dr[iRow].性別,
                                            dr[iRow].生年月日,
                                            dr[iRow].郵便番号,
                                            dr[iRow].住所,
                                            dr[iRow].TEL,
                                            dr[iRow].メールアドレス,
                                            dr[iRow].顧客ID,
                                            dr[iRow].備考,
                                            C02業務共通処理.miログインスタッフNo);
            }
        }

        private void Insert補足情報()
        {
            D10顧客.D10顧客補足Row[] dr = (D10顧客.D10顧客補足Row[])d10顧客.D10顧客補足.Select("新規 = true");

            for (int iRow = 0; iRow < dr.Length; iRow++)
            {
                dr[iRow].補足内容 = C04システム共通.NULLを空文字に変換(dr[iRow].補足内容);
                dr[iRow].備考 = C04システム共通.NULLを空文字に変換(dr[iRow].備考);

				C06DB共通.d10顧客補足ta.Insert(mint顧客No,
                                    dr[iRow].補足名No,
                                    dr[iRow].補足内容,
                                    dr[iRow].備考,
                                    C02業務共通処理.miログインスタッフNo);
            }
        }

        private void Updateコンタクト履歴()
        {
            D13コンタクト.D13コンタクト履歴Row[] dr =
                (D13コンタクト.D13コンタクト履歴Row[])d13コンタクト.D13コンタクト履歴.Select("変更 = true");

            for (int iRow = 0; iRow < dr.Length; iRow++)
            {
                dr[iRow].件名 = C04システム共通.NULLを空文字に変換(dr[iRow].件名);
                dr[iRow].本文 = C04システム共通.NULLを空文字に変換(dr[iRow].本文);
                dr[iRow].備考 = C04システム共通.NULLを空文字に変換(dr[iRow].備考);

				C06DB共通.d13コンタクト履歴2ta.Update(dr[iRow].コンタクト日時, 
                                            dr[iRow].件名, 
                                            dr[iRow].本文,
                                            C02業務共通処理.GetバウンドNo(dr[iRow].バウンドNo, dr[iRow].バウンド),
                                            C02業務共通処理.GetツールNo(dr[iRow].ツールNo, dr[iRow].ツール),
                                            dr[iRow].備考,
                                            C02業務共通処理.GetコンタクトスタッフNo(dr[iRow].コンタクトスタッフNo, dr[iRow].スタッフ氏名),
                                            C02業務共通処理.miログインスタッフNo, 
                                            dr[iRow].コンタクト履歴No);
            }
        }

        private void Update家族構成()
        {
            D10顧客.D10家族構成Row[] dr = (D10顧客.D10家族構成Row[])d10顧客.D10家族構成.Select("変更 = true");

            for (int iRow = 0; iRow < dr.Length; iRow++)
            {
				C06DB共通.d10家族構成ta.UpdateQuery(mint顧客No,
                                            dr[iRow].続柄,
                                            dr[iRow].氏名,
                                            dr[iRow].氏名カナ,
                                            dr[iRow].性別,
                                            dr[iRow].生年月日,
                                            dr[iRow].郵便番号,
                                            dr[iRow].住所,
                                            dr[iRow].TEL,
                                            dr[iRow].メールアドレス,
                                            dr[iRow].顧客ID,
                                            dr[iRow].備考,
                                            C02業務共通処理.miログインスタッフNo,
											dr[iRow].家族構成No);
            }
        }

        private void Update補足情報()
        {
            D10顧客.D10顧客補足Row[] dr = (D10顧客.D10顧客補足Row[])d10顧客.D10顧客補足.Select("変更 = true");

            for (int iRow = 0; iRow < dr.Length; iRow++)
            {
				C06DB共通.d10顧客補足ta.Update(mint顧客No,
                                        dr[iRow].補足名No,
                                        dr[iRow].補足内容,
                                        dr[iRow].備考,
                                        C02業務共通処理.miログインスタッフNo,
                                        dr[iRow].顧客補足No);
            }
        }


        private void Deleteコンタクト履歴()
        {
            for (int iRow = 0; iRow < dgvコンタクト履歴.RowCount; iRow++)
            {
                if (dgvコンタクト履歴.Rows[iRow].Cells[コンタクト履歴Cell.byt削除].Value == null)
                    continue;

                if ((Boolean)dgvコンタクト履歴.Rows[iRow].Cells[コンタクト履歴Cell.byt削除].Value == false)
                    continue;

                if (dgvコンタクト履歴.Rows[iRow].Cells[コンタクト履歴Cell.bytコンタクト履歴No].Value.ToString() == "")
                    continue;

				C06DB共通.d13コンタクト履歴2ta.Delete((int)dgvコンタクト履歴.Rows[iRow].Cells[コンタクト履歴Cell.bytコンタクト履歴No].Value);
            }
        }

        private void Delete家族構成()
        {
            for (int iRow = 0; iRow < dgv家族構成.RowCount; iRow++)
            {
                if (dgv家族構成.Rows[iRow].Cells[家族構成Cell.byt削除].Value == null)
                    continue;

                if ((Boolean)dgv家族構成.Rows[iRow].Cells[家族構成Cell.byt削除].Value == false)
                    continue;

                if (dgv家族構成.Rows[iRow].Cells[家族構成Cell.byt家族構成No].Value.ToString() == "")
                    continue;

				C06DB共通.d10家族構成ta.DeleteQuery((int)dgv家族構成.Rows[iRow].Cells[家族構成Cell.byt家族構成No].Value);
            }
        }

        private void Delete補足情報()
        {
            for (int iRow = 0; iRow < dgv補足情報.RowCount; iRow++)
            {
                if (dgv補足情報.Rows[iRow].Cells[補足情報Cell.byt削除].Value == null)
                    continue;

                if ((Boolean)dgv補足情報.Rows[iRow].Cells[補足情報Cell.byt削除].Value == false)
                    continue;

                if (dgv補足情報.Rows[iRow].Cells[補足情報Cell.byt顧客補足No].Value.ToString() == "")
                    continue;

				C06DB共通.d10顧客補足ta.Delete((int)dgv補足情報.Rows[iRow].Cells[補足情報Cell.byt顧客補足No].Value);
            }
        }

        private void Set基本情報()
        {
            txt顧客ID.Text = mstr顧客ID;
            txt氏名.Text = mstr氏名;
            txt氏名カナ.Text = mstr氏名カナ;
            cmb性別.Text = mstr性別;
            dtp生年月日.Text = mstr生年月日;
            txt郵便番号.Text = mstr郵便番号;
            txt住所.Text = mstr住所;
            txtTEL.Text = mstrTEL;
            txtメールアドレス.Text = mstrメールアドレス;
			//cmbメルマガ許諾.SelectedValue = mstrメルマガ許諾;
			cmbメルマガ許諾.Text = mstrメルマガ許諾;
			txt備考.Text = mstr備考;
        }

        private void SetRFM分析結果()
        {
            D10顧客.D10RFMランクDataTable dt = new D10顧客.D10RFMランクDataTable();
			C06DB共通.d10RFMランクta.Fill(dt, mint顧客No);

            if (dt.Count < 1)
                return;

            txtRFM分析_Rランク.Text = dt[0].R.ToString();
            txtRFM分析_Fランク.Text = dt[0].R.ToString();
            txtRFM分析_Mランク.Text = dt[0].R.ToString();
			txtRFM分析_最新購買日.Text = C06DB共通.d10RFMランクta.Scalar顧客別_最新購買日(mint顧客No).ToString();
			txtRFM分析_累計購買回数.Text = C06DB共通.d10RFMランクta.Scalar顧客別_累計購買回数(mint顧客No).ToString();
			txtRFM分析_累計購買金額.Text = C06DB共通.d10RFMランクta.Scalar顧客別_累計購買金額(mint顧客No).ToString();
        }

        private void Set購買履歴()
        {
			C06DB共通.d03販売履歴ta.FillBy顧客No(d03販売履歴._D03販売履歴, mint顧客No);
        }

        private void Setお勧め商品()
        {
			C06DB共通.d10お勧め商品_顧客毎ta.Fill(d10顧客.D10お勧め商品_顧客毎, mint顧客No);
        }

        private void Setコンタクト履歴()
        {
			C06DB共通.d13コンタクト履歴ta.FillBy検索(d13コンタクト.D13コンタクト履歴, mint顧客No);
        }

        private void Set家族構成()
        {
			C06DB共通.d10家族構成ta.Fill(d10顧客.D10家族構成, mint顧客No);
        }

        private void Set補足情報()
        {
			C06DB共通.d10顧客補足ta.FillBy検索(d10顧客.D10顧客補足, mint顧客No);
        }

        private void Set属性マスタ()
        {
			C06DB共通.d01メルマガ許諾ta.Fill(d01業務共通.D01メルマガ許諾);
			C06DB共通.d01性別ta.Fill(d01業務共通.D01性別);
			C06DB共通.d01ツールta.Fill(d01業務共通.D01ツール);
			C06DB共通.d01バウンドta.Fill(d01業務共通.D01バウンド);
			C06DB共通.d01スタッフta.Fill(d01業務共通.D01スタッフ);
			C06DB共通.d01家族続柄ta.Fill(d01業務共通.D01家族続柄);
			C06DB共通.d01補足名ta.Fill(d01業務共通.D01補足名);
		}

        private void CreateCSVファイル_顧客詳細(string strFileName)
        {
            string 一時ファイル = string.Format(@"{0}{1}.csv", Path.GetTempPath(), DateTime.Now.ToString("yyyyMMddHHmmss"));

			//using (StreamWriter sw = new StreamWriter(一時ファイル, false, Encoding.GetEncoding("Shift_JIS")))
			//{
                string strグリッド以外 = "【基本情報】\r\n";
                strグリッド以外 += "\"顧客ID\",\"氏名\",\"氏名カナ\",\"性別\",\"年齢\",\"郵便番号\",\"住所\",\"TEL\",\"メールアドレス\",\"備考\"";
                strグリッド以外 += "\r\n";
                strグリッド以外 += "\"" + txt顧客ID.Text + "\",\"" + txt氏名.Text + "\",\"" + txt氏名カナ.Text + "\",\"" + cmb性別.Text + "\",\""
                    + dtp生年月日.Text + "\",\"" + txt郵便番号.Text + "\",\"" + txt住所.Text + "\",\"" + txtTEL.Text + "\",\"" + txtメールアドレス.Text
                    + "\",\"" + txt備考.Text + "\"\r\n";
				strグリッド以外 += "\r\n";

                //sw.Write(strグリッド以外);
                //sw.Write("\r\n");
				File.AppendAllText(一時ファイル, strグリッド以外, Encoding.GetEncoding("Shift_JIS"));
				//File.AppendAllText(一時ファイル, "\r\n", Encoding.GetEncoding("Shift_JIS"));

                //sw.Write("【コンタクト履歴】\r\n");
				File.AppendAllText(一時ファイル, "【コンタクト履歴】\r\n", Encoding.GetEncoding("Shift_JIS"));

				//C06CSV.Writeグリッドヘッダ(sw, dgvコンタクト履歴, 1);
				//C06CSV.Writeグリッド明細(sw, dgvコンタクト履歴, 1);
				C06CSV.Writeグリッドヘッダ(一時ファイル, dgvコンタクト履歴, 1);
				C06CSV.Writeグリッド明細(一時ファイル, dgvコンタクト履歴, 1);

                //sw.Write("\r\n");
				//File.AppendAllText(一時ファイル, "\r\n", Encoding.GetEncoding("Shift_JIS"));

                //sw.Write("【購買履歴】\r\n");
				File.AppendAllText(一時ファイル, "\r\n【購買履歴】\r\n", Encoding.GetEncoding("Shift_JIS"));

				//C06CSV.Writeグリッドヘッダ(sw, dgv購買履歴, 1);
				//C06CSV.Writeグリッド明細(sw, dgv購買履歴, 1);
				C06CSV.Writeグリッドヘッダ(一時ファイル, dgv購買履歴, 1);
				C06CSV.Writeグリッド明細(一時ファイル, dgv購買履歴, 1);

                //sw.Write("\r\n");
				//File.AppendAllText(一時ファイル, "\r\n", Encoding.GetEncoding("Shift_JIS"));

                //sw.Write("【家族構成】\r\n");
				File.AppendAllText(一時ファイル, "\r\n【家族構成】\r\n", Encoding.GetEncoding("Shift_JIS"));

				//C06CSV.Writeグリッドヘッダ(sw, dgv家族構成, 1);
				//C06CSV.Writeグリッド明細(sw, dgv家族構成, 1);
				C06CSV.Writeグリッドヘッダ(一時ファイル, dgv家族構成, 1);
				C06CSV.Writeグリッド明細(一時ファイル, dgv家族構成, 1);

                //sw.Write("\r\n");
				//File.AppendAllText(一時ファイル, "\r\n", Encoding.GetEncoding("Shift_JIS"));

                //sw.Write("【補足情報】\r\n");
				File.AppendAllText(一時ファイル, "\r\n【補足情報】\r\n", Encoding.GetEncoding("Shift_JIS"));

				//C06CSV.Writeグリッドヘッダ(sw, dgv補足情報, 1);
				//C06CSV.Writeグリッド明細(sw, dgv補足情報, 1);
				C06CSV.Writeグリッドヘッダ(一時ファイル, dgv補足情報, 1);
				C06CSV.Writeグリッド明細(一時ファイル, dgv補足情報, 1);

                //sw.Write("\r\n");
				//File.AppendAllText(一時ファイル, "\r\n", Encoding.GetEncoding("Shift_JIS"));

				strグリッド以外 = "\r\n【分析結果】\r\n";
                strグリッド以外 += "\"Rランク\",\"Fランク\",\"Mランク\",\"最新購買日\",\"累計購買回数\",\"累計購買金額\"";
                strグリッド以外 += "\r\n";
                strグリッド以外 += "\"" + txtRFM分析_Rランク.Text + "\",\"" + txtRFM分析_Fランク.Text + "\",\"" 
					+ txtRFM分析_Mランク.Text + "\",\"" + txtRFM分析_最新購買日.Text + "\",\""
                    + txtRFM分析_累計購買回数.Text + "\",\"" + txtRFM分析_累計購買金額.Text + "\"\r\n";

                //sw.Write(strグリッド以外);
                //sw.Write("\r\n");
				File.AppendAllText(一時ファイル, strグリッド以外 + "\r\n", Encoding.GetEncoding("Shift_JIS"));
				//File.AppendAllText(一時ファイル, "\r\n", Encoding.GetEncoding("Shift_JIS"));

                //sw.Write(strグリッド以外);
				//File.AppendAllText(一時ファイル, strグリッド以外, Encoding.GetEncoding("Shift_JIS"));

				//C06CSV.Writeグリッドヘッダ(sw, dgvお勧め商品, 1);
				//C06CSV.Writeグリッド明細(sw, dgvお勧め商品, 1);
				C06CSV.Writeグリッドヘッダ(一時ファイル, dgvお勧め商品, 1);
				C06CSV.Writeグリッド明細(一時ファイル, dgvお勧め商品, 1);

                //sw.Write("\r\n");
				//File.AppendAllText(一時ファイル, "\r\n", Encoding.GetEncoding("Shift_JIS"));

				strグリッド以外 = "\r\n【備考】\r\n";
                strグリッド以外 = txt備考.Text + "\r\n";
                //sw.Write(strグリッド以外);
				File.AppendAllText(一時ファイル, strグリッド以外, Encoding.GetEncoding("Shift_JIS"));
			//}

            File.Copy(一時ファイル, strFileName, true);

            if (File.Exists(一時ファイル))
                File.Delete(一時ファイル);
        }

        #endregion


        ////////////////////////////////////////////////////////////////////////
        // イベントハンドラ
        ////////////////////////////////////////////////////////////////////////
        #region イベントハンドラ
        
        private void _405顧客詳細_Load(object sender, EventArgs e)
        {
            try
            {
#if RELEASE
                btnメール配信.Visible = false;
#endif

                Cursor.Current = Cursors.WaitCursor;

                Set属性マスタ();
                Set基本情報();
                Set購買履歴();
                Setコンタクト履歴();
                Set家族構成();
                Set補足情報();
                SetRFM分析結果();
                Setお勧め商品();

                txt年齢.Text = C04システム共通.Get年齢計算(dtp生年月日.Value).ToString();
            }
            catch (Exception ex)
            {
                C04システム共通.ErrorLog("_405顧客詳細", "_405顧客詳細_Load", ex);
            }
            finally
            {
                //d03販売履歴bs.DataSource = d03販売履歴._D03販売履歴;
                //dgv購買履歴.AutoSizeColumnsMode = DataGridViewAutoSizeColumnsMode.AllCells;
                Set列幅_コンタクト履歴();
                Set列幅_購買履歴();
                Set列幅_家族構成();
                Set列幅_補足情報();
                Set列幅_お勧め商品();
                Cursor.Current = Cursors.Arrow;
            }
        }

        private void _405顧客詳細_Resize(object sender, EventArgs e)
        {
            try
            {
                C01FormCommon.画面最小サイズに変更(this, true);
            }
            catch (Exception ex)
            {
                C04システム共通.ErrorLog("_405顧客詳細", "_405顧客詳細_Resize", ex);
            }
        }

        private void dgv購買履歴_RowPostPaint(object sender, DataGridViewRowPostPaintEventArgs e)
        {
            try
            {
                C01FormCommon.行数表示(e.RowBounds.Location.X,
                                              e.RowBounds.Location.Y,
                                              dgv購買履歴.RowHeadersWidth,
                                              e.RowBounds.Height,
                                              e.Graphics,
                                              e.RowIndex,
                                              dgv購買履歴.RowHeadersDefaultCellStyle.Font,
                                              dgv購買履歴.RowHeadersDefaultCellStyle.ForeColor);
            }
            catch (Exception ex)
            {
                C04システム共通.ErrorLog("_405顧客詳細", "dgv購買履歴_RowPostPaint", ex);
            }
        }

        private void dgvお勧め商品_RowPostPaint(object sender, DataGridViewRowPostPaintEventArgs e)
        {
            try
            {
                C01FormCommon.行数表示(e.RowBounds.Location.X,
                                              e.RowBounds.Location.Y,
                                              dgvお勧め商品.RowHeadersWidth,
                                              e.RowBounds.Height,
                                              e.Graphics,
                                              e.RowIndex,
                                              dgvお勧め商品.RowHeadersDefaultCellStyle.Font,
                                              dgvお勧め商品.RowHeadersDefaultCellStyle.ForeColor);
            }
            catch (Exception ex)
            {
                C04システム共通.ErrorLog("_405顧客詳細", "dgvお勧め商品_RowPostPaint", ex);
            }
        }

        private void dgvコンタクト履歴_RowPostPaint(object sender, DataGridViewRowPostPaintEventArgs e)
        {
            try
            {
                C01FormCommon.行数表示(e.RowBounds.Location.X,
                                              e.RowBounds.Location.Y,
                                              dgvコンタクト履歴.RowHeadersWidth,
                                              e.RowBounds.Height,
                                              e.Graphics,
                                              e.RowIndex,
                                              dgvコンタクト履歴.RowHeadersDefaultCellStyle.Font,
                                              dgvコンタクト履歴.RowHeadersDefaultCellStyle.ForeColor);
            }
            catch (Exception ex)
            {
                C04システム共通.ErrorLog("_405顧客詳細", "dgvコンタクト履歴_RowPostPaint", ex);
            }
        }

        private void dgv家族構成_RowPostPaint(object sender, DataGridViewRowPostPaintEventArgs e)
        {
            try
            {
                C01FormCommon.行数表示(e.RowBounds.Location.X,
                                              e.RowBounds.Location.Y,
                                              dgv家族構成.RowHeadersWidth,
                                              e.RowBounds.Height,
                                              e.Graphics,
                                              e.RowIndex,
                                              dgv家族構成.RowHeadersDefaultCellStyle.Font,
                                              dgv家族構成.RowHeadersDefaultCellStyle.ForeColor);
            }
            catch (Exception ex)
            {
                C04システム共通.ErrorLog("_405顧客詳細", "dgv家族構成_RowPostPaint", ex);
            }
        }

        private void dgv補足情報_RowPostPaint(object sender, DataGridViewRowPostPaintEventArgs e)
        {
            try
            {
                C01FormCommon.行数表示(e.RowBounds.Location.X,
                                              e.RowBounds.Location.Y,
											  dgv補足情報.RowHeadersWidth,
                                              e.RowBounds.Height,
                                              e.Graphics,
                                              e.RowIndex,
                                              dgv補足情報.RowHeadersDefaultCellStyle.Font,
                                              dgv補足情報.RowHeadersDefaultCellStyle.ForeColor);
            }
            catch (Exception ex)
            {
                C04システム共通.ErrorLog("_405顧客詳細", "dgv補足情報_RowPostPaint", ex);
            }
        }

        private void dgvコンタクト履歴_CellValueChanged(object sender, DataGridViewCellEventArgs e)
        {
            try
            {
                //if (e.RowIndex < 0)
                //    return;

                //if (e.ColumnIndex < 3)
                //    return;

                //if (dgvコンタクト履歴.Rows[e.RowIndex].Cells[コンタクト履歴Cell.bytコンタクト履歴No].Value == null)
                //    return;

                //if (dgvコンタクト履歴.Rows[e.RowIndex].Cells[コンタクト履歴Cell.bytコンタクト履歴No].Value.ToString() != "")
                //{
                //    // 「変更」列をチェック状態にする
                //    dgvコンタクト履歴.Rows[e.RowIndex].Cells[コンタクト履歴Cell.byt新規].Value = false;
                //    dgvコンタクト履歴.Rows[e.RowIndex].Cells[コンタクト履歴Cell.byt変更].Value = true;
                //    dgvコンタクト履歴.Rows[e.RowIndex].Cells[コンタクト履歴Cell.byt削除].Value = false;
                //}
                //else
                //{
                //    // 「新規」列をチェック状態にする
                //    dgvコンタクト履歴.Rows[e.RowIndex].Cells[コンタクト履歴Cell.byt新規].Value = true;
                //    dgvコンタクト履歴.Rows[e.RowIndex].Cells[コンタクト履歴Cell.byt変更].Value = false;
                //    dgvコンタクト履歴.Rows[e.RowIndex].Cells[コンタクト履歴Cell.byt削除].Value = false;
                //}

                C11ValidateOnForm.新規変更削除列のチェック状態変更(e, コンタクト履歴Cell.bytコンタクト履歴No,
                    コンタクト履歴Cell.byt新規, コンタクト履歴Cell.byt変更, コンタクト履歴Cell.byt削除,
                    ref dgvコンタクト履歴);
            }
            catch (Exception ex)
            {
                C04システム共通.ErrorLog("_405顧客詳細", "dgvコンタクト履歴_CellValueChanged", ex);
            }
        }

        private void dgv家族構成_CellValueChanged(object sender, DataGridViewCellEventArgs e)
        {
            try
            {
                C11ValidateOnForm.新規変更削除列のチェック状態変更(e, 家族構成Cell.byt家族構成No,
                    家族構成Cell.byt新規, 家族構成Cell.byt変更, 家族構成Cell.byt削除,
                    ref dgv家族構成);
            }
            catch (Exception ex)
            {
                C04システム共通.ErrorLog("_405顧客詳細", "dgvコンタクト履歴_CellValueChanged", ex);
            }
        }

        private void dgv補足情報_CellValueChanged(object sender, DataGridViewCellEventArgs e)
        {
            try
            {
                C11ValidateOnForm.新規変更削除列のチェック状態変更(e, 補足情報Cell.byt顧客補足No,
                    補足情報Cell.byt新規, 補足情報Cell.byt変更, 補足情報Cell.byt削除,
                    ref dgv補足情報);
            }
            catch (Exception ex)
            {
                C04システム共通.ErrorLog("_405顧客詳細", "dgv補足情報_CellValueChanged", ex);
            }
        }

        private void dgvコンタクト履歴_CellValidating(object sender, DataGridViewCellValidatingEventArgs e)
        {
            try
            {
                //列が変わった場合は書式チェックを実施
                string value = e.FormattedValue.ToString();

                switch (e.ColumnIndex)
                {
                    case コンタクト履歴Cell.bytコンタクト日時:
                        if (value != string.Empty)
                        {
                            if (!C11ValidateOnForm.IsValidateCell日時型(dgvコンタクト履歴, e.RowIndex, e.ColumnIndex, value))
                                break;

                            //必須入力で入力完了したものについてはメッセージを消去
                            dgvコンタクト履歴.Rows[e.RowIndex].Cells[e.ColumnIndex].ErrorText = string.Empty;
                        }

                        break;

                    case コンタクト履歴Cell.byt件名:
                        if (value != string.Empty)
                        {
                            if (!C11ValidateOnForm.IsValidateCell必須入力(dgvコンタクト履歴, e.RowIndex, e.ColumnIndex, value))
                                break;

                            //必須入力で入力完了したものについてはメッセージを消去
                            dgvコンタクト履歴.Rows[e.RowIndex].Cells[e.ColumnIndex].ErrorText = string.Empty;
                        }

                        break;

                    case コンタクト履歴Cell.byt本文:
                        if (value != string.Empty)
                        {
                            if (!C11ValidateOnForm.IsValidateCell必須入力(dgvコンタクト履歴, e.RowIndex, e.ColumnIndex, value))
                                break;

                            //必須入力で入力完了したものについてはメッセージを消去
                            dgvコンタクト履歴.Rows[e.RowIndex].Cells[e.ColumnIndex].ErrorText = string.Empty;
                        }

                        break;

                    case コンタクト履歴Cell.bytバウンド:
                        if (value != string.Empty)
                        {
                            if (!C11ValidateOnForm.IsValidateCell必須入力(dgvコンタクト履歴, e.RowIndex, e.ColumnIndex, value))
                                break;

                            //必須入力で入力完了したものについてはメッセージを消去
                            dgvコンタクト履歴.Rows[e.RowIndex].Cells[e.ColumnIndex].ErrorText = string.Empty;
                        }

                        break;

                    case コンタクト履歴Cell.bytツール:
                        if (value != string.Empty)
                        {
                            if (!C11ValidateOnForm.IsValidateCell必須入力(dgvコンタクト履歴, e.RowIndex, e.ColumnIndex, value))
                                break;

                            //必須入力で入力完了したものについてはメッセージを消去
                            dgvコンタクト履歴.Rows[e.RowIndex].Cells[e.ColumnIndex].ErrorText = string.Empty;
                        }

                        break;

                    case コンタクト履歴Cell.bytコンタクトスタッフ:
                        if (value != string.Empty)
                        {
                            if (!C11ValidateOnForm.IsValidateCell必須入力(dgvコンタクト履歴, e.RowIndex, e.ColumnIndex, value))
                                break;

                            //必須入力で入力完了したものについてはメッセージを消去
                            dgvコンタクト履歴.Rows[e.RowIndex].Cells[e.ColumnIndex].ErrorText = string.Empty;
                        }

                        break;
                }
            }
            catch (Exception ex)
            {
                C04システム共通.ErrorLog("_405顧客詳細", "dgvコンタクト履歴_CellValidating", ex);
            }
            finally
            {
                Cursor.Current = Cursors.Arrow;
            }
        }

        private void dgv家族構成_CellValidating(object sender, DataGridViewCellValidatingEventArgs e)
        {
            try
            {
                //列が変わった場合は書式チェックを実施
                string value = e.FormattedValue.ToString();

                switch (e.ColumnIndex)
                {
                    case 家族構成Cell.byt生年月日:
                        if (value != string.Empty)
                        {
                            if (!C11ValidateOnForm.IsValidateCell日時型(dgv家族構成, e.RowIndex, e.ColumnIndex, value))
                                break;

                            //必須入力で入力完了したものについてはメッセージを消去
                            dgv家族構成.Rows[e.RowIndex].Cells[e.ColumnIndex].ErrorText = string.Empty;
                        }

                        break;

                    case 家族構成Cell.byt氏名:
                    case 家族構成Cell.byt氏名カナ:
                        if (value != string.Empty)
                        {
                            if (!C11ValidateOnForm.IsValidateCell必須入力(dgv家族構成, e.RowIndex, e.ColumnIndex, value))
                                break;

                            //必須入力で入力完了したものについてはメッセージを消去
                            dgv家族構成.Rows[e.RowIndex].Cells[e.ColumnIndex].ErrorText = string.Empty;
                        }

                        break;
                }
            }
            catch (Exception ex)
            {
                C04システム共通.ErrorLog("_405顧客詳細", "dgv家族構成_CellValidating", ex);
            }
            finally
            {
                Cursor.Current = Cursors.Arrow;
            }
        }


        private void dgv補足情報_CellValidating(object sender, DataGridViewCellValidatingEventArgs e)
        {
            try
            {
                string value = e.FormattedValue.ToString();

                switch (e.ColumnIndex)
                {
                    case 補足情報Cell.byt補足内容:
                    case 補足情報Cell.byt備考:
                        if (value != string.Empty)
                        {
                            if (!C11ValidateOnForm.IsValidateCell必須入力(dgv補足情報, e.RowIndex, e.ColumnIndex, value))
                                break;

                            //必須入力で入力完了したものについてはメッセージを消去
                            dgv補足情報.Rows[e.RowIndex].Cells[e.ColumnIndex].ErrorText = string.Empty;
                        }

                        break;
                }
            }
            catch (Exception ex)
            {
                C04システム共通.ErrorLog("_405顧客詳細", "dgv補足情報_CellValidating", ex);
            }
            finally
            {
                Cursor.Current = Cursors.Arrow;
            }
        }

        private void dgvコンタクト履歴_RowValidating(object sender, DataGridViewCellCancelEventArgs e)
        {
            try
            {
                //行が変わった場合は必須入力チェックを実施
                if (e.RowIndex <= dgvコンタクト履歴.RowCount)
                {
					IsValidateDGVコンタクト履歴(dgvコンタクト履歴, e.RowIndex);
                }
            }
            catch (Exception ex)
            {
                C04システム共通.ErrorLog("_405顧客詳細", "dgvコンタクト履歴_RowValidating", ex);
            }
        }

        private void dgv家族構成_RowValidating(object sender, DataGridViewCellCancelEventArgs e)
        {
            try
            {
                //行が変わった場合は必須入力チェックを実施
                if (e.RowIndex <= dgv家族構成.RowCount)
                {
					IsValidateDGV家族構成(dgv家族構成, e.RowIndex);
                }
            }
            catch (Exception ex)
            {
                C04システム共通.ErrorLog("_405顧客詳細", "dgv家族構成_RowValidating", ex);
            }
        }

        private void dgv補足情報_RowValidating(object sender, DataGridViewCellCancelEventArgs e)
        {
            try
            {
                //行が変わった場合は必須入力チェックを実施
                if (e.RowIndex <= dgv補足情報.RowCount)
                {
					IsValidateDGV補足情報(dgv補足情報, e.RowIndex);
                }
            }
            catch (Exception ex)
            {
                C04システム共通.ErrorLog("_405顧客詳細", "dgv補足情報_RowValidating", ex);
            }
        }

        private void dgvコンタクト履歴_DataError(object sender, DataGridViewDataErrorEventArgs e)
        {
            try
            {
                e.Cancel = true;    //データソースとの不整合が発生した場合のエラーを無視する
            }
            catch (Exception ex)
            {
                C04システム共通.ErrorLog("_405顧客詳細", "dgvコンタクト履歴_DataError", ex);
            }
        }

        private void dgv家族構成_DataError(object sender, DataGridViewDataErrorEventArgs e)
        {
            try
            {
                e.Cancel = true;    //データソースとの不整合が発生した場合のエラーを無視する
            }
            catch (Exception ex)
            {
                C04システム共通.ErrorLog("_405顧客詳細", "dgv家族構成_DataError", ex);
            }
        }

        private void dgv補足情報_DataError(object sender, DataGridViewDataErrorEventArgs e)
        {
            try
            {
                e.Cancel = true;    //データソースとの不整合が発生した場合のエラーを無視する
            }
            catch (Exception ex)
            {
                C04システム共通.ErrorLog("_405顧客詳細", "dgv補足情報_DataError", ex);
            }
        }

        private void btnCSVファイル読込_コンタクト履歴_Click(object sender, EventArgs e)
        {
            bool b正常終了 = true;

            try
            {
                OpenFileDialog dlg = new OpenFileDialog();
                dlg.Filter = "CSV " + Properties.Resources.MSG_I_ファイル + "(*.csv)|*.csv";
                if (dlg.ShowDialog(this) == DialogResult.Cancel)
                    return;

                Cursor.Current = Cursors.WaitCursor;

                CSV取込_コンタクト履歴 取込処理 = new CSV取込_コンタクト履歴();
                D13コンタクト.D13コンタクト履歴DataTable dt = new D13コンタクト.D13コンタクト履歴DataTable();

                if (!取込処理.CSV変換(dlg.FileName, dt, 2))
                {
					//string errmsg = 取込処理.LastErrorMessage 
					//    + "\n\n【" + Properties.Resources.MSG_I_詳細 + "】\n" + 取込処理.ErrorDetail;
					string errmsg = 取込処理.LastErrorMessage;
					MessageBox.Show(errmsg, Text, MessageBoxButtons.OK, MessageBoxIcon.Warning);
                    return;
                }

                if (dt.Count > C_最大値.CSV取込件数)
                {
                    string errmsg = string.Format(Properties.Resources.MSG_W_最大取込件数A件を超えています, (long)C_最大値.CSV取込件数);
                    MessageBox.Show(errmsg, this.Text, MessageBoxButtons.OK, MessageBoxIcon.Warning);
                    return;
                }

                d13コンタクト履歴bs.DataSource = null;

				d13コンタクト.D13コンタクト履歴.Clear();
				d13コンタクト.D13コンタクト履歴.Merge(dt);
            }
            catch (Exception ex)
            {
                b正常終了 = false;
                C04システム共通.ErrorLog("_405顧客詳細", "btnCSVファイル読込_Click", ex);
            }
            finally
            {
                d13コンタクト履歴bs.DataSource = d13コンタクト.D13コンタクト履歴;
                Cursor.Current = Cursors.Arrow;
            }

            if (b正常終了 == true)
                MessageBox.Show(Properties.Resources.MSG_I_読込が完了しました, this.Text, MessageBoxButtons.OK, MessageBoxIcon.Information);
            else
                MessageBox.Show(Properties.Resources.MSG_W_ファイルの読込に失敗しました, this.Text, MessageBoxButtons.OK, MessageBoxIcon.Warning);
        }

        private void btnCSVファイル読込_家族構成_Click(object sender, EventArgs e)
        {
            bool b正常終了 = true;

            try
            {
                OpenFileDialog dlg = new OpenFileDialog();
                dlg.Filter = "CSV " + Properties.Resources.MSG_I_ファイル + "(*.csv)|*.csv";
                if (dlg.ShowDialog(this) == DialogResult.Cancel)
                    return;

                Cursor.Current = Cursors.WaitCursor;

                CSV取込_家族構成 取込処理 = new CSV取込_家族構成();
                D10顧客.D10家族構成DataTable dt = new D10顧客.D10家族構成DataTable();

                if (!取込処理.CSV変換(dlg.FileName, dt, 2))
                {
					//string errmsg = 取込処理.LastErrorMessage 
					//    + "\n\n【" + Properties.Resources.MSG_I_詳細 + "】\n" + 取込処理.ErrorDetail;
					string errmsg = 取込処理.LastErrorMessage;
					MessageBox.Show(errmsg, Text, MessageBoxButtons.OK, MessageBoxIcon.Warning);
                    return;
                }

                if (dt.Count > C_最大値.CSV取込件数)
                {
                    string errmsg = string.Format(Properties.Resources.MSG_W_最大取込件数A件を超えています, (long)C_最大値.CSV取込件数);
                    MessageBox.Show(errmsg, this.Text, MessageBoxButtons.OK, MessageBoxIcon.Warning);
                    return;
                }

                d10家族構成bs.DataSource = null;
                d10顧客.D10家族構成.Merge(dt);
            }
            catch (Exception ex)
            {
                b正常終了 = false;
                C04システム共通.ErrorLog("_405顧客詳細", "btnCSVファイル読込_家族構成_Click", ex);
            }
            finally
            {
                d10家族構成bs.DataSource = d10顧客.D10家族構成;
                Cursor.Current = Cursors.Arrow;
            }

            if (b正常終了 == true)
                MessageBox.Show(Properties.Resources.MSG_I_読込が完了しました, this.Text, MessageBoxButtons.OK, MessageBoxIcon.Information);
            else
                MessageBox.Show(Properties.Resources.MSG_W_ファイルの読込に失敗しました, this.Text, MessageBoxButtons.OK, MessageBoxIcon.Warning);
        }

        private void btnCSVファイル読込_補足情報_Click(object sender, EventArgs e)
        {
            bool b正常終了 = true;

            try
            {
                OpenFileDialog dlg = new OpenFileDialog();
                dlg.Filter = "CSV " + Properties.Resources.MSG_I_ファイル + "(*.csv)|*.csv";
                if (dlg.ShowDialog(this) == DialogResult.Cancel)
                    return;

                Cursor.Current = Cursors.WaitCursor;

                CSV取込_補足情報 取込処理 = new CSV取込_補足情報();
                D10顧客.D10顧客補足DataTable dt = new D10顧客.D10顧客補足DataTable();

                if (!取込処理.CSV変換(dlg.FileName, dt, 2))
                {
					//string errmsg = 取込処理.LastErrorMessage 
					//    + "\n\n【" + Properties.Resources.MSG_I_詳細 + "】\n" + 取込処理.ErrorDetail;
					string errmsg = 取込処理.LastErrorMessage;
					MessageBox.Show(errmsg, Text, MessageBoxButtons.OK, MessageBoxIcon.Warning);
                    return;
                }

                if (dt.Count > C_最大値.CSV取込件数)
                {
                    string errmsg = string.Format(Properties.Resources.MSG_W_最大取込件数A件を超えています, (long)C_最大値.CSV取込件数);
                    MessageBox.Show(errmsg, this.Text, MessageBoxButtons.OK, MessageBoxIcon.Warning);
                    return;
                }

                d10顧客補足bs.DataSource = null;
                d10顧客.D10顧客補足.Merge(dt);
            }
            catch (Exception ex)
            {
                b正常終了 = false;
                C04システム共通.ErrorLog("_405顧客詳細", "btnCSVファイル読込_家族構成_Click", ex);
            }
            finally
            {
                d10顧客補足bs.DataSource = d10顧客.D10顧客補足;
                Cursor.Current = Cursors.Arrow;
            }

            if (b正常終了 == true)
                MessageBox.Show(Properties.Resources.MSG_I_読込が完了しました, this.Text, MessageBoxButtons.OK, MessageBoxIcon.Information);
            else
                MessageBox.Show(Properties.Resources.MSG_W_ファイルの読込に失敗しました, this.Text, MessageBoxButtons.OK, MessageBoxIcon.Warning);
        }

        private void btn選択行の削除を全てチェック_コンタクト履歴_Click(object sender, EventArgs e)
        {
            try
            {
                Cursor.Current = Cursors.WaitCursor;

                foreach (DataGridViewRow row in dgvコンタクト履歴.SelectedRows)
                {
                    if (IsValidate未入力行_コンタクト履歴(row))
                        continue;

                    row.Cells[コンタクト履歴Cell.byt新規].Value = false;
                    row.Cells[コンタクト履歴Cell.byt変更].Value = false;
                    row.Cells[コンタクト履歴Cell.byt削除].Value = true;

                }
            }
            catch (Exception ex)
            {
                C04システム共通.ErrorLog("_405顧客詳細", "btn選択行の削除を全てチェック_Click", ex);
            }
            finally
            {
                Cursor.Current = Cursors.Arrow;
            }
        }

        private void btn選択行の削除を全てチェック_家族構成_Click(object sender, EventArgs e)
        {
            try
            {
                Cursor.Current = Cursors.WaitCursor;

                foreach (DataGridViewRow row in dgv家族構成.SelectedRows)
                {
                    if (IsValidate未入力行_家族構成(row))
                        continue;

                    row.Cells[家族構成Cell.byt新規].Value = false;
                    row.Cells[家族構成Cell.byt変更].Value = false;
                    row.Cells[家族構成Cell.byt削除].Value = true;
                }
            }
            catch (Exception ex)
            {
                C04システム共通.ErrorLog("_405顧客詳細", "btn選択行の削除を全てチェック_家族構成_Click", ex);
            }
            finally
            {
                Cursor.Current = Cursors.Arrow;
            }
        }

        private void btn選択行の削除を全てチェック_補足情報_Click(object sender, EventArgs e)
        {
            try
            {
                Cursor.Current = Cursors.WaitCursor;

                foreach (DataGridViewRow row in dgv補足情報.SelectedRows)
                {
                    if (IsValidate未入力行_補足情報(row))
                        continue;

                    row.Cells[補足情報Cell.byt新規].Value = false;
                    row.Cells[補足情報Cell.byt変更].Value = false;
                    row.Cells[補足情報Cell.byt削除].Value = true;
                }
            }
            catch (Exception ex)
            {
                C04システム共通.ErrorLog("_405顧客詳細", "btn選択行の削除を全てチェック_補足情報_Click", ex);
            }
            finally
            {
                Cursor.Current = Cursors.Arrow;
            }
        }

        private void btn選択行のチェックを全て外す_コンタクト履歴_Click(object sender, EventArgs e)
        {
            try
            {
                Cursor.Current = Cursors.WaitCursor;

                foreach (DataGridViewRow row in dgvコンタクト履歴.SelectedRows)
                {
                    row.Cells[コンタクト履歴Cell.byt新規].Value = false;
                    row.Cells[コンタクト履歴Cell.byt変更].Value = false;
                    row.Cells[コンタクト履歴Cell.byt削除].Value = false;
                }
            }
            catch (Exception ex)
            {
                C04システム共通.ErrorLog("_405顧客詳細", "btn選択行のチェックを全て外す_Click", ex);
            }
            finally
            {
                Cursor.Current = Cursors.Arrow;
            }
        }

        private void btn選択行のチェックを全て外す_家族構成_Click(object sender, EventArgs e)
        {
            try
            {
                Cursor.Current = Cursors.WaitCursor;

                foreach (DataGridViewRow row in dgv家族構成.SelectedRows)
                {
                    row.Cells[家族構成Cell.byt新規].Value = false;
                    row.Cells[家族構成Cell.byt変更].Value = false;
                    row.Cells[家族構成Cell.byt削除].Value = false;
                }
            }
            catch (Exception ex)
            {
                C04システム共通.ErrorLog("_405顧客詳細", "btn選択行のチェックを全て外す_家族構成_Click", ex);
            }
            finally
            {
                Cursor.Current = Cursors.Arrow;
            }
        }

        private void btn選択行のチェックを全て外す_補足情報_Click(object sender, EventArgs e)
        {
            try
            {
                Cursor.Current = Cursors.WaitCursor;

                foreach (DataGridViewRow row in dgv補足情報.SelectedRows)
                {
                    row.Cells[補足情報Cell.byt新規].Value = false;
                    row.Cells[補足情報Cell.byt変更].Value = false;
                    row.Cells[補足情報Cell.byt削除].Value = false;
                }
            }
            catch (Exception ex)
            {
                C04システム共通.ErrorLog("_405顧客詳細", "btn選択行のチェックを全て外す_補足情報_Click", ex);
            }
            finally
            {
                Cursor.Current = Cursors.Arrow;
            }
        }


        private void btnCSVファイル出力_Click(object sender, EventArgs e)
        {
            try
            {
                //行が選択されていない場合はメッセージを表示
                //if (dgv購買履歴.Rows.Count == 0 && dgvお勧め商品.Rows.Count == 0)
                //{
                //    MessageBox.Show(Properties.Resources.MSG_INF_074, this.Text, MessageBoxButtons.OK,
                //        MessageBoxIcon.Warning);
                //    return;
                //}

                //ファイル参照ダイアログを表示する
                SaveFileDialog sfd = new SaveFileDialog();
                sfd.Filter = "CSV " + Properties.Resources.MSG_I_ファイル + "(*.csv)|*.csv";

                if (sfd.ShowDialog() != DialogResult.OK)
                    return;

				Cursor.Current = Cursors.WaitCursor;

				//グリッドの内容をCSV形式で出力する

                CreateCSVファイル_顧客詳細(sfd.FileName);

                C02業務共通処理.Insert操作履歴(this.Text, Properties.Resources.OPRT_007);

                MessageBox.Show(Properties.Resources.MSG_I_ファイル出力が完了しました, this.Text, MessageBoxButtons.OK,
                    MessageBoxIcon.Information);
            }
            catch (Exception ex)
            {
                C04システム共通.ErrorLog("_405顧客詳細", "btnCSVファイル出力_Click", ex);
            }
			finally
			{
				Cursor.Current = Cursors.Arrow;
			}
		}

        private void btnメール配信_Click(object sender, EventArgs e)
        {
            try
            {
                _205メール配信 _205メール配信 = null;
                _205メール配信 = new _205メール配信();
                C01FormCommon.画面最小サイズに変更(_205メール配信, false);

                D11メール配信.D11宛先DataTable dt = new D11メール配信.D11宛先DataTable();
                D11メール配信.D11宛先Row 宛先Row = dt.NewD11宛先Row();
                宛先Row.顧客ID = txt顧客ID.Text;
                宛先Row.氏名 = txt氏名.Text;
                宛先Row.メールアドレス = txtメールアドレス.Text;
                dt.AddD11宛先Row(宛先Row);
                _205メール配信.mdt宛先 = dt;

                _205メール配信.ShowDialog();
            }
            catch (Exception ex)
            {
                C04システム共通.ErrorLog("_405顧客詳細", "btnメール配信_Click", ex);
            }
        }

        private void btn確定_Click(object sender, EventArgs e)
        {
            try
            {
                Cursor.Current = Cursors.WaitCursor;
                if (false == IsValidate())
                {
                    Cursor.Current = Cursors.Arrow;
                    return;
                }

                if (DialogResult.Yes != MessageBox.Show(Properties.Resources.MSG_Q_入力した内容を登録しますか
                    , this.Text, MessageBoxButtons.YesNo, MessageBoxIcon.Question))
                    return;

                Cursor.Current = Cursors.WaitCursor;

                Update基本情報();

                Insertコンタクト履歴();
                Updateコンタクト履歴();
                Deleteコンタクト履歴();
                Setコンタクト履歴();

                Insert家族構成();
                Update家族構成();
                Delete家族構成();
                Set家族構成();

                Insert補足情報();
                Update補足情報();
                Delete補足情報();
                Set補足情報();

				mbyt確定実行済み = 1;

                MessageBox.Show(Properties.Resources.MSG_I_登録が完了しました, this.Text, MessageBoxButtons.OK,
                    MessageBoxIcon.Information);
            }
            catch (Exception ex)
            {
                C04システム共通.ErrorLog("_405顧客詳細", "btn確定_Click", ex);
            }
            finally
            {
                Cursor.Current = Cursors.Arrow;
            }
        }

        private void btnキャンセル_Click(object sender, EventArgs e)
        {
            try
            {
                this.Close();
            }
            catch (Exception ex)
            {
                C04システム共通.ErrorLog("_405顧客詳細", "btnキャンセル_Click", ex);
            }
        }

        #endregion




    }
}
