﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Shapes;

using System.Globalization;
using Microsoft.Maps.MapControl.WPF;
using Microsoft.Maps.MapControl.WPF.Design;

namespace MAP
{
	/// <summary>
	/// Window2.xaml の相互作用ロジック
	/// </summary>
	public partial class Window2 : Window
	{
		public Window2()
		{
			InitializeComponent();
			myMap.Focus();
		}

		private void addImageToMap(object sender, RoutedEventArgs e)
		{
			MapLayer imageLayer = new MapLayer();


			Image image = new Image();
			image.Height = 150;
			//Define the URI location of the image
			BitmapImage myBitmapImage = new BitmapImage();
			myBitmapImage.BeginInit();
			myBitmapImage.UriSource = new Uri("http://upload.wikimedia.org/wikipedia/commons/d/d4/Golden_Gate_Bridge10.JPG");
			// To save significant application memory, set the DecodePixelWidth or  
			// DecodePixelHeight of the BitmapImage value of the image source to the desired 
			// height or width of the rendered image. If you don't do this, the application will 
			// cache the image as though it were rendered as its normal size rather then just 
			// the size that is displayed.
			// Note: In order to preserve aspect ratio, set DecodePixelWidth
			// or DecodePixelHeight but not both.
			//Define the image display properties
			myBitmapImage.DecodePixelHeight = 150;
			myBitmapImage.EndInit();
			image.Source = myBitmapImage;
			image.Opacity = 0.6;
			image.Stretch = System.Windows.Media.Stretch.None;

			//The map location to place the image at
			Location location = new Location() { Latitude = 37.8197222222222, Longitude = -122.478611111111 };
			//Center the image around the location specified
			PositionOrigin position = PositionOrigin.Center;

			//Add the image to the defined map layer
			imageLayer.AddChild(image, location, position);
			//Add the image layer to the map
			myMap.Children.Add(imageLayer);
		}
	}
}
