﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace 顧客分析君
{
    public partial class _206初期値設定 : Form
    {
        ////////////////////////////////////////////////////////////////////////
        // メンバ変数
        ////////////////////////////////////////////////////////////////////////
        #region メンバ変数

        public int miMode;  // 1：メール配信　2：一括メール配信
        
        #endregion


        ////////////////////////////////////////////////////////////////////////
        // 公開 共通メソッド 
        ////////////////////////////////////////////////////////////////////////
        #region 公開 共通メソッド

        public _206初期値設定()
        {
            InitializeComponent();
        }

        #endregion


        ////////////////////////////////////////////////////////////////////////
        // 非公開 共通メソッド
        ////////////////////////////////////////////////////////////////////////
        #region 非公開 共通メソッド
        #endregion


        ////////////////////////////////////////////////////////////////////////
        // イベントハンドラ
        ////////////////////////////////////////////////////////////////////////
        #region イベントハンドラ

        private void _206初期値設定_Load(object sender, EventArgs e)
        {
            try
            {
                if (miMode == 1)
                {
                    this.Text = "初期値設定（メール作成）";

                    txtTo.Text = Properties.Settings.Default.メール配信_To;
                    txtFrom.Text = Properties.Settings.Default.メール配信_From;
                    txt件名.Text = Properties.Settings.Default.メール配信_件名;
                    txt本文.Text = Properties.Settings.Default.メール配信_本文;
                    txt控えメール送付先.Text = Properties.Settings.Default.メール配信_控えメール送付先;
                    txtチェック項目1.Text = Properties.Settings.Default.メール配信_チェック項目1;
                    txtチェック項目2.Text = Properties.Settings.Default.メール配信_チェック項目2;
                    txtチェック項目3.Text = Properties.Settings.Default.メール配信_チェック項目3;
                    txtチェック項目4.Text = Properties.Settings.Default.メール配信_チェック項目4;
                    txtチェック項目5.Text = Properties.Settings.Default.メール配信_チェック項目5;

                    txtTo.Multiline = false;//64
                    txtTo.ScrollBars = ScrollBars.None;
                    txtTo.Height = 19;//64
                    txtFrom.Top = 43;
                    txtFrom.Height = 19;
                    txt件名.Top = 68;
                    txt件名.Height = 19;
                    txt本文.Top = 93;
                    txt本文.Height = 125;
                    lblTo.Top = 24;
                    lblFrom.Top = 46;
                    lbl件名.Top = 71;
                    lbl本文.Top = 96;

                }
                else if (miMode == 2)
                {
                    this.Text = "初期値設定（一括メール作成）";

                    txtTo.Text = Properties.Settings.Default.一括メール配信_To;
                    txtFrom.Text = Properties.Settings.Default.一括メール配信_From;
                    txt件名.Text = Properties.Settings.Default.一括メール配信_件名;
                    txt本文.Text = Properties.Settings.Default.一括メール配信_本文;
                    txt控えメール送付先.Text = Properties.Settings.Default.一括メール配信_控えメール送付先;
                    txtチェック項目1.Text = Properties.Settings.Default.一括メール配信_チェック項目1;
                    txtチェック項目2.Text = Properties.Settings.Default.一括メール配信_チェック項目2;
                    txtチェック項目3.Text = Properties.Settings.Default.一括メール配信_チェック項目3;
                    txtチェック項目4.Text = Properties.Settings.Default.一括メール配信_チェック項目4;
                    txtチェック項目5.Text = Properties.Settings.Default.一括メール配信_チェック項目5;

                    txtTo.Multiline = true;//
                    txtTo.ScrollBars = ScrollBars.Vertical;
                    txtTo.Height = 64;
                    txtFrom.Top = 88;
                    txtFrom.Height = 19;
                    txt件名.Top = 113;
                    txt件名.Height = 19;
                    txt本文.Top = 139;
                    txt本文.Height = 79;
                    lblTo.Top = 24;
                    lblFrom.Top = 91;
                    lbl件名.Top = 120;
                    lbl本文.Top = 142;
                }
            }
            catch (Exception ex)
            {
                Program.業務共通処理.ErrorLog("_206初期値設定", "_206初期値設定_Load", ex);
            }
        }


        private void btnOK_Click(object sender, EventArgs e)
        {
            try
            {
                if (Program.業務共通処理.メール送信内容チェック(txtTo.Text, txtFrom.Text, txt控えメール送付先.Text) == false)
                    return;

                if (DialogResult.Yes != MessageBox.Show(this, string.Format("初期値設定 を更新します、宜しいですか？", this.Text)
                    , this.Text, MessageBoxButtons.YesNo, MessageBoxIcon.Question))
                    return;

                if (miMode == 1)
                {
                    Properties.Settings.Default.メール配信_To = txtTo.Text;
                    Properties.Settings.Default.メール配信_From = txtFrom.Text;
                    Properties.Settings.Default.メール配信_件名 = txt件名.Text;
                    Properties.Settings.Default.メール配信_本文 = txt本文.Text;
                    Properties.Settings.Default.メール配信_控えメール送付先 = txt控えメール送付先.Text;
                    Properties.Settings.Default.メール配信_チェック項目1 = txtチェック項目1.Text;
                    Properties.Settings.Default.メール配信_チェック項目2 = txtチェック項目2.Text;
                    Properties.Settings.Default.メール配信_チェック項目3 = txtチェック項目3.Text;
                    Properties.Settings.Default.メール配信_チェック項目4 = txtチェック項目4.Text;
                    Properties.Settings.Default.メール配信_チェック項目5 = txtチェック項目5.Text;
                }
                else if (miMode == 2)
                {
                    Properties.Settings.Default.一括メール配信_To = txtTo.Text;
                    Properties.Settings.Default.一括メール配信_From = txtFrom.Text;
                    Properties.Settings.Default.一括メール配信_件名 = txt件名.Text;
                    Properties.Settings.Default.一括メール配信_本文 = txt本文.Text;
                    Properties.Settings.Default.一括メール配信_控えメール送付先 = txt控えメール送付先.Text;
                    Properties.Settings.Default.一括メール配信_チェック項目1 = txtチェック項目1.Text;
                    Properties.Settings.Default.一括メール配信_チェック項目2 = txtチェック項目2.Text;
                    Properties.Settings.Default.一括メール配信_チェック項目3 = txtチェック項目3.Text;
                    Properties.Settings.Default.一括メール配信_チェック項目4 = txtチェック項目4.Text;
                    Properties.Settings.Default.一括メール配信_チェック項目5 = txtチェック項目5.Text;
                }

                Properties.Settings.Default.Save();

                this.Close();
            }
            catch (Exception ex)
            {
                Program.業務共通処理.ErrorLog("_206初期値設定", "btnOK_Click", ex);
            }
        }


        private void btnキャンセル_Click(object sender, EventArgs e)
        {
            try
            {
                this.Close();

            }
            catch (Exception ex)
            {
                Program.業務共通処理.ErrorLog("_206初期値設定", "btnキャンセル_Click", ex);
            }
        }

        #endregion
    }
}
