﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

using SystemCommon;
using ClientCommon;


namespace 顧客分析君
{
    public partial class _503属性マスタ : Form
    {
        ////////////////////////////////////////////////////////////////////////
        // メンバ変数
        ////////////////////////////////////////////////////////////////////////
        #region メンバ変数

		//private enum enm値一覧Cell : int
		//{
		//    新規 = 0,
		//    変更 = 1,
		//    削除 = 2,
		//    属性No = 3,
		//    区分 = 4,
		//    値 = 5
		//}
		private static class 値一覧Cell
		{
            public const byte byt新規 = 0;
            public const byte byt変更 = 1;
            public const byte byt削除 = 2;
            public const byte byt属性No = 3;
            public const byte byt区分 = 4;
			public const byte byt値 = 5;
		}

        #endregion

        ////////////////////////////////////////////////////////////////////////
        // 公開 共通メソッド
        ////////////////////////////////////////////////////////////////////////
        #region 公開 共通メソッド

        public _503属性マスタ()
        {
            InitializeComponent();
        }

        #endregion

        ////////////////////////////////////////////////////////////////////////
        // 非公開 共通メソッド
        ////////////////////////////////////////////////////////////////////////
        #region 非公開 共通メソッド

        private void Set列幅()
        {
            dgv値一覧.Columns[値一覧Cell.byt新規].Visible = false;
            dgv値一覧.Columns[値一覧Cell.byt変更].Visible = false;
            dgv値一覧.Columns[値一覧Cell.byt削除].Width = C_列幅.削除;
            dgv値一覧.Columns[値一覧Cell.byt属性No].Visible = false;
            dgv値一覧.Columns[値一覧Cell.byt区分].Visible = false;
            dgv値一覧.Columns[値一覧Cell.byt値].Width = C_列幅.備考;
        }

        //全項目未入力となっているかを返す
        private bool IsValidate未入力行(DataGridViewRow row)
        {
            if ((row.Cells[値一覧Cell.byt値].FormattedValue.ToString() == string.Empty))
                return true;
            else
                return false;
        }

        private void Set値一覧()
        {
            this.d01属性ta.FillBy検索(this.d01業務共通.D01属性, byte.Parse(cmbマスタ選択.SelectedValue.ToString()));
        }

        //最終行でかつ全項目未入力となっているかを返す
        private bool IsValidateDGV値一覧(int iRow)
        {
            if (iRow < 0)
                return true;

            bool ret = true;

            if (最終行or全項目未入力(iRow))
                return ret;

            for (int iCol = 0; iCol < dgv値一覧.ColumnCount; iCol++)
            {
                string value = dgv値一覧.Rows[iRow].Cells[iCol].FormattedValue.ToString();

                switch (iCol)
                {
                    case 値一覧Cell.byt値:
                        if (!C11ValidateOnForm.IsValidateCell必須入力(dgv値一覧, iRow, iCol, value))
                        {
                            ret = false;
                            break;
                        }

                        break;
                }
            }

            return ret;
        }

        //最終行でかつ全項目未入力となっているかを返す
        private bool 最終行or全項目未入力(int rowIndex)
        {
            if ((dgv値一覧.RowCount - 1) != rowIndex)
                return false;

            if (dgv値一覧.Rows[rowIndex].Cells[値一覧Cell.byt値].FormattedValue.ToString() == string.Empty)
            {
                return true;
            }

            return false;
        }

        //入力値検証
        private bool IsValidate()
        {
            D01業務共通.D01属性Row[] dr = (D01業務共通.D01属性Row[])d01業務共通.D01属性
                .Select(Properties.Resources.DGV列名_新規 + " = true");

            //必須入力欄
            if ((dgv値一覧.RowCount == 1) && (最終行or全項目未入力(0)))
            {
                MessageBox.Show(Properties.Resources.MSG_W_販売履歴が入力されていません, this.Text, MessageBoxButtons.OK
                    , MessageBoxIcon.Warning);

                dgv値一覧.Focus();
                return false;
            }

            //最大値確定件数チェック
            dr = (D01業務共通.D01属性Row[])d01業務共通.D01属性.Select(Properties.Resources.DGV列名_新規 + " = true or " 
                + Properties.Resources.DGV列名_変更 + " = true or " + Properties.Resources.DGV列名_削除 + " = true");

            if (dr.Length > C_最大値.確定件数)
            {
                MessageBox.Show(string.Format(Properties.Resources.MSG_W_編集された行数が_最大数A件_を超えています, C_最大値.CSV取込件数), this.Text
                    , MessageBoxButtons.OK, MessageBoxIcon.Warning);
            }

            if (IsValidate新規変更削除チェック状態() == false)
                return false;

            //未入力
            bool b新規変更削除にチェック有り = false;
            for (int iRow = 0; iRow < dgv値一覧.RowCount; iRow++)
            {
                if (最終行or全項目未入力(iRow) == true)
                    continue;

                if ((Boolean)dgv値一覧.Rows[iRow].Cells[値一覧Cell.byt新規].Value == false &&
                    (Boolean)dgv値一覧.Rows[iRow].Cells[値一覧Cell.byt変更].Value == false &&
                    (Boolean)dgv値一覧.Rows[iRow].Cells[値一覧Cell.byt削除].Value == false)
                    continue;

                b新規変更削除にチェック有り = true;
                break;
            }

            if (b新規変更削除にチェック有り == false)
            {
                MessageBox.Show(Properties.Resources.MSG_W_編集された行がありません, this.Text, MessageBoxButtons.OK,
                    MessageBoxIcon.Warning);
                dgv値一覧.Focus();
                return false;
            }

            //編集されたセルを全てチェックする
            bool isValid = true;
            for (int iRow = 0; iRow < dgv値一覧.RowCount; iRow++)
            {
                if (最終行or全項目未入力(iRow) == true)
                    continue;

                if ((Boolean)dgv値一覧.Rows[iRow].Cells[値一覧Cell.byt新規].Value == false &&
                    (Boolean)dgv値一覧.Rows[iRow].Cells[値一覧Cell.byt変更].Value == false &&
                    (Boolean)dgv値一覧.Rows[iRow].Cells[値一覧Cell.byt削除].Value == false)
                    continue;

                if (!IsValidateDGV値一覧(iRow))
                    isValid = false;

            }

            if (!isValid)
            {
                MessageBox.Show(string.Format(Properties.Resources.MSG_W_Aの入力内容に誤りがある為_登録を完了できません, "値一覧")
                    , this.Text, MessageBoxButtons.OK, MessageBoxIcon.Warning);

                dgv値一覧.Focus();
                return false;
            }

            return true;
        }

        private void Insert値一覧()
        {
            D01業務共通.D01属性Row[] dr = (D01業務共通.D01属性Row[])d01業務共通.D01属性
                .Select(Properties.Resources.DGV列名_新規 + " = true");

            string str値リスト = "";
            for (int iRow = 0; iRow < dr.Length; iRow++)
            {
                d01属性ta.Insert(byte.Parse(cmbマスタ選択.SelectedValue.ToString()), dr[iRow].値, C02業務共通処理.miログインスタッフNo, C02業務共通処理.miログインスタッフNo);
                str値リスト += dr[iRow].値 + ", ";
            }

            if (dr.Length > 0)
                C02業務共通処理.Insert操作履歴(this.Text, Properties.Resources.OPRT_023
                    + "=" + str値リスト.Substring(0, str値リスト.Length - 2));
        }

        private void Update値一覧()
        {
            D01業務共通.D01属性Row[] dr = (D01業務共通.D01属性Row[])d01業務共通.D01属性
                .Select(Properties.Resources.DGV列名_変更 + " = true");

            string str値リスト = "";
            for (int iRow = 0; iRow < dr.Length; iRow++)
            {
                d01属性ta.Update(dr[iRow].値, C02業務共通処理.miログインスタッフNo, dr[iRow].属性No);
                str値リスト += dr[iRow].値 + ", ";
            }

            if (dr.Length > 0)
                C02業務共通処理.Insert操作履歴(this.Text, Properties.Resources.OPRT_023
                    + "=" + str値リスト.Substring(0, str値リスト.Length - 2));
        }


        private void Delete値一覧()
        {
            string str値リスト = "";
            int i削除行数 = 0;
            for (int iRow = 0; iRow < dgv値一覧.RowCount; iRow++)
            {
                if (dgv値一覧.Rows[iRow].Cells[値一覧Cell.byt削除].Value == null)
                    continue;

                if ((Boolean)dgv値一覧.Rows[iRow].Cells[値一覧Cell.byt削除].Value == false)
                    continue;

                if (dgv値一覧.Rows[iRow].Cells[値一覧Cell.byt属性No].Value.ToString() == "")
                    continue;

                d01属性ta.Delete(int.Parse(dgv値一覧.Rows[iRow].Cells[値一覧Cell.byt属性No].Value.ToString()));

                str値リスト += dgv値一覧.Rows[iRow].Cells[値一覧Cell.byt値].Value.ToString() + ", ";

                i削除行数++;
            }

            if (i削除行数 > 0)
                C02業務共通処理.Insert操作履歴(this.Text, Properties.Resources.OPRT_023
                    + "=" + str値リスト.Substring(0, str値リスト.Length - 2));
        }

        //入力値検証
        private bool IsValidate新規変更削除チェック状態()
        {
            for (int iRow = 0; iRow < dgv値一覧.RowCount; iRow++)
            {
                if (最終行or全項目未入力(iRow) == true)
                    continue;

                string strErrMsg = "";
                if (!C11ValidateOnForm.IsValidate新規変更削除チェック状態(dgv値一覧, iRow,
                    値一覧Cell.byt新規, 値一覧Cell.byt変更, 値一覧Cell.byt削除,
                    値一覧Cell.byt属性No, ref strErrMsg))
                {
                    MessageBox.Show(strErrMsg, this.Text, MessageBoxButtons.OK, MessageBoxIcon.Warning);
                    return false;
                }
            }

            return true;
        }

        #endregion

        ////////////////////////////////////////////////////////////////////////
        // イベントハンドラ
        ////////////////////////////////////////////////////////////////////////
        #region イベントハンドラ

        private void _111属性マスタ_Load(object sender, EventArgs e)
        {
            try
            {
                this.d01属性区分ta.Fill(this.d01業務共通.D01属性区分);
                Set値一覧();
            }
            catch (Exception ex)
            {
                C04システム共通.ErrorLog("_111属性マスタ", "_111属性マスタ_Load", ex);
            }
            finally
            {
                Set列幅();
            }
        }

        private void _111属性マスタ_Resize(object sender, EventArgs e)
        {
            try
            {
                C01FormCommon.画面最小サイズに変更(this, false);
            }
            catch (Exception ex)
            {
                C04システム共通.ErrorLog("_111属性マスタ", "_111属性マスタ_Resize", ex);
            }

        }

        private void cmbマスタ選択_SelectedIndexChanged_1(object sender, EventArgs e)
        {
            try
            {
                Set値一覧();
            }
            catch (Exception ex)
            {
                C04システム共通.ErrorLog("_111属性マスタ", "cmbマスタ選択_SelectedIndexChanged", ex);
            }
        }

        private void btn選択行をCSVファイルに出力_Click(object sender, EventArgs e)
        {
            try
            {
                if (dgv値一覧.SelectedRows.Count == 0)
                {
                    MessageBox.Show(Properties.Resources.MSG_W_073, this.Text, MessageBoxButtons.OK,
                        MessageBoxIcon.Warning);
                    return;
                }

                SaveFileDialog sfd = new SaveFileDialog();
                sfd.Filter = "CSV ファイル(*.csv)|*.csv";

                if (sfd.ShowDialog() != DialogResult.OK)
                    return;

                Cursor.Current = Cursors.WaitCursor;

				//C06CSV.CreateCSVファイル(dgv値一覧, sfd.FileName, true, 4, true, "");
				if (C06CSV.CreateCSVファイル(dgv値一覧, sfd.FileName, true, 4, true, "") == false)
					return;

                C02業務共通処理.Insert操作履歴(this.Text, Properties.Resources.OPRT_007);

                MessageBox.Show(Properties.Resources.MSG_I_ファイル出力が完了しました, this.Text, MessageBoxButtons.OK,
                    MessageBoxIcon.Information);
            }
            catch (Exception ex)
            {
                C04システム共通.ErrorLog("_111属性マスタ", "btn選択行をCSVファイルに出力_Click", ex);
            }
            finally
            {
                Cursor.Current = Cursors.Arrow;
            }
        }

        private void dgv値一覧_CellValueChanged(object sender, DataGridViewCellEventArgs e)
        {
            try
            {
                //if (e.RowIndex < 0)
                //    return;

                //if (e.ColumnIndex < 3)
                //    return;

                //if (dgv値一覧.Rows[e.RowIndex].Cells[値一覧Cell.byt属性No].Value == null)
                //    return;

                //if (dgv値一覧.Rows[e.RowIndex].Cells[値一覧Cell.byt属性No].Value.ToString() != "")
                //{
                //    // 「変更」列をチェック状態にする
                //    dgv値一覧.Rows[e.RowIndex].Cells[値一覧Cell.byt新規].Value = false;
                //    dgv値一覧.Rows[e.RowIndex].Cells[値一覧Cell.byt変更].Value = true;
                //    dgv値一覧.Rows[e.RowIndex].Cells[値一覧Cell.byt削除].Value = false;
                //}
                //else
                //{
                //    // 「新規」列をチェック状態にする
                //    dgv値一覧.Rows[e.RowIndex].Cells[値一覧Cell.byt新規].Value = true;
                //    dgv値一覧.Rows[e.RowIndex].Cells[値一覧Cell.byt変更].Value = false;
                //    dgv値一覧.Rows[e.RowIndex].Cells[値一覧Cell.byt削除].Value = false;
                //}

                C11ValidateOnForm.新規変更削除列のチェック状態変更(e, 値一覧Cell.byt属性No,
                    値一覧Cell.byt新規, 値一覧Cell.byt変更, 値一覧Cell.byt削除, ref dgv値一覧);
            }
            catch (Exception ex)
            {
                C04システム共通.ErrorLog("_111属性マスタ", "dgv値一覧_CellValueChanged", ex);
            }
        }

        private void dgv値一覧_CellValidating(object sender, DataGridViewCellValidatingEventArgs e)
        {
            try
            {
                //列が変わった場合は書式チェックを実施
                string value = e.FormattedValue.ToString();

                switch (e.ColumnIndex)
                {
                    case 値一覧Cell.byt値:
                        if (value != string.Empty)
                        {
                            if (!C11ValidateOnForm.IsValidateCell必須入力(dgv値一覧, e.RowIndex, e.ColumnIndex, value))
                                break;

                            //必須入力で入力完了したものについてはメッセージを消去
                            dgv値一覧.Rows[e.RowIndex].Cells[e.ColumnIndex].ErrorText = string.Empty;
                        }

                        break;

                }
            }
            catch (Exception ex)
            {
                C04システム共通.ErrorLog("_111属性マスタ", "dgv値一覧_CellValidating", ex);
            }
        }

        private void dgv値一覧_RowValidating(object sender, DataGridViewCellCancelEventArgs e)
        {
            try
            {
                //行が変わった場合は必須入力チェックを実施
                if (e.RowIndex <= dgv値一覧.RowCount)
                {
                    IsValidateDGV値一覧(e.RowIndex);
                }
            }
            catch (Exception ex)
            {
                C04システム共通.ErrorLog("_111属性マスタ", "dgv値一覧_RowValidating", ex);
            }
        }

        private void dgv値一覧_DataError(object sender, DataGridViewDataErrorEventArgs e)
        {
            try
            {
                e.Cancel = true;
            }
            catch (Exception ex)
            {
                C04システム共通.ErrorLog("_111属性マスタ", "dgv値一覧_DataError", ex);
            }
        }

        private void dgv値一覧_RowPostPaint(object sender, DataGridViewRowPostPaintEventArgs e)
        {
            try
            {
                C01FormCommon.行数表示(e.RowBounds.Location.X,
                                              e.RowBounds.Location.Y,
                                              dgv値一覧.RowHeadersWidth,
                                              e.RowBounds.Height,
                                              e.Graphics,
                                              e.RowIndex,
                                              dgv値一覧.RowHeadersDefaultCellStyle.Font,
                                              dgv値一覧.RowHeadersDefaultCellStyle.ForeColor);
            }
            catch (Exception ex)
            {
                C04システム共通.ErrorLog("_111属性マスタ", "dgv値一覧_RowPostPaint", ex);
            }
        }

        private void btn選択行の削除を全てチェック_Click(object sender, EventArgs e)
        {
            try
            {
                Cursor.Current = Cursors.WaitCursor;

                foreach (DataGridViewRow row in dgv値一覧.SelectedRows)
                {
                    if (IsValidate未入力行(row))
                        continue;

                    row.Cells[値一覧Cell.byt新規].Value = false;
                    row.Cells[値一覧Cell.byt変更].Value = false;
                    row.Cells[値一覧Cell.byt削除].Value = true;
                }
            }
            catch (Exception ex)
            {
                C04システム共通.ErrorLog("_111属性マスタ", "btn選択行の削除を全てチェック_Click", ex);
            }
            finally
            {
                Cursor.Current = Cursors.Arrow;
            }
        }

        private void btn選択行のチェックを全て外す_Click(object sender, EventArgs e)
        {
            try
            {
                Cursor.Current = Cursors.WaitCursor;

                foreach (DataGridViewRow row in dgv値一覧.SelectedRows)
                {
                    row.Cells[値一覧Cell.byt新規].Value = false;
                    row.Cells[値一覧Cell.byt変更].Value = false;
                    row.Cells[値一覧Cell.byt削除].Value = false;
                }
            }
            catch (Exception ex)
            {
                C04システム共通.ErrorLog("_111属性マスタ", "btn選択行のチェックを全て外す_Click", ex);
            }
            finally
            {
                Cursor.Current = Cursors.Arrow;
            }
        }

        private void btn確定_Click(object sender, EventArgs e)
        {
            try
            {
                Cursor.Current = Cursors.WaitCursor;
                if (false == IsValidate())
                {
                    Cursor.Current = Cursors.Arrow;
                    return;
                }

                if (DialogResult.Yes != MessageBox.Show(Properties.Resources.MSG_Q_入力した内容を登録しますか
                    , this.Text, MessageBoxButtons.YesNo, MessageBoxIcon.Question))
                    return;

                Cursor.Current = Cursors.WaitCursor;

                //トランザクション開始(ref transaction);

                Insert値一覧();
                Update値一覧();
                Delete値一覧();

                //トランザクション_コミット(transaction);

                //d01業務共通.D01属性.Clear();
                Set値一覧();

                MessageBox.Show(Properties.Resources.MSG_I_登録が完了しました, this.Text, MessageBoxButtons.OK,
                    MessageBoxIcon.Information);
            }
            catch (Exception ex)
            {
                //トランザクション_ロールバック(transaction);

                C04システム共通.ErrorLog("_111属性マスタ", "btn確定_Click", ex);
            }
            finally
            {
                Cursor.Current = Cursors.Arrow;
            }
        }

        private void btnキャンセル_Click(object sender, EventArgs e)
        {
            try
            {
                this.Close();
            }
            catch (Exception ex)
            {
                C04システム共通.ErrorLog("_111属性マスタ", "btnキャンセル_Click", ex);
            }

        }

        #endregion


    }
}
