﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.Net;
using System.Net.Mail;

namespace 顧客分析君
{
    public partial class _205一括メール作成 : Form
    {
        ////////////////////////////////////////////////////////////////////////
        // メンバ変数
        ////////////////////////////////////////////////////////////////////////
        #region メンバ変数
        #endregion


        ////////////////////////////////////////////////////////////////////////
        // 公開 共通メソッド 
        ////////////////////////////////////////////////////////////////////////
        #region 公開 共通メソッド

        public _205一括メール作成()
        {
            InitializeComponent();
        }

        #endregion


        ////////////////////////////////////////////////////////////////////////
        // 非公開 共通メソッド
        ////////////////////////////////////////////////////////////////////////
        #region 非公開 共通メソッド

        private void 初期化()
        {
            txt作成_to.Text = Properties.Settings.Default.一括メール配信_To;
            txt作成_from.Text = Properties.Settings.Default.一括メール配信_From;
            txt作成_件名.Text = Properties.Settings.Default.一括メール配信_件名;
            txt作成_本文.Text = Properties.Settings.Default.一括メール配信_本文;
            txt作成_控えメール送付先.Text = Properties.Settings.Default.一括メール配信_控えメール送付先;

            txt内容確認_to.Text = "";
            txt内容確認_from.Text = "";
            txt内容確認_件名.Text = "";
            txt内容確認_本文.Text = "";
            txt内容確認_控えメール送付先.Text = "";

            chk項目1.Checked = false;
            chk項目2.Checked = false;
            chk項目3.Checked = false;
            chk項目4.Checked = false;
            chk項目5.Checked = false;
        }

        #endregion


        ////////////////////////////////////////////////////////////////////////
        // イベントハンドラ
        ////////////////////////////////////////////////////////////////////////
        #region イベントハンドラ

        private void _201メール作成_Load(object sender, EventArgs e)
        {
            try
            {
                grp作成.Width = this.Width - 40;
                grp作成.Height = this.Height - 60;
                grp内容確認.Left = grp作成.Left;
                grp内容確認.Top = grp作成.Top;
                grp内容確認.Width = grp作成.Width;
                grp内容確認.Height = grp作成.Height;

                chk項目1.Text = Properties.Settings.Default.一括メール配信_チェック項目1;
                chk項目2.Text = Properties.Settings.Default.一括メール配信_チェック項目2;
                chk項目3.Text = Properties.Settings.Default.一括メール配信_チェック項目3;
                chk項目4.Text = Properties.Settings.Default.一括メール配信_チェック項目4;
                chk項目5.Text = Properties.Settings.Default.一括メール配信_チェック項目5;

                if (chk項目1.Text == "")
                    chk項目1.Enabled = false;
                if (chk項目2.Text == "")
                    chk項目2.Enabled = false;
                if (chk項目3.Text == "")
                    chk項目3.Enabled = false;
                if (chk項目4.Text == "")
                    chk項目4.Enabled = false;
                if (chk項目5.Text == "")
                    chk項目5.Enabled = false;

                初期化();
            }
            catch (Exception ex)
            {
                Program.業務共通処理.ErrorLog("_205一括メール作成", "_201メール作成_Load", ex);
            }
        }

        private void btn送信_Click(object sender, EventArgs e)
        {
            try
            {
                //if (txt作成_to.Text == "")
                //{ 
                //    MessageBox.Show("To が入力されていません", "入力エラー", MessageBoxButtons.OK, MessageBoxIcon.Warning);
                //    return;
                //}
                //if (txt作成_from.Text == "")
                //{
                //    MessageBox.Show("From が入力されていません", "入力エラー", MessageBoxButtons.OK, MessageBoxIcon.Warning);
                //    return;
                //}
                //if (txt作成_件名.Text == "")
                //{
                //    MessageBox.Show("件名 が入力されていません", "入力エラー", MessageBoxButtons.OK, MessageBoxIcon.Warning);
                //    return;
                //}
                //if (txt作成_本文.Text == "")
                //{
                //    MessageBox.Show("本文 が入力されていません", "入力エラー", MessageBoxButtons.OK, MessageBoxIcon.Warning);
                //    return;
                //}
                if (Program.業務共通処理.メール送信内容チェック(txt作成_to.Text, txt作成_from.Text, txt作成_件名.Text, txt作成_本文.Text, txt作成_控えメール送付先.Text) == false)
                    return;

               
                txt内容確認_to.Text = txt作成_to.Text;
                txt内容確認_from.Text = txt作成_from.Text;
                txt内容確認_件名.Text = txt作成_件名.Text;
                //txt内容確認_本文.Text += txt作成_本文.Text;
                txt内容確認_本文.Text = txt作成_本文.Text;
                //txt内容確認_控えメール送付先.Text += txt作成_控えメール送付先.Text;
                txt内容確認_控えメール送付先.Text = txt作成_控えメール送付先.Text;

                grp作成.Visible = false;
                grp内容確認.Visible = true;

            }
            catch (Exception ex)
            {
                Program.業務共通処理.ErrorLog("_205一括メール作成", "btn送信_Click", ex);
            }
        }

        private void btnキャンセル2_Click(object sender, EventArgs e)
        {
            try
            {
                this.Close();
            }
            catch (Exception ex)
            {
                Program.業務共通処理.ErrorLog("_205一括メール作成", "btnキャンセル2_Click", ex);
            }
        }

        private void btn送信確定_Click(object sender, EventArgs e)
        {
            try
            {
                if (Program.業務共通処理.メール送信最終チェック(this, chk項目1, chk項目2, chk項目3, chk項目4, chk項目5) == false)
                    return;

                string strTmp = txt内容確認_to.Text.Replace("\r\n", "\n");
                string[] strTo = strTmp.Split('\n');

                pgs進行状況.Minimum = 1;
                pgs進行状況.Value = 1;
                pgs進行状況.Maximum = strTo.Length;

                for (int iRow = 0; iRow < strTo.Length; iRow++)
                {
                    try
                    {
                        DataRow dr = dt2.Rows[iRow];
                        if (dr[0].ToString() != "")
                            Program.業務共通処理.メール送信(dr[0].ToString(), txt内容確認_from.Text, txt内容確認_件名.Text, txt内容確認_本文.Text);
                    }
                    catch (Exception ex)
                    {
                        MessageBox.Show(strTo[iRow] + " へのメール送信が失敗しました。\r\nこの後の処理は中断されました。\r\n\r\nメールアドレスが間違っているか、SMTPサーバーの設定が間違っているか、不正な文字が含まれている可能性があります。\r\n\r\n\r\n" + ex.Message, "メール送信エラー", MessageBoxButtons.OK, MessageBoxIcon.Warning);
                        grp作成.Visible = true;
                        grp内容確認.Visible = false;

                        return;
                    }

                    pgs進行状況.PerformStep();
                }

                if (Program.業務共通処理.控えメール送信(txt内容確認_控えメール送付先.Text, txt内容確認_to.Text, txt内容確認_from.Text, txt内容確認_件名.Text, txt内容確認_本文.Text) == false)
                {
                    grp作成.Visible = true;
                    grp内容確認.Visible = false;
                }
                
                MessageBox.Show("メールの送信が完了しました。", "メール送信", MessageBoxButtons.OK, MessageBoxIcon.Information);

                初期化();
                grp作成.Visible = true;
                grp内容確認.Visible = false;
            }
            catch (Exception ex)
            {
                Program.業務共通処理.ErrorLog("_205一括メール作成", "btn送信確定_Click", ex);
            }
        }

        private void btnキャンセル_Click(object sender, EventArgs e)
        {
            try
            {
                grp作成.Visible = true;
                grp内容確認.Visible = false;
            }
            catch (Exception ex)
            {
                Program.業務共通処理.ErrorLog("_205一括メール作成", "btnキャンセル_Click", ex);
            }
        }

        private void btnOK_Click(object sender, EventArgs e)
        {
            try
            {
                初期化();

                grp作成.Visible = true;
                grp内容確認.Visible = false;
            }
            catch (Exception ex)
            {
                Program.業務共通処理.ErrorLog("_205一括メール作成", "btnOK_Click", ex);
            }
        }

        private void btn初期値設定_Click(object sender, EventArgs e)
        {
            try
            {
                _103初期値設定 _103初期値設定 = null;
                _103初期値設定 = new _103初期値設定();
                _103初期値設定.miMode = 2;
                _103初期値設定.ShowDialog();

            }
            catch (Exception ex)
            {
                Program.業務共通処理.ErrorLog("_205一括メール作成", "btn初期値設定_Click", ex);
            }
        }


        #endregion


    }
}
