﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

using SystemCommon;
using ClientCommon;


namespace 顧客分析君
{
    public partial class _407FM分析 : Form
    {
        ////////////////////////////////////////////////////////////////////////
        // メンバ変数
        ////////////////////////////////////////////////////////////////////////
        #region メンバ変数

        private Color mclrセル背景色_F = Color.LightGreen;
        private Color mclrセル背景色_M = Color.LightCyan;

        private string mstr顧客総数名 = "顧客総数";
        private string mstrF3M3名 = "F:3 M:3";
        private string mstrF3M2名 = "F:3 M:2";
        private string mstrF3M1名 = "F:3 M:1";
        private string mstrF2M3名 = "F:2 M:3";
        private string mstrF2M2名 = "F:2 M:2";
        private string mstrF2M1名 = "F:2 M:1";
        private string mstrF1M3名 = "F:1 M:3";
        private string mstrF1M2名 = "F:1 M:2";
        private string mstrF1M1名 = "F:1 M:1";

        public string mb呼出し元画面名 = "";
        public byte[] mbF;     // 「3：FM分析」共有
        public byte[] mbM;     // 「3：FM分析」共有
        public short ms年;    // 「3：FM分析」共有
        public byte mb月;      // 「3：FM分析」共有

		//public enum enm分析結果Cell : int
		//{
		//    Fタイトル = 0,
		//    M3値 = 1,
		//    M2値 = 2,
		//    M1値 = 3,
		//}
		private static class 分析結果Cell
		{
            public const byte bytFタイトル = 0;
            public const byte bytM3値 = 1;
            public const byte bytM2値 = 2;
			public const byte bytM1値 = 3;
		}

        #endregion

        ////////////////////////////////////////////////////////////////////////
        // 公開 共通メソッド
        ////////////////////////////////////////////////////////////////////////
        #region 公開 共通メソッド

        public _407FM分析()
        {
            InitializeComponent();
        }

        #endregion

        ////////////////////////////////////////////////////////////////////////
        // 非公開 共通メソッド
        ////////////////////////////////////////////////////////////////////////
        #region 非公開 共通メソッド

        private void Set列幅()
        {
            dgvFM分析表.Columns[分析結果Cell.bytFタイトル].Width = 40;
            dgvFM分析表.Columns[分析結果Cell.bytM3値].Width = 80;
            dgvFM分析表.Columns[分析結果Cell.bytM2値].Width = 80;
            dgvFM分析表.Columns[分析結果Cell.bytM1値].Width = 80;

            dgvFM分析表.Columns[分析結果Cell.bytFタイトル].Width = 40;

            dgvFM分析表.Rows[0].Height = 20;
            dgvFM分析表.Rows[1].Height = 50;
            dgvFM分析表.Rows[2].Height = 50;
            dgvFM分析表.Rows[3].Height = 50;
        }

        private void Set計算条件()
        {
            d05RFM計算条件ta.Fill(d05計算.D05RFM計算条件);

            txtF3.Text = d05計算.D05RFM計算条件[25].値;
            txtF2.Text = d05計算.D05RFM計算条件[26].値;
            txtM3.Text = string.Format("{0:#,0}", long.Parse(d05計算.D05RFM計算条件[27].値.ToString()));
            txtM2.Text = string.Format("{0:#,0}", long.Parse(d05計算.D05RFM計算条件[28].値.ToString()));

            txt計算対象期間From.Text = d05計算.D05RFM計算条件[29].値;
            txt計算対象期間To.Text = d05計算.D05RFM計算条件[30].値;
        }

        private void SetFMランク別顧客数推移_表示年()
        {
            d15表示年ta.Fill(d15FM分析.D15表示年);
            cb表示年.Text = "全年";
        }

        private void SetFMランク別顧客数推移(string str表示年)
        {
            //「表示年」変更前に表示されていたPointsを全て削除
            chtFMランク別顧客数推移.Series[mstr顧客総数名].Points.Clear();
            chtFMランク別顧客数推移.Series[mstrF3M3名].Points.Clear();
            chtFMランク別顧客数推移.Series[mstrF3M2名].Points.Clear();
            chtFMランク別顧客数推移.Series[mstrF3M1名].Points.Clear();
            chtFMランク別顧客数推移.Series[mstrF2M3名].Points.Clear();
            chtFMランク別顧客数推移.Series[mstrF2M2名].Points.Clear();
            chtFMランク別顧客数推移.Series[mstrF2M1名].Points.Clear();
            chtFMランク別顧客数推移.Series[mstrF1M3名].Points.Clear();
            chtFMランク別顧客数推移.Series[mstrF1M2名].Points.Clear();
            chtFMランク別顧客数推移.Series[mstrF1M1名].Points.Clear();

            D15FM分析.D15FMランク別顧客数DataTable dt = new D15FM分析.D15FMランク別顧客数DataTable();
            int i月数 = 0;

            int i表示年 = 0;
            if (str表示年 != "全年")
                i表示年 = int.Parse(cb表示年.Text);

            DateTime dt計算対象期間From;
            if (str表示年 == "全年")
            {
                dt計算対象期間From = (DateTime)d15FMta.Scalar最小表示日時();
                i月数 = (int)d15FMta.Scalar表示対象月数();
            }
            else if ((int)d15FMta.Scalar翌年以降の件数(i表示年) > 0 && (int)d15FMta.Scalar前年以前の件数(i表示年) > 0)
            {
                dt計算対象期間From = (DateTime)d15FMta.Scalar最小表示日時with年(i表示年);
                i月数 = 11; // 最小年、最大年の間であれば、１２カ月固定(プログラムの都合上、12ではなく11)
            }
            else
            {
                dt計算対象期間From = (DateTime)d15FMta.Scalar最小表示日時with年(i表示年);
                i月数 = (int)d15FMta.Scalar表示対象月数with年(i表示年);
            }

			//DateTime dt基準 = dt計算対象期間From;

			//for (int i月 = 0; i月 <= i月数; i月++)
			//{
			//    d15FMランク別顧客数ta.FillBy顧客総数推移(dt, dt基準.Year, dt基準.Month);

			//    //if (cb表示年.Text == "全年")
			//        chtFMランク別顧客数推移.Series[mstr顧客総数名].Points.AddXY(dt基準.Year.ToString() + "/" + dt基準.Month.ToString(), dt[0].顧客数);
			//    //else
			//    //    chtFMランク別顧客数推移.Series[mstr顧客総数名].Points.AddXY(dt基準.Month, dt[0].顧客数);

			//    dt基準 = dt基準.AddMonths(1);
			//}

			////DateTime dt計算対象期間To = (DateTime)d15FMta.Scalar最大表示日時();
			////dt計算対象期間To = DateTime.Parse(dt計算対象期間To.Year + "/" + dt計算対象期間To.Month + "/" + dt計算対象期間To.Day + " 23:59:59");

			//for (byte btF = 1; btF < 4; btF++)
			//{
			//    for (byte btM = 1; btM < 4; btM++)
			//    {
			//        dt基準 = dt計算対象期間From;
			//        for (int i月 = 0; i月 <= i月数; i月++)
			//        {
			//            //d15FMランク別顧客数ta.Fill(dt, DateTime.Parse(dt基準.Year + "/" + dt基準.Month + "/1"), btF, btM);
			//            d15FMランク別顧客数ta.Fill(dt, btF, btM, dt基準.Year, dt基準.Month);

			//            string strX = "";
			//            //if (cb表示年.Text == "全年")
			//                strX = dt基準.Year.ToString() + "/" + dt基準.Month.ToString();
			//            //else
			//            //    strX = dt基準.Month.ToString();

			//            if (btF == 3 && btM == 3)
			//                chtFMランク別顧客数推移.Series[mstrF3M3名].Points.AddXY(strX, dt[0].顧客数);
			//            else if (btF == 3 && btM == 2)
			//                chtFMランク別顧客数推移.Series[mstrF3M2名].Points.AddXY(strX, dt[0].顧客数);
			//            else if (btF == 3 && btM == 1)
			//                chtFMランク別顧客数推移.Series[mstrF3M1名].Points.AddXY(strX, dt[0].顧客数);
			//            else if (btF == 2 && btM == 3)
			//                chtFMランク別顧客数推移.Series[mstrF2M3名].Points.AddXY(strX, dt[0].顧客数);
			//            else if (btF == 2 && btM == 2)
			//                chtFMランク別顧客数推移.Series[mstrF2M2名].Points.AddXY(strX, dt[0].顧客数);
			//            else if (btF == 2 && btM == 1)
			//                chtFMランク別顧客数推移.Series[mstrF2M1名].Points.AddXY(strX, dt[0].顧客数);
			//            else if (btF == 1 && btM == 3)
			//                chtFMランク別顧客数推移.Series[mstrF1M3名].Points.AddXY(strX, dt[0].顧客数);
			//            else if (btF == 1 && btM == 2)
			//                chtFMランク別顧客数推移.Series[mstrF1M2名].Points.AddXY(strX, dt[0].顧客数);
			//            else if (btF == 1 && btM == 1)
			//                chtFMランク別顧客数推移.Series[mstrF1M1名].Points.AddXY(strX, dt[0].顧客数);

			//            dt基準 = dt基準.AddMonths(1);
			//        }
			//    }
			//}

			//chtFMランク別顧客数推移.ChartAreas["ChartArea1"].AxisX.IsMarginVisible = false;

			SetFMランク別顧客数推移_月別(i月数, str表示年, dt計算対象期間From, dt);
        }

		private void SetFMランク別顧客数推移_月別(int i月数, string str表示年, DateTime dt計算対象期間From, D15FM分析.D15FMランク別顧客数DataTable dt)
		{

			DateTime dt基準 = dt計算対象期間From;

			for (int i月 = 0; i月 <= i月数; i月++)
			{
				d15FMランク別顧客数ta.FillBy顧客総数推移(dt, dt基準.Year, dt基準.Month);

				//if (cb表示年.Text == "全年")
				chtFMランク別顧客数推移.Series[mstr顧客総数名].Points.AddXY(dt基準.Year.ToString() + "/" + dt基準.Month.ToString(), dt[0].顧客数);
				//else
				//    chtFMランク別顧客数推移.Series[mstr顧客総数名].Points.AddXY(dt基準.Month, dt[0].顧客数);

				dt基準 = dt基準.AddMonths(1);
			}

			//DateTime dt計算対象期間To = (DateTime)d15FMta.Scalar最大表示日時();
			//dt計算対象期間To = DateTime.Parse(dt計算対象期間To.Year + "/" + dt計算対象期間To.Month + "/" + dt計算対象期間To.Day + " 23:59:59");

			for (byte btF = 1; btF < 4; btF++)
			{
				for (byte btM = 1; btM < 4; btM++)
				{
					dt基準 = dt計算対象期間From;
					for (int i月 = 0; i月 <= i月数; i月++)
					{
						//d15FMランク別顧客数ta.Fill(dt, DateTime.Parse(dt基準.Year + "/" + dt基準.Month + "/1"), btF, btM);
						d15FMランク別顧客数ta.Fill(dt, btF, btM, dt基準.Year, dt基準.Month);

						string strX = "";
						//if (cb表示年.Text == "全年")
						strX = dt基準.Year.ToString() + "/" + dt基準.Month.ToString();
						//else
						//    strX = dt基準.Month.ToString();

						if (btF == 3 && btM == 3)
							chtFMランク別顧客数推移.Series[mstrF3M3名].Points.AddXY(strX, dt[0].顧客数);
						else if (btF == 3 && btM == 2)
							chtFMランク別顧客数推移.Series[mstrF3M2名].Points.AddXY(strX, dt[0].顧客数);
						else if (btF == 3 && btM == 1)
							chtFMランク別顧客数推移.Series[mstrF3M1名].Points.AddXY(strX, dt[0].顧客数);
						else if (btF == 2 && btM == 3)
							chtFMランク別顧客数推移.Series[mstrF2M3名].Points.AddXY(strX, dt[0].顧客数);
						else if (btF == 2 && btM == 2)
							chtFMランク別顧客数推移.Series[mstrF2M2名].Points.AddXY(strX, dt[0].顧客数);
						else if (btF == 2 && btM == 1)
							chtFMランク別顧客数推移.Series[mstrF2M1名].Points.AddXY(strX, dt[0].顧客数);
						else if (btF == 1 && btM == 3)
							chtFMランク別顧客数推移.Series[mstrF1M3名].Points.AddXY(strX, dt[0].顧客数);
						else if (btF == 1 && btM == 2)
							chtFMランク別顧客数推移.Series[mstrF1M2名].Points.AddXY(strX, dt[0].顧客数);
						else if (btF == 1 && btM == 1)
							chtFMランク別顧客数推移.Series[mstrF1M1名].Points.AddXY(strX, dt[0].顧客数);

						dt基準 = dt基準.AddMonths(1);
					}
				}
			}

			chtFMランク別顧客数推移.ChartAreas["ChartArea1"].AxisX.IsMarginVisible = false;

		}
		
		private void SetFMグリッドヘッダー()
        {
            // グリッド数初期化
            dgvFM分析表.ColumnCount = 4;
            dgvFM分析表.RowCount = 4;

            // グリッドのFエリアに、ヘッダーテキストを設定
            dgvFM分析表.Rows[1].Cells[0].Value = "F3";
            dgvFM分析表.Rows[2].Cells[0].Value = "F2";
            dgvFM分析表.Rows[3].Cells[0].Value = "F1";

            // グリッドのFエリアに、背景色を設定
            for (int iRow = 1; iRow < dgvFM分析表.RowCount; iRow++)
            {
                dgvFM分析表.Rows[iRow].Cells[0].Style.BackColor = mclrセル背景色_F;
            }

            // グリッドのMエリアに、ヘッダーテキストを設定
            dgvFM分析表.Rows[0].Cells[1].Value = "M3";
            dgvFM分析表.Rows[0].Cells[2].Value = "M2";
            dgvFM分析表.Rows[0].Cells[3].Value = "M1";

            // グリッドのMエリアに、背景色を設定
            for (int iClm = 1; iClm < dgvFM分析表.RowCount; iClm++)
                dgvFM分析表.Rows[0].Cells[iClm].Style.BackColor = mclrセル背景色_M;

            dgvFM分析表.Rows[0].Cells[0].Style.BackColor = SystemColors.Control;

        }

        private void SetFMランク別顧客数表()
        {
            txt顧客総数.Text = d15FMランク別顧客数ta.Scalar顧客総数().ToString();

            //d15最大年ta.Fill(d15FM分析.D15最大年);
            //int i年 = d15FM分析.D15最大年[0].年;
            int i年 = (int)d15FMta.Scalar最大年();
            txt表示対象年.Text = i年.ToString();

            //d15最大月ta.Fill(d15FM分析.D15最大月, i年);
            //int i月 = d15FM分析.D15最大月[0].月;
            int i月 = (int)d15FMta.Scalar最大月(i年);
            txt表示対象月.Text = i月.ToString();

            int[,] iFM = new int[3, 3];
            D15FM分析.D15FMランク別顧客数DataTable dt = new D15FM分析.D15FMランク別顧客数DataTable();

            // FM毎の顧客数を取得
            for (byte btF = 3; btF > 0; btF--)
            {
                for (byte btM = 3; btM > 0; btM--)
                {
                    d15FMランク別顧客数ta.Fill(dt, btF, btM, i年, i月);
                    iFM[btF - 1, btM - 1] = dt[0].顧客数;
                }
            }

            // グリッドに顧客数を設定
            // FMのインデックスとグリッドのインデックスは反転している。
            int iRow = 1;
            for (int iF = 3; iF > 0; iF--)
            {
                dgvFM分析表.Rows[iRow].Cells[1].Value = iFM[iF - 1, 2];    // M3
                dgvFM分析表.Rows[iRow].Cells[2].Value = iFM[iF - 1, 1];    // M2
                dgvFM分析表.Rows[iRow].Cells[3].Value = iFM[iF - 1, 0];    // M1

                iRow++;
            }

            SetFMランク別顧客数円グラフ(iFM);
        }

        private void SetFMランク別顧客数円グラフ(int[,] iFM)
        {
            if (iFM[2, 2] > 0)
                chtFMランク別顧客数円グラフ.Series["Series1"].Points.AddXY(mstrF3M3名, ((double)iFM[2, 2] / double.Parse(txt顧客総数.Text)));
            if (iFM[2, 1] > 0)
                chtFMランク別顧客数円グラフ.Series["Series1"].Points.AddXY(mstrF3M2名, ((double)iFM[2, 1] / double.Parse(txt顧客総数.Text)));
            if (iFM[2, 0] > 0)
                chtFMランク別顧客数円グラフ.Series["Series1"].Points.AddXY(mstrF3M1名, ((double)iFM[2, 0] / double.Parse(txt顧客総数.Text)));
            if (iFM[1, 2] > 0)
                chtFMランク別顧客数円グラフ.Series["Series1"].Points.AddXY(mstrF2M3名, ((double)iFM[1, 2] / double.Parse(txt顧客総数.Text)));
            if (iFM[1, 1] > 0)
                chtFMランク別顧客数円グラフ.Series["Series1"].Points.AddXY(mstrF2M2名, ((double)iFM[1, 1] / double.Parse(txt顧客総数.Text)));
            if (iFM[1, 0] > 0)
                chtFMランク別顧客数円グラフ.Series["Series1"].Points.AddXY(mstrF2M1名, ((double)iFM[1, 0] / double.Parse(txt顧客総数.Text)));
            if (iFM[0, 2] > 0)
                chtFMランク別顧客数円グラフ.Series["Series1"].Points.AddXY(mstrF1M3名, ((double)iFM[0, 2] / double.Parse(txt顧客総数.Text)));
            if (iFM[0, 1] > 0)
                chtFMランク別顧客数円グラフ.Series["Series1"].Points.AddXY(mstrF1M2名, ((double)iFM[0, 1] / double.Parse(txt顧客総数.Text)));
            if (iFM[0, 0] > 0)
                chtFMランク別顧客数円グラフ.Series["Series1"].Points.AddXY(mstrF1M1名, ((double)iFM[0, 0] / double.Parse(txt顧客総数.Text)));

        }

        private bool IsValidate()
        {
            bool bSts = true;

            for (int iCnt = 0; iCnt < dgvFM分析表.SelectedCells.Count; iCnt++)
            {
                if (dgvFM分析表.SelectedCells[iCnt].ColumnIndex < 1 || dgvFM分析表.SelectedCells[iCnt].RowIndex < 1)
                {
                    bSts = false;
                    break;
                }
            }

            if (bSts == false)
            {
                MessageBox.Show(Properties.Resources.MSG_W_顧客数が表示されているセル以外が選択されています, this.Text, MessageBoxButtons.OK,
                    MessageBoxIcon.Warning);
                return false;
            }

            // 顧客数=0 のセルを選択していたらエラー
            for (int iCnt = 0; iCnt < dgvFM分析表.SelectedCells.Count; iCnt++)
            {
                if ((int)dgvFM分析表.SelectedCells[iCnt].Value < 1)
                {
                    MessageBox.Show(Properties.Resources.MSG_W_顧客数が0のセルを_選択することはできません, this.Text, MessageBoxButtons.OK,
                        MessageBoxIcon.Warning);
                    return false;
                }
            }

            return true;
        }

        #endregion



        ////////////////////////////////////////////////////////////////////////
        // イベントハンドラ
        ////////////////////////////////////////////////////////////////////////
        #region イベントハンドラ


        private void _407FM分析_Load(object sender, EventArgs e)
        {
            bool b正常終了 = true;

            try
            {
                //計算済みチェック
                if (C02業務共通処理.最後に計算した日時() == "")
                {
                    b正常終了 = false;
                    MessageBox.Show(Properties.Resources.MSG_W_計算が完了していない為_分析結果を表示できません, this.Text, MessageBoxButtons.OK, MessageBoxIcon.Warning);
                    this.Close();
                    return;
                }

                Set計算条件();
                SetFMランク別顧客数推移_表示年();
                SetFMランク別顧客数推移(cb表示年.Text);
                SetFMグリッドヘッダー();
                SetFMランク別顧客数表();

                if (mb呼出し元画面名 == C_画面名.PR詳細)
                {
                    btn抽出顧客一覧.Text = "OK";
                }
            }
            catch (Exception ex)
            {
                C04システム共通.ErrorLog("_407FM分析", "_407FM分析_Load", ex);
            }
            finally
            {
                if (b正常終了 == true)
                    Set列幅();

                Cursor.Current = Cursors.Arrow;
            }
        }

        private void chk表示年_SelectedIndexChanged(object sender, EventArgs e)
        {
            try
            {
                SetFMランク別顧客数推移(cb表示年.Text);
            }
            catch (Exception ex)
            {
                C04システム共通.ErrorLog("_407FM分析", "chk表示年_SelectedIndexChanged", ex);
            }
        }

        private void chk顧客総数_CheckedChanged(object sender, EventArgs e)
        {
            try
            {
                if (chk顧客総数.Checked == true)
                    chtFMランク別顧客数推移.Series[mstr顧客総数名].Enabled = true;
                else
                    chtFMランク別顧客数推移.Series[mstr顧客総数名].Enabled = false;

                SetFMランク別顧客数推移(cb表示年.Text);
            }
            catch (Exception ex)
            {
                C04システム共通.ErrorLog("_407FM分析", "chk顧客総数_CheckedChanged", ex);
            }
        }

        private void chkF3M3_CheckedChanged(object sender, EventArgs e)
        {
            try
            {
                if (chkF3M3.Checked == true)
                    chtFMランク別顧客数推移.Series[mstrF3M3名].Enabled = true;
                else
                    chtFMランク別顧客数推移.Series[mstrF3M3名].Enabled = false;

                SetFMランク別顧客数推移(cb表示年.Text);
            }
            catch (Exception ex)
            {
                C04システム共通.ErrorLog("_407FM分析", "chkF3M3_CheckedChanged", ex);
            }
        }

        private void chkF3M2_CheckedChanged(object sender, EventArgs e)
        {
            try
            {
                if (chkF3M2.Checked == true)
                    chtFMランク別顧客数推移.Series[mstrF3M2名].Enabled = true;
                else
                    chtFMランク別顧客数推移.Series[mstrF3M2名].Enabled = false;

                SetFMランク別顧客数推移(cb表示年.Text);
            }
            catch (Exception ex)
            {
                C04システム共通.ErrorLog("_407FM分析", "chkF3M2_CheckedChanged", ex);
            }
        }

        private void chkF3M1_CheckedChanged(object sender, EventArgs e)
        {
            try
            {
                if (chkF3M1.Checked == true)
                    chtFMランク別顧客数推移.Series[mstrF3M1名].Enabled = true;
                else
                    chtFMランク別顧客数推移.Series[mstrF3M1名].Enabled = false;

                SetFMランク別顧客数推移(cb表示年.Text);
            }
            catch (Exception ex)
            {
                C04システム共通.ErrorLog("_407FM分析", "chkF3M1_CheckedChanged", ex);
            }
        }
        
        private void chkF2M3_CheckedChanged(object sender, EventArgs e)
        {
            try
            {
                if (chkF2M3.Checked == true)
                    chtFMランク別顧客数推移.Series[mstrF2M3名].Enabled = true;
                else
                    chtFMランク別顧客数推移.Series[mstrF2M3名].Enabled = false;

                SetFMランク別顧客数推移(cb表示年.Text);
            }
            catch (Exception ex)
            {
                C04システム共通.ErrorLog("_407FM分析", "chkF2M3_CheckedChanged", ex);
            }
        }

        private void chkF2M2_CheckedChanged(object sender, EventArgs e)
        {
            try
            {
                if (chkF2M2.Checked == true)
                    chtFMランク別顧客数推移.Series[mstrF2M2名].Enabled = true;
                else
                    chtFMランク別顧客数推移.Series[mstrF2M2名].Enabled = false;

                SetFMランク別顧客数推移(cb表示年.Text);
            }
            catch (Exception ex)
            {
                C04システム共通.ErrorLog("_407FM分析", "chkF2M2_CheckedChanged", ex);
            }
        }

        private void chkF2M1_CheckedChanged(object sender, EventArgs e)
        {
            try
            {
                if (chkF2M1.Checked == true)
                    chtFMランク別顧客数推移.Series[mstrF2M1名].Enabled = true;
                else
                    chtFMランク別顧客数推移.Series[mstrF2M1名].Enabled = false;

                SetFMランク別顧客数推移(cb表示年.Text);
            }
            catch (Exception ex)
            {
                C04システム共通.ErrorLog("_407FM分析", "chkF2M1_CheckedChanged", ex);
            }
        }

        private void chkF1M3_CheckedChanged(object sender, EventArgs e)
        {
            try
            {
                if (chkF1M3.Checked == true)
                    chtFMランク別顧客数推移.Series[mstrF1M3名].Enabled = true;
                else
                    chtFMランク別顧客数推移.Series[mstrF1M3名].Enabled = false;

                SetFMランク別顧客数推移(cb表示年.Text);
            }
            catch (Exception ex)
            {
                C04システム共通.ErrorLog("_407FM分析", "chkF1M3_CheckedChanged", ex);
            }
        }

        private void chkF1M2_CheckedChanged(object sender, EventArgs e)
        {
            try
            {
                if (chkF1M2.Checked == true)
                    chtFMランク別顧客数推移.Series[mstrF1M2名].Enabled = true;
                else
                    chtFMランク別顧客数推移.Series[mstrF1M2名].Enabled = false;

                SetFMランク別顧客数推移(cb表示年.Text);
            }
            catch (Exception ex)
            {
                C04システム共通.ErrorLog("_407FM分析", "chkF1M2_CheckedChanged", ex);
            }
        }

        private void chkF1M1_CheckedChanged(object sender, EventArgs e)
        {
            try
            {
                if (chkF1M1.Checked == true)
                    chtFMランク別顧客数推移.Series[mstrF1M1名].Enabled = true;
                else
                    chtFMランク別顧客数推移.Series[mstrF1M1名].Enabled = false;

                SetFMランク別顧客数推移(cb表示年.Text);
            }
            catch (Exception ex)
            {
                C04システム共通.ErrorLog("_407FM分析", "chkF1M1_CheckedChanged", ex);
            }
        }

        private void btn抽出顧客一覧_Click(object sender, EventArgs e)
        {
            try
            {
                if (IsValidate() == false)
                    return;

                byte[] bF = new byte[dgvFM分析表.SelectedCells.Count];
                byte[] bM = new byte[dgvFM分析表.SelectedCells.Count];

                for (int iCnt = 0; iCnt < dgvFM分析表.SelectedCells.Count; iCnt++)
                {
                    if (dgvFM分析表.SelectedCells[iCnt].RowIndex == 1) 
                        bF[iCnt] = 3;
                    else if (dgvFM分析表.SelectedCells[iCnt].RowIndex == 2) 
                        bF[iCnt] = 2;
                    else if (dgvFM分析表.SelectedCells[iCnt].RowIndex == 3) 
                        bF[iCnt] = 1;

                    if (dgvFM分析表.SelectedCells[iCnt].ColumnIndex == 1)
                        bM[iCnt] = 3;
                    else if (dgvFM分析表.SelectedCells[iCnt].ColumnIndex == 2)
                        bM[iCnt] = 2;
                    else if (dgvFM分析表.SelectedCells[iCnt].ColumnIndex == 3)
                        bM[iCnt] = 1;
                }

                if (mb呼出し元画面名 == C_画面名.メインメニュー.ToString())
                {
                    _403抽出顧客一覧 _403抽出顧客一覧 = null;
                    _403抽出顧客一覧 = new _403抽出顧客一覧();
                    _403抽出顧客一覧.mbMode = C_抽出顧客Mode.FM分析;
                    _403抽出顧客一覧.mbF = bF;
                    _403抽出顧客一覧.mbM = bM;
                    _403抽出顧客一覧.ms年 = short.Parse(txt表示対象年.Text);
                    _403抽出顧客一覧.mb月 = byte.Parse(txt表示対象月.Text);

                    C01FormCommon.画面最小サイズに変更(_403抽出顧客一覧, true);
                    _403抽出顧客一覧.ShowDialog();
                }
                else if (mb呼出し元画面名 == C_画面名.PR詳細)
                {
                    mbF = bF;
                    mbM = bM;
                    ms年 = short.Parse(txt表示対象年.Text);
                    mb月 = byte.Parse(txt表示対象月.Text);

                    this.DialogResult = DialogResult.OK;
                    this.Close();
                }
            }
            catch (Exception ex)
            {
                C04システム共通.ErrorLog("_407FM分析", "btn抽出顧客一覧_Click", ex);
            }
        }

        private void btnキャンセル_Click(object sender, EventArgs e)
        {
            try
            {
                this.Close();
            }
            catch (Exception ex)
            {
                C04システム共通.ErrorLog("_407FM分析", "btnキャンセル_Click", ex);
            }
        }

        #endregion





    }
}
