﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
//using System.Reflection;

using SystemCommon;
using ClientCommon;


namespace 顧客分析君
{
    public partial class _401RFM分析 : Form
    {
        ////////////////////////////////////////////////////////////////////////
        // メンバ変数
        ////////////////////////////////////////////////////////////////////////
        #region メンバ変数

        private Color mclrセル背景色_R = Color.Gold;
        private Color mclrセル背景色_F = Color.LightGreen;
        private Color mclrセル背景色_M = Color.LightCyan;

		//private enum enmセル比較モード
		//{
		//    縦 = 1,
		//    横 = 2
		//}
		private static class セル比較モード
		{
            public const byte byt縦 = 1;
			public const byte byt横 = 2;
		}

        public string mb呼出し元画面名 ="";
        public byte[] mbR;
        public byte[] mbF;
        public byte[] mbM;

		//public enum enm分析結果Cell : int
		//{
		//    Fタイトル = 0,
		//    R1タイトル = 1,
		//    R1値 = 2,
		//    R2タイトル = 3,
		//    R2値 = 4,
		//    R3タイトル = 5,
		//    R3値 = 6,
		//    R4タイトル = 7,
		//    R4値 = 8,
		//    R5タイトル = 9,
		//    R5値 = 10,
		//}
		private static class 分析結果Cell
		{
            public const byte bytFタイトル = 0;
            public const byte bytR1タイトル = 1;
            public const byte bytR1値 = 2;
            public const byte bytR2タイトル = 3;
            public const byte bytR2値 = 4;
            public const byte bytR3タイトル = 5;
            public const byte bytR3値 = 6;
            public const byte bytR4タイトル = 7;
            public const byte bytR4値 = 8;
            public const byte bytR5タイトル = 9;
			public const byte bytR5値 = 10;
		}

        #endregion


        ////////////////////////////////////////////////////////////////////////
        // 公開 共通メソッド 
        ////////////////////////////////////////////////////////////////////////
        #region 公開 共通メソッド
        
        public _401RFM分析()
        {
            InitializeComponent();
        }

        #endregion


        ////////////////////////////////////////////////////////////////////////
        // 非公開 共通メソッド
        ////////////////////////////////////////////////////////////////////////
        #region 非公開 共通メソッド

        private void Set列幅()
        {
            dgvRFM分析.Columns[分析結果Cell.bytFタイトル].Width = C_列幅.RFMランク;
            dgvRFM分析.Columns[分析結果Cell.bytR1タイトル].Width = C_列幅.RFMランク;
            dgvRFM分析.Columns[分析結果Cell.bytR1値].Width = C_列幅.顧客数;
            dgvRFM分析.Columns[分析結果Cell.bytR2タイトル].Width = C_列幅.RFMランク;
            dgvRFM分析.Columns[分析結果Cell.bytR2値].Width = C_列幅.顧客数;
            dgvRFM分析.Columns[分析結果Cell.bytR3タイトル].Width = C_列幅.RFMランク;
            dgvRFM分析.Columns[分析結果Cell.bytR3値].Width = C_列幅.顧客数;
            dgvRFM分析.Columns[分析結果Cell.bytR4タイトル].Width = C_列幅.RFMランク;
            dgvRFM分析.Columns[分析結果Cell.bytR4値].Width = C_列幅.顧客数;
            dgvRFM分析.Columns[分析結果Cell.bytR5タイトル].Width = C_列幅.RFMランク;
            dgvRFM分析.Columns[分析結果Cell.bytR5値].Width = C_列幅.顧客数;
        }

        //入力値検証
        private bool IsValidate()
        {
            bool bSts = true;

            for (int iCnt = 0; iCnt < dgvRFM分析.SelectedCells.Count; iCnt++)
            {
                if (dgvRFM分析.SelectedCells[iCnt].ColumnIndex < 1 || dgvRFM分析.SelectedCells[iCnt].RowIndex < 1)
                {
                    bSts = false;
                    break;
                }
                else if (dgvRFM分析.SelectedCells[0].Value.ToString().IndexOf("M") != -1)
                {
                    bSts = false;
                    break;
                }
            }
            if (bSts == false)
            {
                MessageBox.Show(Properties.Resources.MSG_W_顧客数が表示されているセル以外が選択されています, this.Text, MessageBoxButtons.OK,
                    MessageBoxIcon.Warning);
                return false;
            }

            // 顧客数=0 のセルを選択していたらエラー
            for (int iCnt = 0; iCnt < dgvRFM分析.SelectedCells.Count; iCnt++)
            {
                if ((int)dgvRFM分析.SelectedCells[iCnt].Value < 1)
                {
                    MessageBox.Show(Properties.Resources.MSG_W_顧客数が0のセルを_選択することはできません, this.Text, MessageBoxButtons.OK,
                        MessageBoxIcon.Warning);
                    return false;
                }
            }

            //if (dgvRFM分析.SelectedCells[0].ColumnIndex < 1 || dgvRFM分析.SelectedCells[0].RowIndex < 1)
            //{
            //    MessageBox.Show(Properties.Resources.MSG_INF_068, this.Text, MessageBoxButtons.OK, 
            //        MessageBoxIcon.Warning);
            //    return false;
            //}

            return true;
        }

        private void SetRFMグリッドヘッダー()
        {
            // グリッド数初期化
            dgvRFM分析.ColumnCount = 11;
            dgvRFM分析.RowCount = 26;

            // グリッドのRエリアに、ヘッダーテキストを設定
            dgvRFM分析.Rows[0].Cells[1].Value = "R5";
            dgvRFM分析.Rows[0].Cells[2].Value = "R5";
            dgvRFM分析.Rows[0].Cells[3].Value = "R4";
            dgvRFM分析.Rows[0].Cells[4].Value = "R4";
            dgvRFM分析.Rows[0].Cells[5].Value = "R3";
            dgvRFM分析.Rows[0].Cells[6].Value = "R3";
            dgvRFM分析.Rows[0].Cells[7].Value = "R2";
            dgvRFM分析.Rows[0].Cells[8].Value = "R2";
            dgvRFM分析.Rows[0].Cells[9].Value = "R1";
            dgvRFM分析.Rows[0].Cells[10].Value = "R1";

            // グリッドのRエリアに、背景色を設定
            for (int iColumn = 1; iColumn < dgvRFM分析.ColumnCount; iColumn++)
            {
                dgvRFM分析.Rows[0].Cells[iColumn].Style.BackColor = mclrセル背景色_R;
            }
            dgvRFM分析.Rows[0].Cells[0].Style.BackColor = SystemColors.Control;

            // グリッドのFエリアに、ヘッダーテキストを設定
            dgvRFM分析.Rows[1].Cells[0].Value = "F5";
            dgvRFM分析.Rows[2].Cells[0].Value = "F5";
            dgvRFM分析.Rows[3].Cells[0].Value = "F5";
            dgvRFM分析.Rows[4].Cells[0].Value = "F5";
            dgvRFM分析.Rows[5].Cells[0].Value = "F5";
            dgvRFM分析.Rows[6].Cells[0].Value = "F4";
            dgvRFM分析.Rows[7].Cells[0].Value = "F4";
            dgvRFM分析.Rows[8].Cells[0].Value = "F4";
            dgvRFM分析.Rows[9].Cells[0].Value = "F4";
            dgvRFM分析.Rows[10].Cells[0].Value = "F4";
            dgvRFM分析.Rows[11].Cells[0].Value = "F3";
            dgvRFM分析.Rows[11].Cells[0].Value = "F3";
            dgvRFM分析.Rows[12].Cells[0].Value = "F3";
            dgvRFM分析.Rows[13].Cells[0].Value = "F3";
            dgvRFM分析.Rows[14].Cells[0].Value = "F3";
            dgvRFM分析.Rows[15].Cells[0].Value = "F3";
            dgvRFM分析.Rows[16].Cells[0].Value = "F2";
            dgvRFM分析.Rows[17].Cells[0].Value = "F2";
            dgvRFM分析.Rows[18].Cells[0].Value = "F2";
            dgvRFM分析.Rows[19].Cells[0].Value = "F2";
            dgvRFM分析.Rows[20].Cells[0].Value = "F2";
            dgvRFM分析.Rows[21].Cells[0].Value = "F1";
            dgvRFM分析.Rows[22].Cells[0].Value = "F1";
            dgvRFM分析.Rows[23].Cells[0].Value = "F1";
            dgvRFM分析.Rows[24].Cells[0].Value = "F1";
            dgvRFM分析.Rows[25].Cells[0].Value = "F1";

            // グリッドのFエリアに、背景色を設定
            for (int iRow = 1; iRow < dgvRFM分析.RowCount; iRow++)
            {
                dgvRFM分析.Rows[iRow].Cells[0].Style.BackColor = mclrセル背景色_F;
            }

            // グリッドのMエリアに、ヘッダーテキストを設定
            for (int iColumn = 1; iColumn < dgvRFM分析.ColumnCount; iColumn++)
            {
                if (iColumn % 2 == 0)
                    continue;

                dgvRFM分析.Rows[1].Cells[iColumn].Value = "M5";
                dgvRFM分析.Rows[2].Cells[iColumn].Value = "M4";
                dgvRFM分析.Rows[3].Cells[iColumn].Value = "M3";
                dgvRFM分析.Rows[4].Cells[iColumn].Value = "M2";
                dgvRFM分析.Rows[5].Cells[iColumn].Value = "M1";
                dgvRFM分析.Rows[6].Cells[iColumn].Value = "M5";
                dgvRFM分析.Rows[7].Cells[iColumn].Value = "M4";
                dgvRFM分析.Rows[8].Cells[iColumn].Value = "M3";
                dgvRFM分析.Rows[9].Cells[iColumn].Value = "M2";
                dgvRFM分析.Rows[10].Cells[iColumn].Value = "M1";
                dgvRFM分析.Rows[11].Cells[iColumn].Value = "M5";
                dgvRFM分析.Rows[12].Cells[iColumn].Value = "M4";
                dgvRFM分析.Rows[13].Cells[iColumn].Value = "M3";
                dgvRFM分析.Rows[14].Cells[iColumn].Value = "M2";
                dgvRFM分析.Rows[15].Cells[iColumn].Value = "M1";
                dgvRFM分析.Rows[16].Cells[iColumn].Value = "M5";
                dgvRFM分析.Rows[17].Cells[iColumn].Value = "M4";
                dgvRFM分析.Rows[18].Cells[iColumn].Value = "M3";
                dgvRFM分析.Rows[19].Cells[iColumn].Value = "M2";
                dgvRFM分析.Rows[20].Cells[iColumn].Value = "M1";
                dgvRFM分析.Rows[21].Cells[iColumn].Value = "M5";
                dgvRFM分析.Rows[22].Cells[iColumn].Value = "M4";
                dgvRFM分析.Rows[23].Cells[iColumn].Value = "M3";
                dgvRFM分析.Rows[24].Cells[iColumn].Value = "M2";
                dgvRFM分析.Rows[25].Cells[iColumn].Value = "M1";

                // グリッドのMエリアに、背景色を設定
                for (int iRow = 1; iRow < dgvRFM分析.RowCount; iRow++)
                    dgvRFM分析.Rows[iRow].Cells[iColumn].Style.BackColor = mclrセル背景色_M;
            }

        }

        private void SetRFMグリッド顧客数()
        {
            D05計算.D05RFM別顧客数DataTable dt = new D05計算.D05RFM別顧客数DataTable();

            int[,,] iRFM = new int[5,5,5]; 

            // RFM毎の顧客数を取得
            for (int iR = 5; iR > 0; iR--)
            {
                for (int iF = 5; iF > 0; iF--)
                {
                    for (int iM = 5; iM > 0; iM--)
                    {
                        d05RFM別顧客数ta.Fill(dt, iR, iF, iM);
                        iRFM[iR - 1, iF - 1, iM - 1] = dt[0].cnt;
                    }
                }
            }

            // グリッドに顧客数を設定
            // RFMのインデックスとグリッドのインデックスは反転している。
            // 「 * 5 - 4」、「 * 2」でデータ表示セルを特定している。
            int iColum = 1;
            int iRow = 1;
            for (int iR = 5; iR > 0; iR--)
            {
                for (int iF = 5; iF > 0; iF--)
                {
                    dgvRFM分析.Rows[iRow * 5 - 4].Cells[iColum * 2].Value = iRFM[iR - 1, iF - 1, 4];    // F5
                    dgvRFM分析.Rows[iRow * 5 - 3].Cells[iColum * 2].Value = iRFM[iR - 1, iF - 1, 3];    // F4
                    dgvRFM分析.Rows[iRow * 5 - 2].Cells[iColum * 2].Value = iRFM[iR - 1, iF - 1, 2];    // F3
                    dgvRFM分析.Rows[iRow * 5 - 1].Cells[iColum * 2].Value = iRFM[iR - 1, iF - 1, 1];    // F2
                    dgvRFM分析.Rows[iRow * 5].Cells[iColum * 2].Value = iRFM[iR - 1, iF - 1, 0];        // F1

                    iRow++;
                }
                iColum++;
                iRow = 1;
            }
        }

        // 指定したセルと1つ上のセルの値を比較
        // iセル比較モード：1=縦 2=横
        private bool セル比較(int iColumn, int iRow, int iセル比較モード)
        {
            DataGridViewCell cell1;
            DataGridViewCell cell2;

            cell1 = dgvRFM分析[iColumn, iRow];
            if (iセル比較モード == セル比較モード.byt縦)
                cell2 = dgvRFM分析[iColumn, iRow - 1];
            else
                cell2 = dgvRFM分析[iColumn - 1, iRow];

            if (cell1.Value == null || cell2.Value == null)
            {
                return false;
            }

            // ここでは文字列としてセルの値を比較
            if (cell1.Value.ToString() == cell2.Value.ToString())
            {
                return true;
            }
            else
            {
                return false;
            }
        }

        #endregion


        ////////////////////////////////////////////////////////////////////////
        // イベントハンドラ
        ////////////////////////////////////////////////////////////////////////
        #region イベントハンドラ
        
        private void _401RFM分析_Load(object sender, EventArgs e)
        {
            bool b正常終了 = true;

            try
            {
                //計算済みチェック
                if (C02業務共通処理.最後に計算した日時() == "")
                {
                    b正常終了 = false;
                    MessageBox.Show(Properties.Resources.MSG_W_計算が完了していない為_分析結果を表示できません, this.Text, MessageBoxButtons.OK
                        , MessageBoxIcon.Warning);
                    this.Close();
                    return;
                }

                Cursor.Current = Cursors.WaitCursor;

                D05計算.D05RFM計算条件DataTable dt = new D05計算.D05RFM計算条件DataTable();

                //検索実行
                d05RFM計算条件ta.Fill(dt);

                //検索条件設定
                txtR5.Text = dt[0].値;
                txtR4.Text = dt[1].値;
                txtR3.Text = dt[2].値;
                txtR2.Text = dt[3].値;
                txtF5.Text = dt[4].値;
                txtF4.Text = dt[5].値;
                txtF3.Text = dt[6].値;
                txtF2.Text = dt[7].値;
                txtM5.Text = string.Format("{0:#,0}", long.Parse(dt[8].値.ToString()));
                txtM4.Text = string.Format("{0:#,0}", long.Parse(dt[9].値.ToString()));
                txtM3.Text = string.Format("{0:#,0}", long.Parse(dt[10].値.ToString()));
                txtM2.Text = string.Format("{0:#,0}", long.Parse(dt[11].値.ToString()));

                // 計算結果を表示
                //dgvRFM分析.AutoSizeColumnsMode = DataGridViewAutoSizeColumnsMode.None;
                SetRFMグリッドヘッダー();
                SetRFMグリッド顧客数();

                if (C02業務共通処理.分析手法を取得() == enm分析手法.バスケット分析.ToString())
                    btn抽出顧客一覧.Visible = false;

                if (mb呼出し元画面名 == C_画面名.PR詳細)
                {
                    btn抽出顧客一覧.Text = "OK";
                }
            }
            catch (Exception ex)
            {
                C04システム共通.ErrorLog("_401RFM分析", "_401RFM分析_Load", ex);
            }
            finally
            {
                //dgvRFM分析.AutoSizeColumnsMode = DataGridViewAutoSizeColumnsMode.AllCells;
                if (b正常終了 == true)
                    Set列幅();

                Cursor.Current = Cursors.Arrow;
            }
        }

        private void _401RFM分析_Resize(object sender, EventArgs e)
        {
            try
            {
                C01FormCommon.画面最小サイズに変更(this, true);
            }
            catch (Exception ex)
            {
                C04システム共通.ErrorLog("_401RFM分析", "_401RFM分析_Resize", ex);
            }

        }

        private void btn顧客リスト_Click(object sender, EventArgs e)
        {
            try
            {
                if (IsValidate() == false)
                    return;

                byte[] bR = new byte[dgvRFM分析.SelectedCells.Count];
                byte[] bF = new byte[dgvRFM分析.SelectedCells.Count];
                byte[] bM = new byte[dgvRFM分析.SelectedCells.Count];

                for (int iCnt = 0; iCnt < dgvRFM分析.SelectedCells.Count; iCnt++)
                {
                    if (dgvRFM分析.SelectedCells[iCnt].ColumnIndex == 2)      
						bR[iCnt] = 5;
                    else if (dgvRFM分析.SelectedCells[iCnt].ColumnIndex == 4) 
						bR[iCnt] = 4;
                    else if (dgvRFM分析.SelectedCells[iCnt].ColumnIndex == 6) 
						bR[iCnt] = 3;
                    else if (dgvRFM分析.SelectedCells[iCnt].ColumnIndex == 8) 
						bR[iCnt] = 2;
                    else if (dgvRFM分析.SelectedCells[iCnt].ColumnIndex == 10) 
						bR[iCnt] = 1;

                    if (1 <= dgvRFM分析.SelectedCells[iCnt].RowIndex && dgvRFM分析.SelectedCells[iCnt].RowIndex <= 5) 
						bF[iCnt] = 5;
                    else if (6 <= dgvRFM分析.SelectedCells[iCnt].RowIndex && dgvRFM分析.SelectedCells[iCnt].RowIndex <= 10) 
						bF[iCnt] = 4;
                    else if (11 <= dgvRFM分析.SelectedCells[iCnt].RowIndex && dgvRFM分析.SelectedCells[iCnt].RowIndex <= 15) 
						bF[iCnt] = 3;
                    else if (16 <= dgvRFM分析.SelectedCells[iCnt].RowIndex && dgvRFM分析.SelectedCells[iCnt].RowIndex <= 20) 
						bF[iCnt] = 2;
                    else if (21 <= dgvRFM分析.SelectedCells[iCnt].RowIndex && dgvRFM分析.SelectedCells[iCnt].RowIndex <= 25) 
						bF[iCnt] = 1;

                    bM[iCnt] = byte.Parse(dgvRFM分析.Rows[dgvRFM分析.SelectedCells[iCnt].RowIndex]
						.Cells[dgvRFM分析.SelectedCells[iCnt].ColumnIndex - 1].Value.ToString().Substring(1));
                }

                if (mb呼出し元画面名 == C_画面名.メインメニュー)
                {
                    _403抽出顧客一覧 _403抽出顧客一覧 = null;
                    _403抽出顧客一覧 = new _403抽出顧客一覧();
					_403抽出顧客一覧.mbMode = C_抽出顧客Mode.RFM分析;
                    _403抽出顧客一覧.mbR = bR;
                    _403抽出顧客一覧.mbF = bF;
                    _403抽出顧客一覧.mbM = bM;

                    C01FormCommon.画面最小サイズに変更(_403抽出顧客一覧, true);
                    _403抽出顧客一覧.ShowDialog();
                }
                else if (mb呼出し元画面名 == C_画面名.PR詳細)
                {
                    mbR = bR;
                    mbF = bF;
                    mbM = bM;

                    this.DialogResult = DialogResult.OK;
                    this.Close();
                }
            }
            catch (Exception ex)
            {
                C04システム共通.ErrorLog("_401RFM分析", "btn顧客リスト_Click", ex);
            }
        }

        private void btnキャンセル_Click(object sender, EventArgs e)
        {
            try
            {
                this.Close();
            }
            catch (Exception ex)
            {
                C04システム共通.ErrorLog("_401RFM分析", "btnキャンセル_Click", ex);
            }
        }

        private void dgvRFM分析_CellPainting(object sender, DataGridViewCellPaintingEventArgs e)
        {
            try
            {

                if (e.RowIndex > 0 && e.ColumnIndex == 0)
                {
                    if (e.RowIndex == 25)
                    {
                        e.AdvancedBorderStyle.Bottom = dgvRFM分析.AdvancedCellBorderStyle.Top;
                        return;
                    }

                    // 1列目の行ヘッダーは、セル結合っぽく見せる。

                    // セルの下側の境界線を「境界線なし」に設定
                    e.AdvancedBorderStyle.Bottom = DataGridViewAdvancedCellBorderStyle.None;

                    if (セル比較(e.ColumnIndex, e.RowIndex, セル比較モード.byt縦))
                    {
                        // セルの上側の境界線を「境界線なし」に設定
                        e.AdvancedBorderStyle.Top = DataGridViewAdvancedCellBorderStyle.None;
                    }
                    else
                    {
                        // セルの上側の境界線を既定の境界線に設定
                        e.AdvancedBorderStyle.Top = dgvRFM分析.AdvancedCellBorderStyle.Top;
                    }
                }
                else if (e.RowIndex == 0 && e.ColumnIndex > 0)
                {
                    if (e.ColumnIndex == 10)
                    {
                        e.AdvancedBorderStyle.Right = dgvRFM分析.AdvancedCellBorderStyle.Left;
                        return;
                    }


                    // 1行目の列ヘッダーは、セル結合っぽく見せる。

                    // セルの下側の境界線を「境界線なし」に設定
                    e.AdvancedBorderStyle.Right = DataGridViewAdvancedCellBorderStyle.None;

                    if (セル比較(e.ColumnIndex, e.RowIndex, セル比較モード.byt横))
                    {
                        // セルの上側の境界線を「境界線なし」に設定
                        e.AdvancedBorderStyle.Left = DataGridViewAdvancedCellBorderStyle.None;
                    }
                    else
                    {
                        // セルの上側の境界線を既定の境界線に設定
                        e.AdvancedBorderStyle.Left = dgvRFM分析.AdvancedCellBorderStyle.Left;
                    }
                }

            }
            catch (Exception ex)
            {
                C04システム共通.ErrorLog("_401RFM分析", "dgvRFM分析_CellPainting", ex);
            }
        }

        private void dgvRFM分析_CellFormatting(object sender, DataGridViewCellFormattingEventArgs e)
        {
            try
            {
                if (e.RowIndex > 0 && e.ColumnIndex == 0)
                {
                    // 1列目の行ヘッダーは、セル結合っぽく見せる。

                    if (セル比較(e.ColumnIndex, e.RowIndex, セル比較モード.byt縦))
                    {
                        e.Value = "";
                        e.FormattingApplied = true; // 以降の書式設定は不要
                    }
                }
                else if (e.RowIndex == 0 && e.ColumnIndex > 0)
                {
                    // 1行目の列ヘッダーは、セル結合っぽく見せる。

                    if (セル比較(e.ColumnIndex, e.RowIndex, セル比較モード.byt横))
                    {
                        e.Value = "";
                        e.FormattingApplied = true; // 以降の書式設定は不要
                    }
                }

            }
            catch (Exception ex)
            {
                C04システム共通.ErrorLog("_401RFM分析", "dgvRFM分析_CellFormatting", ex);
            }
        }

        #endregion


    }
}
