/***************************************************************************
* Tabs 5 9
* The carets in the following lines will match up if tabs are set properly
*   ^	^	^	^	^	^	<== tabs
*   ^   ^   ^   ^   ^   ^   <== spaces
***************************************************************************/

////////////////////////////////////////////////////////////////////////////
//	Author:			Brandon Wong
//	Module:			SCIF
//	Version:		0.00
//	File:			scif.h
//	Creation Date:	3/7/2005 6:13PM
//	Last Modified:	3/7/2005 7:00PM
//
//	Summary:		
//
//	Version:		Note:
//	--------		--------------------------------------------------------
//	1.0				Created to make the commsh3.c a little more flexible
////////////////////////////////////////////////////////////////////////////

#ifndef		__SCIF_H__
#define 	__SCIF_H__ 1

// SCSMR
#define SCIF_SMR_CM			(0x0080)
#define SCIF_SMR_CHR		(0x0040)
#define SCIF_SMR_PE			(0x0020)
#define SCIF_SMR_PM			(0x0010)
#define SCIF_SMR_STOP		(0x0008)
#define SCIF_SMR_MP			(0x0004)
#define SCIF_SMR_CKS1		(0x0002)
#define SCIF_SMR_CKS0		(0x0001)

/*///////////////////////////////////////////////////////////////////////////*/
/* Baud rate generator macros*/
/*///////////////////////////////////////////////////////////////////////////*/

#define MHZ			96000000

#define ckf(bps)	((bps < 40000) ? 32 : 16)	// Biscayne Changed Multiplier from 64 to 8 - synchronous

#define BRR_CALC(bps)	( (unsigned)( pClock / (ckf(bps)*bps ) - 1) )
#define SEMR_CALC(bps)	( (bps < 40000) ? 0 : 0x10 )

#define pClock ((unsigned long)(MHZ/2))	// pclock is half the bus speed

#endif
