/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.tidy;

import java.io.PrintWriter;
import java.util.List;
import java.util.Stack;
import java.util.Vector;
import org.w3c.tidy.AttVal;
import org.w3c.tidy.AttributeTable;
import org.w3c.tidy.Configuration;
import org.w3c.tidy.EncodingUtils;
import org.w3c.tidy.EntityTable;
import org.w3c.tidy.IStack;
import org.w3c.tidy.Node;
import org.w3c.tidy.Report;
import org.w3c.tidy.StreamIn;
import org.w3c.tidy.Style;
import org.w3c.tidy.TidyUtils;

public class Lexer {
    public static final short IGNORE_WHITESPACE = 0;
    public static final short MIXED_CONTENT = 1;
    public static final short PREFORMATTED = 2;
    public static final short IGNORE_MARKUP = 3;
    private static final String VOYAGER_LOOSE = "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd";
    private static final String VOYAGER_STRICT = "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd";
    private static final String VOYAGER_FRAMESET = "http://www.w3.org/TR/xhtml1/DTD/xhtml1-frameset.dtd";
    private static final String VOYAGER_11 = "http://www.w3.org/TR/xhtml11/DTD/xhtml11.dtd";
    private static final String XHTML_NAMESPACE = "http://www.w3.org/1999/xhtml";
    private static final W3CVersionInfo[] W3CVERSION = new W3CVersionInfo[]{new W3CVersionInfo("HTML 4.01", "XHTML 1.0 Strict", "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd", 4), new W3CVersionInfo("HTML 4.01 Transitional", "XHTML 1.0 Transitional", "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd", 8), new W3CVersionInfo("HTML 4.01 Frameset", "XHTML 1.0 Frameset", "http://www.w3.org/TR/xhtml1/DTD/xhtml1-frameset.dtd", 16), new W3CVersionInfo("HTML 4.0", "XHTML 1.0 Strict", "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd", 4), new W3CVersionInfo("HTML 4.0 Transitional", "XHTML 1.0 Transitional", "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd", 8), new W3CVersionInfo("HTML 4.0 Frameset", "XHTML 1.0 Frameset", "http://www.w3.org/TR/xhtml1/DTD/xhtml1-frameset.dtd", 16), new W3CVersionInfo("HTML 3.2", "XHTML 1.0 Transitional", "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd", 2), new W3CVersionInfo("HTML 3.2 Final", "XHTML 1.0 Transitional", "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd", 2), new W3CVersionInfo("HTML 3.2 Draft", "XHTML 1.0 Transitional", "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd", 2), new W3CVersionInfo("HTML 2.0", "XHTML 1.0 Strict", "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd", 1), new W3CVersionInfo("HTML 4.01", "XHTML 1.1", "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd", 1024)};
    private static final short LEX_CONTENT = 0;
    private static final short LEX_GT = 1;
    private static final short LEX_ENDTAG = 2;
    private static final short LEX_STARTTAG = 3;
    private static final short LEX_COMMENT = 4;
    private static final short LEX_DOCTYPE = 5;
    private static final short LEX_PROCINSTR = 6;
    private static final short LEX_CDATA = 8;
    private static final short LEX_SECTION = 9;
    private static final short LEX_ASP = 10;
    private static final short LEX_JSTE = 11;
    private static final short LEX_PHP = 12;
    private static final short LEX_XMLDECL = 13;
    protected StreamIn in;
    protected PrintWriter errout;
    protected short badAccess;
    protected short badLayout;
    protected short badChars;
    protected short badForm;
    protected short warnings;
    protected short errors;
    protected int lines;
    protected int columns;
    protected boolean waswhite;
    protected boolean pushed;
    protected boolean insertspace;
    protected boolean excludeBlocks;
    protected boolean exiled;
    protected boolean isvoyager;
    protected short versions;
    protected int doctype;
    protected boolean badDoctype;
    protected int txtstart;
    protected int txtend;
    protected short state;
    protected Node token;
    protected byte[] lexbuf;
    protected int lexlength;
    protected int lexsize;
    protected Node inode;
    protected int insert;
    protected Stack istack;
    protected int istackbase;
    protected Style styles;
    protected Configuration configuration;
    protected boolean seenEndBody;
    protected boolean seenEndHtml;
    protected Report report;
    protected Node root;
    private List nodeList;
    private static final int CDATA_INTERMEDIATE = 0;
    private static final int CDATA_STARTTAG = 1;
    private static final int CDATA_ENDTAG = 2;

    public Lexer(StreamIn streamIn, Configuration configuration, Report report) {
        this.report = report;
        this.in = streamIn;
        this.lines = 1;
        this.columns = 1;
        this.state = 0;
        this.versions = (short)3551;
        this.doctype = 0;
        this.insert = -1;
        this.istack = new Stack();
        this.configuration = configuration;
        this.nodeList = new Vector();
    }

    public Node newNode() {
        Node node = new Node();
        this.nodeList.add(node);
        return node;
    }

    public Node newNode(short s, byte[] byArray, int n, int n2) {
        Node node = new Node(s, byArray, n, n2);
        this.nodeList.add(node);
        return node;
    }

    public Node newNode(short s, byte[] byArray, int n, int n2, String string) {
        Node node = new Node(s, byArray, n, n2, string, this.configuration.tt);
        this.nodeList.add(node);
        return node;
    }

    public Node cloneNode(Node node) {
        Node node2 = node.cloneNode(false);
        this.nodeList.add(node2);
        AttVal attVal = node2.attributes;
        while (attVal != null) {
            if (attVal.asp != null) {
                this.nodeList.add(attVal.asp);
            }
            if (attVal.php != null) {
                this.nodeList.add(attVal.php);
            }
            attVal = attVal.next;
        }
        return node2;
    }

    public AttVal cloneAttributes(AttVal attVal) {
        AttVal attVal2;
        AttVal attVal3 = attVal2 = (AttVal)attVal.clone();
        while (attVal3 != null) {
            if (attVal3.asp != null) {
                this.nodeList.add(attVal3.asp);
            }
            if (attVal3.php != null) {
                this.nodeList.add(attVal3.php);
            }
            attVal3 = attVal3.next;
        }
        return attVal2;
    }

    protected void updateNodeTextArrays(byte[] byArray, byte[] byArray2) {
        for (int i = 0; i < this.nodeList.size(); ++i) {
            Node node = (Node)this.nodeList.get(i);
            if (node.textarray != byArray) continue;
            node.textarray = byArray2;
        }
    }

    public Node newLineNode() {
        Node node = this.newNode();
        node.textarray = this.lexbuf;
        node.start = this.lexsize;
        this.addCharToLexer(10);
        node.end = this.lexsize;
        return node;
    }

    public boolean endOfInput() {
        return this.in.isEndOfStream();
    }

    public void addByte(int n) {
        if (this.lexsize + 1 >= this.lexlength) {
            while (this.lexsize + 1 >= this.lexlength) {
                if (this.lexlength == 0) {
                    this.lexlength = 8192;
                    continue;
                }
                this.lexlength *= 2;
            }
            byte[] byArray = this.lexbuf;
            this.lexbuf = new byte[this.lexlength];
            if (byArray != null) {
                System.arraycopy(byArray, 0, this.lexbuf, 0, byArray.length);
                this.updateNodeTextArrays(byArray, this.lexbuf);
            }
        }
        this.lexbuf[this.lexsize++] = (byte)n;
        this.lexbuf[this.lexsize] = 0;
    }

    public void changeChar(byte by) {
        if (this.lexsize > 0) {
            this.lexbuf[this.lexsize - 1] = by;
        }
    }

    public void addCharToLexer(int n) {
        if (!(!this.configuration.xmlOut && !this.configuration.xHTML || n >= 32 && n <= 55295 || n == 9 || n == 10 || n == 13 || n >= 57344 && n <= 65533 || n >= 65536 && n <= 0x10FFFF)) {
            return;
        }
        int n2 = 0;
        byte[] byArray = new byte[10];
        int[] nArray = new int[]{0};
        boolean bl = EncodingUtils.encodeCharToUTF8Bytes(n, byArray, null, nArray);
        if (bl) {
            byArray[0] = -17;
            byArray[1] = -65;
            byArray[2] = -67;
            nArray[0] = 3;
        }
        for (n2 = 0; n2 < nArray[0]; ++n2) {
            this.addByte(byArray[n2]);
        }
    }

    public void addStringToLexer(String string) {
        for (int i = 0; i < string.length(); ++i) {
            this.addCharToLexer(string.charAt(i));
        }
    }

    public void parseEntity(short s) {
        int n;
        String string;
        int n2;
        boolean bl = true;
        boolean bl2 = false;
        int n3 = this.lexsize - 1;
        int n4 = this.in.getCurcol() - 1;
        while ((n2 = this.in.readChar()) != -1) {
            if (n2 == 59) {
                bl2 = true;
                break;
            }
            if (bl && n2 == 35) {
                if (!this.configuration.ncr || "BIG5".equals(this.configuration.getInCharEncodingName()) || "SHIFTJIS".equals(this.configuration.getInCharEncodingName())) {
                    this.in.ungetChar(n2);
                    return;
                }
                this.addCharToLexer(n2);
                bl = false;
                continue;
            }
            bl = false;
            if (TidyUtils.isNamechar((char)n2)) {
                this.addCharToLexer(n2);
                continue;
            }
            this.in.ungetChar(n2);
            break;
        }
        if ("&apos".equals(string = TidyUtils.getString(this.lexbuf, n3, this.lexsize - n3)) && !this.configuration.xmlOut && !this.isvoyager && !this.configuration.xHTML) {
            this.report.entityError(this, (short)5, string, 39);
        }
        if ((n = EntityTable.getDefaultEntityTable().entityCode(string)) <= 0 || n >= 256 && n2 != 59) {
            this.lines = this.in.getCurline();
            this.columns = n4;
            if (this.lexsize > n3 + 1) {
                if (n >= 128 && n <= 159) {
                    int n5;
                    int n6 = 0;
                    if ("WIN1252".equals(this.configuration.replacementCharEncoding)) {
                        n6 = EncodingUtils.decodeWin1252(n);
                    } else if ("MACROMAN".equals(this.configuration.replacementCharEncoding)) {
                        n6 = EncodingUtils.decodeMacRoman(n);
                    }
                    int n7 = n5 = n6 != 0 ? 0 : 1;
                    if (n2 != 59) {
                        this.report.entityError(this, (short)2, string, n2);
                    }
                    this.report.encodingError(this, (short)(0x52 | n5), n);
                    if (n6 != 0) {
                        this.lexsize = n3;
                        this.addCharToLexer(n6);
                        bl2 = false;
                    } else {
                        this.lexsize = n3;
                        bl2 = false;
                    }
                } else {
                    this.report.entityError(this, (short)3, string, n);
                }
                if (bl2) {
                    this.addCharToLexer(59);
                }
            } else {
                this.report.entityError(this, (short)4, string, n);
            }
        } else {
            if (n2 != 59) {
                this.lines = this.in.getCurline();
                this.columns = n4;
                this.report.entityError(this, (short)1, string, n2);
            }
            this.lexsize = n3;
            if (n == 160 && TidyUtils.toBoolean(s & 2)) {
                n = 32;
            }
            this.addCharToLexer(n);
            if (n == 38 && !this.configuration.quoteAmpersand) {
                this.addCharToLexer(97);
                this.addCharToLexer(109);
                this.addCharToLexer(112);
                this.addCharToLexer(59);
            }
        }
    }

    public char parseTagName() {
        int n = this.lexbuf[this.txtstart];
        if (!this.configuration.xmlTags && TidyUtils.isUpper((char)n)) {
            n = TidyUtils.toLower((char)n);
            this.lexbuf[this.txtstart] = (byte)n;
        }
        while ((n = this.in.readChar()) != -1 && TidyUtils.isNamechar((char)n)) {
            if (!this.configuration.xmlTags && TidyUtils.isUpper((char)n)) {
                n = TidyUtils.toLower((char)n);
            }
            this.addCharToLexer(n);
        }
        this.txtend = this.lexsize;
        return (char)n;
    }

    public void addStringLiteral(String string) {
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            this.addCharToLexer(string.charAt(i));
        }
    }

    void addStringLiteralLen(String string, int n) {
        int n2 = string.length();
        if (n2 < n) {
            n = n2;
        }
        for (int i = 0; i < n; ++i) {
            this.addCharToLexer(string.charAt(i));
        }
    }

    public short htmlVersion() {
        if (TidyUtils.toBoolean(this.versions & 1)) {
            return 1;
        }
        if (!(this.configuration.xmlOut | this.configuration.xmlTags | this.isvoyager) && TidyUtils.toBoolean(this.versions & 2)) {
            return 2;
        }
        if (TidyUtils.toBoolean(this.versions & 0x400)) {
            return 1024;
        }
        if (TidyUtils.toBoolean(this.versions & 4)) {
            return 4;
        }
        if (TidyUtils.toBoolean(this.versions & 8)) {
            return 8;
        }
        if (TidyUtils.toBoolean(this.versions & 0x10)) {
            return 16;
        }
        return 0;
    }

    public String htmlVersionName() {
        short s = this.apparentVersion();
        for (int i = 0; i < W3CVERSION.length; ++i) {
            if (s != Lexer.W3CVERSION[i].code) continue;
            if (this.isvoyager) {
                return Lexer.W3CVERSION[i].voyagerName;
            }
            return Lexer.W3CVERSION[i].name;
        }
        return null;
    }

    public boolean addGenerator(Node node) {
        Node node2 = node.findHEAD(this.configuration.tt);
        if (node2 != null) {
            String string = "HTML Tidy for Java (vers. " + Report.RELEASE_DATE_STRING + "), see jtidy.sourceforge.net";
            Node node3 = node2.content;
            while (node3 != null) {
                AttVal attVal;
                if (node3.tag == this.configuration.tt.tagMeta && (attVal = node3.getAttrByName("name")) != null && attVal.value != null && "generator".equalsIgnoreCase(attVal.value) && (attVal = node3.getAttrByName("content")) != null && attVal.value != null && attVal.value.length() >= 9 && "HTML Tidy".equalsIgnoreCase(attVal.value.substring(0, 9))) {
                    attVal.value = string;
                    return false;
                }
                node3 = node3.next;
            }
            node3 = this.inferredTag("meta");
            node3.addAttribute("content", string);
            node3.addAttribute("name", "generator");
            node2.insertNodeAtStart(node3);
            return true;
        }
        return false;
    }

    public boolean checkDocTypeKeyWords(Node node) {
        int n = node.end - node.start;
        String string = TidyUtils.getString(this.lexbuf, node.start, n);
        return !TidyUtils.findBadSubString("SYSTEM", string, string.length()) && !TidyUtils.findBadSubString("PUBLIC", string, string.length()) && !TidyUtils.findBadSubString("//DTD", string, string.length()) && !TidyUtils.findBadSubString("//W3C", string, string.length()) && !TidyUtils.findBadSubString("//EN", string, string.length());
    }

    public short findGivenVersion(Node node) {
        String string = TidyUtils.getString(this.lexbuf, node.start, 5);
        if (!"html ".equalsIgnoreCase(string)) {
            return 0;
        }
        if (!this.checkDocTypeKeyWords(node)) {
            this.report.warning(this, node, null, (short)37);
        }
        if ("SYSTEM ".equalsIgnoreCase(string = TidyUtils.getString(this.lexbuf, node.start + 5, 7))) {
            if (!string.substring(0, 6).equals("SYSTEM")) {
                System.arraycopy(TidyUtils.getBytes("SYSTEM"), 0, this.lexbuf, node.start + 5, 6);
            }
            return 0;
        }
        if ("PUBLIC ".equalsIgnoreCase(string)) {
            if (!string.substring(0, 6).equals("PUBLIC")) {
                System.arraycopy(TidyUtils.getBytes("PUBLIC "), 0, this.lexbuf, node.start + 5, 6);
            }
        } else {
            this.badDoctype = true;
        }
        for (int i = node.start; i < node.end; ++i) {
            int n;
            if (this.lexbuf[i] != 34) continue;
            string = TidyUtils.getString(this.lexbuf, i + 1, 12);
            String string2 = TidyUtils.getString(this.lexbuf, i + 1, 13);
            if (string.equals("-//W3C//DTD ")) {
                int n2;
                for (n2 = i + 13; n2 < node.end && this.lexbuf[n2] != 47; ++n2) {
                }
                int n3 = n2 - i - 13;
                String string3 = TidyUtils.getString(this.lexbuf, i + 13, n3);
                for (n2 = 1; n2 < W3CVERSION.length; ++n2) {
                    String string4 = Lexer.W3CVERSION[n2].name;
                    if (n3 != string4.length() || !string4.equals(string3)) continue;
                    return Lexer.W3CVERSION[n2].code;
                }
                break;
            }
            if (!string2.equals("-//IETF//DTD ")) break;
            for (n = i + 14; n < node.end && this.lexbuf[n] != 47; ++n) {
            }
            int n4 = n - i - 14;
            String string5 = TidyUtils.getString(this.lexbuf, i + 14, n4);
            String string6 = Lexer.W3CVERSION[0].name;
            if (n4 != string6.length() || !string6.equals(string5)) break;
            return Lexer.W3CVERSION[0].code;
        }
        return 0;
    }

    public void fixHTMLNameSpace(Node node, String string) {
        Node node2 = node.content;
        while (node2 != null && node2.tag != this.configuration.tt.tagHtml) {
            node2 = node2.next;
        }
        if (node2 != null) {
            AttVal attVal = node2.attributes;
            while (attVal != null && !attVal.attribute.equals("xmlns")) {
                attVal = attVal.next;
            }
            if (attVal != null) {
                if (!attVal.value.equals(string)) {
                    this.report.warning(this, node2, null, (short)33);
                    attVal.value = string;
                }
            } else {
                attVal = new AttVal(node2.attributes, null, 34, "xmlns", string);
                attVal.dict = AttributeTable.getDefaultAttributeTable().findAttribute(attVal);
                node2.attributes = attVal;
            }
        }
    }

    Node newXhtmlDocTypeNode(Node node) {
        Node node2 = node.findHTML(this.configuration.tt);
        if (node2 == null) {
            return null;
        }
        Node node3 = this.newNode();
        node3.setType((short)1);
        node3.next = node2;
        node3.parent = node;
        node3.prev = null;
        if (node2 == node.content) {
            node.content.prev = node3;
            node.content = node3;
            node3.prev = null;
        } else {
            node3.prev = node2.prev;
            node3.prev.next = node3;
        }
        node2.prev = node3;
        return node3;
    }

    public boolean setXHTMLDocType(Node node) {
        int n;
        String string = " ";
        String string2 = "";
        String string3 = XHTML_NAMESPACE;
        String string4 = null;
        int n2 = 0;
        Node node2 = node.findDocType();
        this.fixHTMLNameSpace(node, string3);
        if (this.configuration.docTypeMode == 0) {
            if (node2 != null) {
                Node.discardElement(node2);
            }
            return true;
        }
        if (this.configuration.docTypeMode == 1) {
            if (TidyUtils.toBoolean(this.versions & 4)) {
                string = "-//W3C//DTD XHTML 1.0 Strict//EN";
                string2 = VOYAGER_STRICT;
            } else if (TidyUtils.toBoolean(this.versions & 0x10)) {
                string = "-//W3C//DTD XHTML 1.0 Frameset//EN";
                string2 = VOYAGER_FRAMESET;
            } else if (TidyUtils.toBoolean(this.versions & 0x1A)) {
                string = "-//W3C//DTD XHTML 1.0 Transitional//EN";
                string2 = VOYAGER_LOOSE;
            } else if (TidyUtils.toBoolean(this.versions & 0x400)) {
                string = "-//W3C//DTD XHTML 1.1//EN";
                string2 = VOYAGER_11;
            } else {
                string = null;
                string2 = "";
                if (node2 != null) {
                    Node.discardElement(node2);
                }
            }
        } else if (this.configuration.docTypeMode == 2) {
            string = "-//W3C//DTD XHTML 1.0 Strict//EN";
            string2 = VOYAGER_STRICT;
        } else if (this.configuration.docTypeMode == 3) {
            string = "-//W3C//DTD XHTML 1.0 Transitional//EN";
            string2 = VOYAGER_LOOSE;
        }
        if (this.configuration.docTypeMode == 4 && this.configuration.docTypeStr != null) {
            string = this.configuration.docTypeStr;
            string2 = "";
        }
        if (string == null) {
            return false;
        }
        if (node2 != null) {
            int n3;
            String string5;
            int n4;
            if ((this.configuration.xHTML || this.configuration.xmlOut) && (n4 = (string5 = TidyUtils.getString(this.lexbuf, node2.start, n = node2.end - node2.start + 1)).indexOf(91)) >= 0 && (n3 = string5.substring(n4).indexOf(93)) >= 0) {
                n2 = n3 + 1;
                string4 = string5.substring(n4);
            }
        } else {
            node2 = this.newXhtmlDocTypeNode(node);
            if (node2 == null) {
                return false;
            }
        }
        this.txtstart = this.lexsize;
        this.txtend = this.lexsize;
        this.addStringLiteral("html PUBLIC ");
        if (string.charAt(0) == '\"') {
            this.addStringLiteral(string);
        } else {
            this.addStringLiteral("\"");
            this.addStringLiteral(string);
            this.addStringLiteral("\"");
        }
        if (this.configuration.wraplen != 0 && string2.length() + 6 >= this.configuration.wraplen) {
            this.addStringLiteral("\n\"");
        } else {
            this.addStringLiteral(" \"");
        }
        this.addStringLiteral(string2);
        this.addStringLiteral("\"");
        if (n2 > 0 && string4 != null) {
            this.addCharToLexer(32);
            this.addStringLiteralLen(string4, n2);
        }
        this.txtend = this.lexsize;
        n = this.txtend - this.txtstart;
        node2.textarray = new byte[n];
        System.arraycopy(this.lexbuf, this.txtstart, node2.textarray, 0, n);
        node2.start = 0;
        node2.end = n;
        return false;
    }

    public short apparentVersion() {
        switch (this.doctype) {
            case 0: {
                return this.htmlVersion();
            }
            case 1: {
                if (!TidyUtils.toBoolean(this.versions & 1)) break;
                return 1;
            }
            case 2: {
                if (!TidyUtils.toBoolean(this.versions & 2)) break;
                return 2;
            }
            case 4: {
                if (!TidyUtils.toBoolean(this.versions & 4)) break;
                return 4;
            }
            case 8: {
                if (!TidyUtils.toBoolean(this.versions & 8)) break;
                return 8;
            }
            case 16: {
                if (!TidyUtils.toBoolean(this.versions & 0x10)) break;
                return 16;
            }
            case 1024: {
                if (!TidyUtils.toBoolean(this.versions & 0x400)) break;
                return 1024;
            }
        }
        this.lines = 1;
        this.columns = 1;
        this.report.warning(this, null, null, (short)28);
        return this.htmlVersion();
    }

    public boolean fixDocType(Node node) {
        short s = 4;
        if (this.badDoctype) {
            this.report.warning(this, null, null, (short)35);
        }
        Node node2 = node.findDocType();
        if (this.configuration.docTypeMode == 0) {
            if (node2 != null) {
                Node.discardElement(node2);
            }
            return true;
        }
        if (this.configuration.xmlOut) {
            return true;
        }
        if (this.configuration.docTypeMode == 2) {
            Node.discardElement(node2);
            node2 = null;
            s = 4;
        } else if (this.configuration.docTypeMode == 3) {
            Node.discardElement(node2);
            node2 = null;
            s = 8;
        } else if (this.configuration.docTypeMode == 1) {
            if (node2 != null) {
                if (this.doctype == 0) {
                    return false;
                }
                switch (this.doctype) {
                    case 0: {
                        return false;
                    }
                    case 1: {
                        if (!TidyUtils.toBoolean(this.versions & 1)) break;
                        return true;
                    }
                    case 2: {
                        if (!TidyUtils.toBoolean(this.versions & 2)) break;
                        return true;
                    }
                    case 4: {
                        if (!TidyUtils.toBoolean(this.versions & 4)) break;
                        return true;
                    }
                    case 8: {
                        if (!TidyUtils.toBoolean(this.versions & 8)) break;
                        return true;
                    }
                    case 16: {
                        if (!TidyUtils.toBoolean(this.versions & 0x10)) break;
                        return true;
                    }
                    case 1024: {
                        if (!TidyUtils.toBoolean(this.versions & 0x400)) break;
                        return true;
                    }
                }
            }
            s = this.htmlVersion();
        }
        if (s == 0) {
            return false;
        }
        if (this.configuration.xmlOut || this.configuration.xmlTags || this.isvoyager) {
            if (node2 != null) {
                Node.discardElement(node2);
            }
            this.fixHTMLNameSpace(node, XHTML_NAMESPACE);
        }
        if (node2 == null && (node2 = this.newXhtmlDocTypeNode(node)) == null) {
            return false;
        }
        this.txtstart = this.lexsize;
        this.txtend = this.lexsize;
        this.addStringLiteral("html PUBLIC ");
        if (this.configuration.docTypeMode == 4 && this.configuration.docTypeStr != null && this.configuration.docTypeStr.length() > 0) {
            if (this.configuration.docTypeStr.charAt(0) == '\"') {
                this.addStringLiteral(this.configuration.docTypeStr);
            } else {
                this.addStringLiteral("\"");
                this.addStringLiteral(this.configuration.docTypeStr);
                this.addStringLiteral("\"");
            }
        } else if (s == 1) {
            this.addStringLiteral("\"-//IETF//DTD HTML 2.0//EN\"");
        } else {
            this.addStringLiteral("\"-//W3C//DTD ");
            for (int i = 0; i < W3CVERSION.length; ++i) {
                if (s != Lexer.W3CVERSION[i].code) continue;
                this.addStringLiteral(Lexer.W3CVERSION[i].name);
                break;
            }
            this.addStringLiteral("//EN\"");
        }
        this.txtend = this.lexsize;
        int n = this.txtend - this.txtstart;
        node2.textarray = new byte[n];
        System.arraycopy(this.lexbuf, this.txtstart, node2.textarray, 0, n);
        node2.start = 0;
        node2.end = n;
        return true;
    }

    public boolean fixXmlDecl(Node node) {
        Node node2;
        if (node.content != null && node.content.type == 13) {
            node2 = node.content;
        } else {
            node2 = this.newNode((short)13, this.lexbuf, 0, 0);
            node2.next = node.content;
            if (node.content != null) {
                node.content.prev = node2;
                node2.next = node.content;
            }
            node.content = node2;
        }
        AttVal attVal = node2.getAttrByName("version");
        AttVal attVal2 = node2.getAttrByName("encoding");
        if (attVal2 == null && !"UTF8".equals(this.configuration.getOutCharEncodingName())) {
            if ("ISO8859_1".equals(this.configuration.getOutCharEncodingName())) {
                node2.addAttribute("encoding", "iso-8859-1");
            }
            if ("ISO2022".equals(this.configuration.getOutCharEncodingName())) {
                node2.addAttribute("encoding", "iso-2022");
            }
        }
        if (attVal == null) {
            node2.addAttribute("version", "1.0");
        }
        return true;
    }

    public Node inferredTag(String string) {
        Node node = this.newNode((short)5, this.lexbuf, this.txtstart, this.txtend, string);
        node.implicit = true;
        return node;
    }

    public Node getCDATA(Node node) {
        int n;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        boolean bl = true;
        boolean bl2 = false;
        boolean bl3 = node.getAttrByName("src") != null;
        this.lines = this.in.getCurline();
        this.columns = this.in.getCurcol();
        this.waswhite = false;
        this.txtstart = this.lexsize;
        this.txtend = this.lexsize;
        while ((n = this.in.readChar()) != -1) {
            int n5;
            this.addCharToLexer(n);
            this.txtend = this.lexsize;
            if (n4 == 0) {
                if (n != 60) {
                    if (!bl || TidyUtils.isWhite((char)n)) continue;
                    bl = false;
                    continue;
                }
                n = this.in.readChar();
                if (TidyUtils.isLetter((char)n)) {
                    if (bl3 && bl && node.tag == this.configuration.tt.tagScript) {
                        this.lexsize = this.txtstart;
                        this.in.ungetChar(n);
                        this.in.ungetChar(60);
                        return null;
                    }
                    this.addCharToLexer(n);
                    n2 = this.lexsize - 1;
                    n4 = 1;
                    continue;
                }
                if (n == 47) {
                    this.addCharToLexer(n);
                    n = this.in.readChar();
                    if (!TidyUtils.isLetter((char)n)) {
                        this.in.ungetChar(n);
                        continue;
                    }
                    this.in.ungetChar(n);
                    n2 = this.lexsize;
                    n4 = 2;
                    continue;
                }
                if (n == 92) {
                    this.addCharToLexer(n);
                    n = this.in.readChar();
                    if (n != 47) {
                        this.in.ungetChar(n);
                        continue;
                    }
                    this.addCharToLexer(n);
                    n = this.in.readChar();
                    if (!TidyUtils.isLetter((char)n)) {
                        this.in.ungetChar(n);
                        continue;
                    }
                    this.in.ungetChar(n);
                    n2 = this.lexsize;
                    n4 = 2;
                    continue;
                }
                this.in.ungetChar(n);
                continue;
            }
            if (n4 == 1) {
                if (TidyUtils.isLetter((char)n)) continue;
                bl2 = node.element.equalsIgnoreCase(TidyUtils.getString(this.lexbuf, n2, node.element.length()));
                if (bl2) {
                    ++n3;
                }
                n4 = 0;
                continue;
            }
            if (n4 != 2 || TidyUtils.isLetter((char)n)) continue;
            bl2 = node.element.equalsIgnoreCase(TidyUtils.getString(this.lexbuf, n2, node.element.length()));
            if (bl && !bl2) {
                for (n5 = this.lexsize - 1; n5 >= n2; --n5) {
                    this.in.ungetChar(this.lexbuf[n5]);
                }
                this.in.ungetChar(47);
                this.in.ungetChar(60);
                break;
            }
            if (bl2 && n3-- <= 0) {
                for (n5 = this.lexsize - 1; n5 >= n2; --n5) {
                    this.in.ungetChar(this.lexbuf[n5]);
                }
                this.in.ungetChar(47);
                this.in.ungetChar(60);
                this.lexsize -= this.lexsize - n2 + 2;
                break;
            }
            if (this.lexbuf[n2 - 2] != 92) {
                this.lines = this.in.getCurline();
                this.columns = this.in.getCurcol();
                this.columns -= 3;
                this.report.error(this, null, null, (short)32);
                if (node.isJavaScript()) {
                    for (n5 = this.lexsize; n5 > n2 - 1; --n5) {
                        this.lexbuf[n5] = this.lexbuf[n5 - 1];
                    }
                    this.lexbuf[n2 - 1] = 92;
                    ++this.lexsize;
                }
            }
            n4 = 0;
        }
        if (bl) {
            this.lexsize = this.txtstart = this.txtend;
        } else {
            this.txtend = this.lexsize;
        }
        if (n == -1) {
            this.report.error(this, node, null, (short)6);
        }
        return this.newNode((short)4, this.lexbuf, this.txtstart, this.txtend);
    }

    public void ungetToken() {
        this.pushed = true;
    }

    /*
     * Unable to fully structure code
     */
    public Node getToken(short var1_1) {
        var2_2 = 0;
        var3_3 = 0;
        var4_4 = new boolean[1];
        var5_5 = false;
        var6_6 = null;
        if (this.pushed && (this.token.type != 4 || this.insert == -1 && this.inode == null)) {
            this.pushed = false;
            return this.token;
        }
        if (this.insert != -1 || this.inode != null) {
            return this.insertedToken();
        }
        this.lines = this.in.getCurline();
        this.columns = this.in.getCurcol();
        this.waswhite = false;
        this.txtstart = this.lexsize;
        this.txtend = this.lexsize;
        block15: while ((var2_2 = this.in.readChar()) != -1) {
            if (this.insertspace && var1_1 != 0) {
                this.addCharToLexer(32);
            }
            if (this.insertspace && !TidyUtils.toBoolean(var1_1 & 0)) {
                this.waswhite = true;
                this.insertspace = false;
            }
            if (var2_2 == 13) {
                var2_2 = this.in.readChar();
                if (var2_2 != 10) {
                    this.in.ungetChar(var2_2);
                }
                var2_2 = 10;
            }
            this.addCharToLexer(var2_2);
            switch (this.state) {
                case 0: {
                    if (TidyUtils.isWhite((char)var2_2) && var1_1 == 0 && this.lexsize == this.txtstart + 1) {
                        --this.lexsize;
                        this.waswhite = false;
                        this.lines = this.in.getCurline();
                        this.columns = this.in.getCurcol();
                        continue block15;
                    }
                    if (var2_2 == 60) {
                        this.state = 1;
                        continue block15;
                    }
                    if (TidyUtils.isWhite((char)var2_2)) {
                        if (this.waswhite) {
                            if (var1_1 == 2 || var1_1 == 3) continue block15;
                            --this.lexsize;
                            this.lines = this.in.getCurline();
                            this.columns = this.in.getCurcol();
                            continue block15;
                        }
                        this.waswhite = true;
                        if (var1_1 == 2 || var1_1 == 3 || var2_2 == 32) continue block15;
                        this.changeChar((byte)32);
                        continue block15;
                    }
                    if (var2_2 == 38 && var1_1 != 3) {
                        this.parseEntity(var1_1);
                    }
                    if (var1_1 == 0) {
                        var1_1 = 1;
                    }
                    this.waswhite = false;
                    continue block15;
                }
                case 1: {
                    if (var2_2 == 47) {
                        var2_2 = this.in.readChar();
                        if (var2_2 == -1) {
                            this.in.ungetChar(var2_2);
                            continue block15;
                        }
                        this.addCharToLexer(var2_2);
                        if (TidyUtils.isLetter((char)var2_2)) {
                            this.lexsize -= 3;
                            this.txtend = this.lexsize;
                            this.in.ungetChar(var2_2);
                            this.state = (short)2;
                            this.lexbuf[this.lexsize] = 0;
                            this.columns -= 2;
                            if (this.txtend <= this.txtstart) continue block15;
                            if (var1_1 == 0 && this.lexbuf[this.lexsize - 1] == 32) {
                                --this.lexsize;
                                this.txtend = this.lexsize;
                            }
                            this.token = this.newNode((short)4, this.lexbuf, this.txtstart, this.txtend);
                            return this.token;
                        }
                        this.waswhite = false;
                        this.state = 0;
                        continue block15;
                    }
                    if (var1_1 == 3) {
                        this.waswhite = false;
                        this.state = 0;
                        continue block15;
                    }
                    if (var2_2 != 33) ** GOTO lbl136
                    var2_2 = this.in.readChar();
                    if (var2_2 != 45) ** GOTO lbl98
                    var2_2 = this.in.readChar();
                    if (var2_2 == 45) {
                        this.state = (short)4;
                        this.lexsize -= 2;
                        this.txtend = this.lexsize;
                        if (this.txtend > this.txtstart) {
                            this.token = this.newNode((short)4, this.lexbuf, this.txtstart, this.txtend);
                            return this.token;
                        }
                        this.txtstart = this.lexsize;
                        continue block15;
                    }
                    this.report.warning(this, null, null, (short)29);
                    ** GOTO lbl128
lbl98:
                    // 1 sources

                    if (var2_2 != 100 && var2_2 != 68) ** GOTO lbl119
                    this.state = (short)5;
                    this.lexsize -= 2;
                    this.txtend = this.lexsize;
                    var1_1 = 0;
                    do {
                        if ((var2_2 = this.in.readChar()) != -1 && var2_2 != 62) continue;
                        this.in.ungetChar(var2_2);
                        ** GOTO lbl114
                    } while (!TidyUtils.isWhite((char)var2_2));
                    do {
                        if ((var2_2 = this.in.readChar()) != -1 && var2_2 != 62) continue;
                        this.in.ungetChar(var2_2);
                        ** GOTO lbl114
                    } while (TidyUtils.isWhite((char)var2_2));
                    this.in.ungetChar(var2_2);
lbl114:
                    // 3 sources

                    if (this.txtend > this.txtstart) {
                        this.token = this.newNode((short)4, this.lexbuf, this.txtstart, this.txtend);
                        return this.token;
                    }
                    this.txtstart = this.lexsize;
                    continue block15;
lbl119:
                    // 1 sources

                    if (var2_2 == 91) {
                        this.lexsize -= 2;
                        this.state = (short)9;
                        this.txtend = this.lexsize;
                        if (this.txtend > this.txtstart) {
                            this.token = this.newNode((short)4, this.lexbuf, this.txtstart, this.txtend);
                            return this.token;
                        }
                        this.txtstart = this.lexsize;
                        continue block15;
                    }
lbl128:
                    // 4 sources

                    while ((var2_2 = this.in.readChar()) != 62) {
                        if (var2_2 != -1) continue;
                        this.in.ungetChar(var2_2);
                        break;
                    }
                    this.lexsize -= 2;
                    this.lexbuf[this.lexsize] = 0;
                    this.state = 0;
                    continue block15;
lbl136:
                    // 1 sources

                    if (var2_2 == 63) {
                        this.lexsize -= 2;
                        this.state = (short)6;
                        this.txtend = this.lexsize;
                        if (this.txtend > this.txtstart) {
                            this.token = this.newNode((short)4, this.lexbuf, this.txtstart, this.txtend);
                            return this.token;
                        }
                        this.txtstart = this.lexsize;
                        continue block15;
                    }
                    if (var2_2 == 37) {
                        this.lexsize -= 2;
                        this.state = (short)10;
                        this.txtend = this.lexsize;
                        if (this.txtend > this.txtstart) {
                            this.token = this.newNode((short)4, this.lexbuf, this.txtstart, this.txtend);
                            return this.token;
                        }
                        this.txtstart = this.lexsize;
                        continue block15;
                    }
                    if (var2_2 == 35) {
                        this.lexsize -= 2;
                        this.state = (short)11;
                        this.txtend = this.lexsize;
                        if (this.txtend > this.txtstart) {
                            this.token = this.newNode((short)4, this.lexbuf, this.txtstart, this.txtend);
                            return this.token;
                        }
                        this.txtstart = this.lexsize;
                        continue block15;
                    }
                    if (TidyUtils.isLetter((char)var2_2)) {
                        this.in.ungetChar(var2_2);
                        this.lexsize -= 2;
                        this.txtend = this.lexsize;
                        this.state = (short)3;
                        if (this.txtend <= this.txtstart) continue block15;
                        this.token = this.newNode((short)4, this.lexbuf, this.txtstart, this.txtend);
                        return this.token;
                    }
                    this.state = 0;
                    this.waswhite = false;
                    continue block15;
                }
                case 2: {
                    this.txtstart = this.lexsize - 1;
                    this.columns -= 2;
                    var2_2 = this.parseTagName();
                    this.token = this.newNode((short)6, this.lexbuf, this.txtstart, this.txtend, TidyUtils.getString(this.lexbuf, this.txtstart, this.txtend - this.txtstart));
                    this.lexsize = this.txtstart;
                    this.txtend = this.txtstart;
                    while (TidyUtils.isWhite((char)var2_2)) {
                        var2_2 = this.in.readChar();
                    }
                    if (var2_2 == -1) {
                        this.in.ungetChar(var2_2);
                        this.report.attrError(this, this.token, null, (short)52);
                        continue block15;
                    }
                    if (var2_2 != 62) {
                        this.in.ungetChar(var2_2);
                        var2_2 = 62;
                        this.report.attrError(this, this.token, null, (short)52);
                    }
                    this.state = 0;
                    this.waswhite = false;
                    return this.token;
                }
                case 3: {
                    this.txtstart = this.lexsize - 1;
                    var2_2 = this.parseTagName();
                    var4_4[0] = false;
                    var6_6 = null;
                    this.token = this.newNode(var4_4[0] != false ? 7 : 5, this.lexbuf, this.txtstart, this.txtend, TidyUtils.getString(this.lexbuf, this.txtstart, this.txtend - this.txtstart));
                    if (var2_2 != 62) {
                        if (var2_2 == 47) {
                            this.in.ungetChar(var2_2);
                        }
                        var6_6 = this.parseAttrs(var4_4);
                    }
                    if (var4_4[0]) {
                        this.token.type = (short)7;
                    }
                    this.token.attributes = var6_6;
                    this.lexsize = this.txtstart;
                    this.txtend = this.txtstart;
                    if ((var1_1 != 2 || this.preContent(this.token)) && (this.token.expectsContent() || this.token.tag == this.configuration.tt.tagBr)) {
                        var2_2 = this.in.readChar();
                        if (var2_2 == 13) {
                            var2_2 = this.in.readChar();
                            if (var2_2 != 10) {
                                this.in.ungetChar(var2_2);
                            }
                        } else if (var2_2 != 10 && var2_2 != 12) {
                            this.in.ungetChar(var2_2);
                        }
                        this.waswhite = true;
                    } else {
                        this.waswhite = false;
                    }
                    this.state = 0;
                    if (this.token.tag == null) {
                        this.report.error(this, null, this.token, (short)22);
                    } else if (!this.configuration.xmlTags) {
                        this.constrainVersion(this.token.tag.versions);
                        if (TidyUtils.toBoolean(this.token.tag.versions & 448)) {
                            if (this.configuration.makeClean && this.token.tag != this.configuration.tt.tagNobr && this.token.tag != this.configuration.tt.tagWbr) {
                                this.report.warning(this, null, this.token, (short)21);
                            } else if (!this.configuration.makeClean) {
                                this.report.warning(this, null, this.token, (short)21);
                            }
                        }
                        if (this.token.tag.getChkattrs() != null) {
                            this.token.tag.getChkattrs().check(this, this.token);
                        } else {
                            this.token.checkAttributes(this);
                        }
                        this.token.repairDuplicateAttributes(this);
                    }
                    return this.token;
                }
                case 4: {
                    if (var2_2 != 45) continue block15;
                    var2_2 = this.in.readChar();
                    this.addCharToLexer(var2_2);
                    if (var2_2 != 45) continue block15;
                    do {
                        if ((var2_2 = this.in.readChar()) == 62) {
                            if (var3_3 != 0) {
                                this.report.warning(this, null, null, (short)29);
                            }
                            this.txtend = this.lexsize - 2;
                            this.lexbuf[this.lexsize] = 0;
                            this.state = 0;
                            this.waswhite = false;
                            this.token = this.newNode((short)2, this.lexbuf, this.txtstart, this.txtend);
                            var2_2 = this.in.readChar();
                            if (var2_2 == 13 && (var2_2 = this.in.readChar()) != 10) {
                                this.token.linebreak = true;
                            }
                            if (var2_2 == 10) {
                                this.token.linebreak = true;
                            } else {
                                this.in.ungetChar(var2_2);
                            }
                            return this.token;
                        }
                        if (var3_3 == 0) {
                            this.lines = this.in.getCurline();
                            this.columns = this.in.getCurcol() - 3;
                        }
                        ++var3_3;
                        if (this.configuration.fixComments) {
                            this.lexbuf[this.lexsize - 2] = 61;
                        }
                        this.addCharToLexer(var2_2);
                    } while (var2_2 == 45);
                    this.lexbuf[this.lexsize - 2] = 61;
                    continue block15;
                }
                case 5: {
                    if (TidyUtils.isWhite((char)var2_2)) {
                        if (this.waswhite) {
                            --this.lexsize;
                        }
                        this.waswhite = true;
                    } else {
                        this.waswhite = false;
                    }
                    if (var5_5) {
                        if (var2_2 == 93) {
                            var5_5 = false;
                        }
                    } else if (var2_2 == 91) {
                        var5_5 = true;
                    }
                    if (var5_5 || var2_2 != 62) continue block15;
                    --this.lexsize;
                    this.txtend = this.lexsize;
                    this.lexbuf[this.lexsize] = 0;
                    this.state = 0;
                    this.waswhite = false;
                    this.token = this.newNode((short)1, this.lexbuf, this.txtstart, this.txtend);
                    this.doctype = this.findGivenVersion(this.token);
                    return this.token;
                }
                case 6: {
                    if (this.lexsize - this.txtstart == 3 && TidyUtils.getString(this.lexbuf, this.txtstart, 3).equals("php")) {
                        this.state = (short)12;
                        continue block15;
                    }
                    if (this.lexsize - this.txtstart == 4 && TidyUtils.getString(this.lexbuf, this.txtstart, 3).equals("xml") && TidyUtils.isWhite((char)this.lexbuf[this.txtstart + 3])) {
                        this.state = (short)13;
                        var6_6 = null;
                        continue block15;
                    }
                    if (this.configuration.xmlPIs) {
                        if (var2_2 != 63) continue block15;
                        var2_2 = this.in.readChar();
                        if (var2_2 == -1) {
                            this.report.warning(this, null, null, (short)36);
                            this.in.ungetChar(var2_2);
                            continue block15;
                        }
                        this.addCharToLexer(var2_2);
                    }
                    if (var2_2 != 62) continue block15;
                    --this.lexsize;
                    this.txtend = this.lexsize;
                    this.lexbuf[this.lexsize] = 0;
                    this.state = 0;
                    this.waswhite = false;
                    this.token = this.newNode((short)3, this.lexbuf, this.txtstart, this.txtend);
                    return this.token;
                }
                case 10: {
                    if (var2_2 != 37) continue block15;
                    var2_2 = this.in.readChar();
                    if (var2_2 != 62) {
                        this.in.ungetChar(var2_2);
                        continue block15;
                    }
                    --this.lexsize;
                    this.txtend = this.lexsize;
                    this.lexbuf[this.lexsize] = 0;
                    this.state = 0;
                    this.waswhite = false;
                    this.token = this.newNode((short)10, this.lexbuf, this.txtstart, this.txtend);
                    return this.token;
                }
                case 11: {
                    if (var2_2 != 35) continue block15;
                    var2_2 = this.in.readChar();
                    if (var2_2 != 62) {
                        this.in.ungetChar(var2_2);
                        continue block15;
                    }
                    --this.lexsize;
                    this.txtend = this.lexsize;
                    this.lexbuf[this.lexsize] = 0;
                    this.state = 0;
                    this.waswhite = false;
                    this.token = this.newNode((short)11, this.lexbuf, this.txtstart, this.txtend);
                    return this.token;
                }
                case 12: {
                    if (var2_2 != 63) continue block15;
                    var2_2 = this.in.readChar();
                    if (var2_2 != 62) {
                        this.in.ungetChar(var2_2);
                        continue block15;
                    }
                    --this.lexsize;
                    this.txtend = this.lexsize;
                    this.lexbuf[this.lexsize] = 0;
                    this.state = 0;
                    this.waswhite = false;
                    this.token = this.newNode((short)12, this.lexbuf, this.txtstart, this.txtend);
                    return this.token;
                }
                case 13: {
                    if (TidyUtils.isWhite((char)var2_2) && var2_2 != 63) continue block15;
                    if (var2_2 != 63) {
                        var8_8 = new Node[1];
                        var9_9 = new Node[1];
                        var10_10 = new AttVal();
                        var11_11 = new int[1];
                        var4_4[0] = false;
                        this.in.ungetChar(var2_2);
                        var10_10.attribute = var7_7 = this.parseAttribute(var4_4, var8_8, var9_9);
                        var10_10.value = this.parseValue(var7_7, true, var4_4, var11_11);
                        var10_10.delim = var11_11[0];
                        var10_10.next = var6_6;
                        var6_6 = var10_10;
                    }
                    if ((var2_2 = this.in.readChar()) != 62) {
                        this.in.ungetChar(var2_2);
                        continue block15;
                    }
                    --this.lexsize;
                    this.txtend = this.txtstart;
                    this.lexbuf[this.txtend] = 0;
                    this.state = 0;
                    this.waswhite = false;
                    this.token = this.newNode((short)13, this.lexbuf, this.txtstart, this.txtend);
                    this.token.attributes = var6_6;
                    return this.token;
                }
                case 9: {
                    if (var2_2 == 91 && this.lexsize == this.txtstart + 6 && TidyUtils.getString(this.lexbuf, this.txtstart, 6).equals("CDATA[")) {
                        this.state = (short)8;
                        this.lexsize -= 6;
                        continue block15;
                    }
                    if (var2_2 != 93) continue block15;
                    var2_2 = this.in.readChar();
                    if (var2_2 != 62) {
                        this.in.ungetChar(var2_2);
                        continue block15;
                    }
                    --this.lexsize;
                    this.txtend = this.lexsize;
                    this.lexbuf[this.lexsize] = 0;
                    this.state = 0;
                    this.waswhite = false;
                    this.token = this.newNode((short)9, this.lexbuf, this.txtstart, this.txtend);
                    return this.token;
                }
                case 8: {
                    if (var2_2 != 93) continue block15;
                    var2_2 = this.in.readChar();
                    if (var2_2 != 93) {
                        this.in.ungetChar(var2_2);
                        continue block15;
                    }
                    var2_2 = this.in.readChar();
                    if (var2_2 != 62) {
                        this.in.ungetChar(var2_2);
                        continue block15;
                    }
                    --this.lexsize;
                    this.txtend = this.lexsize;
                    this.lexbuf[this.lexsize] = 0;
                    this.state = 0;
                    this.waswhite = false;
                    this.token = this.newNode((short)8, this.lexbuf, this.txtstart, this.txtend);
                    return this.token;
                }
            }
        }
        if (this.state == 0) {
            this.txtend = this.lexsize;
            if (this.txtend > this.txtstart) {
                this.in.ungetChar(var2_2);
                if (this.lexbuf[this.lexsize - 1] == 32) {
                    --this.lexsize;
                    this.txtend = this.lexsize;
                }
                this.token = this.newNode((short)4, this.lexbuf, this.txtstart, this.txtend);
                return this.token;
            }
        } else if (this.state == 4) {
            if (var2_2 == -1) {
                this.report.warning(this, null, null, (short)29);
            }
            this.txtend = this.lexsize;
            this.lexbuf[this.lexsize] = 0;
            this.state = 0;
            this.waswhite = false;
            this.token = this.newNode((short)2, this.lexbuf, this.txtstart, this.txtend);
            return this.token;
        }
        return null;
    }

    public Node parseAsp() {
        int n;
        Node node = null;
        this.txtstart = this.lexsize;
        while ((n = this.in.readChar()) != -1) {
            this.addCharToLexer(n);
            if (n != 37) continue;
            n = this.in.readChar();
            if (n == -1) break;
            this.addCharToLexer(n);
            if (n != 62) continue;
        }
        this.lexsize -= 2;
        this.txtend = this.lexsize;
        if (this.txtend > this.txtstart) {
            node = this.newNode((short)10, this.lexbuf, this.txtstart, this.txtend);
        }
        this.txtstart = this.txtend;
        return node;
    }

    public Node parsePhp() {
        int n;
        Node node = null;
        this.txtstart = this.lexsize;
        while ((n = this.in.readChar()) != -1) {
            this.addCharToLexer(n);
            if (n != 63) continue;
            n = this.in.readChar();
            if (n == -1) break;
            this.addCharToLexer(n);
            if (n != 62) continue;
        }
        this.lexsize -= 2;
        this.txtend = this.lexsize;
        if (this.txtend > this.txtstart) {
            node = this.newNode((short)12, this.lexbuf, this.txtstart, this.txtend);
        }
        this.txtstart = this.txtend;
        return node;
    }

    public String parseAttribute(boolean[] blArray, Node[] nodeArray, Node[] nodeArray2) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        nodeArray[0] = null;
        nodeArray2[0] = null;
        while (true) {
            if ((n2 = this.in.readChar()) == 47) {
                n2 = this.in.readChar();
                if (n2 == 62) {
                    blArray[0] = true;
                    return null;
                }
                this.in.ungetChar(n2);
                n2 = 47;
                break;
            }
            if (n2 == 62) {
                return null;
            }
            if (n2 == 60) {
                n2 = this.in.readChar();
                if (n2 == 37) {
                    nodeArray[0] = this.parseAsp();
                    return null;
                }
                if (n2 == 63) {
                    nodeArray2[0] = this.parsePhp();
                    return null;
                }
                this.in.ungetChar(n2);
                if (this.state != 13) {
                    this.in.ungetChar(60);
                }
                this.report.attrError(this, this.token, null, (short)52);
                return null;
            }
            if (n2 == 61) {
                this.report.attrError(this, this.token, null, (short)69);
                continue;
            }
            if (n2 == 34 || n2 == 39) {
                this.report.attrError(this, this.token, null, (short)59);
                continue;
            }
            if (n2 == -1) {
                this.report.attrError(this, this.token, null, (short)36);
                this.in.ungetChar(n2);
                return null;
            }
            if (!TidyUtils.isWhite((char)n2)) break;
        }
        n = this.lexsize;
        n3 = n2;
        while (true) {
            if (n2 == 61 || n2 == 62) {
                this.in.ungetChar(n2);
                break;
            }
            if (n2 == 60 || n2 == -1) {
                this.in.ungetChar(n2);
                break;
            }
            if (n3 == 45 && (n2 == 34 || n2 == 39)) {
                --this.lexsize;
                this.in.ungetChar(n2);
                break;
            }
            if (TidyUtils.isWhite((char)n2)) break;
            if (!this.configuration.xmlTags && TidyUtils.isUpper((char)n2)) {
                n2 = TidyUtils.toLower((char)n2);
            }
            this.addCharToLexer(n2);
            n3 = n2;
            n2 = this.in.readChar();
        }
        int n4 = this.lexsize - n;
        String string = n4 > 0 ? TidyUtils.getString(this.lexbuf, n, n4) : null;
        this.lexsize = n;
        return string;
    }

    public int parseServerInstruction() {
        int n = 34;
        boolean bl = false;
        int n2 = this.in.readChar();
        this.addCharToLexer(n2);
        if (n2 == 37 || n2 == 63 || n2 == 64) {
            bl = true;
        }
        while ((n2 = this.in.readChar()) != -1) {
            if (n2 == 62) {
                if (bl) {
                    this.addCharToLexer(n2);
                    break;
                }
                this.in.ungetChar(n2);
                break;
            }
            if (!bl && TidyUtils.isWhite((char)n2)) break;
            this.addCharToLexer(n2);
            if (n2 == 34) {
                do {
                    n2 = this.in.readChar();
                    if (this.endOfInput()) {
                        this.report.attrError(this, this.token, null, (short)36);
                        this.in.ungetChar(n2);
                        return 0;
                    }
                    if (n2 == 62) {
                        this.in.ungetChar(n2);
                        this.report.attrError(this, this.token, null, (short)52);
                        return 0;
                    }
                    this.addCharToLexer(n2);
                } while (n2 != 34);
                n = 39;
                continue;
            }
            if (n2 != 39) continue;
            do {
                n2 = this.in.readChar();
                if (this.endOfInput()) {
                    this.report.attrError(this, this.token, null, (short)36);
                    this.in.ungetChar(n2);
                    return 0;
                }
                if (n2 == 62) {
                    this.in.ungetChar(n2);
                    this.report.attrError(this, this.token, null, (short)52);
                    return 0;
                }
                this.addCharToLexer(n2);
            } while (n2 != 39);
        }
        return n;
    }

    public String parseValue(String string, boolean bl, boolean[] blArray, int[] nArray) {
        String string2;
        int n = 0;
        boolean bl2 = false;
        boolean bl3 = true;
        int n2 = 0;
        int n3 = 0;
        nArray[0] = 34;
        if (this.configuration.literalAttribs) {
            bl3 = false;
        }
        do {
            if ((n2 = this.in.readChar()) != -1) continue;
            this.in.ungetChar(n2);
            break;
        } while (TidyUtils.isWhite((char)n2));
        if (n2 != 61 && n2 != 34 && n2 != 39) {
            this.in.ungetChar(n2);
            return null;
        }
        do {
            if ((n2 = this.in.readChar()) != -1) continue;
            this.in.ungetChar(n2);
            break;
        } while (TidyUtils.isWhite((char)n2));
        if (n2 == 34 || n2 == 39) {
            n3 = n2;
        } else {
            if (n2 == 60) {
                int n4 = this.lexsize;
                this.addCharToLexer(n2);
                nArray[0] = this.parseServerInstruction();
                n = this.lexsize - n4;
                this.lexsize = n4;
                return n > 0 ? TidyUtils.getString(this.lexbuf, n4, n) : null;
            }
            this.in.ungetChar(n2);
        }
        int n5 = 0;
        int n6 = this.lexsize;
        n2 = 0;
        while (true) {
            int n7 = n2;
            n2 = this.in.readChar();
            if (n2 == -1) {
                this.report.attrError(this, this.token, null, (short)36);
                this.in.ungetChar(n2);
                break;
            }
            if (n3 == 0) {
                if (n2 == 62) {
                    this.in.ungetChar(n2);
                    break;
                }
                if (n2 == 34 || n2 == 39) {
                    int n8 = n2;
                    this.report.attrError(this, this.token, null, (short)59);
                    n2 = this.in.readChar();
                    if (n2 == 62) {
                        this.addCharToLexer(n8);
                        this.in.ungetChar(n2);
                        break;
                    }
                    this.in.ungetChar(n2);
                    n2 = n8;
                }
                if (n2 == 60) {
                    this.in.ungetChar(n2);
                    n2 = 62;
                    this.in.ungetChar(n2);
                    this.report.attrError(this, this.token, null, (short)52);
                    break;
                }
                if (n2 == 47) {
                    n2 = this.in.readChar();
                    if (n2 == 62 && !AttributeTable.getDefaultAttributeTable().isUrl(string)) {
                        blArray[0] = true;
                        this.in.ungetChar(n2);
                        break;
                    }
                    this.in.ungetChar(n2);
                    n2 = 47;
                }
            } else {
                if (n2 == n3) break;
                if (n2 == 13) {
                    n2 = this.in.readChar();
                    if (n2 != 10) {
                        this.in.ungetChar(n2);
                    }
                    n2 = 10;
                }
                if (n2 == 10 || n2 == 60 || n2 == 62) {
                    ++n5;
                }
                if (n2 == 62) {
                    bl2 = true;
                }
            }
            if (n2 == 38) {
                if ("id".equalsIgnoreCase(string)) {
                    this.report.attrError(this, null, null, (short)67);
                    continue;
                }
                this.addCharToLexer(n2);
                this.parseEntity((short)0);
                continue;
            }
            if (n2 == 92 && (n2 = this.in.readChar()) != 10) {
                this.in.ungetChar(n2);
                n2 = 92;
            }
            if (TidyUtils.isWhite((char)n2)) {
                if (n3 == 0) break;
                if (bl3) {
                    if (n2 == 10 && AttributeTable.getDefaultAttributeTable().isUrl(string)) {
                        this.report.attrError(this, this.token, null, (short)65);
                        continue;
                    }
                    n2 = 32;
                    if (n7 == 32) {
                        continue;
                    }
                }
            } else if (bl && TidyUtils.isUpper((char)n2)) {
                n2 = TidyUtils.toLower((char)n2);
            }
            this.addCharToLexer(n2);
        }
        if (!(n5 <= 10 || !bl2 || !bl3 || AttributeTable.getDefaultAttributeTable().isScript(string) || AttributeTable.getDefaultAttributeTable().isUrl(string) && "javascript:".equals(TidyUtils.getString(this.lexbuf, n6, 11)) || "<xml ".equals(TidyUtils.getString(this.lexbuf, n6, 5)))) {
            this.report.error(this, null, null, (short)16);
        }
        n = this.lexsize - n6;
        this.lexsize = n6;
        if (n > 0 || n3 != 0) {
            if (bl3 && !TidyUtils.isInValuesIgnoreCase(new String[]{"alt", "title", "value", "prompt"}, string)) {
                while (TidyUtils.isWhite((char)this.lexbuf[n6 + n - 1])) {
                    --n;
                }
                while (TidyUtils.isWhite((char)this.lexbuf[n6]) && n6 < n) {
                    ++n6;
                    --n;
                }
            }
            string2 = TidyUtils.getString(this.lexbuf, n6, n);
        } else {
            string2 = null;
        }
        nArray[0] = n3 != 0 ? n3 : 34;
        return string2;
    }

    public static boolean isValidAttrName(String string) {
        char c = string.charAt(0);
        if (!TidyUtils.isLetter(c)) {
            return false;
        }
        for (int i = 1; i < string.length(); ++i) {
            c = string.charAt(i);
            if (TidyUtils.isNamechar(c)) continue;
            return false;
        }
        return true;
    }

    public static boolean isCSS1Selector(String string) {
        if (string == null) {
            return false;
        }
        boolean bl = true;
        int n = 0;
        for (int i = 0; bl && i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '\\') {
                n = 1;
                continue;
            }
            if (Character.isDigit(c)) {
                if (n > 0) {
                    boolean bl2 = bl = ++n < 6;
                }
                if (!bl) continue;
                bl = i > 0 || n > 0;
                continue;
            }
            bl = n > 0 || i > 0 && c == '-' || Character.isLetter(c) || c >= '\u00a1' && c <= '\u00ff';
            n = 0;
        }
        return bl;
    }

    public AttVal parseAttrs(boolean[] blArray) {
        int[] nArray = new int[1];
        Node[] nodeArray = new Node[1];
        Node[] nodeArray2 = new Node[1];
        AttVal attVal = null;
        while (!this.endOfInput()) {
            AttVal attVal2;
            String string = this.parseAttribute(blArray, nodeArray, nodeArray2);
            if (string == null) {
                if (nodeArray[0] != null) {
                    attVal = attVal2 = new AttVal(attVal, null, nodeArray[0], null, 0, null, null);
                    continue;
                }
                if (nodeArray2[0] == null) break;
                attVal = attVal2 = new AttVal(attVal, null, null, nodeArray2[0], 0, null, null);
                continue;
            }
            String string2 = this.parseValue(string, false, blArray, nArray);
            if (string != null && Lexer.isValidAttrName(string)) {
                attVal2 = new AttVal(attVal, null, null, null, nArray[0], string, string2);
                attVal2.dict = AttributeTable.getDefaultAttributeTable().findAttribute(attVal2);
                attVal = attVal2;
                continue;
            }
            attVal2 = new AttVal(null, null, null, null, 0, string, string2);
            if (string2 != null) {
                this.report.attrError(this, this.token, attVal2, (short)51);
                continue;
            }
            if (TidyUtils.lastChar(string) == 34) {
                this.report.attrError(this, this.token, attVal2, (short)58);
                continue;
            }
            this.report.attrError(this, this.token, attVal2, (short)48);
        }
        return attVal;
    }

    public void pushInline(Node node) {
        if (node.implicit) {
            return;
        }
        if (node.tag == null) {
            return;
        }
        if (!TidyUtils.toBoolean(node.tag.model & 0x10)) {
            return;
        }
        if (TidyUtils.toBoolean(node.tag.model & 0x800)) {
            return;
        }
        if (node.tag != this.configuration.tt.tagFont && this.isPushed(node)) {
            return;
        }
        IStack iStack = new IStack();
        iStack.tag = node.tag;
        iStack.element = node.element;
        if (node.attributes != null) {
            iStack.attributes = this.cloneAttributes(node.attributes);
        }
        this.istack.push(iStack);
    }

    public void popInline(Node node) {
        if (node != null) {
            if (node.tag == null) {
                return;
            }
            if (!TidyUtils.toBoolean(node.tag.model & 0x10)) {
                return;
            }
            if (TidyUtils.toBoolean(node.tag.model & 0x800)) {
                return;
            }
            if (node.tag == this.configuration.tt.tagA) {
                while (this.istack.size() > 0) {
                    IStack iStack = (IStack)this.istack.pop();
                    if (iStack.tag != this.configuration.tt.tagA) continue;
                }
                if (this.insert >= this.istack.size()) {
                    this.insert = -1;
                }
                return;
            }
        }
        if (this.istack.size() > 0) {
            IStack iStack = (IStack)this.istack.pop();
            if (this.insert >= this.istack.size()) {
                this.insert = -1;
            }
        }
    }

    public boolean isPushed(Node node) {
        for (int i = this.istack.size() - 1; i >= 0; --i) {
            IStack iStack = (IStack)this.istack.elementAt(i);
            if (iStack.tag != node.tag) continue;
            return true;
        }
        return false;
    }

    public int inlineDup(Node node) {
        int n = this.istack.size() - this.istackbase;
        if (n > 0) {
            this.insert = this.istackbase;
            this.inode = node;
        }
        return n;
    }

    public Node insertedToken() {
        if (this.insert == -1) {
            Node node = this.inode;
            this.inode = null;
            return node;
        }
        if (this.inode == null) {
            this.lines = this.in.getCurline();
            this.columns = this.in.getCurcol();
        }
        Node node = this.newNode((short)5, this.lexbuf, this.txtstart, this.txtend);
        node.implicit = true;
        IStack iStack = (IStack)this.istack.elementAt(this.insert);
        node.element = iStack.element;
        node.tag = iStack.tag;
        if (iStack.attributes != null) {
            node.attributes = this.cloneAttributes(iStack.attributes);
        }
        int n = this.insert;
        this.insert = ++n < this.istack.size() ? n : -1;
        return node;
    }

    public boolean canPrune(Node node) {
        if (node.type == 4) {
            return true;
        }
        if (node.content != null) {
            return false;
        }
        if (node.tag == this.configuration.tt.tagA && node.attributes != null) {
            return false;
        }
        if (node.tag == this.configuration.tt.tagP && !this.configuration.dropEmptyParas) {
            return false;
        }
        if (node.tag == null) {
            return false;
        }
        if (TidyUtils.toBoolean(node.tag.model & 0x200)) {
            return false;
        }
        if (TidyUtils.toBoolean(node.tag.model & 1)) {
            return false;
        }
        if (node.tag == this.configuration.tt.tagApplet) {
            return false;
        }
        if (node.tag == this.configuration.tt.tagObject) {
            return false;
        }
        if (node.tag == this.configuration.tt.tagScript && node.getAttrByName("src") != null) {
            return false;
        }
        if (node.tag == this.configuration.tt.tagTitle) {
            return false;
        }
        if (node.tag == this.configuration.tt.tagIframe) {
            return false;
        }
        return node.getAttrByName("id") == null && node.getAttrByName("name") == null;
    }

    public void fixId(Node node) {
        AttVal attVal = node.getAttrByName("name");
        AttVal attVal2 = node.getAttrByName("id");
        if (attVal != null) {
            if (attVal2 != null) {
                if (attVal2.value != null && !attVal2.value.equals(attVal.value)) {
                    this.report.attrError(this, node, attVal, (short)60);
                }
            } else if (this.configuration.xmlOut) {
                node.addAttribute("id", attVal.value);
            }
        }
    }

    public void deferDup() {
        this.insert = -1;
        this.inode = null;
    }

    void constrainVersion(int n) {
        this.versions = (short)(this.versions & (n | 0x1C0));
    }

    protected boolean preContent(Node node) {
        if (node.tag == this.configuration.tt.tagP) {
            return true;
        }
        return node.tag != null && node.tag != this.configuration.tt.tagP && TidyUtils.toBoolean(node.tag.model & 0x100010);
    }

    private static class W3CVersionInfo {
        String name;
        String voyagerName;
        String profile;
        short code;

        public W3CVersionInfo(String string, String string2, String string3, short s) {
            this.name = string;
            this.voyagerName = string2;
            this.profile = string3;
            this.code = s;
        }
    }
}

