/*
 *  @File process.c
 *  @Brief control the process(task) using cpu's feature
 *  
 *  @Author      Sodex
 *  @Revision    0.1
 *  @License     suspension
 *  @Date        creae: 2007/05/09  update: 2007/05/10
 *      
 *  Copyright (C) 2007 Sodex
 */

#include <kernel.h>
#include <sodex/list.h>
#include <ld/page_linker.h>
#include <vga.h>
#include <descriptor.h>
#include <io.h>
#include <string.h>
#include <ihandlers.h>
#include <process.h>
#include <floppy.h>
#include <fs.h>
#include <page.h>
#include <elfloader.h>
#include <execve.h>


PRIVATE TSS tss;

PRIVATE void p_print_debug(struct task_struct* prev, struct task_struct* next);
PRIVATE u_int32_t get_proc_stackmem(u_int32_t *pg_dir);
PRIVATE void set_prev_context(struct task_struct* prev, u_int16_t cs,
                              u_int16_t ds, u_int32_t eip,
                              u_int32_t eax, u_int32_t ebx, u_int32_t ecx,
                              u_int32_t edx, u_int32_t ebp, u_int32_t esp,
                              u_int32_t esi, u_int32_t edi, u_int32_t eflags,
                              int is_usermode);

PUBLIC void init_process()
{
  current = (struct task_struct *)0;

  u_int16_t sel = allocSel();
  u_int16_t type_tss = 0x89;
  memset(&tss, 0, sizeof(TSS));
  tss.ss0 = __KERNEL_DS;
  u_int32_t* pg_dir = kalloc(BLOCK_SIZE*2);
  pg_dir = ((u_int32_t)pg_dir & ~(BLOCK_SIZE-1)) + BLOCK_SIZE;
  memset(pg_dir, 0, BLOCK_SIZE);
  create_kernel_page(pg_dir);
  //tss.esp0 = pg_dir;
  makeGdt((u_int32_t)&tss, sizeof(TSS), type_tss, sel);
  ltr(sel);

  kernel_execve("/usr/bin/init", NULL, NULL);
  //kernel_execve("/usr/bin/idle", NULL, NULL);
  //kernel_execve("/usr/bin/proc3", NULL, NULL);
  //kernel_execve("/ptest", NULL, NULL);
  //sys_execve("/ptest", NULL, NULL);
  //sys_execve("/ptest2", NULL, NULL);
  //sys_execve("/usr/bin/proc3", NULL, NULL);
  //sys_execve("/usr/bin/idle", NULL, NULL);
  //sys_execve("/usr/bin/eshell", NULL, NULL);

  struct task_struct* next = dlist_entry(current->run_list.next,
                                         struct task_struct, run_list);
  tss.esp0 = next->esp0;

  set_trap_gate(0x20,&asm_process_switch);

  /*
  char* filename = "/ptest2";
  char* argv = NULL;
  char* envp = NULL;
  asm __volatile__ (
                    " movl %0, %%ebx    \n\t"
                    " movl %1, %%ecx    \n\t"
                    " movl %2, %%edx    \n\t"
                    " movl $11, %%eax   \n\t"
                    " int $0x80         \n\t"
                    :: "r" (filename), "r" (argv), "r" (envp));
  */
}

PUBLIC void set_context(struct task_struct* prev, u_int32_t eip, u_int32_t esp,
                        u_int32_t eflags)
{
  prev->context->eip = eip;
  prev->context->esp = esp;
  prev->context->eflags = eflags;
  current = dlist_entry(prev->run_list.next,
                        struct task_struct, run_list);
  prev->count++;
}

PRIVATE void set_prev_context(struct task_struct* prev, u_int16_t cs,
                              u_int16_t ds, u_int32_t eip,
                              u_int32_t eax, u_int32_t ebx, u_int32_t ecx,
                              u_int32_t edx, u_int32_t ebp, u_int32_t esp,
                              u_int32_t esi, u_int32_t edi, u_int32_t eflags,
                              int is_usermode)
{
  prev->context->cs = cs;
  prev->context->ds = ds;
  prev->context->eip = eip;
  prev->context->eax = eax;
  prev->context->ebx = ebx;
  prev->context->ecx = ecx;
  prev->context->edx = edx;
  prev->context->ebp = ebp;
  prev->context->esp = esp;
  prev->context->esi = esi;
  prev->context->edi = edi;
  prev->context->eflags = (eflags | 0x200);
  prev->is_usermode = is_usermode;

  //if (prev->firstexec != 0 && is_usermode == SAME_PRIVILEGE)
  //  prev->esp0 = esp;

  current = dlist_entry(prev->run_list.next,
                        struct task_struct, run_list);
  prev->count++;
}

PUBLIC void i20h_process_switch(int is_usermode, u_int32_t iret_eip,
                                u_int32_t iret_cs, u_int32_t iret_eflags,
                                u_int32_t iret_esp, u_int32_t iret_ss,
                                u_int32_t ebp)
{
  /* Don't create the local variable. If u want to create the local variable
   * , check the stack and modify the position of stack at switch_to function.
   */

  out8(0x20, 0x60);

  struct task_struct* prev = current;
  struct task_struct* next = dlist_entry(prev->run_list.next,
                                         struct task_struct, run_list);
  //_kprintf("prev:%x next:%x\n", prev, next);

  u_int32_t prev_eip = prev->context->eip;
  u_int32_t prev_esp = prev->context->esp;

  u_int32_t prev_count = prev->count;

  u_int32_t *p_eax = (u_int32_t*)(ebp-4);
  u_int32_t *p_ecx = (u_int32_t*)(ebp-8);
  u_int32_t *p_edx = (u_int32_t*)(ebp-12);
  u_int32_t *p_ebx = (u_int32_t*)(ebp-16);
  u_int32_t *p_esp = (u_int32_t*)(ebp-20);
  u_int32_t *p_ebp = (u_int32_t*)(ebp-24);
  u_int32_t *p_esi = (u_int32_t*)(ebp-28);
  u_int32_t *p_edi = (u_int32_t*)(ebp-32);
  u_int32_t *prev_ebp = (u_int32_t*)(ebp);


  if (prev->firstexec != 0) { // prev already exist
    //_kprintf("not first: prev save esp:%x same:%x tss.esp0:%x\n",
    //         ebp+16, is_usermode, tss.esp0);

    if (is_usermode == SAME_PRIVILEGE) {
      set_prev_context(prev, __KERNEL_CS, __KERNEL_DS, iret_eip, *p_eax,
                       *p_ebx, *p_ecx, *p_edx, *prev_ebp, ebp+16,
                       *p_esi, *p_edi, iret_eflags, is_usermode);
    } else {
      set_prev_context(prev, __USER_CS, __USER_DS, iret_eip, *p_eax,
                       *p_ebx, *p_ecx, *p_edx, *prev_ebp, iret_esp,
                       *p_esi, *p_edi, iret_eflags, is_usermode);
    }
  } else { // prev didn't exist

    //_kprintf("first:prev save esp:%x\n", prev_esp);
    /*    
    set_prev_context(prev, __USER_CS, __USER_DS, prev_eip, *p_eax,
                     *p_ebx, *p_ecx, *p_edx, *prev_ebp, prev_esp, *p_esi,
                     *p_edi, iret_eflags, OUTER_PRIVILEGE);
    */
    set_prev_context(prev, __USER_CS, __USER_DS, prev_eip, next->context->eax,
                     next->context->ebx, next->context->ecx,
                     next->context->edx, *prev_ebp, prev_esp, *p_esi,
                     *p_edi, iret_eflags, OUTER_PRIVILEGE);
  }

  u_int32_t next_eip = next->context->eip;
  u_int32_t next_esp = next->context->esp;

  u_int32_t next_cr3 = next->context->cr3;
  u_int16_t next_cs = next->context->cs;
  u_int16_t next_ds = next->context->ds;
  u_int32_t next_eflags = next->context->eflags;
  u_int32_t next_ebp = next->context->ebp;
  u_int32_t next_eax = next->context->eax;
  u_int32_t next_ebx = next->context->ebx;
  u_int32_t next_ecx = next->context->ecx;
  u_int32_t next_edx = next->context->edx;
  u_int32_t next_esi = next->context->esi;
  u_int32_t next_edi = next->context->edi;
  int next_is_usermode = next->is_usermode;

  /*
  _kprintf("next filename:%s\n", next->filename);
  _kprintf("prev_eip:%x next_eip:%x\n", prev_eip, next_eip);
  _kprintf("prev_esp:%x next_esp:%x\n", prev_esp, next_esp);

  _kprintf("n_eax:%x n_ebx:%x n_ecx:%x n_edx:%x n_esi:%x "
           "n_edi:%x\n", next_eax, next_ebx, next_ecx, next_edx,
           next_esi, next_edi);


  static c = 0;
  c++;
  if (c > 3)    
    for(;;);
  */
   
  tss.esp0 = next->esp0;

  if (next->firstexec == 0 || next_is_usermode == OUTER_PRIVILEGE) {
    if (next->firstexec == 0) {
      next_eflags = iret_eflags;
      next->firstexec++;
    }
    //_kprintf("outer pv %x cr3:%x\n", next, next_cr3);

    /*
    _kprintf("eax:%x ebx:%x ecx:%x edx:%x ebp:%x esi:%x edi:%x\n",
             *p_eax, *p_ebx, *p_ecx, *p_edx, *prev_ebp, *p_esi, *p_edi);
    _kprintf("n_eax:%x n_ebx:%x n_ecx:%x n_edx:%x n_esi:%x"
             "n_edi:%x\n", next_eax, next_ebx, next_ecx, next_edx,
             next_esi, next_edi);    
    _kprintf("next_cs:%x, next_cr3:%x, next_esp:%x, next_eip:%x\n",
             next_cs, next_cr3, next_esp, next_eip);
    */

    switch_to_outer_privilege(next_cs, next_ds, next_esp, next_cr3, 
                              next_eflags, next_eip, next_esp,
                              next_eax, next_ebx, next_ecx, next_edx,
                              next_esp, next_ebp, next_esi, next_edi);
  } else {
    if (next->firstexec == 0)
      next->firstexec++;
    //_kprintf("same pv %x cr3:%x\n", next, next_cr3);

    /*
    _kprintf("n_eax:%x n_ebx:%x n_ecx:%x n_edx:%x n_esi:%x"
             "n_edi:%x\n", next_eax, next_ebx, next_ecx, next_edx,
             next_esi, next_edi);
    _kprintf("next_cs:%x, next_cr3:%x, next_esp:%x, next_eip:%x\n",
             next_cs, next_cr3, next_esp, next_eip);
    */

    switch_to_same_privilege(next_cs, next_cr3, next_eflags, next_eip,
                             next_esp,
                             next_eax, next_ebx, next_ecx, next_edx,
                             next_esp, next_ebp, next_esi, next_edi);
  }
}

PUBLIC void to_usermode()
{
  current->is_usermode = TRUE;
}

PUBLIC void to_kernelmode()
{
  current->is_usermode = FALSE;
}

PUBLIC int is_usermode()
{
  return current->is_usermode;
}

PRIVATE void p_print_debug(struct task_struct* prev, struct task_struct* next)
{
  _kprintf("prev is %x, next is %x\n", prev, next);
  _kprintf("prev->cr3 is %x, next->cr3 is %x\n",
		   prev->context->cr3, next->context->cr3);
  _kprintf("prev->esp is %x, next->esp is %x\n",
           prev->context->esp, next->context->esp);
  _kprintf("prev->count is %x, next->count is %x\n",
           prev->count, next->count);
}


