/**********************************************************-*-verilog-*-
 *
 *	DES Pipeline(x16)
 *	V[PVL[pDESpCvC
 *
 *	$Id: des_pipeline.v 118 2007-04-11 04:55:06Z chapuni $
 *
 */

module des_pipeline(clk5,
					i_l, i_r, i_k, k_0,
					o_l, o_r, o_k,
					salt,
					kp,
					clk, s_we, s_a, s_d);

	input			clk5;

	// 
	input [1:32] 	i_l;
	input [1:32] 	i_r;
	input [55:0] 	i_k;
	input [55:0] 	k_0;

	// o
	output [1:32]	o_l;
	output [1:32] 	o_r;
	output [55:0] 	o_k;

	// 
	input [11:0] 	salt;

	// phase cache QƗp
	input [55:0] 	kp;

	// S5-8ւ̏݃C^tFCX
	input 			clk;
	input 			s_we;
	input [10:0] 	s_a;
	input [15:0] 	s_d;

	// pCvCL[}XN
	parameter kmsk = 56'b0000_0000_1111_1111_111_111_111_111_000_000_000_000_000_000_000_000_0000;

	/*
	 *  S1-S4̃ZbgAbv
	 *	a[9:6] AeXe[W(0-f)ւweƂȂB
	 *	a[5:0] ́ARAMւ̃AhX(Ȃ킿̓rbgp^[)
	 *	d ́Aς݃f[^łB
	 */
	wire [6:0] 		a;
	wire 			we0, we1, we2, we3, we4, we5, we6, we7;
	wire 			we8, we9, wea, web, wec, wed, wee, wef;

	assign 			a = s_a[10:4];
	assign 			we0 = bk_we(s_we, s_a, 4'h0);
	assign 			we1 = bk_we(s_we, s_a, 4'h1);
	assign 			we2 = bk_we(s_we, s_a, 4'h2);
	assign 			we3 = bk_we(s_we, s_a, 4'h3);
	assign 			we4 = bk_we(s_we, s_a, 4'h4);
	assign 			we5 = bk_we(s_we, s_a, 4'h5);
	assign 			we6 = bk_we(s_we, s_a, 4'h6);
	assign 			we7 = bk_we(s_we, s_a, 4'h7);
	assign 			we8 = bk_we(s_we, s_a, 4'h8);
	assign 			we9 = bk_we(s_we, s_a, 4'h9);
	assign 			wea = bk_we(s_we, s_a, 4'ha);
	assign 			web = bk_we(s_we, s_a, 4'hb);
	assign 			wec = bk_we(s_we, s_a, 4'hc);
	assign 			wed = bk_we(s_we, s_a, 4'hd);
	assign 			wee = bk_we(s_we, s_a, 4'he);
	assign 			wef = bk_we(s_we, s_a, 4'hf);

	/*
	 *	epCvCɕKvȔz
	 *	̂AKL̓pCvC`dȂ̂Ń_~[
	 */
	wire [1:32] 	l01, l12, l23, l34, l45, l56, l67, l78;
	wire [1:32] 	l89, l9a, lab, lbc, lcd, lde, lef;
	wire [1:32] 	r01, r12, r23, r34, r45, r56, r67, r78;
	wire [1:32] 	r89, r9a, rab, rbc, rcd, rde, ref;
	wire [55:0] 	k01, k12, k23, k34, k45, k56, k67, k78;
	wire [55:0] 	k89, k9a, kab, kbc, kcd, kde, kef;

	/*
	 *	eXe[W̃CeV2łB
	 *	eXe[W̓͒iяo͒i̓b`ĂȂB
	 *	ŏIi(i_*, o_*)̈ɂ͒ӂB
	 */
	des12 #(kmsk, 8'b0000_0000,  1) stage_0(i_l, i_r, i_k, k_0, l01, r01, k01, clk5, salt, kp);
	des12 #(kmsk, 8'b0100_1001,  2) stage_1(l01, r01, i_k, k01, l12, r12, k12, clk5, salt, kp);
	des12 #(kmsk, 8'b1111_1111,  4) stage_2(l12, r12, i_k, k12, l23, r23, k23, clk5, salt, kp);
	des12 #(kmsk, 8'b1111_1111,  6) stage_3(l23, r23, i_k, k23, l34, r34, k34, clk5, salt, kp);
	des24 #(kmsk, 8'b0000_0001,  8) stage45(l34, r34, i_k, k34, l56, r56, k56, clk5, salt, kp);
	des24 #(kmsk, 8'b0000_0000, 12) stage67(l56, r56, i_k, k56, l78, r78, k78, clk5, salt, kp);
	des24 #(kmsk, 8'b0000_0000, 15) stage89(l78, r78, i_k, k78, l9a, r9a, k9a, clk5, salt, kp);
	des24 #(kmsk, 8'b0000_1000, 19) stageab(l9a, r9a, i_k, k9a, lbc, rbc, kbc, clk5, salt, kp);
	des12 #(kmsk, 8'b1111_1111, 23) stage_c(lbc, rbc, i_k, kbc, lcd, rcd, kcd, clk5, salt, kp);
	des12 #(kmsk, 8'b1111_1111, 25) stage_d(lcd, rcd, i_k, kcd, lde, rde, kde, clk5, salt, kp);
	des12 #(kmsk, 8'b1111_1111, 27) stage_e(lde, rde, i_k, kde, lef, ref, kef, clk5, salt, kp);
	des12 #(kmsk, 8'b0000_0000, 28) stage_f(lef, ref, i_k, kef, o_r, o_l, o_k, clk5, salt, kp);
	/*** ŏIił LR ւ ***/

	/**************************************************************/

	// oNւwe
	function bk_we;
		input we;
		input [10:0] a;
		input [3:0] b;
		bk_we = we && (a[3:0] == b);
	endfunction

endmodule

/*
 *  Local variables:
 *  tab-width: 4
 *  End:
 */
