/**********************************************************-*-verilog-*-
 *
 *	rXbgςł
 *	ꂩɃqbg邩ǂ̏Ԃ
 *
 *	$Id: comparators.v 118 2007-04-11 04:55:06Z chapuni $
 *
 */

module comparators(rst,
				   clk,				// V[PTpNbN
				   men,				// rLQ[g
				   fk0, fh0,		// 
				   fk1, matched,	// o
				   regclk,		// WX^ݒpNbN
				   c_we, c_wu, c_txd);

	parameter		NCAP = 2;
	parameter		NCAP_THRESHOLD = 1;

	input			rst;

	input 			clk;
	input 			men;		// rLǂ
	input [55:0] 	fk0;
	input [1:66] 	fh0;
	output [55:0] 	fk1;
	output 			matched;	// unbuffered, r킪P1

	// WX^ݒp; regclk ł
	input 			regclk;		// WX^ݗp; hostclk Ó
	input 			c_we;
	input [7:0] 	c_wu;
	input [7:0] 	c_txd;

`include "func_util.v"

	/*
	 *	ʃiVɂ邽߂ɍ׍H{
	 */
	wire [99:64] 	mc0;			// ߍ݃^[Qbg
	reg 			men1;
	reg [99:64] 	mc1;
	reg [55:0] 		fk1;
	reg [1:66] 		fh1;
	always @(posedge clk)
	begin
		men1 <= men;
		mc1 <= mc0;
		fk1 <= fk0;
 		fh1 <= {toupper(fh0[ 1: 6]),
				toupper(fh0[ 7:12]),
				toupper(fh0[13:18]),
				toupper(fh0[19:24]),
				toupper(fh0[25:30]),
				toupper(fh0[31:36]),
				toupper(fh0[37:42]),
				toupper(fh0[43:48]),
				toupper(fh0[49:54]),
				toupper(fh0[55:60]),
				toupper(fh0[61:66])};
	end

	/*
	 *	ʂCOMPARATOR
	 *	ꂩɃqbgꍇAɓ`d
	 */

	cmp8 cu99(fh0, mc0[99]);		// 8ARp[^

	/* ʂ/iVRp[^ */
	wire [99:64] 	m1;
/*
	cmp10s cu64("3","S","H","R","U","N","Y","A","X","A",
				" "," "," "," "," "," "," "," "," "," ",
				clk, fh0, fh1, m1[64]);
*/
	/*
	 *	ʃiVCOMPARATOR
	 *	ꂩɈvۂɁAmatched hCu
	 */
	wire ['h3F:0] 	m;

	genvar i;

	// PackOăRpC镪
	generate for (i = 0;
				  i < NCAP && i < NCAP_THRESHOLD;
				  i = i + 1)
	begin: cui0
		(* ALTERA_ATTRIBUTE = "AUTO_PACKED_REGISTERS_STRATIX=NORMAL" *)
		cmp10 cu1 (regclk, rst,
				   fh1,
				   m[i],
				   c_we && (c_wu == i),
				   c_txd);
	end
	endgenerate

	// Pack܂
	generate for (i = NCAP_THRESHOLD;
				  i < NCAP;
				  i = i + 1)
	begin: cui1
		cmp10 cu1 (regclk, rst,
				   fh1,
				   m[i],
				   c_we && (c_wu == i),
				   c_txd);
	end
	endgenerate

	//cmp8 cu97(fh1, m1[97]);		// 8ARp[^
	cmp9 cu98(fh1, m1[98]);		// 9ARp[^
	//cmpnum10 cu8n(fh1, m1[99]);	// ̂݃Rp[^

	assign 			matched = men1 && |{mc1, m[NCAP - 1:0], m1};

endmodule // comparators

/*
 *  Local variables:
 *  tab-width: 4
 *  End:
 */
