# brushlib - The MyPaint Brush Library
# Copyright (C) 2007-2008 Martin Renold <martinxyz@gmx.ch>
#
# Permission to use, copy, modify, and/or distribute this software for any
# purpose with or without fee is hereby granted, provided that the above
# copyright notice and this permission notice appear in all copies.
#
# THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
# WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
# MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
# ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
# WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
# ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
# OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.

"Code generator, part of the build process."
import os, sys
import brushsettings

def writefile(filename, s):
    "write generated code if changed"
    s = '// DO NOT EDIT - autogenerated by ' + sys.argv[0] + '\n\n' + s
    if os.path.exists(filename) and open(filename).read() == s:
        print 'Checked', filename
    else:
        print 'Writing', filename
        open(filename, 'w').write(s)


content = ''
for i in brushsettings.inputs:
    content += '#define INPUT_%s %d\n' % (i.name.upper(), i.index)
content += '#define INPUT_COUNT %d\n' % len(brushsettings.inputs)
content += '\n'
for s in brushsettings.settings:
    content += '#define BRUSH_%s %d\n' % (s.cname.upper(), s.index)
content += '#define BRUSH_SETTINGS_COUNT %d\n' % len(brushsettings.settings)
content += '\n'
for s in brushsettings.states:
    content += '#define STATE_%s %d\n' % (s.cname.upper(), s.index)
content += '#define STATE_COUNT %d\n' % len(brushsettings.states)

writefile('brushsettings.hpp', content)

