/**
 * ダイアログ基本クラス
 * @author Ryuhei Terada
 */

package com.wiki.standalone.moxkiriya.dialog;

import java.io.IOException;
import java.util.ResourceBundle;

import javafx.fxml.FXMLLoader;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.stage.Modality;
import javafx.stage.Stage;

/**
 * DialogBase
 *
 */
public abstract class DialogBase {
	/**
	 * リソースバンドル
	 */
	protected ResourceBundle resource_;

	/**
	 * FXMLローダー
	 */
	protected FXMLLoader     loader_;

	/**
	 * 親Windowのstage
	 */
	protected Stage          parentStage_;

	/**
	 * My stage.
	 */
	protected Stage          stage_;
	/**
	 * シーン
	 */
	Scene scene_;

	/**
	 * Dialogコントローラ
	 */
	DialogController controller_;
	
	/**
	 * Dialogの終了種別列挙定数
	 */
	public enum CloseType {
		OK,
		Cancel
	};

	/**
	 * ダイアログを表示する
	 * @param stage
	 * @param resouces
	 * @throws Exception 
	 */
	public CloseType showDialog(Stage stage, ResourceBundle resource) throws Exception {
		parentStage_ = stage;
		resource_    = resource;
		loader_      = FXMLLoad();
		scene_       = new Scene((Parent)loader_.getRoot());
		controller_  = getController();
		scene_.getStylesheets().add(getClass().getResource("dialog.css").toExternalForm());

		return show();
	}

	/**
	 * FXMLをロードする。
	 * return FXMLLoader
	 * @throws IOException 
	 */
	protected FXMLLoader FXMLLoad() throws IOException {
		FXMLLoader loader = new FXMLLoader(getClass().getResource(getFXML()), resource_);
		loader.load();
		
		return loader;
	}
	
	/**
	 * Dialogのクローズ種別を取得する。
	 * @return CloseType
	 */
	protected CloseType getCloseType() {
		return CloseType.OK;
	}
	
	/**
	 * FXMLファイル名を取得する。
	 * @return String　FXMLファイル名 
	 */
	protected abstract String getFXML();

	/**
	 * コントローラを取得する。
	 * @return Initializable
	 * @throws Exception 
	 */
	protected abstract DialogController getController() throws Exception;

	/**
	 * ダイアログをj表示する。
	 * @return CloseTypeダイアログの終了種別
	 */
	protected CloseType show() {
		stage_ = new Stage();
		
		stage_.initOwner(parentStage_);
		stage_.initModality(Modality.APPLICATION_MODAL);
		stage_.setScene(scene_);
		stage_.setResizable(false);
		stage_.showAndWait();

		return getCloseType();		
	}
}
