/**
 * Moxkiriya standalone Wiki.
 * Main routine.
 * 
 * @author Ryuhei Terada
 * See the '<a href="{@docRoot}/copyright.html">Copyright</a>'
 */

package com.wiki.standalone.moxkiriya;
	
import java.io.File;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.ResourceBundle;

import com.wiki.standalone.moxkiriya.dialog.ConfigSettingsDialog;
import com.wiki.standalone.moxkiriya.dialog.DialogBase.CloseType;
import com.wiki.standalone.moxkiriya.dialog.SelectPartyDialog;

import javafx.application.Application;
import javafx.stage.Stage;
import javafx.stage.StageStyle;

/**
 * Application Main.
 * 
 *
 */
public class Main extends Application {
	/** primary stage. */
	private Stage primaryStage_ = null;

	/** Setting Manager */
	private SettingManager settingManager_ = null;

	/** Resource Bundle */
	private ResourceBundle resources_;

	/** Resource Manager */
	public static ResourceManager resourceManagr_ = new ResourceManager();

	/** Wiki Main window */
	private WikiMainWindow wikiMainWindow_;

	/**
	 * Main routine for this Application.
	 * @param args
	 */
	public static void main(String[] args) {
		launch(args);
	}

	@Override
	public void start(Stage primaryStage) {
		primaryStage_   = primaryStage;
		settingManager_ = SettingManager.getInstance();
		resources_      = ResourceBundle.getBundle("com.wiki.standalone.moxkiriya.resources.moxkiriya");

		try {
			WikiMainWindow.CloseType closeType = WikiMainWindow.CloseType.EXIT;

			do {
				String AppRoot  = null;
				String wikiroot = null;
				String selectedParty = loadSelectedParty();

				if(selectedParty != null) {
					AppRoot  = settingManager_.get(SettingManager.SETINGKEY_MOXKIRIYAROOT);
					wikiroot = settingManager_.get(SettingManager.SETTINGSKEY_WIKIROOT);					
				}
				
				if( (AppRoot == null)
				 || (wikiroot == null)) {
					/*
					 * selectPartyを未設定の場合
					 */
					Stage stage  = new Stage(StageStyle.UNDECORATED);
					stage.initOwner(primaryStage);
					showConfigSettingsDialog(stage, selectedParty);
				}

				/*
				 * Show a wiki main window.
				 */
				closeType = showWikiMainWindow();
				
				if(closeType == WikiMainWindow.CloseType.RESTART) {
					wikiMainWindow_.closeSession();
				}
			} while(closeType != WikiMainWindow.CloseType.EXIT);
		} catch(Exception e) {
			e.printStackTrace();
		} finally {
			if(wikiMainWindow_ != null) {
				wikiMainWindow_.closeSession();
			}
			primaryStage_.hide();
		}
	}

	/**
	 * Show wiki main window.
	 * @throws Exception
	 */
	private WikiMainWindow.CloseType showWikiMainWindow() throws Exception {
		WikiMainWindow.CloseType closeType = WikiMainWindow.CloseType.EXIT;
		String                   appRoot   = settingManager_.get(SettingManager.SETINGKEY_MOXKIRIYAROOT);

		if(appRoot != null) {
			File    wikirootPath = new File(appRoot + "/" + WikiEngine.WIKIROOT_DIRECTORY);
	
			if (wikirootPath != null) {
				wikirootPath.mkdirs();
	
				wikiMainWindow_ = new WikiMainWindow(primaryStage_, resources_);
	
				/*
				 * wikirootに MainPageを構築する。
				 */
				wikiMainWindow_.buildWikiMainTree(wikirootPath);
	
				/*
				 * 外部リンクアイコン画像をApprootにアップロードする。
				 */
				wikiMainWindow_.uploadResourcefile(appRoot + "/icon/Icon_External_Link.png",
						"icon/Icon_External_Link.png");
	
				closeType = wikiMainWindow_.show();
			}
		}
		
		return closeType;
	}
	
	/**
	 * Load default party.
	 * @return String
	 * @throws Exception
	 */
	private String loadSelectedParty() throws Exception {
		String selectedParty = settingManager_.getSelectedParty();
		
		if( (selectedParty != null)
		 && (selectedParty.isEmpty() == true)) {
			ArrayList<String> partyList = settingManager_.getPartyList();
			
			if(partyList.isEmpty() != true) {
				SelectPartyDialog dialog = new SelectPartyDialog();
				if(dialog.showDialog(primaryStage_, resources_) == CloseType.OK) {
					String path     = settingManager_.get(SettingManager.SETTINGSKEY_MOXKIRIYA_USER_DIR);
					settingManager_.savePartyConfig(path);					
					selectedParty = settingManager_.getSelectedParty();
				}
				else {
					selectedParty = "";
				}
			}
		}
		
		return selectedParty;
	}
	
	
	/**
	 * WikiConfigSettingDialogを表示する。
	 * @param primaryStage
	 * @param selectedParty
	 * @throws Exception 
	 */
	private void showConfigSettingsDialog(Stage stage, String selectedParty) throws Exception {
		ConfigSettingsDialog dialog = new ConfigSettingsDialog(selectedParty);
		dialog.showDialog(stage, resources_);

		Hashtable<String, String> settingsTable = dialog.getSettingsTable();
		String                    path          = settingManager_.get(SettingManager.SETTINGSKEY_MOXKIRIYA_USER_DIR);

		if( (selectedParty == null)
		 || (selectedParty.isEmpty() == true)) {
			selectedParty = dialog.getPartyName();
		}

		if(selectedParty.isEmpty() != true) {
			settingManager_.putParty(selectedParty, dialog.getDefaultPartyCheckValue());
			settingManager_.savePartyConfig(path);
			settingManager_.saveSettingConfig(path, selectedParty, settingsTable);
			settingManager_.loadSettingFiles(path);
		}
	}
}
