/*******************************************************************************
 * tools/cpmbr_files/main.c
 *                                                                   2012/09/16
 * Copyright (C) 2012 Mochi
 ******************************************************************************/
#include <stdio.h>
#include <stdlib.h>
#include <fcntl.h>

int main(int argc, char *argv[]) {
	int src_fd;
	int dst_fd;
	char buffer[512];
	
	/* 引数チェック */
	if (argc != 3) {
		printf("usage : \033[1mcpmbr\033[0m \033[4mSOURCE\033[0m \033[4mDESTINATION\033[0m\n");
		printf("    SOURCEのパーティションテーブル以外の部分をDESTINATIONにコピーする。\n");
		
		return 1;
	}
	
	/* ファイルオープン */
	if ((src_fd = open(argv[1], O_RDONLY)) == -1) {
		printf("エラー : ファイル [%s] が開けない.\n", argv[1]);
		exit(1);
	}
	if ((dst_fd = open(argv[2], O_RDWR)) == -1) {
		printf("エラー : ファイル [%s] が開けない.\n", argv[2]);
		exit(1);
	}
	
	/* 読込み */
	if (read(src_fd, buffer, 512) != 512) {
		printf("エラー : 512バイト読み込む事ができなかった。\n");
		exit(1);
	}
	
	/* 書込み */
	write(dst_fd, buffer, 0x1BE);
	lseek(dst_fd, 0x1FE, SEEK_SET);
	write(dst_fd, &buffer[0x1FE], 2);
	
	/* ファイルクローズ */
	close(src_fd);
	close(dst_fd);
	
	return 0;
}
