/*******************************************************************************
 * include/ia-32/descriptors.h
 *                                                                   2012/09/19
 * Copyright (C) 2012 Mochi
 ******************************************************************************/
#ifndef _DESCRIPTORS_H_
#define _DESCRIPTORS_H_

#include <stdint.h>

/* S = 0タイプ */
#define DESCRIPTOR_TYPE_DATA	0x90	/* 読込み専用データセグメント */
#define DESCRIPTOR_TYPE_DATA_W	0x92	/* 読込み/書込み可データセグメント */
#define DESCRIPTOR_TYPE_DATA_E	0x94	/* 読込み専用エクスパンドダウンデータセグメント */
#define DESCRIPTOR_TYPE_DATA_EW	0x96	/* 読込み/書込み可エクスパンドダウンデータセグメント */
#define DESCRIPTOR_TYPE_CODE	0x98	/* 実行専用コードセグメント */
#define DESCRIPTOR_TYPE_CODE_R	0x9A	/* 実行/読込み可コードセグメント */
#define DESCRIPTOR_TYPE_CODE_C	0x9C	/* 実行専用コンフォーミングコードセグメント */
#define DESCRIPTOR_TYPE_CODE_CR	0x9E	/* 実行/読込み可コンフォーミングコードセグメント */
/* S = 1タイプ */
#define DESCRIPTOR_TYPE_LDT		0x82	/* LDT */
#define DESCRIPTOR_TYPE_TASK	0x85	/* タスクゲート */
#define DESCRIPTOR_TYPE_TSS32	0x89	/* 32ビットTSS */
#define DESCRIPTOR_TYPE_CALL32	0x8C	/* 32ビットコールゲート */
#define DESCRIPTOR_TYPE_INT32	0x8E	/* 32ビット割込みゲート */
#define DESCRIPTOR_TYPE_TRAP32	0x8F	/* 32ビットトラップゲート */
/* 属性 */
#define DESCRIPTOR_ATTR_AVL		0x1		/* システムソフトウェア使用可 */
#define DESCRIPTOR_ATTR_D		0x4		/* 32ビットセグメント */
#define DESCRIPTOR_ATTR_DAVL	0x5
#define DESCRIPTOR_ATTR_G		0x8		/* x4 */
#define DESCRIPTOR_ATTR_GAVL	0x9
#define DESCRIPTOR_ATTR_GD		0xC
#define DESCRIPTOR_ATTR_GDAVL	0xD
/* ディスクリプタ特権レベル */
#define DPL(dpl)	((dpl & 3) << 5)

/* セグメントディスクリプタ */
typedef struct {
	uint16_t	limit_low;
	uint16_t	base_low;
	uint8_t		base_middle;
	uint8_t		attr_low;
	uint8_t		attr_limit_high;
	uint8_t		base_high;
} SEGMENT_DESCRIPTOR;

/* ゲートディスクリプタ */
typedef struct {
	uint16_t	offset_low;
	uint16_t	selector;
	uint8_t		count;
	uint8_t		type;
	uint16_t	offset_high;
} GATE_DESCRIPTOR;

/* ディスクリプタ */
typedef union {
	SEGMENT_DESCRIPTOR	segment;
	GATE_DESCRIPTOR		gate;
} DESCRIPTOR;

/* ディスクリプタレジスタ */
typedef struct {
	uint16_t	limit;
	DESCRIPTOR	*base;
} __attribute__((packed)) DESCRIPTOR_REGISTER;

#endif
