/* 
 * PROJECT: MMD for Java
 * --------------------------------------------------------------------------------
 * This work is based on the ARTK_MMD v0.1 
 *   PY
 * http://ppyy.hp.infoseek.co.jp/
 * py1024<at>gmail.com
 * http://www.nicovideo.jp/watch/sm7398691
 *
 * The MMD for Java is Java version MMD class library.
 * Copyright (C)2009 nyatla
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this framework; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 * For further information please contact.
 *	http://nyatla.jp/
 *	<airmail(at)ebony.plala.or.jp>
 * 
 */
package jp.nyatla.nymmd.struct.pmd;

import jp.nyatla.nymmd.*;
import jp.nyatla.nymmd.struct.*;
import jp.nyatla.nymmd.types.MmdVector3;

public class PMD_FACE_VTX implements StructType {
	public int ulIndex;
	public MmdVector3 vec3Pos = new MmdVector3();

	public void read(DataReader i_reader) throws MmdException {
		this.ulIndex = i_reader.readInt();
		StructReader.read(this.vec3Pos, i_reader);
		return;
	}

	public static PMD_FACE_VTX[] createArray(int i_length) {
		PMD_FACE_VTX[] ret = new PMD_FACE_VTX[i_length];
		for (int i = 0; i < i_length; i++) {
			ret[i] = new PMD_FACE_VTX();
		}
		return ret;
	}

	public void setValue(PMD_FACE_VTX i_value) {
		this.ulIndex = i_value.ulIndex;
		this.vec3Pos.setValue(i_value.vec3Pos);
		return;
	}

	/*
	 * unsigned long ulIndex; Vector3 vec3Pos;
	 */
}
