// ILPicture.cpp: CILPicture NX̃Cve[V
//
//////////////////////////////////////////////////////////////////////

#include "../hed/hed_common/stl.h"
#include "../hed/hed_susie/ILPicture.h"
#include "../hed/hed_picturelib/pldata.h"
#include "../hed/hed_picturelib/memorydata.h"
#include "../hed/hed_picturelib/filedata.h"
#include "../hed/hed_picturelib/plimage.h"

//////////////////////////////////////////////////////////////////////
// \z/
//////////////////////////////////////////////////////////////////////

CILPicture::CILPicture()
{
	Initialize( _T("") );
}

CILPicture::~CILPicture()
{

}

bool CILPicture::Initialize( const TCHAR * const strPluginName)
{
	m_fpGetCopyrightInfo = NULL;
	m_fpGetSupportedFileList = NULL;
	m_fpReadImage = NULL;
	m_fpAttachMemoryImage = NULL;
	m_fpIsSupportedImage = NULL;
	m_fpGetImageInfo = NULL;
	return CDecodePicture::Initialize( strPluginName );
}

bool CILPicture::LoadPluginObject( )
{
	m_hInstance = ::LoadLibrary( m_PluginName );
	if( m_hInstance )
	{
		bool bError = false;
		m_fpGetCopyrightInfo = (FP_GET_COPYRIGHT_INFO)::GetProcAddress( m_hInstance, _GPA("get_copyright_info") );
		m_fpGetSupportedFileList = (FP_GET_SUPPORTED_FILE_LIST)::GetProcAddress( m_hInstance, _GPA("get_supported_file_list") );
		m_fpReadImage = (FP_READ_IMAGE)::GetProcAddress( m_hInstance, _GPA("read_image") );
		m_fpAttachMemoryImage = (FP_ATTACH_MEMORY_IMAGE)::GetProcAddress( m_hInstance, _GPA("attach_memory_image") );
		m_fpIsSupportedImage = (FP_IS_SUPPORTED_IMAGE)::GetProcAddress( m_hInstance, _GPA("is_supported_image") );
		m_fpGetImageInfo = (FP_GET_IMAGE_INFO)::GetProcAddress( m_hInstance, _GPA("get_image_info") );
		return true;
	}
	else
	{
		return false;
	}
}

void CILPicture::UnloadPluginObject( )
{
	if( m_hInstance )
		::FreeLibrary( m_hInstance );
	m_fpGetCopyrightInfo = NULL;
	m_fpGetSupportedFileList = NULL;
	m_fpReadImage = NULL;
	m_fpAttachMemoryImage = NULL;
	m_fpIsSupportedImage = NULL;
	m_fpGetImageInfo = NULL;
}

bool CILPicture::TestPlugin( )
{
	bool bUnload = false;
	bool bResult = false;

	if( m_hInstance == NULL )
	{
		LoadPluginObject( );
		bUnload = true;
	}

	do
	{
		if( 
			!m_fpGetCopyrightInfo  ||
			!m_fpGetSupportedFileList ||
			!m_fpReadImage ||
			!m_fpAttachMemoryImage ||
			!m_fpIsSupportedImage ||
			!m_fpGetImageInfo )
			break;
		bResult = true;
	}while( false );

	if( bUnload != false )
		UnloadPluginObject( );

	return bResult;
}

std::wstring CILPicture::GetCopyright( )
{
	bool bUnload = false;
	if( m_hInstance == NULL )
	{
		LoadPluginObject( );
		bUnload = true;
	}
	
	std::wstring strResult = m_fpGetCopyrightInfo();

	if( bUnload != false )
		UnloadPluginObject( );
	
	return strResult;
}

bool CILPicture::GetExtSetting( int nIndex, std::wstring &strType, std::wstring &strExt )
{
	if( nIndex != 0 )
		return false;

	bool bUnload = false;
	if( m_hInstance == NULL )
	{
		LoadPluginObject( );
		bUnload = true;
	}
	
	bool bResult = m_fpGetSupportedFileList( strType, strExt);

	if( bUnload != false )
		UnloadPluginObject( );
	
	return bResult;
}

bool CILPicture::IsSupported( CPLData *pData )
{
	bool bUnload = false;
	bool bResult = false;

	if( !pData )
		return false;

	if( m_hInstance == NULL )
	{
		LoadPluginObject( );
		bUnload = true;
	}

	bResult = m_fpIsSupportedImage( pData );

	if( bUnload != false )
		UnloadPluginObject( );

	return bResult;
}

bool CILPicture::GetPictureInformation( CPLData *pData, int &width, int &height, int &colordepth )
{
	bool bResult = false;
	bool bUnload = false;

	if( !pData )
		return false;

	if( m_hInstance == NULL )
	{
		LoadPluginObject( );
		bUnload = true;
	}

	bResult = m_fpGetImageInfo( pData, width, height, colordepth );

	if( bUnload != false )
		UnloadPluginObject( );

	return bResult;
}

bool CILPicture::DecodePicture( CPLData *pData, CPLImage *pImageResult, CALLBACKPROGRESS_SUSIE callback , int lParam )
{
	bool bResult = false;
	bool bUnload = false;
	
	if( !pData || !pImageResult )
		return false;

	if( m_hInstance == NULL )
	{
		LoadPluginObject( );
		bUnload = true;
	}

	if( pData->is_file() )
	{
		TCHAR chFileName[MAX_PATH];
		CPLFileData *pFile = pData->get_file();
		pFile->get_name( chFileName, MAX_PATH );
		bResult = m_fpReadImage( chFileName, *pImageResult );
	}
	else if( pData->is_memory() )
	{
		CPLMemoryData *pMemory = pData->get_memory( );
		char *pPtr = (char*)pMemory->get_ptr();
		BITMAPFILEHEADER *pbmf = (BITMAPFILEHEADER*)pPtr;
		BITMAPINFOHEADER *pbmih = (BITMAPINFOHEADER*)(pPtr + sizeof(BITMAPFILEHEADER) );
		BYTE *pBits = (BYTE*)(pPtr + pbmf->bfOffBits);
		bResult = m_fpAttachMemoryImage( pbmih, pBits, *pImageResult );
	}

	if( bUnload != false )
		UnloadPluginObject( );

	return bResult;
}

