#pragma once

class StreamBasic
{
protected:
	StreamBasic( ) : _BUFFER_SIZE_( 256*1024 ), _CURRENT_BUFFER_SIZE_( 0 )
	{
		init( );
		m_pBuffer = (unsigned char*)malloc( _BUFFER_SIZE_ );
		memset( m_pBuffer, 0x00, sizeof( _BUFFER_SIZE_ ) );
	}

	virtual ~StreamBasic( )
	{
		close( );
		free( m_pBuffer );
	}

protected:
	virtual bool open( char *strFileName, DWORD dwOpenFlag, bool bNew, bool bTemp )
	{
		if( m_hFile )
			return false;
		if( !strFileName )
			return false;
		
		if( bNew )
			::DeleteFile( strFileName );
		m_bTemp = bTemp;
		
		m_hFile = ::CreateFile( strFileName,
			dwOpenFlag,
			0, 
			NULL, 
			OPEN_ALWAYS, 
			0, 
			NULL );
		if( m_hFile == INVALID_HANDLE_VALUE )
		{
			m_hFile = NULL;
			return false;
		}
		else
		{
			strncpy( m_chFileName, strFileName, MAX_PATH );
			return true;
		}
	}

	virtual bool close( )
	{
		if( m_hFile )
		{
			::CloseHandle( m_hFile );
			if( m_bTemp )
				::DeleteFile( m_chFileName );
			init( );
		}
		return true;
	}

	virtual void init( )
	{
		memset( m_chFileName, 0x00, MAX_PATH );
		m_hFile = NULL;
		m_nPosition = 0;
		m_bTemp = false;
		m_nBlockIndex = 0;
	}
	
	virtual bool set_current_position( unsigned int nPosition )
	{
		int nNewBlockIndex = nPosition / _BUFFER_SIZE_;
		if( nNewBlockIndex != m_nBlockIndex )
		{
			flush( );
			::SetFilePointer( m_hFile, nPosition / _BUFFER_SIZE_, NULL, FILE_BEGIN );
			::ReadFile( m_hFile, m_pBuffer, _BUFFER_SIZE_, _CURRENT_BUFFER_SIZE_ );
			if( _BUFFER_SIZE_ != _CURRENT_BUFFER_SIZE_ )
				memset( m_pBuffer + _CURRENT_BUFFER_SIZE_, 0x00, _BUFFER_SIZE_ - _CURRENT_BUFFER_SIZE_ );
		}
		m_nPosition = nPosition;
		return true;
	}
	
	virtual bool flush( )
	{
		return true;
	}
	
protected:
	unsigned char *m_pBuffer;
	const unsigned int _BUFFER_SIZE_;
	unsigned int _CURRENT_BUFFER_SIZE_;
	char m_chFileName[MAX_PATH];
	HANDLE m_hFile;
	unsigned int m_nBlockIndex;
	unsigned int m_nPosition;
	bool m_bTemp;
};
