#include "..\hed\hed_common\stl.h"
#include <windows.h>
#include <stdlib.h>
#include <stdio.h>
#include "..\hed\hed_picturelib\filter.h"

static const char EXPORT_PLUGIN_DIR[] = "susie\\";

bool WINAPI GetPluginFullPathName( const char *plugin, char *pResult )
{
	if( !plugin || !pResult )
		return false;
	pResult[0] = '\0';
	char path_buffer_exe[_MAX_PATH];
	char drive_exe[_MAX_DRIVE];
	char dir_exe[_MAX_DIR];
	char fname_exe[_MAX_FNAME];
	char ext_exe[_MAX_EXT];
	::GetModuleFileName( NULL, path_buffer_exe, MAX_PATH );
	_splitpath( path_buffer_exe, drive_exe, dir_exe, fname_exe, ext_exe );

	char drive[_MAX_DRIVE];
	char dir[_MAX_DIR];
	char fname[_MAX_FNAME];
	char ext[_MAX_EXT];
	_splitpath( plugin, drive, dir, fname, ext );

	strupr( ext );
	if( !strcmp( ext, PICTURE_EXPORT_PLUGIN_EXT ) )
	{
	   sprintf( pResult, "%s%s%s%s%s", drive_exe, dir_exe, EXPORT_PLUGIN_DIR, fname, ext );
	}
	else if( !strcmp( ext, PICTURE_IMPORT_PLUGIN_EXT ) )
	{
	   sprintf( pResult, "%s%s%s%s%s", drive_exe, dir_exe, IMPORT_PLUGIN_DIR, fname, ext );
	}
	return true;
}

// import_picture
__declspec(dllexport) bool WINAPI read_image_file_helper( const char *plugin, char *input, CPLImage *readImage )
{
	bool bRetVal = false;
	char chPlugin[MAX_PATH];
	GetPluginFullPathName( plugin, chPlugin );

	HINSTANCE hInstance = ::LoadLibrary( chPlugin );
	if( hInstance )
	{
		FP_READ_IMAGE fp = (FP_READ_IMAGE)::GetProcAddress( hInstance, "read_image" );
		if( fp )
		{
			bRetVal = (fp)( input, *readImage );
		}
		::FreeLibrary( hInstance );
	}
	return bRetVal;
}

__declspec(dllexport) bool WINAPI attach_memory_image_helper( const char *plugin, void *header, void *bits, CPLImage *readImage )
{
	bool bRetVal = false;
	char chPlugin[MAX_PATH];
	GetPluginFullPathName( plugin, chPlugin );

	HINSTANCE hInstance = ::LoadLibrary( chPlugin );
	if( hInstance )
	{
		FP_ATTACH_MEMORY_IMAGE fp = (FP_ATTACH_MEMORY_IMAGE)::GetProcAddress( hInstance, "attach_memory_image" );
		if( fp )
		{
			bRetVal = (fp)( header, bits, *readImage );
		}
		::FreeLibrary( hInstance );
	}
	return bRetVal;
}


//export picture
__declspec(dllexport) bool WINAPI write_image_file_helper( const char *plugin, char *input, CPLImage *writeImage )
{
	bool bRetVal = false;
	char chPlugin[MAX_PATH];
	GetPluginFullPathName( plugin, chPlugin );

	HINSTANCE hInstance = ::LoadLibrary( chPlugin );
	if( hInstance )
	{
		FP_WRITE_IMAGE fp = (FP_WRITE_IMAGE)::GetProcAddress( hInstance, "write_image" );
		if( fp )
		{
			bRetVal = (fp)( writeImage, input );
		}
		::FreeLibrary( hInstance );
	}
	return bRetVal;
}
