#pragma once

class CPLData;
class CPluginObject;

#undef _EXPORT_
#ifdef SPLG_PICTURE_EXPORTS
#define _EXPORT_ __declspec(dllexport) 
#else
#define _EXPORT_ __declspec(dllimport) 
#endif

#include "../hed_common/stl.h"

class _EXPORT_ CSusiePluginArray
{
protected:
	CSusiePluginArray(void);
	virtual ~CSusiePluginArray(void);

public:
	virtual bool add_plugin_file( const TCHAR* const strPathName );
	virtual int add_plugin_files( const TCHAR* const strPath );

	virtual void *find_plugin_first( CPLData *pData, CPluginObject **pPlugin, bool bSearchByExt );
	virtual void *find_plugin_next( void *hFind, CPLData *pData, CPluginObject **pPlugin );
	virtual void find_plugin_close( void *hFind );
	virtual void get_plugin_object( void *hPlugin, CPluginObject **pPlugin );
	
	virtual std::wstring get_file_dlg_filter_string( );

	static CSusiePluginArray* GetSusiePluginArray( )
	{
		if( !m_pPluginArray )
			m_pPluginArray = new CSusiePluginArray;
		return m_pPluginArray;
	}

	static void ReleaseSusiePluginArray( )
	{
		delete m_pPluginArray;
	}
protected:
	bool CSusiePluginArray::StrMatch( const TCHAR* ptn, const TCHAR* str );

protected:
	vector<CPluginObject*> m_arrayPlugin;
	static CSusiePluginArray *m_pPluginArray;

public:
	void remove_all_plugin_files(void);
};
