#include "../hed/hed_common/stl.h"
#include <windows.h>
#include <time.h>
#include "../hed/hed_susie/susie.h"
#include "../hed/hed_susie/pluginobject.h"
#include "../hed/hed_susie/susiearchive.h"
#include "../hed/hed_susie/susiepicture.h"
#include "../hed/hed_susie/ILpicture.h"

#include "../hed/hed_picturelib/pldata.h"
#include "../hed/hed_picturelib/memorydata.h"
#include "../hed/hed_picturelib/filedata.h"

static const int PLUGIN_TYPE_INVALID = -1;
static const int PLUGIN_TYPE_SUSIE_PICTURE = 0;
static const int PLUGIN_TYPE_SUSIE_ARCHIVE = 1;
static const int PLUGIN_TYPE_IL_PICTURE = 2;

CPluginObject::CPluginObject(void)
{
	Initialize( _T("") );
}

CPluginObject::~CPluginObject(void)
{
	UnloadPluginObject();
}

// convert mbc -> wc
std::wstring CPluginObject:: convertMultiByteToWideChar(const char* pStrMultiByte )
{
	std::wstring rStrWideChar;
	std::string strMultiByte(pStrMultiByte);
	int sizeStrWideChar = ::MultiByteToWideChar(CP_ACP, MB_PRECOMPOSED, strMultiByte.c_str(), strMultiByte.length(), NULL, 0);
	wchar_t* pStrWideChar = new wchar_t[sizeStrWideChar + 1];
	::MultiByteToWideChar(CP_ACP, MB_PRECOMPOSED, strMultiByte.c_str(), strMultiByte.length(), pStrWideChar, sizeStrWideChar);
	pStrWideChar[sizeStrWideChar] = '\0';
	rStrWideChar = pStrWideChar;
	delete[] pStrWideChar;

	return rStrWideChar;
}

// convert wc -> mbc
std::string CPluginObject::convertWideCharToMultiByte(const wchar_t* pStrWideChar )
{
	std::string rStrMultiByte;

	std::wstring strWideChar(pStrWideChar);
	int sizeStrMultiByte = ::WideCharToMultiByte(CP_ACP, 0, strWideChar.c_str(), strWideChar.length(), NULL, 0, NULL, NULL);
	char* pStrMultiByte = new char[sizeStrMultiByte + 1];
	::WideCharToMultiByte(CP_ACP, 0, strWideChar.c_str(), strWideChar.length(), pStrMultiByte, sizeStrMultiByte, NULL, NULL);
	pStrMultiByte[sizeStrMultiByte] = '\0';

	rStrMultiByte = pStrMultiByte;
	delete[] pStrMultiByte;

	return rStrMultiByte;
}

CPluginObject *CPluginObject::CreateObject(const TCHAR* const strFileName)
{
	CPluginObject *pResult = NULL;
	int nPluginType= GetPluginType( strFileName );
	switch( nPluginType )
	{
	case PLUGIN_TYPE_INVALID:
		break;
	case PLUGIN_TYPE_SUSIE_PICTURE:
		pResult = new CSusiePicture;
		pResult->Create( strFileName );
		break;
	case PLUGIN_TYPE_SUSIE_ARCHIVE:
		pResult = new CSusieArchive;
		pResult->Create( strFileName );
		break;
	case PLUGIN_TYPE_IL_PICTURE:
		pResult = new CILPicture;
		pResult->Create( strFileName );
		break;
	}
	return pResult;
}

void CPluginObject::DestroyObject( CPluginObject *pObject )
{
	delete pObject;
}

int CPluginObject::GetPluginType( const TCHAR* const strPluginName)
{
	if( strPluginName == NULL )
		return -1;

	TCHAR drive[_MAX_DRIVE];
	TCHAR dir[_MAX_DIR];
	TCHAR fname[_MAX_FNAME];
	TCHAR ext[_MAX_EXT];
	_tsplitpath( strPluginName, drive, dir, fname, ext );
	_tcsupr( ext );
	int nFuncResult = PLUGIN_TYPE_INVALID;
	if( !_tcscmp( PICTURE_IMPORT_PLUGIN_EXT, ext ) )
	{
		HINSTANCE hInstance = ::LoadLibrary( strPluginName );
		do
		{
			if( hInstance == NULL ) break;
			::FreeLibrary( hInstance );
			nFuncResult = PLUGIN_TYPE_IL_PICTURE;
		}while( false );
	}
	else if( !_tcscmp( SUSIE_PLUGIN_EXT, ext ) )
	{
		HINSTANCE hInstance = ::LoadLibrary( strPluginName );
		do
		{
			if( hInstance == NULL ) break;

			GETPLUGININFO fp = (GETPLUGININFO)GetProcAddress( hInstance, _GPA("GetPluginInfo") );
			if( fp == NULL )
				break;

			char chBuffer[256];
			int nResult = GetPluginInfo( fp, 0, chBuffer, 256 );
			if( nResult > 0 )
			{
				strupr( chBuffer );
				if( !strcmp( chBuffer, "00IN" ) )
					nFuncResult = PLUGIN_TYPE_SUSIE_PICTURE;
				else if( !strcmp( chBuffer, "00AM" ) )
					nFuncResult = PLUGIN_TYPE_SUSIE_ARCHIVE;
			}
			::FreeLibrary( hInstance );
		}while( false );
	}
	return nFuncResult;
}

bool CPluginObject::Initialize( const TCHAR * const strPluginName )
{
	m_fpConfigrationDlg = NULL;
	m_fpGetArchiveInfo = NULL;
	m_fpGetFile = NULL;
	m_fpGetPicture = NULL;
	m_fpGetPictureInfo = NULL;
	m_fpGetPluginInfo = NULL;
	m_fpGetPreview = NULL;
	m_fpIsSupported = NULL;
	m_hInstance = NULL;
	memset ( m_PluginCopyright, 0x00, 256 );
	_tcsncpy( m_PluginName, strPluginName, MAX_PATH );
	return true;
}

bool CPluginObject::Create( const TCHAR * const strPluginName )
{
	bool bResult = false;
	do
	{
		if( !Initialize( strPluginName ) ) break;
		if( !LoadPluginObject( ) ) break;
		if( !TestPlugin( ) ) break;
		CreateFileTypeList( );
		bResult = true;
	}while( false );
	return bResult;
}

bool CPluginObject::LoadPluginObject( )
{
	m_hInstance = ::LoadLibrary( m_PluginName );
	if( m_hInstance )
	{
		bool bError = false;
		m_fpGetPluginInfo = (GETPLUGININFO)::GetProcAddress( m_hInstance, _GPA("GetPluginInfo") );
		m_fpIsSupported = (ISSUPPORTED)::GetProcAddress( m_hInstance, _GPA("IsSupported") );
		m_fpGetPictureInfo = (GETPICTUREINFO)::GetProcAddress( m_hInstance, _GPA("GetPictureInfo") );
		m_fpGetPicture = (GETPICTURE)::GetProcAddress( m_hInstance, _GPA("GetPicture") );
		m_fpGetPreview = (GETPREVIEW)::GetProcAddress( m_hInstance, _GPA("GetPreview") );
		m_fpGetArchiveInfo = (GETARCHIVEINFO)::GetProcAddress( m_hInstance, _GPA("GetArchiveInfo") );
		m_fpGetFile = (GETFILE)::GetProcAddress( m_hInstance, _GPA("GetFile") );
		m_fpConfigrationDlg = (CONFIGURATIONDLG)::GetProcAddress( m_hInstance, _GPA("ConfigurationDlg") );
		return true;
	}
	else
	{
		return false;
	}
}

void CPluginObject::UnloadPluginObject( )
{
	if( m_hInstance )
		::FreeLibrary( m_hInstance );
	m_hInstance = NULL;
	m_fpGetPluginInfo = NULL;
	m_fpIsSupported  = NULL;
	m_fpGetPictureInfo  = NULL;
	m_fpGetPicture  = NULL;
	m_fpGetPreview  = NULL;
	m_fpGetArchiveInfo  = NULL;
	m_fpGetFile  = NULL;
	m_fpConfigrationDlg  = NULL;
}

std::wstring CPluginObject::GenFileTypeString( )
{
	std::wstring strResult;
	FILE_TYPE_LIST *pList = m_SupportedFile;
	while( pList )
	{
		strResult += (std::wstring)(pList->FileTypeName) + (std::wstring)(_T("|"));
		std::vector<std::wstring>::iterator it;
		for( it = pList->Exp.begin(); it != pList->Exp.end(); it ++ )
		{
			strResult += *it;
			if( it + 1 != pList->Exp.end() )
				strResult += _T(";");
		}
		strResult += _T("|");
		pList = pList->pNext;
	}
	return strResult;
}

std::wstring CPluginObject::GetCopyright( )
{
	bool bUnload = false;
	if( !m_hInstance )
	{
		if( !LoadPluginObject() || !TestPlugin() )
		{
			UnloadPluginObject( );
			return _T("");
		}
		bUnload = true;
	}
	std::wstring strResult;
	CHAR chCopyright[256] = "";
	::GetPluginInfo( m_fpGetPluginInfo, 1, chCopyright, 256 );
	strResult = convertMultiByteToWideChar( chCopyright );
	if( bUnload )
		UnloadPluginObject( );
	return strResult;
}

bool CPluginObject::GetExtSetting( int nIndex, std::wstring &strType, std::wstring &strExt )
{
	bool bUnload = false;
	if( !m_hInstance )
	{
		if( !LoadPluginObject() || !TestPlugin() )
		{
			UnloadPluginObject( );
			return false;
		}
		bUnload = true;
	}
	
	int nLen = 256;
	int nResultExp = 0, nResultType = 0;
	char chTypeBuffer[256] = "", chExtBuffer[256] = "";
	nResultExp = ::GetPluginInfo( m_fpGetPluginInfo, 2 * nIndex + 2, chExtBuffer, nLen );
	nResultType = ::GetPluginInfo( m_fpGetPluginInfo, 2 * nIndex + 3, chTypeBuffer, nLen );
	strType = convertMultiByteToWideChar( chTypeBuffer );
	strExt = convertMultiByteToWideChar( chExtBuffer );
	if( bUnload )
		UnloadPluginObject( );
	return ( ( nResultExp > 0 ) & ( nResultType > 0 ) );
}

bool CPluginObject::CreateFileTypeList( )
{
	bool bUnload = false;
	if( !m_hInstance )
	{
		if( !LoadPluginObject() || !TestPlugin() )
		{
			UnloadPluginObject( );
			return false;
		}
		bUnload = true;
	}
	
	TCHAR chTypeBuffer[256], chExtBuffer[256];
	std::wstring strType, strExt;
	int nLen = 256;
	int nInfo = 0;
	FILE_TYPE_LIST *pListOld = NULL;
	bool bResult = false;
	do
	{
		bResult = GetExtSetting( nInfo, strType, strExt );
		if( bResult )
		{
			_tcsncpy( chTypeBuffer, strType.c_str(), 256 );
			_tcsncpy( chExtBuffer, strExt.c_str(), 256 );
			FILE_TYPE_LIST *pListNew = new FILE_TYPE_LIST;
			_tcsncpy( pListNew->FileTypeName, chTypeBuffer, 256 );
			TCHAR *token = _tcstok( chExtBuffer, _T(";") );
			while( token != NULL )
			{
				pListNew->Exp.push_back( token );
				token = _tcstok( NULL, _T(";") );
			}
			pListNew->pNext = NULL;
			if( pListOld )
				pListOld->pNext = pListNew;
			else
				m_SupportedFile = pListNew;
			pListOld = pListNew;
		}
		nInfo ++;
	}while( bResult );

	if( bUnload )
		UnloadPluginObject( );
	return true;
}

bool CPluginObject::IsSupported( CPLData *pData )
{
	if( !pData )
		return false;

	bool bUnload = false;
	if( !m_hInstance )
	{
		if( !LoadPluginObject() || !TestPlugin() )
		{
			UnloadPluginObject( );
			return false;
		}
		bUnload = true;
	}

	int nResult = false;
	if( pData->is_file() )
	{
		CPLFileData *pFile = pData->get_file( );
		if( pFile )
		{
			TCHAR buffer[MAX_PATH];
			pFile->get_name(buffer, MAX_PATH);
			CPLData *pPLData = new CPLData( _T("$TEMP$") );
			CPLMemoryData *pMemoryData = pFile->read_data( 2048 );
			if( pMemoryData )
			{
				pPLData->set_memory( pMemoryData );
				nResult = ::IsSupported( m_fpIsSupported, convertWideCharToMultiByte( buffer ).c_str(), pMemoryData->get_ptr() );
				CPLMemoryData::destroy( pMemoryData );
			}
			delete pPLData;
		}
	}
	else if( pData->is_memory() )
	{
		CPLMemoryData *pMemory = pData->get_memory( );
		if( pMemory )
		{
			TCHAR buffer[MAX_PATH];
			pData->get_name(buffer, MAX_PATH);
			if( pMemory->get_size() > 2048 )
			{
				nResult = ::IsSupported( m_fpIsSupported, convertWideCharToMultiByte( buffer ).c_str(), pMemory->get_ptr() );
			}
			else
			{
				char *chBuffer = new char[2048];
				memset( chBuffer, 0x00, 2048 );
				memcpy( chBuffer, pMemory->get_ptr(), pMemory->get_size() );
				nResult = ::IsSupported( m_fpIsSupported, convertWideCharToMultiByte( buffer ).c_str(), chBuffer );
				delete[] chBuffer;
			}
		}
	}

	if( bUnload )
		UnloadPluginObject( );

	if( nResult == 1 )
		return true;
	else
		return false;
}

int PASCAL CPluginObject::SusieDefaultCallBack(int nNum, int nDenom, long lData)
{
	return 0;
}
